/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;

public class VertexEdgeSetWrapper
implements Set {
    private final Set wrapped;
    private final OrientElement parent;

    public VertexEdgeSetWrapper(Set wrapped, OrientElement parentElement) {
        this.wrapped = wrapped;
        this.parent = parentElement;
    }

    private Object unbox(Object next) {
        if (next instanceof OrientElement) {
            return ((OrientElement)next).getRawElement();
        }
        return next;
    }

    private Object box(Object elem) {
        if (elem instanceof ORID) {
            elem = ((ORID)elem).getRecord();
        }
        if (elem instanceof OElement) {
            if (((OElement)elem).isVertex()) {
                elem = this.parent.getGraph().elementFactory().wrapVertex((OVertex)((OElement)elem).asVertex().get());
            } else if (((OElement)elem).isEdge()) {
                elem = this.parent.getGraph().elementFactory().wrapEdge((OEdge)((OElement)elem).asEdge().get());
            }
        }
        return elem;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof OrientElement && this.wrapped.contains(((OrientElement)o).getRawElement())) {
            return true;
        }
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            Iterator baseIter;
            {
                this.baseIter = VertexEdgeSetWrapper.this.wrapped.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIter.hasNext();
            }

            public Object next() {
                return VertexEdgeSetWrapper.this.box(this.baseIter.next());
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.stream().map(x -> this.box(x)).toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.wrapped.stream().map(x -> this.box(x)).toArray();
    }

    @Override
    public boolean add(Object o) {
        return this.wrapped.add(this.unbox(o));
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(this.unbox(o));
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.wrapped.containsAll(c.stream().map(x -> this.unbox(x)).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        for (Object o : c) {
            changed = changed || this.wrapped.add(this.unbox(o));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        for (Object o : c) {
            changed = changed || this.wrapped.remove(this.unbox(o));
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.wrapped.retainAll(c.stream().map(x -> this.unbox(x)).collect(Collectors.toList()));
    }

    @Override
    public Spliterator spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate filter) {
        return this.wrapped.removeIf(filter);
    }

    @Override
    public Stream stream() {
        return this.wrapped.stream().map(x -> this.box(x));
    }

    @Override
    public Stream parallelStream() {
        return this.wrapped.parallelStream().map(x -> this.box(x));
    }

    @Override
    public void forEach(Consumer action) {
        this.wrapped.forEach(action);
    }
}

