/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.orientdb.OrientEdge;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertex;

public class OGremlinResult {
    private OrientGraph graph;
    OResult inner;

    public OGremlinResult(OrientGraph graph, OResult inner) {
        this.graph = graph;
        this.inner = inner;
    }

    public <T> T getProperty(String name) {
        List value = this.inner.getProperty(name);
        if (value instanceof Iterable) {
            Spliterator spliterator = ((Iterable)value).spliterator();
            value = StreamSupport.stream(spliterator, false).map(e -> {
                if (e instanceof OResult) {
                    return new OGremlinResult(this.graph, (OResult)e);
                }
                return e;
            }).collect(Collectors.toList());
        }
        return (T)value;
    }

    public Optional<OrientVertex> getVertex() {
        return this.inner.getVertex().map(v -> this.graph.elementFactory().wrapVertex((OVertex)v));
    }

    public Optional<OrientEdge> getEdge() {
        return this.inner.getEdge().map(v -> this.graph.elementFactory().wrapEdge((OEdge)v));
    }

    public boolean isElement() {
        return this.inner.isElement();
    }

    public boolean isVertex() {
        return this.inner.isVertex();
    }

    public boolean isEdge() {
        return this.inner.isEdge();
    }

    public boolean isBlob() {
        return this.inner.isBlob();
    }

    public OResult getRawResult() {
        return this.inner;
    }
}

