/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformer;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OQueryMetrics;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;

public class OGremlinScriptResultSet
implements OResultSet,
OQueryMetrics {
    private final String textTraversal;
    protected Traversal traversal;
    private OScriptTransformer transformer;
    private boolean closeGraph;
    private boolean closing = false;
    long startTime;
    long totalExecutionTime = 0L;

    public OGremlinScriptResultSet(String iText, Traversal traversal, OScriptTransformer transformer) {
        this(iText, traversal, transformer, false);
    }

    public OGremlinScriptResultSet(String iText, Traversal traversal, OScriptTransformer transformer, boolean closeGraph) {
        this.textTraversal = iText;
        this.traversal = traversal;
        this.transformer = transformer;
        this.closeGraph = closeGraph;
        this.startTime = System.currentTimeMillis();
    }

    public boolean hasNext() {
        try {
            return this.traversal.hasNext();
        }
        catch (TraversalInterruptedException e) {
            throw new OInterruptedException("Timeout expired");
        }
        catch (OStorageException se) {
            if (se.getCause() instanceof TraversalInterruptedException || se.getCause() instanceof ClosedChannelException) {
                throw new OInterruptedException("Timeout expired");
            }
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OResult next() {
        long begin = System.currentTimeMillis();
        try {
            Object next = this.traversal.next();
            OResult oResult = this.transformer.toResult(next);
            return oResult;
        }
        finally {
            this.totalExecutionTime += System.currentTimeMillis() - begin;
        }
    }

    public void close() {
        try {
            this.traversal.close();
            if (this.closeGraph) {
                this.traversal.asAdmin().getGraph().ifPresent(graph -> {
                    try {
                        OrientGraph g = (OrientGraph)graph;
                        if (!this.closing) {
                            this.closing = true;
                            g.close();
                        }
                    }
                    catch (Exception e) {
                        throw OException.wrapException((OException)new OCommandExecutionException("Error closing the Graph "), (Throwable)e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OCommandExecutionException("Error closing the gremlin Result Set"), (Throwable)e);
        }
    }

    public Optional<OExecutionPlan> getExecutionPlan() {
        return Optional.empty();
    }

    public Map<String, Long> getQueryStats() {
        return null;
    }

    public String getStatement() {
        return this.textTraversal;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTimeMillis() {
        return this.totalExecutionTime;
    }

    public String getLanguage() {
        return "gremlin";
    }
}

