/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.jdbc.OrientJdbcConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class OrientJdbcDriver
implements Driver {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 7;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:orient:");
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new OrientJdbcConnection(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    public static String getVersion() {
        return "OrientDB 1.7 JDBC Driver";
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new OrientJdbcDriver());
        }
        catch (SQLException e) {
            OLogManager.instance().error(null, "Error while registering the JDBC Driver", new Object[0]);
        }
    }
}

