/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.jdbc.OrientJdbcResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class OrientJdbcResultSetMetaData
implements ResultSetMetaData {
    private OrientJdbcResultSet resultSet;
    private static final Map<OType, Integer> typesSqlTypes = new HashMap<OType, Integer>();

    public OrientJdbcResultSetMetaData(OrientJdbcResultSet iResultSet) {
        this.resultSet = iResultSet;
    }

    @Override
    public int getColumnCount() throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return 0;
        }
        return currentRecord.fields();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Object value = this.resultSet.getObject(column);
        if (value == null) {
            return null;
        }
        return value.getClass().getName();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return null;
        }
        return currentRecord.fieldNames()[column - 1];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        String[] fieldNames = currentRecord.fieldNames();
        if (column > fieldNames.length) {
            return 0;
        }
        String fieldName = fieldNames[column - 1];
        OType otype = currentRecord.fieldType(fieldName);
        if (otype == null) {
            Object value = currentRecord.field(fieldName);
            if (value == null) {
                return 0;
            }
            if (value instanceof ORecordBytes) {
                return -2;
            }
            if (value instanceof ORecordLazyList) {
                ORecordLazyList list = (ORecordLazyList)value;
                ListIterator iterator = list.listIterator();
                boolean stop = false;
                while (iterator.hasNext() && !stop) {
                    OIdentifiable listElement = (OIdentifiable)iterator.next();
                    if (listElement instanceof ORecordBytes) continue;
                    stop = true;
                }
                if (!stop) {
                    return 2004;
                }
            }
            return this.getSQLTypeFromJavaClass(value);
        }
        if (otype == OType.EMBEDDED || otype == OType.LINK) {
            Object value = currentRecord.field(fieldName);
            if (value == null) {
                return 0;
            }
            if (value instanceof ORecordBytes) {
                return -2;
            }
            return typesSqlTypes.get(otype);
        }
        if (otype == OType.EMBEDDEDLIST || otype == OType.LINKLIST) {
            Object value = currentRecord.field(fieldName);
            if (value == null) {
                return 0;
            }
            if (value instanceof ORecordLazyList) {
                ORecordLazyList list = (ORecordLazyList)value;
                ListIterator iterator = list.listIterator();
                boolean stop = false;
                while (iterator.hasNext() && !stop) {
                    OIdentifiable listElement = (OIdentifiable)iterator.next();
                    if (listElement instanceof ORecordBytes) continue;
                    stop = true;
                }
                if (stop) {
                    return typesSqlTypes.get(otype);
                }
                return 2004;
            }
            return 2000;
        }
        return typesSqlTypes.get(otype);
    }

    private int getSQLTypeFromJavaClass(Object value) {
        if (value instanceof Boolean) {
            return typesSqlTypes.get(OType.BOOLEAN);
        }
        if (value instanceof Byte) {
            return typesSqlTypes.get(OType.BYTE);
        }
        if (value instanceof Date) {
            return typesSqlTypes.get(OType.DATETIME);
        }
        if (value instanceof Double) {
            return typesSqlTypes.get(OType.DOUBLE);
        }
        if (value instanceof Float) {
            return typesSqlTypes.get(OType.FLOAT);
        }
        if (value instanceof Integer) {
            return typesSqlTypes.get(OType.INTEGER);
        }
        if (value instanceof Long) {
            return typesSqlTypes.get(OType.LONG);
        }
        if (value instanceof Short) {
            return typesSqlTypes.get(OType.SHORT);
        }
        if (value instanceof String) {
            return typesSqlTypes.get(OType.STRING);
        }
        return 2000;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return null;
        }
        OType columnType = currentRecord.fieldType(currentRecord.fieldNames()[column - 1]);
        if (columnType == null) {
            return null;
        }
        return columnType.toString();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return "";
        }
        return currentRecord.getDatabase().getName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        OProperty p = this.getProperty(column);
        return p != null ? p.getOwnerClass().getName() : null;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        OProperty p = this.getProperty(column);
        return p != null ? p.getCollate().getName().equalsIgnoreCase("ci") : false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        OProperty p = this.getProperty(column);
        return p != null ? p.isReadonly() : false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return false;
        }
        return this.isANumericColumn(currentRecord.fieldType(currentRecord.fieldNames()[column - 1]));
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private boolean isANumericColumn(OType type) {
        return type == OType.BYTE || type == OType.DOUBLE || type == OType.FLOAT || type == OType.INTEGER || type == OType.LONG || type == OType.SHORT;
    }

    public static Integer getSqlType(OType iType) {
        return typesSqlTypes.get(iType);
    }

    protected OProperty getProperty(int column) throws SQLException {
        ODocument currentRecord = this.resultSet.unwrap(ODocument.class);
        if (currentRecord == null) {
            return null;
        }
        OClass schemaClass = currentRecord.getSchemaClass();
        if (schemaClass != null) {
            String fieldName = currentRecord.fieldNames()[column - 1];
            return schemaClass.getProperty(fieldName);
        }
        return null;
    }

    static {
        typesSqlTypes.put(OType.STRING, 12);
        typesSqlTypes.put(OType.INTEGER, 4);
        typesSqlTypes.put(OType.FLOAT, 6);
        typesSqlTypes.put(OType.SHORT, 5);
        typesSqlTypes.put(OType.BOOLEAN, 16);
        typesSqlTypes.put(OType.LONG, -5);
        typesSqlTypes.put(OType.DOUBLE, 3);
        typesSqlTypes.put(OType.DATE, 91);
        typesSqlTypes.put(OType.DATETIME, 93);
        typesSqlTypes.put(OType.BYTE, -6);
        typesSqlTypes.put(OType.SHORT, 5);
        typesSqlTypes.put(OType.BINARY, -2);
        typesSqlTypes.put(OType.EMBEDDED, 2000);
        typesSqlTypes.put(OType.EMBEDDEDLIST, 2000);
        typesSqlTypes.put(OType.EMBEDDEDMAP, 2000);
        typesSqlTypes.put(OType.EMBEDDEDSET, 2000);
        typesSqlTypes.put(OType.LINK, 2000);
        typesSqlTypes.put(OType.LINKLIST, 2000);
        typesSqlTypes.put(OType.LINKMAP, 2000);
        typesSqlTypes.put(OType.LINKSET, 2000);
        typesSqlTypes.put(OType.TRANSIENT, 0);
    }
}

