/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OProfiler
extends OAbstractProfiler {
    protected Map<String, Long> counters = new HashMap<String, Long>();
    protected Map<String, AtomicInteger> tips = new HashMap<String, AtomicInteger>();
    protected Map<String, Long> tipsTimestamp = new HashMap<String, Long>();

    public OProfiler() {
    }

    public OProfiler(OAbstractProfiler profiler) {
        super(profiler);
    }

    @Override
    protected void setTip(String iMessage, AtomicInteger counter) {
        this.tips.put(iMessage, counter);
        this.tipsTimestamp.put(iMessage, System.currentTimeMillis());
    }

    @Override
    protected AtomicInteger getTip(String iMessage) {
        return this.tips.get(iMessage);
    }

    @Override
    public void configure(String iConfiguration) {
        if (iConfiguration == null || iConfiguration.length() == 0) {
            return;
        }
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.startRecording();
    }

    @Override
    public boolean startRecording() {
        this.counters = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tips = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tipsTimestamp = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        if (super.startRecording()) {
            this.counters.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean stopRecording() {
        if (super.stopRecording()) {
            this.counters.clear();
            return true;
        }
        this.counters.clear();
        this.tips.clear();
        this.tipsTimestamp.clear();
        return false;
    }

    @Override
    public void dump(PrintStream out) {
        if (this.recordingFrom < 0L) {
            return;
        }
        StringBuilder buffer = new StringBuilder(super.dump());
        if (this.tips.size() == 0) {
            return;
        }
        buffer.append("TIPS:");
        buffer.append(String.format("\n%100s +------------+", ""));
        buffer.append(String.format("\n%100s | Value      |", "Name"));
        buffer.append(String.format("\n%100s +------------+", ""));
        ArrayList<String> names = new ArrayList<String>(this.tips.keySet());
        Collections.sort(names);
        for (String n : names) {
            AtomicInteger v = this.tips.get(n);
            buffer.append(String.format("\n%-100s | %10d |", n, v.intValue()));
        }
        buffer.append(String.format("\n%100s +------------+", ""));
        out.println(buffer);
    }

    @Override
    public void updateCounter(String statName, String description, long plus, String metadata) {
        Long newValue;
        Long oldValue;
        if (statName == null || !this.isRecording()) {
            return;
        }
        do {
            if ((oldValue = this.counters.get(statName)) != null) continue;
            this.counters.putIfAbsent(statName, 0L);
            oldValue = this.counters.get(statName);
        } while (!this.counters.replace(statName, oldValue, newValue = Long.valueOf(oldValue + plus)));
    }

    @Override
    public long getCounter(String statName) {
        if (statName == null || !this.isRecording()) {
            return -1L;
        }
        Long stat = this.counters.get(statName);
        if (stat == null) {
            return -1L;
        }
        return stat;
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        return null;
    }

    @Override
    public String[] getChronosAsString() {
        return null;
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    @Override
    public void resetRealtime(String iText) {
    }

    @Override
    protected void updateMetadata(String iName, String iDescription, OProfilerMBean.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }
}

