/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import java.util.Locale;

public class OProfilerEntry {
    public String name = null;
    public long entries = 0L;
    public long last = 0L;
    public long min = 999999999L;
    public long max = 0L;
    public float average = 0.0f;
    public long total = 0L;
    public final long firstExecution;
    public long lastExecution = this.firstExecution = System.currentTimeMillis();
    public String payLoad;
    public String description;

    public void updateLastExecution() {
        this.lastExecution = System.currentTimeMillis();
    }

    public String toJSON() {
        StringBuilder buffer = new StringBuilder(1024);
        this.toJSON(buffer);
        return buffer.toString();
    }

    public void toJSON(StringBuilder buffer) {
        buffer.append('{');
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "entries", this.entries));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "last", this.last));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "min", this.min));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "max", this.max));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%.2f,", "average", Float.valueOf(this.average)));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "total", this.total));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d,", "firstExecution", this.firstExecution));
        buffer.append(String.format(Locale.ENGLISH, "\"%s\":%d", "lastExecution", this.lastExecution));
        if (this.payLoad != null) {
            buffer.append(String.format(Locale.ENGLISH, "\"%s\":%s", "payload", this.payLoad));
        }
        buffer.append('}');
    }

    public String toString() {
        return String.format("Profiler entry [%s]: total=%d, average=%.2f, items=%d, last=%d, max=%d, min=%d", this.name, this.total, Float.valueOf(this.average), this.entries, this.last, this.max, this.min);
    }
}

