/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public strictfp class MersenneTwister
extends Random
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4035832775130174188L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private double __nextNextGaussian;
    private boolean __haveNextNextGaussian;

    public MersenneTwister() {
        this(System.currentTimeMillis());
    }

    public MersenneTwister(long seed) {
        super(seed);
        this.setSeed(seed);
    }

    public MersenneTwister(int[] array) {
        super(System.currentTimeMillis());
        this.setSeed(array);
    }

    public Object clone() {
        try {
            MersenneTwister f = (MersenneTwister)super.clone();
            f.mt = (int[])this.mt.clone();
            f.mag01 = (int[])this.mag01.clone();
            return f;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean stateEquals(Object o) {
        int x;
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof MersenneTwister)) {
            return false;
        }
        MersenneTwister other = (MersenneTwister)o;
        if (this.mti != other.mti) {
            return false;
        }
        for (x = 0; x < this.mag01.length; ++x) {
            if (this.mag01[x] == other.mag01[x]) continue;
            return false;
        }
        for (x = 0; x < this.mt.length; ++x) {
            if (this.mt[x] == other.mt[x]) continue;
            return false;
        }
        return true;
    }

    public void readState(DataInputStream stream) throws IOException {
        int x;
        int len = this.mt.length;
        for (x = 0; x < len; ++x) {
            this.mt[x] = stream.readInt();
        }
        len = this.mag01.length;
        for (x = 0; x < len; ++x) {
            this.mag01[x] = stream.readInt();
        }
        this.mti = stream.readInt();
        this.__nextNextGaussian = stream.readDouble();
        this.__haveNextNextGaussian = stream.readBoolean();
    }

    public void writeState(DataOutputStream stream) throws IOException {
        int x;
        int len = this.mt.length;
        for (x = 0; x < len; ++x) {
            stream.writeInt(this.mt[x]);
        }
        len = this.mag01.length;
        for (x = 0; x < len; ++x) {
            stream.writeInt(this.mag01[x]);
        }
        stream.writeInt(this.mti);
        stream.writeDouble(this.__nextNextGaussian);
        stream.writeBoolean(this.__haveNextNextGaussian);
    }

    @Override
    public synchronized void setSeed(long seed) {
        super.setSeed(seed);
        this.__haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
    }

    public synchronized void setSeed(int[] array) {
        int k;
        if (array.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            int n2 = i++;
            this.mt[n2] = this.mt[n2] & 0xFFFFFFFF;
            ++j;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            int n3 = i++;
            this.mt[n3] = this.mt[n3] & 0xFFFFFFFF;
            if (i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public boolean nextBoolean(float probability) {
        if (probability < 0.0f || probability > 1.0f) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0f) {
            return false;
        }
        if (probability == 1.0f) {
            return true;
        }
        return this.nextFloat() < probability;
    }

    public boolean nextBoolean(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        return this.nextDouble() < probability;
    }

    @Override
    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public double nextDouble(boolean includeZero, boolean includeOne) {
        double d = 0.0;
        do {
            d = this.nextDouble();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0;
        } while (d > 1.0 || !includeZero && d == 0.0);
        return d;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextFloat(boolean includeZero, boolean includeOne) {
        float d = 0.0f;
        do {
            d = this.nextFloat();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0f;
        } while (d > 1.0f || !includeZero && d == 0.0f);
        return d;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = (byte)this.next(8);
        }
    }

    public char nextChar() {
        return (char)this.next(16);
    }

    public short nextShort() {
        return (short)this.next(16);
    }

    public byte nextByte() {
        return (byte)this.next(8);
    }

    @Override
    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.__haveNextNextGaussian) {
            this.__haveNextNextGaussian = false;
            return this.__nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.__nextNextGaussian = v2 * multiplier;
        this.__haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    @Override
    protected synchronized int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

