/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;

public class OClassLoaderHelper {
    public static synchronized <T> Iterator<T> lookupProviderWithOrientClassLoader(Class<T> clazz) {
        return OClassLoaderHelper.lookupProviderWithOrientClassLoader(clazz, OClassLoaderHelper.class.getClassLoader());
    }

    public static synchronized <T> Iterator<T> lookupProviderWithOrientClassLoader(Class<T> clazz, ClassLoader orientClassLoader) {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(orientClassLoader);
        try {
            Iterator<T> iterator = ServiceRegistry.lookupProviders(clazz);
            return iterator;
        }
        catch (Exception e) {
            OLogManager.instance().warn(null, "Cannot lookup in service registry", e, new Object[0]);
            throw new OConfigurationException("Cannot lookup in service registry", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }
}

