/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.nio;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.nio.CLibrary;
import com.orientechnologies.nio.OCLibraryFactory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteOrder;

public class OJNADirectMemory
implements ODirectMemory {
    private static final CLibrary C_LIBRARY = OCLibraryFactory.INSTANCE.library();
    public static final OJNADirectMemory INSTANCE = new OJNADirectMemory();
    private static final boolean unaligned;
    private static final ByteOrder alignedOrder;
    private static final boolean onlyAlignedOrder;

    @Override
    public long allocate(long size) {
        long pointer = Native.malloc(size);
        if (pointer == 0L) {
            throw new OutOfMemoryError();
        }
        return pointer;
    }

    @Override
    public void free(long pointer) {
        Native.free(pointer);
    }

    @Override
    public byte[] get(long pointer, int length) {
        return new Pointer(pointer).getByteArray(0L, length);
    }

    @Override
    public void get(long pointer, byte[] array, int arrayOffset, int length) {
        new Pointer(pointer).read(0L, array, arrayOffset, length);
    }

    @Override
    public void set(long pointer, byte[] content, int arrayOffset, int length) {
        new Pointer(pointer).write(0L, content, arrayOffset, length);
    }

    @Override
    public int getInt(long pointer) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            return ptr.getInt(0L);
        }
        if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (0xFF & ptr.getByte(0L)) << 24 | (0xFF & ptr.getByte(1L)) << 16 | (0xFF & ptr.getByte(2L)) << 8 | 0xFF & ptr.getByte(3L);
        }
        return 0xFF & ptr.getByte(0L) | (0xFF & ptr.getByte(1L)) << 8 | (0xFF & ptr.getByte(2L)) << 16 | (0xFF & ptr.getByte(3L)) << 24;
    }

    @Override
    public void setInt(long pointer, int value) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            ptr.setInt(0L, value);
        } else if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            ptr.setByte(0L, (byte)(value >>> 24));
            ptr.setByte(1L, (byte)(value >>> 16));
            ptr.setByte(2L, (byte)(value >>> 8));
            ptr.setByte(3L, (byte)value);
        } else {
            ptr.setByte(0L, (byte)value);
            ptr.setByte(1L, (byte)(value >>> 8));
            ptr.setByte(2L, (byte)(value >>> 16));
            ptr.setByte(3L, (byte)(value >>> 24));
        }
    }

    @Override
    public void setShort(long pointer, short value) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            ptr.setShort(0L, value);
        } else if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            ptr.setByte(0L, (byte)(value >>> 8));
            ptr.setByte(1L, (byte)value);
        } else {
            ptr.setByte(0L, (byte)value);
            ptr.setByte(1L, (byte)(value >>> 8));
        }
    }

    @Override
    public short getShort(long pointer) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            return ptr.getShort(0L);
        }
        if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (short)(ptr.getByte(0L) << 8 | ptr.getByte(1L) & 0xFF);
        }
        return (short)(ptr.getByte(0L) & 0xFF | ptr.getByte(1L) << 8);
    }

    @Override
    public long getLong(long pointer) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            return ptr.getLong(0L);
        }
        if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (0xFFL & (long)ptr.getByte(0L)) << 56 | (0xFFL & (long)ptr.getByte(1L)) << 48 | (0xFFL & (long)ptr.getByte(2L)) << 40 | (0xFFL & (long)ptr.getByte(3L)) << 32 | (0xFFL & (long)ptr.getByte(4L)) << 24 | (0xFFL & (long)ptr.getByte(5L)) << 16 | (0xFFL & (long)ptr.getByte(6L)) << 8 | 0xFFL & (long)ptr.getByte(7L);
        }
        return 0xFFL & (long)ptr.getByte(0L) | (0xFFL & (long)ptr.getByte(1L)) << 8 | (0xFFL & (long)ptr.getByte(2L)) << 16 | (0xFFL & (long)ptr.getByte(3L)) << 24 | (0xFFL & (long)ptr.getByte(4L)) << 32 | (0xFFL & (long)ptr.getByte(5L)) << 40 | (0xFFL & (long)ptr.getByte(6L)) << 48 | (0xFFL & (long)ptr.getByte(7L)) << 56;
    }

    @Override
    public void setLong(long pointer, long value) {
        Pointer ptr = new Pointer(pointer);
        if (unaligned) {
            ptr.setLong(0L, value);
        } else if (alignedOrder.equals(ByteOrder.BIG_ENDIAN)) {
            ptr.setByte(0L, (byte)(value >>> 56));
            ptr.setByte(1L, (byte)(value >>> 48));
            ptr.setByte(2L, (byte)(value >>> 40));
            ptr.setByte(3L, (byte)(value >>> 32));
            ptr.setByte(4L, (byte)(value >>> 24));
            ptr.setByte(5L, (byte)(value >>> 16));
            ptr.setByte(6L, (byte)(value >>> 8));
            ptr.setByte(7L, (byte)value);
        } else {
            ptr.setByte(0L, (byte)value);
            ptr.setByte(1L, (byte)(value >>> 8));
            ptr.setByte(2L, (byte)(value >>> 16));
            ptr.setByte(3L, (byte)(value >>> 24));
            ptr.setByte(4L, (byte)(value >>> 32));
            ptr.setByte(5L, (byte)(value >>> 40));
            ptr.setByte(6L, (byte)(value >>> 48));
            ptr.setByte(7L, (byte)(value >>> 56));
        }
    }

    @Override
    public byte getByte(long pointer) {
        return new Pointer(pointer).getByte(0L);
    }

    @Override
    public void setByte(long pointer, byte value) {
        new Pointer(pointer).setByte(0L, value);
    }

    @Override
    public void setChar(long pointer, char value) {
        short short_char = (short)value;
        this.setShort(pointer, short_char);
    }

    @Override
    public char getChar(long pointer) {
        short short_char = this.getShort(pointer);
        return (char)short_char;
    }

    @Override
    public void moveData(long srcPointer, long destPointer, long len) {
        C_LIBRARY.memoryMove(srcPointer, destPointer, len);
    }

    static {
        onlyAlignedOrder = OGlobalConfiguration.DIRECT_MEMORY_ONLY_ALIGNED_ACCESS.getValueAsBoolean();
        alignedOrder = ByteOrder.nativeOrder();
        unaligned = !onlyAlignedOrder;
    }
}

