/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.console.OConsoleDatabaseListener;
import com.orientechnologies.orient.console.OTableFormatter;
import com.orientechnologies.orient.console.OrientConsole;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.OBonsaiTreeRepair;
import com.orientechnologies.orient.core.db.tool.ODatabaseCompare;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.intent.OIntentMassiveRead;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class OConsoleDatabaseApp
extends OrientConsole
implements OCommandOutputListener,
OProgressListener {
    protected static final int DEFAULT_WIDTH = 150;
    protected ODatabaseDocumentTx currentDatabase;
    protected String currentDatabaseName;
    protected ORecord currentRecord;
    protected int currentRecordIdx;
    protected List<OIdentifiable> currentResultSet;
    protected Object currentResult;
    protected OServerAdmin serverAdmin;
    private int windowSize = 150;
    private int lastPercentStep;
    private String currentDatabaseUserName;
    private String currentDatabaseUserPassword;
    private int collectionMaxItems = 10;

    public OConsoleDatabaseApp(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result = 0;
        try {
            boolean tty = false;
            try {
                if (OConsoleDatabaseApp.setTerminalToCBreak()) {
                    tty = true;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        OConsoleDatabaseApp.restoreTerminal();
                    }
                });
            }
            catch (Exception ignored) {
                // empty catch block
            }
            new OSignalHandler().installDefaultSignals(new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    OConsoleDatabaseApp.restoreTerminal();
                }
            });
            OConsoleDatabaseApp console = new OConsoleDatabaseApp(args);
            if (tty) {
                console.setReader(new TTYConsoleReader());
            }
            result = console.run();
        }
        finally {
            OConsoleDatabaseApp.restoreTerminal();
        }
        Orient.instance().shutdown();
        System.exit(result);
    }

    protected static void restoreTerminal() {
        try {
            OConsoleDatabaseApp.stty("echo");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static boolean setTerminalToCBreak() throws IOException, InterruptedException {
        int result = OConsoleDatabaseApp.stty("-icanon min 1");
        if (result != 0) {
            return false;
        }
        OConsoleDatabaseApp.stty("-echo");
        return true;
    }

    protected static int stty(String args) throws IOException, InterruptedException {
        String cmd = "stty " + args + " < /dev/tty";
        return OConsoleDatabaseApp.exec(new String[]{"sh", "-c", cmd});
    }

    protected static int exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        return p.exitValue();
    }

    @ConsoleCommand(aliases={"use database"}, description="Connect to a database or a remote Server instance")
    public void connect(@ConsoleParameter(name="url", description="The url of the remote server or the database to connect to in the format '<mode>:<path>'") String iURL, @ConsoleParameter(name="user", description="User name") String iUserName, @ConsoleParameter(name="password", description="User password", optional=true) String iUserPassword) throws IOException {
        this.disconnect();
        if (iUserPassword == null) {
            this.message("Enter password: ", new Object[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            iUserPassword = br.readLine();
            this.message("\n", new Object[0]);
        }
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iURL.contains("/")) {
            this.message("\nConnecting to database [" + iURL + "] with user '" + iUserName + "'...", new Object[0]);
            this.currentDatabase = new ODatabaseDocumentTx(iURL);
            this.currentDatabase.registerListener(new OConsoleDatabaseListener(this));
            this.currentDatabase.open(iUserName, iUserPassword);
            this.currentDatabaseName = this.currentDatabase.getName();
        } else {
            this.message("\nConnecting to remote Server instance [" + iURL + "] with user '" + iUserName + "'...", new Object[0]);
            this.serverAdmin = new OServerAdmin(iURL).connect(iUserName, iUserPassword);
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.message("OK", new Object[0]);
        this.dumpDistributedConfiguration(false);
    }

    @ConsoleCommand(aliases={"close database"}, description="Disconnect from the current database")
    public void disconnect() {
        if (this.serverAdmin != null) {
            this.message("\nDisconnecting from remote server [" + this.serverAdmin.getURL() + "]...", new Object[0]);
            this.serverAdmin.close(true);
            this.serverAdmin = null;
            this.message("\nOK", new Object[0]);
        }
        if (this.currentDatabase != null) {
            this.message("\nDisconnecting from the database [" + this.currentDatabaseName + "]...", new Object[0]);
            OStorage stg = Orient.instance().getStorage(this.currentDatabase.getURL());
            this.currentDatabase.close();
            if (stg != null) {
                stg.close(true, false);
            }
            this.currentDatabase = null;
            this.currentDatabaseName = null;
            this.currentRecord = null;
            this.message("OK", new Object[0]);
        }
    }

    @ConsoleCommand(description="Create a new database")
    public void createDatabase(@ConsoleParameter(name="database-url", description="The url of the database to create in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", optional=true, description="Server administrator name") String iUserName, @ConsoleParameter(name="password", optional=true, description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", optional=true, description="The type of the storage. 'local' and 'plocal' for disk-based databases and 'memory' for in-memory database") String iStorageType, @ConsoleParameter(name="db-type", optional=true, description="The type of the database used between 'document' and 'graph'. By default is graph.") String iDatabaseType) throws IOException {
        if (iUserName == null) {
            iUserName = "admin";
        }
        if (iUserPassword == null) {
            iUserPassword = "admin";
        }
        if (iStorageType == null) {
            if (iDatabaseURL.startsWith("remote:")) {
                throw new IllegalArgumentException("Missing storage type for remote database");
            }
            int pos = iDatabaseURL.indexOf(":");
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid URL");
            }
            iStorageType = iDatabaseURL.substring(0, pos);
        }
        if (iDatabaseType == null) {
            iDatabaseType = "graph";
        }
        this.message("\nCreating database [" + iDatabaseURL + "] using the storage type [" + iStorageType + "]...", new Object[0]);
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(iUserName, iUserPassword).createDatabase(iDatabaseType, iStorageType).close();
            this.connect(iDatabaseURL, "admin", "admin");
        } else {
            if (iStorageType != null && !iDatabaseURL.toLowerCase().startsWith(iStorageType.toLowerCase())) {
                throw new IllegalArgumentException("Storage type '" + iStorageType + "' is different by storage type in URL");
            }
            this.currentDatabase = Orient.instance().getDatabaseFactory().createDatabase(iDatabaseType, iDatabaseURL);
            this.currentDatabase.create();
            this.currentDatabaseName = this.currentDatabase.getName();
        }
        this.message("\nDatabase created successfully.", new Object[0]);
        this.message("\n\nCurrent database is: " + iDatabaseURL, new Object[0]);
    }

    @ConsoleCommand(description="List all the databases available on the connected server")
    public void listDatabases() throws IOException {
        if (this.serverAdmin != null) {
            Map<String, String> databases = this.serverAdmin.listDatabases();
            this.message("\nFound %d databases:\n", databases.size());
            for (Map.Entry<String, String> database : databases.entrySet()) {
                this.message("\n* %s (%s)", database.getKey(), database.getValue().substring(0, database.getValue().indexOf(":")));
            }
        } else {
            this.message("\nNot connected to the Server instance. You've to connect to the Server using server's credentials (look at orientdb-*server-config.xml file)", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="Reload the database schema")
    public void reloadSchema() throws IOException {
        this.message("\nreloading database schema...", new Object[0]);
        this.updateDatabaseInfo();
        this.message("\n\nDone.", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new cluster in the current database. The cluster can be physical or memory")
    public void createCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCluster created correctly with id #%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Remove a cluster in the current database. The cluster can be physical or memory")
    public void dropCluster(@ConsoleParameter(name="cluster-name", description="The name or the id of the cluster to remove") String iClusterName) {
        this.checkForDatabase();
        this.message("\nDropping cluster [" + iClusterName + "] in database " + this.currentDatabaseName + "...", new Object[0]);
        boolean result = this.currentDatabase.dropCluster(iClusterName, true);
        if (!result) {
            try {
                int clusterId = Integer.parseInt(iClusterName);
                if (clusterId > -1) {
                    result = this.currentDatabase.dropCluster(clusterId, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result) {
            this.message("\nCluster correctly removed", new Object[0]);
        } else {
            this.message("\nCannot find the cluster to remove", new Object[0]);
        }
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alters a cluster in the current database. The cluster can be physical or memory")
    public void alterCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nCluster updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Begins a transaction. All the changes will remain local")
    public void begin() throws IOException {
        this.checkForDatabase();
        if (this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: an active transaction is currently open (id=" + this.currentDatabase.getTransaction().getId() + "). Commit or rollback before starting a new one.", new Object[0]);
            return;
        }
        this.currentDatabase.begin();
        this.message("\nTransaction " + this.currentDatabase.getTransaction().getId() + " is running", new Object[0]);
    }

    @ConsoleCommand(description="Commits transaction changes to the database")
    public void commit() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is currently open.", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.commit();
        this.message("\nTransaction " + txId + " has been committed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(description="Rolls back transaction changes to the previous state")
    public void rollback() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.message("\nError: no active transaction is running right now.", new Object[0]);
            return;
        }
        long begin = System.currentTimeMillis();
        int txId = this.currentDatabase.getTransaction().getId();
        this.currentDatabase.rollback();
        this.message("\nTransaction " + txId + " has been rollbacked in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the class content in the current database")
    public void truncateClass(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the cluster content in the current database")
    public void truncateCluster(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate a record deleting it at low level")
    public void truncateRecord(@ConsoleParameter(name="text", description="The record(s) to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Load a record in memory using passed fetch plan")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.loadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Load a record in memory and set it as the current")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.loadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(description="Reloads a record using passed fetch plan")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.reloadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Reload a record and set it as the current one")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.reloadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(splitInWords=false, description="Explain how a command is executed profiling it")
    public void explain(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        Object result = this.sqlCommand("explain", iCommandText, "\nProfiled command '%s' in %f sec(s):\n", true);
        if (result != null && result instanceof ODocument) {
            this.message(((ODocument)result).toJSON(), new Object[0]);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Executes a command inside a transaction")
    public void transactional(@ConsoleParameter(name="command-text", description="The command to execute") String iCommandText) {
        this.sqlCommand("transactional", iCommandText, "\nResult: '%s'. Executed in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Insert a new record into the database")
    public void insert(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("insert", iCommandText, "\nInserted record '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new vertex into the database")
    public void createVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated vertex '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a new edge into the database")
    public void createEdge(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated edge '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Update records in the database")
    public void update(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("update", iCommandText, "\nUpdated record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="Move vertices to another position (class/cluster)", priority=8)
    public void moveVertex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("move", iCommandText, "\nMove vertex command executed with result '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Force calling of JVM Garbage Collection")
    public void gc() {
        System.gc();
    }

    @ConsoleCommand(splitInWords=false, description="Delete records from the database")
    public void delete(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("delete", iCommandText, "\nDelete record(s) '%s' in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLocalCache().invalidate();
    }

    @ConsoleCommand(splitInWords=false, description="Grant privileges to a role")
    public void grant(@ConsoleParameter(name="text", description="Grant command") String iCommandText) {
        this.sqlCommand("grant", iCommandText, "\nPrivilege granted to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Revoke privileges to a role")
    public void revoke(@ConsoleParameter(name="text", description="Revoke command") String iCommandText) {
        this.sqlCommand("revoke", iCommandText, "\nPrivilege revoked to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a link from a JOIN")
    public void createLink(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated %d link(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Find all references the target record id @rid")
    public void findReferences(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("find", iCommandText, "\nFound %s in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Alter a database property")
    public void alterDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nDatabase updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Freeze database and flush on the disk")
    public void freezeDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).freezeDatabase(storageType);
        } else {
            this.currentDatabase.freeze();
        }
        this.message("\n\nDatabase '" + dbName + "' was frozen successfully", new Object[0]);
    }

    @ConsoleCommand(description="Release database after freeze")
    public void releaseDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).releaseDatabase(storageType);
        } else {
            this.currentDatabase.release();
        }
        this.message("\n\nDatabase '" + dbName + "' was released successfully", new Object[0]);
    }

    @ConsoleCommand(description="Flushes all database content to the disk")
    public void flushDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.freezeDatabase(storageType);
        this.releaseDatabase(storageType);
    }

    @ConsoleCommand(description="Freeze clusters and flush on the disk")
    public void freezeCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster to freeze") String iClusterName, @ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        int clusterId = this.currentDatabase.getClusterIdByName(iClusterName);
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).freezeCluster(clusterId, storageType);
        } else {
            this.currentDatabase.freezeCluster(clusterId);
        }
        this.message("\n\nCluster '" + iClusterName + "' was frozen successfully", new Object[0]);
    }

    @ConsoleCommand(description="Release cluster after freeze")
    public void releaseCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster to unfreeze") String iClusterName, @ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        int clusterId = this.currentDatabase.getClusterIdByName(iClusterName);
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (storageType == null) {
                storageType = "plocal";
            }
            new OServerAdmin(this.currentDatabase.getURL()).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).releaseCluster(clusterId, storageType);
        } else {
            this.currentDatabase.releaseCluster(clusterId);
        }
        this.message("\n\nCluster '" + iClusterName + "' was released successfully", new Object[0]);
    }

    @ConsoleCommand(description="Display current record")
    public void current() {
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record cursor to the next one in result set")
    public void next() {
        this.setCurrentRecord(this.currentRecordIdx + 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Move the current record cursor to the previous one in result set")
    public void prev() {
        this.setCurrentRecord(this.currentRecordIdx - 1);
        this.dumpRecordDetails();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class in the database schema")
    public void alterClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nClass updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a class")
    public void createClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nClass created successfully. Total classes in database now: %d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class property in the database schema")
    public void alterProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nProperty updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a property")
    public void createProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nProperty created successfully with id=%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a stored function")
    public void createFunction(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nFunction created successfully with id=%s\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Traverse records and display the results")
    public void traverse(@ConsoleParameter(name="query-text", description="The traverse to execute") String iQueryText) {
        int limit = iQueryText.contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.setResultset((List)this.currentDatabase.command(new OCommandSQL("traverse " + iQueryText)).execute(new Object[0]));
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(limit);
        this.message("\n\n" + this.currentResultSet.size() + " item(s) found. Traverse executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a query against the database and display the results")
    public void select(@ConsoleParameter(name="query-text", description="The query to execute") String iQueryText) {
        this.checkForDatabase();
        if (iQueryText == null) {
            return;
        }
        if ((iQueryText = iQueryText.trim()).length() == 0 || iQueryText.equalsIgnoreCase("select")) {
            return;
        }
        iQueryText = "select " + iQueryText;
        int limit = iQueryText.contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.setResultset((List<OIdentifiable>)this.currentDatabase.query(new OSQLSynchQuery(iQueryText, limit).setFetchPlan("*:0"), new Object[0]));
        float elapsedSeconds = this.getElapsedSecs(start);
        this.dumpResultSet(limit);
        this.message("\n\n" + this.currentResultSet.size() + " item(s) found. Query executed in " + elapsedSeconds + " sec(s).", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Move from current record by evaluating a predicate against current record")
    public void move(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate(this.currentRecord, null, null);
        if (result != null) {
            if (result instanceof OIdentifiable) {
                this.setResultset(new ArrayList<OIdentifiable>());
                this.currentRecord = ((OIdentifiable)result).getRecord();
                this.dumpRecordDetails();
            } else if (result instanceof List) {
                this.setResultset((List)result);
                this.dumpResultSet(-1);
            } else if (result instanceof Iterator) {
                ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                while (((Iterator)result).hasNext()) {
                    list.add((OIdentifiable)((Iterator)result).next());
                }
                this.setResultset(list);
                this.dumpResultSet(-1);
            } else {
                this.setResultset(new ArrayList<OIdentifiable>());
            }
        }
    }

    @ConsoleCommand(splitInWords=false, description="Evaluate a predicate against current record")
    public void eval(@ConsoleParameter(name="text", description="The sql predicate to evaluate") String iText) {
        if (iText == null) {
            return;
        }
        if (this.currentRecord == null) {
            return;
        }
        Object result = new OSQLPredicate(iText).evaluate(this.currentRecord, null, null);
        if (result != null) {
            this.out.println("\n" + result);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute a script containing multiple commands separated by ; or new line")
    public void script(@ConsoleParameter(name="text", description="Commands to execute, one per line") String iText) {
        int languageEndPos = iText.indexOf(";");
        if (languageEndPos <= -1) {
            throw new IllegalArgumentException("Missing language in script (sql, js, gremlin, etc.) as first argument");
        }
        String language = iText.substring(0, languageEndPos);
        iText = iText.substring(languageEndPos + 1);
        this.executeServerSideScript(language, iText);
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands in the console")
    public void js(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        OCommandExecutorScript cmd = new OCommandExecutorScript();
        cmd.parse(new OCommandScript("Javascript", iText));
        long start = System.currentTimeMillis();
        this.currentResult = cmd.execute(null);
        float elapsedSeconds = this.getElapsedSecs(start);
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nClient side script executed in %f sec(s). Returned %d records", Float.valueOf(elapsedSeconds), this.currentResultSet.size());
        } else {
            this.message("\nClient side script executed in %f sec(s). Value returned is: %s", Float.valueOf(elapsedSeconds), this.currentResult);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands against a remote server")
    public void jss(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        this.checkForRemoteServer();
        this.executeServerSideScript("javascript", iText);
    }

    @ConsoleCommand(splitInWords=false, description="Create an index against a property")
    public void createIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nCreating index...", new Object[0]);
        this.sqlCommand("create", iCommandText, "\nCreated index successfully with %d entries in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.message("\n\nIndex created successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the current database")
    public void dropDatabase(@ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (this.serverAdmin == null) {
                this.message("\n\nCannot drop a remote database without connecting to the server with a valid server's user", new Object[0]);
                return;
            }
            if (storageType == null) {
                storageType = "plocal";
            }
            String dbURL = this.currentDatabase.getURL().substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).dropDatabase(storageType);
        } else {
            this.currentDatabase.drop();
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.message("\n\nDatabase '" + dbName + "' deleted successfully", new Object[0]);
    }

    @ConsoleCommand(description="Delete the specified database")
    public void dropDatabase(@ConsoleParameter(name="database-url", description="The url of the database to drop in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", description="Server administrator name") String iUserName, @ConsoleParameter(name="password", description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", description="Storage type of server database", optional=true) String storageType) throws IOException {
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            if (this.serverAdmin != null) {
                this.serverAdmin.close();
            }
            this.serverAdmin = new OServerAdmin(dbURL).connect(iUserName, iUserPassword);
            this.serverAdmin.dropDatabase(storageType);
            this.disconnect();
        } else {
            this.currentDatabase = new ODatabaseDocumentTx(iDatabaseURL);
            if (this.currentDatabase.exists()) {
                this.currentDatabase.open(iUserName, iUserPassword);
                this.currentDatabase.drop();
            } else {
                this.message("\n\nCannot drop database '" + iDatabaseURL + "' because was not found", new Object[0]);
            }
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.message("\n\nDatabase '" + iDatabaseURL + "' deleted successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Remove an index")
    public void dropIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRemoving index...", new Object[0]);
        this.sqlCommand("drop", iCommandText, "\nDropped index in %f sec(s).\n", false);
        this.updateDatabaseInfo();
        this.message("\n\nIndex removed successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Rebuild an index if it is automatic")
    public void rebuildIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.message("\n\nRebuilding index(es)...", new Object[0]);
        this.sqlCommand("rebuild", iCommandText, "\nRebuilt index(es). Found %d link(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.message("\n\nIndex(es) rebuilt successfully", new Object[0]);
    }

    @ConsoleCommand(splitInWords=false, description="Remove a class from the schema")
    public void dropClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Remove a property from a class")
    public void dropProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class property in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Browse all records of a class")
    public void browseClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        this.checkForDatabase();
        this.resetResultSet();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorClass<ODocument> it = this.currentDatabase.browseClass(iClassName);
        this.browseRecords(limit, it);
    }

    @ConsoleCommand(description="Browse all records of a cluster")
    public void browseCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster") String iClusterName) {
        this.checkForDatabase();
        this.resetResultSet();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorCluster<ODocument> it = this.currentDatabase.browseCluster(iClusterName);
        this.browseRecords(limit, it);
    }

    @ConsoleCommand(aliases={"display"}, description="Display current record attributes")
    public void displayRecord(@ConsoleParameter(name="number", description="The number of the record in the most recent result set") String iRecordNumber) {
        this.checkForDatabase();
        if (iRecordNumber == null || this.currentResultSet == null) {
            this.checkCurrentObject();
        } else {
            int recNumber = Integer.parseInt(iRecordNumber);
            if (this.currentResultSet.size() == 0) {
                throw new OException("No result set where to find the requested record. Execute a query first.");
            }
            if (this.currentResultSet.size() <= recNumber) {
                throw new OException("The record requested is not part of current result set (0" + (this.currentResultSet.size() > 0 ? "-" + (this.currentResultSet.size() - 1) : "") + ")");
            }
            this.setCurrentRecord(recNumber);
        }
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Display a record as raw bytes")
    public void displayRawRecord(@ConsoleParameter(name="rid", description="The record id to display") String iRecordId) {
        ORecordId rid;
        this.checkForDatabase();
        if (iRecordId.indexOf(58) > -1) {
            rid = new ORecordId(iRecordId);
        } else {
            OIdentifiable rec = this.setCurrentRecord(Integer.parseInt(iRecordId));
            if (rec != null) {
                rid = (ORecordId)rec.getIdentity();
            } else {
                return;
            }
        }
        ORawBuffer buffer = this.currentDatabase.getStorage().readRecord(rid, null, false, null).getResult();
        if (buffer == null) {
            throw new OException("The record has been deleted");
        }
        String content = Integer.parseInt((String)this.properties.get("maxBinaryDisplay")) < buffer.buffer.length ? new String(Arrays.copyOf(buffer.buffer, Integer.parseInt((String)this.properties.get("maxBinaryDisplay")))) : new String(buffer.buffer);
        this.out.println("\nRaw record content. The size is " + buffer.buffer.length + " bytes, while settings force to print first " + content.length() + " bytes:\n\n" + content);
    }

    @ConsoleCommand(aliases={"status"}, description="Display information about the database")
    public void info() {
        if (this.currentDatabaseName != null) {
            this.message("\nCurrent database: " + this.currentDatabaseName + " (url=" + this.currentDatabase.getURL() + ")", new Object[0]);
            OStorage stg = this.currentDatabase.getStorage();
            if (stg instanceof OStorageRemoteThread) {
                this.dumpDistributedConfiguration(true);
            }
            this.listProperties();
            this.listClusters();
            this.listClasses();
            this.listIndexes();
        }
    }

    @ConsoleCommand(description="Display the database properties")
    public void listProperties() {
        if (this.currentDatabase == null) {
            return;
        }
        OStorage stg = this.currentDatabase.getStorage();
        OStorageConfiguration dbCfg = stg.getConfiguration();
        this.message("\n\nDATABASE PROPERTIES", new Object[0]);
        if (dbCfg.properties != null) {
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            this.message("\n NAME                           | VALUE                                              |", new Object[0]);
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            this.message("\n %-30s | %-50s |", "Name", this.format(dbCfg.name, 50));
            this.message("\n %-30s | %-50s |", "Version", this.format("" + dbCfg.version, 50));
            this.message("\n %-30s | %-50s |", "Conflict Strategy", this.format(dbCfg.getConflictStrategy(), 50));
            this.message("\n %-30s | %-50s |", "Date format", this.format(dbCfg.dateFormat, 50));
            this.message("\n %-30s | %-50s |", "Datetime format", this.format(dbCfg.dateTimeFormat, 50));
            this.message("\n %-30s | %-50s |", "Timezone", this.format(dbCfg.getTimeZone().getID(), 50));
            this.message("\n %-30s | %-50s |", "Locale Country", this.format(dbCfg.getLocaleCountry(), 50));
            this.message("\n %-30s | %-50s |", "Locale Language", this.format(dbCfg.getLocaleLanguage(), 50));
            this.message("\n %-30s | %-50s |", "Charset", this.format(dbCfg.getCharset(), 50));
            this.message("\n %-30s | %-50s |", "Schema RID", this.format(dbCfg.schemaRecordId, 50));
            this.message("\n %-30s | %-50s |", "Index Manager RID", this.format(dbCfg.indexMgrRecordId, 50));
            this.message("\n %-30s | %-50s |", "Dictionary RID", this.format(dbCfg.dictionaryRecordId, 50));
            this.message("\n--------------------------------+----------------------------------------------------+", new Object[0]);
            if (!dbCfg.properties.isEmpty()) {
                this.message("\n\nDATABASE CUSTOM PROPERTIES:", new Object[0]);
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
                this.message("\n | NAME                          | VALUE                                            |", new Object[0]);
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
                for (OStorageEntryConfiguration cfg : dbCfg.properties) {
                    this.message("\n | %-29s | %-49s|", cfg.name, this.format(cfg.value, 49));
                }
                this.message("\n +-------------------------------+--------------------------------------------------+", new Object[0]);
            }
        }
    }

    @ConsoleCommand(aliases={"desc"}, description="Display the schema of a class")
    public void infoClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        Set<OIndex<?>> indexes;
        if (this.currentDatabaseName == null) {
            this.message("\nNo database selected yet.", new Object[0]);
            return;
        }
        OClass cls = this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClass(iClassName);
        if (cls == null) {
            this.message("\n! Class '" + iClassName + "' does not exist in the database '" + this.currentDatabaseName + "'", new Object[0]);
            return;
        }
        this.message("\nClass................: " + cls, new Object[0]);
        if (cls.getShortName() != null) {
            this.message("\nAlias................: " + cls.getShortName(), new Object[0]);
        }
        if (cls.getSuperClass() != null) {
            this.message("\nSuper class..........: " + cls.getSuperClass(), new Object[0]);
        }
        this.message("\nDefault cluster......: " + this.currentDatabase.getClusterNameById(cls.getDefaultClusterId()) + " (id=" + cls.getDefaultClusterId() + ")", new Object[0]);
        this.message("\nSupported cluster ids: " + Arrays.toString(cls.getClusterIds()), new Object[0]);
        this.message("\nCluster selection....: " + cls.getClusterSelection().getName(), new Object[0]);
        if (!cls.getBaseClasses().isEmpty()) {
            this.message("\nBase classes.........: ", new Object[0]);
            int i = 0;
            for (OClass oClass : cls.getBaseClasses()) {
                if (i > 0) {
                    this.message(", ", new Object[0]);
                }
                this.message(oClass.getName(), new Object[0]);
                ++i;
            }
            this.out.println();
        }
        if (cls.properties().size() > 0) {
            this.message("\nPROPERTIES", new Object[0]);
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
            this.message("\n NAME                          | TYPE        | LINKED TYPE/CLASS             | MANDATORY | READONLY | NOT NULL |    MIN    |    MAX    | COLLATE  |", new Object[0]);
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
            for (OProperty p : cls.properties()) {
                try {
                    this.message("\n %-30s| %-12s| %-30s| %-10s| %-9s| %-9s| %-10s| %-10s| %-9s|", new Object[]{p.getName(), p.getType(), p.getLinkedClass() != null ? p.getLinkedClass() : p.getLinkedType(), p.isMandatory(), p.isReadonly(), p.isNotNull(), p.getMin() != null ? p.getMin() : "", p.getMax() != null ? p.getMax() : "", p.getCollate() != null ? p.getCollate().getName() : ""});
                }
                catch (Exception exception) {}
            }
            this.message("\n-------------------------------+-------------+-------------------------------+-----------+----------+----------+-----------+-----------+----------+", new Object[0]);
        }
        if (!(indexes = cls.getClassIndexes()).isEmpty()) {
            this.message("\n\nINDEXES (" + indexes.size() + " altogether)", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            this.message("\n NAME                          | PROPERTIES     |", new Object[0]);
            this.message("\n-------------------------------+----------------+", new Object[0]);
            for (OIndex oIndex : indexes) {
                OIndexDefinition indexDefinition = oIndex.getDefinition();
                if (indexDefinition != null) {
                    List<String> fields = indexDefinition.getFields();
                    this.message("\n %-30s| %-15s|", oIndex.getName(), fields.get(0) + (fields.size() > 1 ? " (+)" : ""));
                    for (int i = 1; i < fields.size(); ++i) {
                        if (i < fields.size() - 1) {
                            this.message("\n %-30s| %-15s|", "", fields.get(i) + " (+)");
                            continue;
                        }
                        this.message("\n %-30s| %-15s|", "", fields.get(i));
                    }
                    continue;
                }
                this.message("\n %-30s| %-15s|", oIndex.getName(), "");
            }
            this.message("\n-------------------------------+----------------+", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all indexes", aliases={"indexes"})
    public void listIndexes() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nINDEXES", new Object[0]);
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            this.message("\n NAME                                         | TYPE       |         CLASS         |     FIELDS     | RECORDS    |", new Object[0]);
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            int totalIndexes = 0;
            long totalRecords = 0L;
            ArrayList indexes = new ArrayList(this.currentDatabase.getMetadata().getIndexManager().getIndexes());
            Collections.sort(indexes, new Comparator<OIndex<?>>(){

                @Override
                public int compare(OIndex<?> o1, OIndex<?> o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (OIndex oIndex : indexes) {
                try {
                    OIndexDefinition indexDefinition = oIndex.getDefinition();
                    long size = oIndex.getKeySize();
                    if (indexDefinition == null || indexDefinition.getClassName() == null) {
                        this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", this.format(oIndex.getName(), 45), this.format(oIndex.getType(), 10), "", "", size);
                    } else {
                        List<String> fields = indexDefinition.getFields();
                        if (fields.size() == 1) {
                            this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", this.format(oIndex.getName(), 45), this.format(oIndex.getType(), 10), this.format(indexDefinition.getClassName(), 22), this.format(fields.get(0), 10), size);
                        } else {
                            this.message("\n %-45s| %-10s | %-22s| %-15s|%11d |", this.format(oIndex.getName(), 45), this.format(oIndex.getType(), 10), this.format(indexDefinition.getClassName(), 22), this.format(fields.get(0), 10), size);
                            for (int i = 1; i < fields.size(); ++i) {
                                this.message("\n %-45s| %-10s | %-22s| %-15s|%11s |", "", "", "", fields.get(i), "");
                            }
                        }
                    }
                    ++totalIndexes;
                    totalRecords += size;
                }
                catch (Exception ignored) {}
            }
            this.message("\n----------------------------------------------+------------+-----------------------+----------------+------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                                                     %15d |", totalIndexes, totalRecords);
            this.message("\n-----------------------------------------------------------------------------------------------------------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured clusters", aliases={"clusters"})
    public void listClusters() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nCLUSTERS", new Object[0]);
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            this.message("\n NAME                                         | ID    | CONFLICT STRATEGY | RECORDS        |", new Object[0]);
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            long totalElements = 0L;
            ArrayList<String> clusters = new ArrayList<String>(this.currentDatabase.getClusterNames());
            Collections.sort(clusters);
            for (String clusterName : clusters) {
                try {
                    int clusterId = this.currentDatabase.getClusterIdByName(clusterName);
                    OCluster cluster = this.currentDatabase.getStorage().getClusterById(clusterId);
                    String conflictStrategy = cluster.getRecordConflictStrategy() != null ? cluster.getRecordConflictStrategy().getName() : "";
                    long count = this.currentDatabase.countClusterElements(clusterName);
                    totalElements += count;
                    this.message("\n %-45s| %5d | %-17s |%15d |", this.format(clusterName, 45), clusterId, this.format(conflictStrategy, 15), count);
                }
                catch (Exception e) {
                    if (!(e instanceof OIOException)) continue;
                    break;
                }
            }
            this.message("\n----------------------------------------------+-------+-------------------+----------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                              |%15d |", clusters.size(), totalElements);
            this.message("\n------------------------------------------------------+-------------------+----------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Display all the configured classes", aliases={"classes"})
    public void listClasses() {
        if (this.currentDatabaseName != null) {
            this.message("\n\nCLASSES", new Object[0]);
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            this.message("\n NAME                                         | SUPERCLASS                         | CLUSTERS   | RECORDS        |", new Object[0]);
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            long totalElements = 0L;
            ArrayList<OClass> classes = new ArrayList<OClass>(this.currentDatabase.getMetadata().getImmutableSchemaSnapshot().getClasses());
            Collections.sort(classes, new Comparator<OClass>(){

                @Override
                public int compare(OClass o1, OClass o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (OClass cls : classes) {
                try {
                    StringBuilder clusters = new StringBuilder(1024);
                    if (cls.isAbstract()) {
                        clusters.append("-");
                    } else {
                        for (int i = 0; i < cls.getClusterIds().length; ++i) {
                            if (i > 0) {
                                clusters.append(",");
                            }
                            clusters.append(cls.getClusterIds()[i]);
                        }
                    }
                    long count = this.currentDatabase.countClass(cls.getName(), false);
                    totalElements += count;
                    String superClass = cls.getSuperClass() != null ? cls.getSuperClass().getName() : "";
                    this.message("\n %-45s| %-35s| %-11s|%15d |", this.format(cls.getName(), 45), this.format(superClass, 35), clusters.toString(), count);
                }
                catch (Exception ignored) {}
            }
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
            this.message("\n TOTAL = %-3d                                                                                     %15d |", classes.size(), totalElements);
            this.message("\n----------------------------------------------+------------------------------------+------------+----------------+", new Object[0]);
        } else {
            this.message("\nNo database selected yet.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Loook up a record using the dictionary. If found, set it as the current record")
    public void dictionaryGet(@ConsoleParameter(name="key", description="The key to search") String iKey) {
        this.checkForDatabase();
        this.currentRecord = (ORecord)this.currentDatabase.getDictionary().get(iKey);
        if (this.currentRecord == null) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.currentRecord = this.currentRecord.load();
            this.displayRecord(null);
        }
    }

    @ConsoleCommand(description="Insert or modify an entry in the database dictionary. The entry is comprised of key=String, value=record-id")
    public void dictionaryPut(@ConsoleParameter(name="key", description="The key to bind") String iKey, @ConsoleParameter(name="record-id", description="The record-id of the record to bind to the key") String iRecordId) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.load(new ORecordId(iRecordId));
        if (this.currentRecord == null) {
            this.message("\nError: record with id '" + iRecordId + "' was not found in database", new Object[0]);
        } else {
            this.currentDatabase.getDictionary().put(iKey, this.currentRecord);
            this.displayRecord(null);
            this.message("\nThe entry " + iKey + "=" + iRecordId + " has been inserted in the database dictionary", new Object[0]);
        }
    }

    @ConsoleCommand(description="Remove the association in the dictionary")
    public void dictionaryRemove(@ConsoleParameter(name="key", description="The key to remove") String iKey) {
        this.checkForDatabase();
        boolean result = this.currentDatabase.getDictionary().remove(iKey);
        if (!result) {
            this.message("\nEntry not found in dictionary.", new Object[0]);
        } else {
            this.message("\nEntry removed from the dictionary.", new Object[0]);
        }
    }

    @ConsoleCommand(description="Copy a database to a remote server")
    public void copyDatabase(@ConsoleParameter(name="db-name", description="Name of the database to share") String iDatabaseName, @ConsoleParameter(name="db-user", description="Database user") String iDatabaseUserName, @ConsoleParameter(name="db-password", description="Database password") String iDatabaseUserPassword, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName, @ConsoleParameter(name="engine-name", description="Remote server's engine to use between 'local' or 'memory'") String iRemoteEngine) throws IOException {
        try {
            if (this.serverAdmin == null) {
                throw new IllegalStateException("You must be connected to a remote server to share a database");
            }
            this.message("\nCopying database '" + iDatabaseName + "' to the server '" + iRemoteName + "' via network streaming...", new Object[0]);
            this.serverAdmin.copyDatabase(iDatabaseName, iDatabaseUserName, iDatabaseUserPassword, iRemoteName, iRemoteEngine);
            this.message("\nDatabase '" + iDatabaseName + "' has been copied to the server '" + iRemoteName + "'", new Object[0]);
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Displays the status of the cluster nodes")
    public void clusterStatus() throws IOException {
        if (this.serverAdmin == null) {
            throw new IllegalStateException("You must be connected to a remote server to get the cluster status");
        }
        this.checkForRemoteServer();
        try {
            this.message("\nCluster status:", new Object[0]);
            this.out.println(this.serverAdmin.clusterStatus().toJSON("attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0"));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Check database integrity")
    public void checkDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        if (!(this.currentDatabase.getStorage() instanceof OAbstractPaginatedStorage)) {
            this.message("\nCannot check integrity of non-local database. Connect to it using local mode.", new Object[0]);
            return;
        }
        boolean verbose = iOptions != null && iOptions.contains("-v");
        try {
            ((OAbstractPaginatedStorage)this.currentDatabase.getStorage()).check(verbose, this);
        }
        catch (ODatabaseImportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Repair database structure")
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        this.message("\nRepairing database...", new Object[0]);
        boolean verbose = iOptions != null && iOptions.contains("-v");
        boolean fix_ridbags = iOptions != null && iOptions.contains("--fix-ridbags");
        long fixedLinks = 0L;
        long modifiedDocuments = 0L;
        long errors = 0L;
        this.message("\n- Fixing dirty links...", new Object[0]);
        try {
            if (!fix_ridbags) {
                for (String clusterName : this.currentDatabase.getClusterNames()) {
                    for (ORecord oRecord : this.currentDatabase.browseCluster(clusterName)) {
                        try {
                            if (!(oRecord instanceof ODocument)) continue;
                            boolean changed = false;
                            ODocument doc = (ODocument)oRecord;
                            for (String fieldName : doc.fieldNames()) {
                                Object fieldValue = doc.rawField(fieldName);
                                if (fieldValue instanceof OIdentifiable) {
                                    if (!this.fixLink(fieldValue)) continue;
                                    doc.field(fieldName, (Object)null);
                                    ++fixedLinks;
                                    changed = true;
                                    if (!verbose) continue;
                                    this.message("\n--- reset link " + ((OIdentifiable)fieldValue).getIdentity() + " in field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                                    continue;
                                }
                                if (!(fieldValue instanceof Iterable)) continue;
                                if (fieldValue instanceof ORecordLazyMultiValue) {
                                    ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(false);
                                }
                                Iterator it = ((Iterable)fieldValue).iterator();
                                int i = 0;
                                while (it.hasNext()) {
                                    Object v = it.next();
                                    if (this.fixLink(v)) {
                                        it.remove();
                                        ++fixedLinks;
                                        changed = true;
                                        if (verbose) {
                                            this.message("\n--- reset link " + ((OIdentifiable)v).getIdentity() + " as item " + i + " in collection of field '" + fieldName + "' (rid=" + doc.getIdentity() + ")", new Object[0]);
                                        }
                                    }
                                    ++i;
                                }
                            }
                            if (!changed) continue;
                            ++modifiedDocuments;
                            doc.save();
                            if (!verbose) continue;
                            this.message("\n-- updated document " + doc.getIdentity(), new Object[0]);
                        }
                        catch (Exception e) {
                            ++errors;
                        }
                    }
                }
            } else if (fix_ridbags) {
                boolean lightweight = false;
                List custom = (List)this.currentDatabase.get(ODatabase.ATTRIBUTES.CUSTOM);
                for (OStorageEntryConfiguration oStorageEntryConfiguration : custom) {
                    if (!oStorageEntryConfiguration.name.equals("useLightweightEdges") || !Boolean.TRUE.equals(Boolean.parseBoolean(oStorageEntryConfiguration.value))) continue;
                    lightweight = true;
                }
                if (!lightweight) {
                    OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
                    repairer.repairDatabaseRidbags(this.currentDatabase);
                } else {
                    this.message("cannot execute fix ridbags on a db with ligthweight edges", new Object[0]);
                }
            }
            if (verbose) {
                this.message("\n", new Object[0]);
            }
            this.message("Done! Fixed links: " + fixedLinks + ", modified documents: " + modifiedDocuments, new Object[0]);
            this.message("\nRepair database complete (" + errors + " errors)", new Object[0]);
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Compare two databases")
    public void compareDatabases(@ConsoleParameter(name="db1-url", description="URL of the first database") String iDb1URL, @ConsoleParameter(name="db2-url", description="URL of the second database") String iDb2URL, @ConsoleParameter(name="user-name", description="User name", optional=true) String iUserName, @ConsoleParameter(name="user-password", description="User password", optional=true) String iUserPassword, @ConsoleParameter(name="detect-mapping-data", description="Whether RID mapping data after DB import should be tried to found on the disk.", optional=true) String autoDiscoveringMappingData) throws IOException {
        try {
            ODatabaseCompare compare = iUserName == null ? new ODatabaseCompare(iDb1URL, iDb2URL, (OCommandOutputListener)this) : new ODatabaseCompare(iDb1URL, iDb2URL, iUserName, iUserPassword, this);
            compare.setAutoDetectExportImportMap(autoDiscoveringMappingData != null ? Boolean.valueOf(autoDiscoveringMappingData) : true);
            compare.setCompareIndexMetadata(true);
            compare.compare();
        }
        catch (ODatabaseExportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Import a database into the current one", splitInWords=false)
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        this.checkForDatabase();
        this.message("\nImporting database " + text + "...", new Object[0]);
        List<String> items = OStringSerializerHelper.smartSplit(text, ' ', new char[0]);
        String fileName = items.size() <= 0 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        String options = fileName != null ? text.substring(items.get(0).length() + items.get(1).length() + 1).trim() : text;
        try {
            ODatabaseImport databaseImport = new ODatabaseImport((ODatabaseDocumentInternal)this.currentDatabase, fileName, (OCommandOutputListener)this);
            databaseImport.setOptions(options).importDatabase();
            databaseImport.close();
        }
        catch (ODatabaseImportException e) {
            this.printError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Backup a database", splitInWords=false)
    public void backupDatabase(@ConsoleParameter(name="options", description="Backup options") String iText) throws IOException {
        this.checkForDatabase();
        List<String> items = OStringSerializerHelper.smartSplit(iText, ' ', new char[0]);
        if (items.size() < 2) {
            try {
                this.syntaxError("backupDatabase", this.getClass().getMethod("backupDatabase", String.class));
                return;
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        this.out.println(new StringBuilder("Backuping current database to: ").append(iText).append("..."));
        String fileName = items.size() <= 0 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        int bufferSize = Integer.parseInt((String)this.properties.get("backupBufferSize"));
        int compressionLevel = Integer.parseInt((String)this.properties.get("backupCompressionLevel"));
        for (int i = 2; i < items.size(); ++i) {
            String item = items.get(i);
            int sep = item.indexOf(61);
            if (sep == -1) {
                OLogManager.instance().warn((Object)this, "Unrecognized parameter %s, skipped", item);
                continue;
            }
            String parName = item.substring(1, sep);
            String parValue = item.substring(sep + 1);
            if (parName.equalsIgnoreCase("bufferSize")) {
                bufferSize = Integer.parseInt(parValue);
                continue;
            }
            if (!parName.equalsIgnoreCase("compressionLevel")) continue;
            compressionLevel = Integer.parseInt(parValue);
        }
        long startTime = System.currentTimeMillis();
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                this.currentDatabase.backup(fos, null, null, this, compressionLevel, bufferSize);
                this.message("\nBackup executed in %.2f seconds", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
            }
            finally {
                fos.flush();
                fos.close();
            }
        }
        catch (ODatabaseExportException e) {
            this.printError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConsoleCommand(description="Restore a database into the current one", splitInWords=false)
    public void restoreDatabase(@ConsoleParameter(name="options", description="Restore options") String text) throws IOException {
        this.checkForDatabase();
        this.message("\nRestoring database %s...", text);
        List<String> items = OStringSerializerHelper.smartSplit(text, ' ', new char[0]);
        if (items.size() < 2) {
            try {
                this.syntaxError("restoreDatabase", this.getClass().getMethod("restoreDatabase", String.class));
                return;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        String fileName = items.size() <= 0 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        long startTime = System.currentTimeMillis();
        try {
            FileInputStream f = new FileInputStream(fileName);
            try {
                this.currentDatabase.restore(f, null, null, this);
            }
            finally {
                f.close();
            }
            this.message("\nDatabase restored in %.2f seconds", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
        }
        catch (ODatabaseImportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Export a database", splitInWords=false)
    public void exportDatabase(@ConsoleParameter(name="options", description="Export options") String iText) throws IOException {
        this.checkForDatabase();
        this.out.println(new StringBuilder("Exporting current database to: ").append(iText).append(" in GZipped JSON format ..."));
        List<String> items = OStringSerializerHelper.smartSplit(iText, ' ', new char[0]);
        String fileName = items.size() <= 1 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        String options = fileName != null ? iText.substring(items.get(0).length() + items.get(1).length() + 1).trim() : iText;
        try {
            new ODatabaseExport((ODatabaseDocumentInternal)this.currentDatabase, fileName, (OCommandOutputListener)this).setOptions(options).exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Export a database schema")
    public void exportSchema(@ConsoleParameter(name="output-file", description="Output file path") String iOutputFilePath) throws IOException {
        this.checkForDatabase();
        this.message("\nExporting current database to: " + iOutputFilePath + "...", new Object[0]);
        try {
            ODatabaseExport exporter = new ODatabaseExport((ODatabaseDocumentInternal)this.currentDatabase, iOutputFilePath, (OCommandOutputListener)this);
            exporter.setIncludeRecords(false);
            exporter.exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Export the current record in the requested format")
    public void exportRecord(@ConsoleParameter(name="format", description="Format, such as 'json'") String iFormat, @ConsoleParameter(name="options", description="Options", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        this.checkCurrentObject();
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat(iFormat.toLowerCase());
        if (serializer == null) {
            this.message("\nERROR: Format '" + iFormat + "' was not found.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (!(serializer instanceof ORecordSerializerStringAbstract)) {
            this.message("\nERROR: Format '" + iFormat + "' does not export as text.", new Object[0]);
            this.printSupportedSerializerFormat();
            return;
        }
        if (iOptions == null || iOptions.length() <= 0) {
            iOptions = "rid,version,class,type,keepTypes,alwaysFetchEmbedded,fetchPlan:*:0,prettyPrint";
        }
        try {
            this.out.println(((ORecordSerializerStringAbstract)serializer).toString(this.currentRecord, iOptions));
        }
        catch (ODatabaseExportException e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Return all configured properties")
    public void properties() {
        this.message("\nPROPERTIES:", new Object[0]);
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
        this.message("\n| %-30s| %-30s |", "NAME", "VALUE");
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
        for (Map.Entry p : this.properties.entrySet()) {
            this.message("\n| %-30s| %-30s |", p.getKey(), p.getValue());
        }
        this.message("\n+-------------------------------+--------------------------------+", new Object[0]);
    }

    @ConsoleCommand(description="Return the value of a property")
    public void get(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName) {
        Object value = this.properties.get(iPropertyName);
        this.out.println();
        if (value == null) {
            this.message("\nProperty '" + iPropertyName + "' is not setted", new Object[0]);
        } else {
            this.out.println(iPropertyName + " = " + value);
        }
    }

    @ConsoleCommand(description="Change the value of a property")
    public void set(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName, @ConsoleParameter(name="property-value", description="Value to set") String iPropertyValue) {
        Object prevValue = this.properties.get(iPropertyName);
        this.out.println();
        if (iPropertyName.equalsIgnoreCase("limit") && (Integer.parseInt(iPropertyValue) == 0 || Integer.parseInt(iPropertyValue) < -1)) {
            this.message("\nERROR: Limit must be > 0 or = -1 (no limit)", new Object[0]);
        } else {
            if (prevValue != null) {
                this.message("\nPrevious value was: " + prevValue, new Object[0]);
            }
            this.properties.put(iPropertyName, iPropertyValue);
            this.out.println();
            this.out.println(iPropertyName + " = " + iPropertyValue);
        }
    }

    @ConsoleCommand(description="Declare an intent")
    public void declareIntent(@ConsoleParameter(name="Intent name", description="name of the intent to execute") String iIntentName) {
        this.checkForDatabase();
        this.message("\nDeclaring intent '" + iIntentName + "'...", new Object[0]);
        if (iIntentName.equalsIgnoreCase("massiveinsert")) {
            this.currentDatabase.declareIntent(new OIntentMassiveInsert());
        } else if (iIntentName.equalsIgnoreCase("massiveread")) {
            this.currentDatabase.declareIntent(new OIntentMassiveRead());
        } else {
            throw new IllegalArgumentException("Intent '" + iIntentName + "' not supported. Available ones are: massiveinsert, massiveread");
        }
        this.message("\nIntent '" + iIntentName + "' setted successfully", new Object[0]);
    }

    @ConsoleCommand(description="Execute a command against the profiler")
    public void profiler(@ConsoleParameter(name="profiler command", description="command to execute against the profiler") String iCommandName) {
        if (iCommandName.equalsIgnoreCase("on")) {
            Orient.instance().getProfiler().startRecording();
            this.message("\nProfiler is ON now, use 'profiler off' to turn off.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("off")) {
            Orient.instance().getProfiler().stopRecording();
            this.message("\nProfiler is OFF now, use 'profiler on' to turn on.", new Object[0]);
        } else if (iCommandName.equalsIgnoreCase("dump")) {
            this.out.println(Orient.instance().getProfiler().dump());
        }
    }

    @ConsoleCommand(description="Return the value of a configuration value")
    public void configGet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName) throws IOException {
        String value;
        OGlobalConfiguration config = OGlobalConfiguration.findByKey(iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' wasn't found");
        }
        if (this.serverAdmin != null) {
            value = this.serverAdmin.getGlobalConfiguration(config);
            this.message("\nRemote configuration: ", new Object[0]);
        } else {
            value = config.getValueAsString();
            this.message("\nLocal configuration: ", new Object[0]);
        }
        this.out.println(iConfigName + " = " + value);
    }

    @ConsoleCommand(description="Sleep X milliseconds")
    public void sleep(String iTime) {
        try {
            Thread.sleep(Long.parseLong(iTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ConsoleCommand(description="Change the value of a configuration value")
    public void configSet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName, @ConsoleParameter(name="config-value", description="Value to set") String iConfigValue) throws IOException {
        OGlobalConfiguration config = OGlobalConfiguration.findByKey(iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' not found");
        }
        if (this.serverAdmin != null) {
            this.serverAdmin.setGlobalConfiguration(config, iConfigValue);
            this.message("\n\nRemote configuration value changed correctly", new Object[0]);
        } else {
            config.setValue(iConfigValue);
            this.message("\n\nLocal configuration value changed correctly", new Object[0]);
        }
        this.out.println();
    }

    @ConsoleCommand(description="Return all the configuration values")
    public void config() throws IOException {
        if (this.serverAdmin != null) {
            Map<String, String> values = this.serverAdmin.getGlobalConfigurations();
            this.message("\nREMOTE SERVER CONFIGURATION:", new Object[0]);
            this.message("\n+------------------------------------+--------------------------------+", new Object[0]);
            this.message("\n| %-35s| %-30s |", "NAME", "VALUE");
            this.message("\n+------------------------------------+--------------------------------+", new Object[0]);
            for (Map.Entry<String, String> p : values.entrySet()) {
                this.message("\n| %-35s= %-30s |", p.getKey(), p.getValue());
            }
        } else {
            this.message("\nLOCAL SERVER CONFIGURATION:", new Object[0]);
            this.message("\n+------------------------------------+--------------------------------+", new Object[0]);
            this.message("\n| %-35s| %-30s |", "NAME", "VALUE");
            this.message("\n+------------------------------------+--------------------------------+", new Object[0]);
            for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
                this.message("\n| %-35s= %-30s |", cfg.getKey(), cfg.getValue());
            }
        }
        this.message("\n+------------------------------------+--------------------------------+", new Object[0]);
    }

    public ODatabaseDocument getCurrentDatabase() {
        return this.currentDatabase;
    }

    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    public String getCurrentDatabaseUserName() {
        return this.currentDatabaseUserName;
    }

    public String getCurrentDatabaseUserPassword() {
        return this.currentDatabaseUserPassword;
    }

    public ORecord getCurrentRecord() {
        return this.currentRecord;
    }

    public List<OIdentifiable> getCurrentResultSet() {
        return this.currentResultSet;
    }

    public void loadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.load(new ORecordId(iRecordId), iFetchPlan);
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    public void reloadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = this.currentDatabase.executeReadRecord(new ORecordId(iRecordId), null, iFetchPlan, true, false, OStorage.LOCKING_STRATEGY.NONE);
        this.displayRecord(null);
        this.message("\nOK", new Object[0]);
    }

    public void checkForRemoteServer() {
        if (this.serverAdmin == null && (this.currentDatabase == null || !(this.currentDatabase.getStorage() instanceof OStorageRemoteThread) || this.currentDatabase.isClosed())) {
            throw new OException("Remote server is not connected. Use 'connect remote:<host>[:<port>][/<database-name>]' to connect");
        }
    }

    public void checkForDatabase() {
        if (this.currentDatabase == null) {
            throw new OException("Database not selected. Use 'connect <database-name>' to connect to a database.");
        }
        if (this.currentDatabase.isClosed()) {
            throw new ODatabaseException("Database '" + this.currentDatabaseName + "' is closed");
        }
    }

    public void checkCurrentObject() {
        if (this.currentRecord == null) {
            throw new OException("The is no current object selected: create a new one or load it");
        }
    }

    public String ask(String iText) {
        this.out.print(iText);
        Scanner scanner = new Scanner(this.in);
        String answer = scanner.nextLine();
        scanner.close();
        return answer;
    }

    @Override
    public void onMessage(String iText) {
        this.message(iText, new Object[0]);
    }

    @Override
    public void onBegin(Object iTask, long iTotal, Object metadata) {
        this.lastPercentStep = 0;
        this.message("[", new Object[0]);
        if (this.interactiveMode) {
            for (int i = 0; i < 10; ++i) {
                this.message(" ", new Object[0]);
            }
            this.message("]   0%", new Object[0]);
        }
    }

    @Override
    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        int completitionBar = (int)iPercent / 10;
        if ((int)(iPercent * 10.0f) == this.lastPercentStep) {
            return true;
        }
        StringBuilder buffer = new StringBuilder(64);
        if (this.interactiveMode) {
            int i;
            buffer.append("\r[");
            for (i = 0; i < completitionBar; ++i) {
                buffer.append('=');
            }
            for (i = completitionBar; i < 10; ++i) {
                buffer.append(' ');
            }
            this.message("] %3.1f%% ", Float.valueOf(iPercent));
        } else {
            for (int i = this.lastPercentStep / 100; i < completitionBar; ++i) {
                buffer.append('=');
            }
        }
        this.message(buffer.toString(), new Object[0]);
        this.lastPercentStep = (int)(iPercent * 10.0f);
        return true;
    }

    @ConsoleCommand(description="Display the current path")
    public void pwd() {
        this.message("\nCurrent path: " + new File("").getAbsolutePath(), new Object[0]);
    }

    @Override
    public void onCompletition(Object iTask, boolean iSucceed) {
        if (this.interactiveMode) {
            if (iSucceed) {
                this.message("\r[==========] 100% Done.", new Object[0]);
            } else {
                this.message(" Error!", new Object[0]);
            }
        } else {
            this.message(iSucceed ? "] Done." : " Error!", new Object[0]);
        }
    }

    protected boolean fixLink(Object fieldValue) {
        ORID id;
        if (fieldValue instanceof OIdentifiable && (id = ((OIdentifiable)fieldValue).getIdentity()).isValid()) {
            if (id.isPersistent()) {
                Object connected = ((OIdentifiable)fieldValue).getRecord();
                if (connected == null) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected void dumpDistributedConfiguration(boolean iForce) {
        if (this.currentDatabase == null) {
            return;
        }
        OStorage stg = this.currentDatabase.getStorage();
        if (stg instanceof OStorageRemoteThread) {
            ODocument distributedCfg = ((OStorageRemoteThread)stg).getClusterConfiguration();
            if (distributedCfg != null && !distributedCfg.isEmpty()) {
                this.message("\n\nDISTRIBUTED CONFIGURATION:\n" + distributedCfg.toJSON("prettyPrint"), new Object[0]);
            } else if (iForce) {
                this.message("\n\nDISTRIBUTED CONFIGURATION: none (OrientDB is running in standalone mode)", new Object[0]);
            }
        }
    }

    @Override
    protected boolean isCollectingCommands(String iLine) {
        return iLine.startsWith("js") || iLine.startsWith("script");
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.setResultset(new ArrayList<OIdentifiable>());
        OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.setValue(0);
        OGlobalConfiguration.NETWORK_LOCK_TIMEOUT.setValue(0);
        OGlobalConfiguration.CLIENT_CHANNEL_MIN_POOL.setValue(1);
        OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.setValue(2);
        this.properties.put("limit", "20");
        this.properties.put("width", "150");
        this.properties.put("debug", "false");
        this.properties.put("collectionMaxItems", "10");
        this.properties.put("maxBinaryDisplay", "150");
        this.properties.put("verbose", "2");
        this.properties.put("ignoreErrors", "false");
        this.properties.put("backupCompressionLevel", "9");
        this.properties.put("backupBufferSize", "1048576");
    }

    protected OIdentifiable setCurrentRecord(int iIndex) {
        this.currentRecordIdx = iIndex;
        this.currentRecord = iIndex < this.currentResultSet.size() ? (ORecord)this.currentResultSet.get(iIndex) : null;
        return this.currentRecord;
    }

    @Override
    protected void printApplicationInfo() {
        this.message("\nOrientDB console v." + OConstants.getVersion() + " " + "www.orientechnologies.com", new Object[0]);
        this.message("\nType 'help' to display all the supported commands.", new Object[0]);
    }

    protected void dumpResultSet(int limit) {
        new OTableFormatter(this).setMaxWidthSize(this.getWindowSize()).writeRecords(this.currentResultSet, limit);
    }

    protected float getElapsedSecs(long start) {
        return (float)(System.currentTimeMillis() - start) / 1000.0f;
    }

    protected void printError(Exception e) {
        if (this.properties.get("debug") != null && Boolean.parseBoolean((String)this.properties.get("debug"))) {
            this.message("\n\n!ERROR:", new Object[0]);
            e.printStackTrace(this.err);
        } else {
            this.message("\n\n!ERROR: " + e.getMessage(), new Object[0]);
            if (e.getCause() != null) {
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    this.message("\n-> " + t.getMessage(), new Object[0]);
                }
            }
        }
    }

    protected void updateDatabaseInfo() {
        this.currentDatabase.getStorage().reload();
        this.currentDatabase.getMetadata().getSchema().reload();
        this.currentDatabase.getMetadata().getIndexManager().reload();
    }

    @Override
    protected String getContext() {
        if (this.currentDatabase != null && this.currentDatabaseName != null) {
            StringBuilder buffer = new StringBuilder(64);
            buffer.append(" {db=");
            buffer.append(this.currentDatabaseName);
            if (this.currentDatabase.getTransaction().isActive()) {
                buffer.append(" tx=[");
                buffer.append(this.currentDatabase.getTransaction().getEntryCount());
                buffer.append(" entries]");
            }
            buffer.append("}");
            return buffer.toString();
        }
        if (this.serverAdmin != null) {
            return " {server=" + this.serverAdmin.getURL() + "}";
        }
        return "";
    }

    @Override
    protected String getPrompt() {
        return String.format("orientdb%s> ", this.getContext());
    }

    protected void parseResult() {
        this.setResultset(null);
        if (this.currentResult instanceof Map) {
            return;
        }
        Object first = OMultiValue.getFirstValue(this.currentResult);
        if (first instanceof OIdentifiable) {
            if (this.currentResult instanceof List) {
                this.currentResultSet = (List)this.currentResult;
            } else if (this.currentResult instanceof Collection) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                this.currentResultSet.addAll((Collection)this.currentResult);
            } else if (this.currentResult.getClass().isArray()) {
                this.currentResultSet = new ArrayList<OIdentifiable>();
                Collections.addAll(this.currentResultSet, (OIdentifiable[])this.currentResult);
            }
            this.setResultset(this.currentResultSet);
        }
    }

    protected void setResultset(List<OIdentifiable> iResultset) {
        this.currentResultSet = iResultset;
        this.currentRecordIdx = 0;
        this.currentRecord = iResultset == null || iResultset.isEmpty() ? null : iResultset.get(0).getRecord();
    }

    protected void resetResultSet() {
        this.currentResultSet = null;
        this.currentRecord = null;
    }

    protected void executeServerSideScript(String iLanguage, String iText) {
        if (iText == null) {
            return;
        }
        this.resetResultSet();
        long start = System.currentTimeMillis();
        this.currentResult = this.currentDatabase.command(new OCommandScript(iLanguage, iText)).execute(new Object[0]);
        float elapsedSeconds = this.getElapsedSecs(start);
        this.parseResult();
        if (this.currentResultSet != null) {
            this.dumpResultSet(-1);
            this.message("\nServer side script executed in %f sec(s). Returned %d records", Float.valueOf(elapsedSeconds), this.currentResultSet.size());
        } else {
            String lineFeed = this.currentResult instanceof Map ? "\n" : "";
            this.message("\nServer side script executed in %f sec(s). Value returned is: %s%s", Float.valueOf(elapsedSeconds), lineFeed, this.currentResult);
        }
    }

    protected Map<String, List<String>> parseOptions(String iOptions) {
        HashMap<String, List<String>> options = new HashMap<String, List<String>>();
        if (iOptions != null) {
            List<String> opts = OStringSerializerHelper.smartSplit(iOptions, ' ', new char[0]);
            for (String o : opts) {
                int sep = o.indexOf(61);
                if (sep == -1) {
                    OLogManager.instance().warn((Object)this, "Unrecognized option %s, skipped", o);
                    continue;
                }
                String option = o.substring(0, sep);
                List<String> items = OStringSerializerHelper.smartSplit(o.substring(sep + 1), ' ', new char[0]);
                options.put(o, items);
            }
        }
        return options;
    }

    protected int getWindowSize() {
        if (this.properties.containsKey("width")) {
            return Integer.parseInt((String)this.properties.get("width"));
        }
        return this.windowSize;
    }

    protected int getCollectionMaxItems() {
        if (this.properties.containsKey("collectionMaxItems")) {
            return Integer.parseInt((String)this.properties.get("collectionMaxItems"));
        }
        return this.collectionMaxItems;
    }

    private void dumpRecordDetails() {
        if (this.currentRecord == null) {
            return;
        }
        if (this.currentRecord instanceof ODocument) {
            ODocument rec = (ODocument)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Document - @class: %-37s @rid: %-15s @version: %-6s |", rec.getClassName(), rec.getIdentity().toString(), rec.getRecordVersion().toString());
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| %24s | %-68s |", "Name", "Value");
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            for (String fieldName : rec.fieldNames()) {
                int size;
                Object value = rec.field(fieldName);
                if (value instanceof byte[]) {
                    value = "byte[" + ((byte[])value).length + "]";
                } else if (value instanceof Iterator) {
                    ArrayList coll = new ArrayList();
                    while (((Iterator)value).hasNext()) {
                        coll.add(((Iterator)value).next());
                    }
                    value = coll;
                } else if (OMultiValue.isMultiValue(value) && (size = OMultiValue.getSize(value)) < this.getCollectionMaxItems()) {
                    StringBuilder buffer = new StringBuilder(50);
                    for (Object o : OMultiValue.getMultiValueIterable(value)) {
                        if (buffer.length() > 0) {
                            buffer.append(',');
                        }
                        buffer.append(o);
                    }
                    value = "[" + buffer.toString() + "]";
                }
                this.message("\n| %24s | %-68s |", fieldName, value);
            }
        } else if (this.currentRecord instanceof ORecordFlat) {
            ORecordFlat rec = (ORecordFlat)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Flat     - @rid: %s @version: %s", rec.getIdentity().toString(), rec.getRecordVersion().toString());
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message(rec.value(), new Object[0]);
        } else if (this.currentRecord instanceof ORecordBytes) {
            ORecordBytes rec = (ORecordBytes)this.currentRecord;
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| Bytes    - @rid: %s @version: %s", rec.getIdentity().toString(), rec.getRecordVersion().toString());
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            byte[] value = rec.toStream();
            int max = Math.min(Integer.parseInt((String)this.properties.get("maxBinaryDisplay")), Array.getLength(value));
            for (int i = 0; i < max; ++i) {
                this.message("%03d", Array.getByte(value, i));
            }
        } else {
            this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
            this.message("\n| %s - record id: %s   v.%s", this.currentRecord.getClass().getSimpleName(), this.currentRecord.getIdentity().toString(), this.currentRecord.getRecordVersion().toString());
        }
        this.message("\n+-------------------------------------------------------------------------------------------------+", new Object[0]);
        this.out.println();
    }

    private void printSupportedSerializerFormat() {
        this.message("\nSupported formats are:", new Object[0]);
        for (ORecordSerializer s : ORecordSerializerFactory.instance().getFormats()) {
            if (!(s instanceof ORecordSerializerStringAbstract)) continue;
            this.message("\n- " + s.toString(), new Object[0]);
        }
    }

    private void browseRecords(int limit, OIdentifiableIterator<?> it) {
        OTableFormatter tableFormatter = new OTableFormatter(this).setMaxWidthSize(this.getWindowSize());
        this.setResultset(new ArrayList<OIdentifiable>());
        while (it.hasNext() && this.currentResultSet.size() <= limit) {
            this.currentResultSet.add((OIdentifiable)it.next());
        }
        tableFormatter.writeRecords(this.currentResultSet, limit);
    }

    private Object sqlCommand(String iExpectedCommand, String iReceivedCommand, String iMessage, boolean iIncludeResult) {
        this.checkForDatabase();
        if (iReceivedCommand == null) {
            return null;
        }
        iReceivedCommand = iExpectedCommand + " " + iReceivedCommand.trim();
        this.resetResultSet();
        long start = System.currentTimeMillis();
        Object result = new OCommandSQL(iReceivedCommand).setProgressListener(this).execute(new Object[0]);
        float elapsedSeconds = this.getElapsedSecs(start);
        if (iIncludeResult) {
            this.message(iMessage, result, Float.valueOf(elapsedSeconds));
        } else {
            this.message(iMessage, Float.valueOf(elapsedSeconds));
        }
        return result;
    }
}

