/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.db.ODatabaseFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseThreadLocalFactory;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.local.OEngineLocalPaginated;
import com.orientechnologies.orient.core.engine.memory.OEngineMemory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Orient
extends OListenerManger<OOrientListener> {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    private static final Orient instance = new Orient();
    private static volatile boolean registerDatabaseByPath = false;
    private final ConcurrentMap<String, OEngine> engines = new ConcurrentHashMap<String, OEngine>();
    private final ConcurrentMap<String, OStorage> storages = new ConcurrentHashMap<String, OStorage>();
    private final Map<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> dbLifecycleListeners = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>();
    private final ODatabaseFactory databaseFactory = new ODatabaseFactory();
    private final OScriptManager scriptManager = new OScriptManager();
    private final ThreadGroup threadGroup;
    private final AtomicInteger serialId = new AtomicInteger();
    private final ReadWriteLock engineLock = new ReentrantReadWriteLock();
    private final ORecordConflictStrategyFactory recordConflictStrategy = new ORecordConflictStrategyFactory();
    private final ReferenceQueue<OOrientStartupListener> removedStartupListenersQueue = new ReferenceQueue();
    private final ReferenceQueue<OOrientShutdownListener> removedShutdownListenersQueue = new ReferenceQueue();
    private final Set<OOrientStartupListener> startupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientStartupListener>> weakStartupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientShutdownListener>> weakShutdownListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private String os;
    private volatile Timer timer;
    private volatile ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    private OrientShutdownHook shutdownHook;
    private volatile OProfilerMBean profiler;
    private ODatabaseThreadLocalFactory databaseThreadFactory;
    private volatile boolean active = false;
    private ThreadPoolExecutor workers;
    private OSignalHandler signalHandler;

    protected Orient() {
        super(true);
        this.threadGroup = new ThreadGroup("OrientDB");
        this.threadGroup.setDaemon(false);
    }

    public static Orient instance() {
        return instance;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = OSystemVariableResolver.resolveVariable(ORIENTDB_HOME);
        }
        return OFileUtils.getPath(v);
    }

    public static String getTempPath() {
        return OFileUtils.getPath(System.getProperty("java.io.tmpdir") + "/orientdb/");
    }

    public static boolean isRegisterDatabaseByPath() {
        return registerDatabaseByPath;
    }

    public static void setRegisterDatabaseByPath(boolean iValue) {
        registerDatabaseByPath = iValue;
    }

    public ORecordConflictStrategyFactory getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient startup() {
        this.engineLock.writeLock().lock();
        try {
            if (this.active) {
                Orient orient = this;
                return orient;
            }
            this.os = System.getProperty("os.name").toLowerCase();
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.profiler = new OProfiler();
            this.shutdownHook = new OrientShutdownHook();
            if (this.signalHandler == null) {
                this.signalHandler = new OSignalHandler();
                this.signalHandler.installDefaultSignals();
            }
            int cores = Runtime.getRuntime().availableProcessors();
            this.workers = new ThreadPoolExecutor(cores, cores * 3, 10L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(cores * 500){

                @Override
                public boolean offer(Runnable e) {
                    try {
                        this.put(e);
                        return true;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            });
            this.registerEngine(new OEngineLocalPaginated());
            this.registerEngine(new OEngineMemory());
            this.registerEngine("com.orientechnologies.orient.client.remote.OEngineRemote");
            if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
                OGlobalConfiguration.dumpConfiguration(System.out);
            }
            this.active = true;
            for (OOrientStartupListener oOrientStartupListener : this.startupListeners) {
                try {
                    if (oOrientStartupListener == null) continue;
                    oOrientStartupListener.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on startup", (Throwable)e, new Object[0]);
                }
            }
            this.purgeWeakStartupListeners();
            for (WeakHashSetValueHolder weakHashSetValueHolder : this.weakStartupListeners) {
                try {
                    OOrientStartupListener l;
                    if (weakHashSetValueHolder == null || (l = (OOrientStartupListener)weakHashSetValueHolder.get()) == null) continue;
                    l.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on startup", (Throwable)e, new Object[0]);
                }
            }
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient shutdown() {
        this.engineLock.writeLock().lock();
        try {
            if (!this.active) {
                Orient orient = this;
                return orient;
            }
            this.active = false;
            this.workers.shutdown();
            try {
                this.workers.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            OLogManager.instance().debug((Object)this, "Orient Engine is shutting down...", new Object[0]);
            if (this.threadGroup != null) {
                this.threadGroup.interrupt();
            }
            if (this.databaseFactory != null) {
                this.databaseFactory.shutdown();
            }
            this.closeAllStorages();
            for (OEngine oEngine : this.engines.values()) {
                oEngine.shutdown();
            }
            this.engines.clear();
            if (this.shutdownHook != null) {
                this.shutdownHook.cancel();
                this.shutdownHook = null;
            }
            this.timer.cancel();
            this.timer = null;
            this.profiler.shutdown();
            for (OOrientListener oOrientListener : this.browseListeners()) {
                if (oOrientListener == null) continue;
                try {
                    oOrientListener.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during orient shutdown.", (Throwable)e, new Object[0]);
                }
            }
            this.purgeWeakShutdownListeners();
            for (WeakHashSetValueHolder weakHashSetValueHolder : this.weakShutdownListeners) {
                try {
                    OOrientShutdownListener l;
                    if (weakHashSetValueHolder == null || (l = (OOrientShutdownListener)weakHashSetValueHolder.get()) == null) continue;
                    l.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during orient shutdown.", (Throwable)e, new Object[0]);
                }
            }
            OLogManager.instance().info((Object)this, "OrientDB Engine shutdown complete", new Object[0]);
            OLogManager.instance().flush();
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(TimerTask task, long delay, long period) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                this.timer.schedule(task, delay, period);
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(TimerTask task, Date firstTime, long period) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                this.timer.schedule(task, firstTime, period);
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllStorages() {
        this.engineLock.writeLock().lock();
        try {
            ArrayList storagesCopy = new ArrayList(this.storages.values());
            for (OStorage stg : storagesCopy) {
                try {
                    OLogManager.instance().info((Object)this, "- closing storage: " + stg.getName() + "...", new Object[0]);
                    stg.close(true, false);
                }
                catch (Throwable e) {
                    OLogManager.instance().warn((Object)this, "-- error on closing storage", e, new Object[0]);
                }
            }
            this.storages.clear();
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Deprecated
    public ThreadPoolExecutor getWorkers() {
        return this.workers;
    }

    public Future<?> submit(Runnable runnable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<?> future = this.workers.submit(runnable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public <V> Future<V> submit(Callable<V> callable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<V> future = this.workers.submit(callable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage loadStorage(String iURL) {
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if (this.isWindowsOS()) {
            int colonDblSlash = iURL.indexOf("://");
            if (colonDblSlash != -1 && iURL.length() >= colonDblSlash + 4) {
                iURL = iURL.substring(0, colonDblSlash + 3) + iURL.substring(colonDblSlash + 3).replace("//", "/");
            }
        } else {
            iURL = iURL.replace("//", "/");
        }
        int pos = iURL.indexOf(58);
        if (pos <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.engineLock.readLock().lock();
        try {
            OStorage storage;
            String dbName;
            OEngine engine = (OEngine)this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". Registered engines are: " + this.engines.keySet());
            }
            iURL = iURL.substring(pos + 1);
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            String dbPath = null;
            if (pos > 0) {
                dbPath = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                String[] pairs = iURL.split("&");
                for (String pair : pairs) {
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                }
            } else {
                dbPath = iURL;
            }
            String string = dbName = registerDatabaseByPath ? dbPath : OIOUtils.getRelativePathIfAny(dbPath, null);
            if (engine.isShared()) {
                OStorage oldStorage;
                storage = (OStorage)this.storages.get(dbName);
                if (storage == null && (oldStorage = this.storages.putIfAbsent(dbName, storage = engine.createStorage(dbPath, parameters))) != null) {
                    storage = oldStorage;
                }
            } else {
                storage = engine.createStorage(dbPath, parameters);
                this.storages.put(dbName + "__" + this.serialId.incrementAndGet(), storage);
            }
            for (OOrientListener l : this.browseListeners()) {
                l.onStorageRegistered(storage);
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public boolean isWindowsOS() {
        return this.os.indexOf("win") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage registerStorage(OStorage storage) throws IOException {
        this.engineLock.readLock().lock();
        try {
            for (OOrientListener l : this.browseListeners()) {
                l.onStorageRegistered(storage);
            }
            OStorage oldStorage = this.storages.putIfAbsent(storage.getName(), storage);
            if (oldStorage != null) {
                storage = oldStorage;
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public OStorage getStorage(String dbName) {
        this.engineLock.readLock().lock();
        try {
            OStorage oStorage = (OStorage)this.storages.get(dbName);
            return oStorage;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public void registerEngine(OEngine iEngine) {
        this.engineLock.readLock().lock();
        try {
            this.engines.put(iEngine.getName(), iEngine);
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public OEngine getEngine(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine oEngine = (OEngine)this.engines.get(engineName);
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public Set<String> getEngines() {
        this.engineLock.readLock().lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public void unregisterStorageByName(String name) {
        String dbName = registerDatabaseByPath ? name : OIOUtils.getRelativePathIfAny(name, null);
        OStorage stg = (OStorage)this.storages.get(dbName);
        this.unregisterStorage(stg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStorage(OStorage storage) {
        if (!this.active) {
            return;
        }
        if (storage == null) {
            return;
        }
        this.engineLock.writeLock().lock();
        try {
            Iterable listenerCopy = this.getListenersCopy();
            for (OOrientListener l : listenerCopy) {
                this.unregisterListener(l);
                l.onStorageUnregistered(storage);
            }
            ArrayList storagesToRemove = new ArrayList();
            for (Map.Entry s : this.storages.entrySet()) {
                if (!((OStorage)s.getValue()).equals(storage)) continue;
                storagesToRemove.add(s.getKey());
            }
            for (String dbName : storagesToRemove) {
                this.storages.remove(dbName);
            }
            for (OEngine engine : this.engines.values()) {
                engine.removeStorage(storage);
            }
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    public Collection<OStorage> getStorages() {
        this.engineLock.readLock().lock();
        try {
            ArrayList<OStorage> arrayList = new ArrayList<OStorage>(this.storages.values());
            return arrayList;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    @Deprecated
    public Timer getTimer() {
        return this.timer;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    public boolean isSelfManagedShutdown() {
        return this.shutdownHook != null;
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return this.dbLifecycleListeners.keySet().iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> tmp = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>(this.dbLifecycleListeners);
        tmp.put(iListener, iListener.getPriority());
        this.dbLifecycleListeners.clear();
        for (ODatabaseLifecycleListener.PRIORITY p : ODatabaseLifecycleListener.PRIORITY.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.dbLifecycleListeners.put((ODatabaseLifecycleListener)e.getKey(), (ODatabaseLifecycleListener.PRIORITY)((Object)e.getValue()));
            }
        }
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ODatabaseThreadLocalFactory getDatabaseThreadFactory() {
        return this.databaseThreadFactory;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public ODatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public OProfilerMBean getProfiler() {
        return this.profiler;
    }

    public void setProfiler(OProfilerMBean iProfiler) {
        this.profiler = iProfiler;
    }

    public void registerThreadDatabaseFactory(ODatabaseThreadLocalFactory iDatabaseFactory) {
        this.databaseThreadFactory = iDatabaseFactory;
    }

    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @Override
    public void registerListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.registerOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.registerListener(listener);
    }

    @Override
    public void unregisterListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.unregisterOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.unregisterListener(listener);
    }

    public void registerOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.add(listener);
    }

    public void registerWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.add(new WeakHashSetValueHolder(listener, this.removedStartupListenersQueue));
    }

    public void unregisterOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.remove(listener);
    }

    public void unregisterWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    public void registerWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.add(new WeakHashSetValueHolder(listener, this.removedShutdownListenersQueue));
    }

    public void unregisterWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.weakShutdownListeners.clear();
        this.startupListeners.clear();
        this.weakStartupListeners.clear();
    }

    private void registerEngine(String className) {
        try {
            Class<?> cls = Class.forName(className);
            this.registerEngine((OEngine)cls.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakStartupListeners() {
        ReferenceQueue<OOrientStartupListener> referenceQueue = this.removedStartupListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            while (ref != null) {
                this.weakStartupListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakShutdownListeners() {
        ReferenceQueue<OOrientShutdownListener> referenceQueue = this.removedShutdownListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            while (ref != null) {
                this.weakShutdownListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            }
        }
    }

    static {
        instance.startup();
    }

    private static class WeakHashSetValueHolder<T>
    extends WeakReference<T> {
        private final int hashCode;

        private WeakHashSetValueHolder(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeakHashSetValueHolder that = (WeakHashSetValueHolder)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            Object thisObject = this.get();
            Object thatObject = that.get();
            if (thisObject == null && thatObject == null) {
                return super.equals(that);
            }
            if (thisObject != null && thatObject != null) {
                return thisObject.equals(thatObject);
            }
            return false;
        }
    }
}

