/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OAbstractMapCache;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class OUnboundedWeakCache
extends OAbstractMapCache<WeakHashMap<ORID, WeakReference<ORecord>>>
implements OCache {
    public OUnboundedWeakCache() {
        super(new WeakHashMap());
    }

    @Override
    public ORecord get(ORID rid) {
        WeakReference value = (WeakReference)((WeakHashMap)this.cache).get(rid);
        return this.get(value);
    }

    @Override
    public ORecord put(ORecord record) {
        WeakReference<ORecord> value = ((WeakHashMap)this.cache).put(record.getIdentity(), new WeakReference<ORecord>(record));
        return this.get(value);
    }

    @Override
    public ORecord remove(ORID rid) {
        WeakReference value = (WeakReference)((WeakHashMap)this.cache).remove(rid);
        return this.get(value);
    }

    private ORecord get(WeakReference<ORecord> value) {
        if (value == null) {
            return null;
        }
        return (ORecord)value.get();
    }
}

