/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.OProcessException;
import com.orientechnologies.orient.core.processor.OProcessorManager;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OScriptDocumentDatabaseWrapper {
    protected ODatabaseDocumentTx database;

    public OScriptDocumentDatabaseWrapper(ODatabaseDocumentTx database) {
        this.database = database;
    }

    public OScriptDocumentDatabaseWrapper(String iURL) {
        this.database = new ODatabaseDocumentTx(iURL);
    }

    public void switchUser(String iUserName, String iUserPassword) {
        if (!this.database.isClosed()) {
            this.database.close();
        }
        this.database.open(iUserName, iUserPassword);
    }

    public OIdentifiable[] query(String iText) {
        return this.query(iText, (Object[])null);
    }

    public OIdentifiable[] query(String iText, Object ... iParameters) {
        return this.query(new OSQLSynchQuery(iText), iParameters);
    }

    public OIdentifiable[] query(OSQLQuery iQuery, Object ... iParameters) {
        Object res = this.database.query(iQuery, this.convertParameters(iParameters));
        if (res == null) {
            return new OIdentifiable[0];
        }
        return res.toArray((OIdentifiable[])new OIdentifiable[res.size()]);
    }

    public Object executeCommand(String iText) {
        return this.command(iText, null);
    }

    public Object executeCommand(String iText, Object ... iParameters) {
        return this.command(iText, iParameters);
    }

    public Object command(String iText) {
        return this.command(iText, null);
    }

    public Object command(String iText, Object ... iParameters) {
        Object res = this.database.command(new OCommandSQL(iText)).execute(this.convertParameters(iParameters));
        if (res instanceof List) {
            List list = (List)res;
            return list.toArray(new OIdentifiable[list.size()]);
        }
        return res;
    }

    public Object process(String iType, String iName, Object ... iParameters) {
        Object res;
        OComposableProcessor process = (OComposableProcessor)OProcessorManager.getInstance().get(iType);
        if (process == null) {
            throw new OProcessException("Process type '" + iType + "' is undefined");
        }
        OBasicCommandContext context = new OBasicCommandContext();
        if (iParameters != null) {
            int argIdx = 0;
            for (Object p : iParameters) {
                context.setVariable("arg" + argIdx++, p);
            }
        }
        try {
            res = process.processFromFile(iName, context, false);
        }
        catch (Exception e) {
            throw new OProcessException("Error on processing '" + iName + "' field of '" + this.getName() + "' block", e);
        }
        return res;
    }

    public OIndex<?> getIndex(String iName) {
        return this.database.getMetadata().getIndexManager().getIndex(iName);
    }

    public boolean exists() {
        return this.database.exists();
    }

    public ODocument newInstance() {
        return this.database.newInstance();
    }

    public void reload() {
        this.database.reload();
    }

    public ODocument newInstance(String iClassName) {
        return this.database.newInstance(iClassName);
    }

    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.database.browseClass(iClassName);
    }

    public ODatabase.STATUS getStatus() {
        return this.database.getStatus();
    }

    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        return this.database.browseClass(iClassName, iPolymorphic);
    }

    public <THISDB extends ODatabase> THISDB setStatus(ODatabase.STATUS iStatus) {
        return (THISDB)this.database.setStatus(iStatus);
    }

    public void drop() {
        this.database.drop();
    }

    public String getName() {
        return this.database.getName();
    }

    public String getURL() {
        return this.database.getURL();
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        return this.database.browseCluster(iClusterName);
    }

    public boolean isClosed() {
        return this.database.isClosed();
    }

    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        return (THISDB)this.database.open(iUserName, iUserPassword);
    }

    public ODocument save(Map<String, Object> iObject) {
        return (ODocument)this.database.save(new ODocument().fields(iObject));
    }

    public ODocument save(String iString) {
        return (ODocument)this.database.save(new ODocument().fromJSON(iString, true));
    }

    public ODocument save(ORecord iRecord) {
        return (ODocument)this.database.save(iRecord);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.database.dropCluster(iClusterName, iTruncate);
    }

    public <THISDB extends ODatabase> THISDB create() {
        return (THISDB)this.database.create();
    }

    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        return this.database.dropCluster(iClusterId, true);
    }

    public void close() {
        this.database.close();
    }

    public int getClusters() {
        return this.database.getClusters();
    }

    public Collection<String> getClusterNames() {
        return this.database.getClusterNames();
    }

    public OTransaction getTransaction() {
        return this.database.getTransaction();
    }

    public ODatabase<ORecord> begin() {
        return this.database.begin();
    }

    public int getClusterIdByName(String iClusterName) {
        return this.database.getClusterIdByName(iClusterName);
    }

    public boolean isMVCC() {
        return this.database.isMVCC();
    }

    public String getClusterNameById(int iClusterId) {
        return this.database.getClusterNameById(iClusterId);
    }

    public <RET extends ODatabase<?>> RET setMVCC(boolean iValue) {
        return (RET)this.database.setMVCC(iValue);
    }

    public long getClusterRecordSizeById(int iClusterId) {
        return this.database.getClusterRecordSizeById(iClusterId);
    }

    public boolean isValidationEnabled() {
        return this.database.isValidationEnabled();
    }

    public long getClusterRecordSizeByName(String iClusterName) {
        return this.database.getClusterRecordSizeByName(iClusterName);
    }

    public <RET extends ODatabaseDocument> RET setValidationEnabled(boolean iValue) {
        return (RET)this.database.setValidationEnabled(iValue);
    }

    public OSecurityUser getUser() {
        return this.database.getUser();
    }

    public void setUser(OUser user) {
        this.database.setUser(user);
    }

    public ODocument save(ORecord iRecord, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return (ODocument)this.database.save(iRecord, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    public OMetadata getMetadata() {
        return this.database.getMetadata();
    }

    public ODictionary<ORecord> getDictionary() {
        return this.database.getDictionary();
    }

    public byte getRecordType() {
        return this.database.getRecordType();
    }

    public ODatabase<ORecord> delete(ORID iRid) {
        return this.database.delete(iRid);
    }

    public <RET extends ORecord> RET load(ORID iRecordId) {
        return (RET)this.database.load(iRecordId);
    }

    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)this.database.load(iRecordId, iFetchPlan);
    }

    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)this.database.load(iRecordId, iFetchPlan, iIgnoreCache);
    }

    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        return this.database.getRecord(iIdentifiable);
    }

    public int getDefaultClusterId() {
        return this.database.getDefaultClusterId();
    }

    public <RET extends ORecord> RET load(ORecord iRecord) {
        return this.database.load(iRecord);
    }

    public boolean declareIntent(OIntent iIntent) {
        return this.database.declareIntent(iIntent);
    }

    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan) {
        return this.database.load(iRecord, iFetchPlan);
    }

    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.database.load(iRecord, iFetchPlan, iIgnoreCache);
    }

    public ODatabase<?> setDatabaseOwner(ODatabaseInternal<?> iOwner) {
        return this.database.setDatabaseOwner(iOwner);
    }

    public void reload(ORecord iRecord) {
        this.database.reload(iRecord);
    }

    public void reload(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        this.database.reload(iRecord, iFetchPlan, iIgnoreCache);
    }

    public Object setProperty(String iName, Object iValue) {
        return this.database.setProperty(iName, iValue);
    }

    public ODocument save(ORecord iRecord, String iClusterName) {
        return (ODocument)this.database.save(iRecord, iClusterName);
    }

    public Object getProperty(String iName) {
        return this.database.getProperty(iName);
    }

    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.database.getProperties();
    }

    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        return this.database.get(iAttribute);
    }

    public <THISDB extends ODatabase> THISDB set(ODatabase.ATTRIBUTES attribute, Object iValue) {
        return (THISDB)this.database.set(attribute, iValue);
    }

    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        this.database.setInternal(attribute, iValue);
    }

    public boolean isRetainRecords() {
        return this.database.isRetainRecords();
    }

    public ODatabaseDocument setRetainRecords(boolean iValue) {
        return this.database.setRetainRecords(iValue);
    }

    public long getSize() {
        return this.database.getSize();
    }

    public ORecord getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        return this.database.getRecordByUserObject(iUserObject, iCreateIfNotAvailable);
    }

    public ODocument save(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return (ODocument)this.database.save(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    public ODatabaseDocumentTx delete(ODocument iRecord) {
        return this.database.delete(iRecord);
    }

    public long countClass(String iClassName) {
        return this.database.countClass(iClassName);
    }

    public ODatabase<ORecord> commit() {
        return this.database.commit();
    }

    public ODatabase<ORecord> rollback() {
        return this.database.rollback();
    }

    public String getType() {
        return this.database.getType();
    }

    protected Object[] convertParameters(Object[] iParameters) {
        if (iParameters != null) {
            for (int i = 0; i < iParameters.length; ++i) {
                Object p = iParameters[i];
                if (p == null) continue;
            }
        }
        return iParameters;
    }
}

