/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.OCommand;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseContext;
import com.orientechnologies.orient.core.command.traverse.OTraversePath;
import com.orientechnologies.orient.core.command.traverse.OTraverseRecordSetProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OTraverse
implements OCommand,
Iterable<OIdentifiable>,
Iterator<OIdentifiable> {
    private OCommandPredicate predicate;
    private Iterator<? extends OIdentifiable> target;
    private List<Object> fields = new ArrayList<Object>();
    private long resultCount = 0L;
    private long limit = 0L;
    private OIdentifiable lastTraversed;
    private STRATEGY strategy = STRATEGY.DEPTH_FIRST;
    private OTraverseContext context = new OTraverseContext();

    @Override
    public List<OIdentifiable> execute() {
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }

    public OTraverseAbstractProcess<?> nextProcess() {
        return this.context.next();
    }

    @Override
    public boolean hasNext() {
        if (this.limit > 0L && this.resultCount >= this.limit) {
            return false;
        }
        if (this.lastTraversed == null) {
            this.lastTraversed = this.next();
        }
        if (this.lastTraversed == null && !this.context.isEmpty()) {
            throw new IllegalStateException("Traverse ended abnormally");
        }
        if (!this.context.checkTimeout()) {
            return false;
        }
        return this.lastTraversed != null;
    }

    @Override
    public OIdentifiable next() {
        OTraverseAbstractProcess<?> toProcess;
        if (Thread.interrupted()) {
            throw new OCommandExecutionException("The traverse execution has been interrupted");
        }
        if (this.lastTraversed != null) {
            OIdentifiable result = this.lastTraversed;
            this.lastTraversed = null;
            return result;
        }
        if (this.limit > 0L && this.resultCount >= this.limit) {
            return null;
        }
        while ((toProcess = this.nextProcess()) != null) {
            OIdentifiable result = (OIdentifiable)toProcess.process();
            if (result == null) continue;
            ++this.resultCount;
            return result;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    @Override
    public OTraverseContext getContext() {
        return this.context;
    }

    public OTraverse target(Iterable<? extends OIdentifiable> iTarget) {
        return this.target(iTarget.iterator());
    }

    public OTraverse target(OIdentifiable ... iRecords) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, iRecords);
        return this.target(list.iterator());
    }

    public OTraverse target(Iterator<? extends OIdentifiable> iTarget) {
        this.target = iTarget;
        this.context.reset();
        new OTraverseRecordSetProcess(this, this.target, OTraversePath.empty());
        return this;
    }

    public Iterator<? extends OIdentifiable> getTarget() {
        return this.target;
    }

    public OTraverse predicate(OCommandPredicate iPredicate) {
        this.predicate = iPredicate;
        return this;
    }

    public OCommandPredicate getPredicate() {
        return this.predicate;
    }

    public OTraverse field(Object iField) {
        if (!this.fields.contains(iField)) {
            this.fields.add(iField);
        }
        return this;
    }

    public OTraverse fields(Collection<Object> iFields) {
        for (Object f : iFields) {
            this.field(f);
        }
        return this;
    }

    public OTraverse fields(String ... iFields) {
        for (String f : iFields) {
            this.field(f);
        }
        return this;
    }

    public List<Object> getFields() {
        return this.fields;
    }

    public long getLimit() {
        return this.limit;
    }

    public OTraverse limit(long iLimit) {
        if (iLimit < -1L) {
            throw new IllegalArgumentException("Limit cannot be negative. 0 = infinite");
        }
        this.limit = iLimit;
        return this;
    }

    public String toString() {
        return String.format("OTraverse.target(%s).fields(%s).limit(%d).predicate(%s)", this.target, this.fields, this.limit, this.predicate);
    }

    public long getResultCount() {
        return this.resultCount;
    }

    public OIdentifiable getLastTraversed() {
        return this.lastTraversed;
    }

    public STRATEGY getStrategy() {
        return this.strategy;
    }

    public void setStrategy(STRATEGY strategy) {
        this.strategy = strategy;
        this.context.setStrategy(strategy);
    }

    public static enum STRATEGY {
        DEPTH_FIRST,
        BREADTH_FIRST;

    }
}

