/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class ODatabaseRecordWrapperAbstract<DB extends ODatabaseDocumentInternal>
extends ODatabaseWrapperAbstract<DB, ORecord>
implements ODatabaseDocumentInternal {
    public ODatabaseRecordWrapperAbstract(DB iDatabase) {
        super(iDatabase);
        iDatabase.setDatabaseOwner(this);
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_CREATE, new Object[0]);
        return super.create();
    }

    @Override
    public <THISDB extends ODatabase> THISDB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_CREATE, new Object[0]);
        return super.create(iInitialSettings);
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_DELETE, new Object[0]);
        super.drop();
    }

    @Override
    public int addCluster(String iClusterName, int iRequestedId, Object ... iParameters) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        return super.addCluster(iClusterName, iRequestedId, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, Object ... iParameters) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        return super.addCluster(iClusterName, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkClusterBoundedToClass(this.getClusterIdByName(iClusterName));
        return super.dropCluster(iClusterName, iTruncate);
    }

    @Override
    public boolean dropCluster(int iClusterId, boolean iTruncate) {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkClusterBoundedToClass(iClusterId);
        return super.dropCluster(iClusterId, iTruncate);
    }

    @Override
    public OBinarySerializerFactory getSerializerFactory() {
        return ((ODatabaseDocumentInternal)this.underlying).getSerializerFactory();
    }

    @Override
    public OTransaction getTransaction() {
        return ((ODatabaseDocumentInternal)this.underlying).getTransaction();
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        ((ODatabaseDocumentInternal)this.underlying).replaceStorage(iNewStorage);
    }

    @Override
    public ODatabase<ORecord> begin() {
        return ((ODatabaseDocumentInternal)this.underlying).begin();
    }

    @Override
    public ODatabase<ORecord> begin(OTransaction.TXTYPE iType) {
        return ((ODatabaseDocumentInternal)this.underlying).begin(iType);
    }

    @Override
    public ODatabase<ORecord> begin(OTransaction iTx) {
        return ((ODatabaseDocumentInternal)this.underlying).begin(iTx);
    }

    @Override
    public boolean isMVCC() {
        this.checkOpeness();
        return ((ODatabaseDocumentInternal)this.underlying).isMVCC();
    }

    @Override
    public <RET extends ODatabase<?>> RET setMVCC(boolean iValue) {
        this.checkOpeness();
        return (RET)((ODatabaseDocumentInternal)this.underlying).setMVCC(iValue);
    }

    @Override
    public boolean isValidationEnabled() {
        return ((ODatabaseDocumentInternal)this.underlying).isValidationEnabled();
    }

    public <RET extends ODatabaseDocument> RET setValidationEnabled(boolean iValue) {
        return (RET)((ODatabaseDocumentInternal)this.underlying).setValidationEnabled(iValue);
    }

    @Override
    public OSecurityUser getUser() {
        return ((ODatabaseDocumentInternal)this.underlying).getUser();
    }

    @Override
    public void setUser(OSecurityUser user) {
        ((ODatabaseDocumentInternal)this.underlying).setUser(user);
    }

    @Override
    public OMetadata getMetadata() {
        return ((ODatabaseDocumentInternal)this.underlying).getMetadata();
    }

    @Override
    public ODictionary<ORecord> getDictionary() {
        return ((ODatabaseDocumentInternal)this.underlying).getDictionary();
    }

    @Override
    public byte getRecordType() {
        return ((ODatabaseDocumentInternal)this.underlying).getRecordType();
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName) {
        return ((ODatabaseDocumentInternal)this.underlying).browseCluster(iClusterName);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass) {
        return ((ODatabaseDocumentInternal)this.underlying).browseCluster(iClusterName, iRecordClass);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        return ((ODatabaseDocumentInternal)this.underlying).browseCluster(iClusterName, iRecordClass, startClusterPosition, endClusterPosition, loadTombstones);
    }

    @Override
    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        return ((ODatabaseDocumentInternal)this.underlying).command(iCommand);
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<? extends Object> iCommand, Object ... iArgs) {
        return ((ODatabaseDocumentInternal)this.underlying).query(iCommand, iArgs);
    }

    @Override
    public <RET> RET newInstance() {
        return ((ODatabaseDocumentInternal)this.underlying).newInstance();
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRid) {
        ((ODatabaseDocumentInternal)this.underlying).delete(iRid);
        return this;
    }

    @Override
    public ODatabase<ORecord> delete(ORID iRid, ORecordVersion iVersion) {
        ((ODatabaseDocumentInternal)this.underlying).delete(iRid, iVersion);
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        return ((ODatabaseDocumentInternal)this.underlying).hide(rid);
    }

    @Override
    public ODatabase<ORecord> cleanOutRecord(ORID rid, ORecordVersion version) {
        ((ODatabaseDocumentInternal)this.underlying).cleanOutRecord(rid, version);
        return this;
    }

    @Override
    public ODatabase<ORecord> delete(ORecord iRecord) {
        ((ODatabaseDocumentInternal)this.underlying).delete(iRecord);
        return this;
    }

    @Override
    public <RET extends ORecord> RET load(ORID recordId) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(recordId));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecordId, iFetchPlan));
    }

    @Override
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache));
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT));
    }

    @Override
    @Deprecated
    public <RET extends ORecord> RET load(ORecord iObject, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iObject, iFetchPlan, iIgnoreCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT));
    }

    @Override
    public <RET extends ORecord> RET getRecord(OIdentifiable iIdentifiable) {
        return ((ODatabaseDocumentInternal)this.underlying).getRecord(iIdentifiable);
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecord));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecord, iFetchPlan));
    }

    @Override
    public <RET extends ORecord> RET load(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).load(iRecord, iFetchPlan, iIgnoreCache));
    }

    public <RET extends ORecord> RET reload(ORecord iRecord) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).reload(iRecord, null, true));
    }

    @Override
    public <RET extends ORecord> RET reload(ORecord iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).reload(iRecord, iFetchPlan, iIgnoreCache));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).save(iRecord));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).save(iRecord, iClusterName));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).save(iRecord, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback));
    }

    @Override
    public <RET extends ORecord> RET save(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return (RET)((ORecord)((ODatabaseDocumentInternal)this.underlying).save(iRecord, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback));
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        ((ODatabaseDocumentInternal)this.underlying).setInternal(attribute, iValue);
    }

    @Override
    public boolean isRetainRecords() {
        return ((ODatabaseDocumentInternal)this.underlying).isRetainRecords();
    }

    @Override
    public ODatabaseDocument setRetainRecords(boolean iValue) {
        ((ODatabaseDocumentInternal)this.underlying).setRetainRecords(iValue);
        return (ODatabaseDocument)this.getClass().cast(this);
    }

    @Override
    public ORecord getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        if (this.databaseOwner != this) {
            return this.getDatabaseOwner().getRecordByUserObject(iUserObject, false);
        }
        return (ORecord)iUserObject;
    }

    @Override
    public void registerUserObject(Object iObject, ORecord iRecord) {
        if (this.databaseOwner != this) {
            this.getDatabaseOwner().registerUserObject(iObject, iRecord);
        }
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecord iRecord) {
        if (this.databaseOwner != this) {
            this.getDatabaseOwner().registerUserObjectAfterLinkSave(iRecord);
        }
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
        if (this.databaseOwner != this) {
            return this.databaseOwner.getUserObjectByRecord(iRecord, iFetchPlan);
        }
        return iRecord;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        if (this.databaseOwner != this) {
            return this.databaseOwner.existsUserObjectByRID(iRID);
        }
        return false;
    }

    public <DBTYPE extends ODatabaseDocument> DBTYPE checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    public <DBTYPE extends ODatabaseDocument> DBTYPE checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object iResourceSpecific) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(iResourceGeneric, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabaseDocument> DBTYPE checkSecurity(ORule.ResourceGeneric iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        return (DBTYPE)((ODatabaseDocumentInternal)this.underlying).checkSecurity(iResourceGeneric, iOperation, iResourcesSpecific);
    }

    @Override
    public <DBTYPE extends ODatabase<?>> DBTYPE registerHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentInternal)this.underlying).registerHook(iHookImpl);
        return (DBTYPE)this;
    }

    @Override
    public <DBTYPE extends ODatabase<?>> DBTYPE registerHook(ORecordHook iHookImpl, ORecordHook.HOOK_POSITION iPosition) {
        ((ODatabaseDocumentInternal)this.underlying).registerHook(iHookImpl, iPosition);
        return (DBTYPE)this;
    }

    @Override
    public ORecordHook.RESULT callbackHooks(ORecordHook.TYPE iType, OIdentifiable iObject) {
        return ((ODatabaseDocumentInternal)this.underlying).callbackHooks(iType, iObject);
    }

    @Override
    public Map<ORecordHook, ORecordHook.HOOK_POSITION> getHooks() {
        return ((ODatabaseDocumentInternal)this.underlying).getHooks();
    }

    @Override
    public <DBTYPE extends ODatabase<?>> DBTYPE unregisterHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentInternal)this.underlying).unregisterHook(iHookImpl);
        return (DBTYPE)this;
    }

    @Override
    public void backup(OutputStream out, Map<String, Object> options, final Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        ((ODatabaseDocumentInternal)this.underlying).backup(out, options, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (OIndex<?> index : ODatabaseRecordWrapperAbstract.this.getMetadata().getIndexManager().getIndexes()) {
                    index.flush();
                }
                if (callable != null) {
                    return callable.call();
                }
                return null;
            }
        }, iListener, compressionLevel, bufferSize);
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.getStorage().getConflictStrategy();
    }

    @Override
    public ODatabaseRecordWrapperAbstract<DB> setConflictStrategy(String iStrategyName) {
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODatabaseRecordWrapperAbstract<DB> setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getStorage().setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public void resetInitialization() {
        ((ODatabaseDocumentInternal)this.underlying).resetInitialization();
    }

    @Override
    public ODatabase<ORecord> commit() throws OTransactionException {
        return ((ODatabaseDocumentInternal)this.underlying).commit();
    }

    @Override
    public ODatabase<ORecord> commit(boolean force) throws OTransactionException {
        return ((ODatabaseDocumentInternal)this.underlying).commit(false);
    }

    @Override
    public ODatabase<ORecord> rollback() throws OTransactionException {
        return ((ODatabaseDocumentInternal)this.underlying).rollback();
    }

    @Override
    public ODatabase<ORecord> rollback(boolean force) throws OTransactionException {
        return ((ODatabaseDocumentInternal)this.underlying).rollback(force);
    }

    @Override
    public String getType() {
        return ((ODatabaseDocumentInternal)this.underlying).getType();
    }

    @Override
    public OCurrentStorageComponentsFactory getStorageVersions() {
        return ((ODatabaseDocumentInternal)this.underlying).getStorageVersions();
    }

    @Override
    public OSBTreeCollectionManager getSbTreeCollectionManager() {
        return ((ODatabaseDocumentInternal)this.underlying).getSbTreeCollectionManager();
    }

    @Override
    public ORecordSerializer getSerializer() {
        return ((ODatabaseDocumentInternal)this.underlying).getSerializer();
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return ((ODatabaseDocumentInternal)this.underlying).browseClass(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        return ((ODatabaseDocumentInternal)this.underlying).browseClass(iClassName, iPolymorphic);
    }

    @Override
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String iClusterName, long startClusterPosition, long endClusterPosition, boolean loadTombstones) {
        return ((ODatabaseDocumentInternal)this.underlying).browseCluster(iClusterName, startClusterPosition, endClusterPosition, loadTombstones);
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        return ((ODatabaseDocumentInternal)this.underlying).newInstance(iClassName);
    }

    @Override
    public long countClass(String iClassName) {
        return ((ODatabaseDocumentInternal)this.underlying).countClass(iClassName);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        return ((ODatabaseDocumentInternal)this.underlying).countClass(iClassName, iPolymorphic);
    }

    protected void checkClusterBoundedToClass(int iClusterId) {
        if (iClusterId == -1) {
            return;
        }
        for (OClass clazz : ((OMetadataInternal)this.getMetadata()).getImmutableSchemaSnapshot().getClasses()) {
            if (clazz.getDefaultClusterId() == iClusterId) {
                throw new OSchemaException("Cannot drop the cluster '" + this.getClusterNameById(iClusterId) + "' because the classes ['" + clazz.getName() + "'] are bound to it. Drop these classes before dropping the cluster");
            }
            if (clazz.getClusterIds().length <= 1) continue;
            for (int i : clazz.getClusterIds()) {
                if (i != iClusterId) continue;
                throw new OSchemaException("Cannot drop the cluster '" + this.getClusterNameById(iClusterId) + "' because the classes ['" + clazz.getName() + "'] are bound to it. Drop these classes before dropping the cluster");
            }
        }
    }
}

