/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class OPartitionedDatabasePool
extends OOrientListenerAbstract {
    private static final int HASH_INCREMENT = 1640531527;
    private static final int MIN_POOL_SIZE = 2;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private final String url;
    private final String userName;
    private final String password;
    private final int maxSize;
    private final ThreadLocal<PoolData> poolData = new ThreadPoolData();
    private final AtomicBoolean poolBusy = new AtomicBoolean();
    private final int maxPartitions = Runtime.getRuntime().availableProcessors() << 3;
    private volatile PoolPartition[] partitions;
    private volatile boolean closed = false;
    private boolean autoCreate = false;

    public OPartitionedDatabasePool(String url, String userName, String password) {
        this(url, userName, password, 64);
    }

    public OPartitionedDatabasePool(String url, String userName, String password, int maxSize) {
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.maxSize = maxSize;
        PoolPartition[] pts = new PoolPartition[2];
        for (int i = 0; i < pts.length; ++i) {
            PoolPartition partition;
            pts[i] = partition = new PoolPartition();
            this.initQueue(url, partition);
        }
        this.partitions = pts;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getAvailableConnections() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get() - partition.acquiredConnections.get();
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getCreatedInstances() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get();
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public ODatabaseDocumentTx acquire() {
        DatabaseDocumentTxPolled db;
        PoolPartition partition;
        PoolData data;
        block7: {
            this.checkForClose();
            data = this.poolData.get();
            if (data.acquireCount > 0) {
                data.acquireCount++;
                assert (data.acquiredDatabase != null);
                return data.acquiredDatabase;
            }
            while (true) {
                int index;
                PoolPartition[] pts;
                if ((partition = (pts = this.partitions)[index = pts.length - 1 & data.hashCode]) == null) {
                    if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                    if (pts == this.partitions && (partition = pts[index]) == null) {
                        partition = new PoolPartition();
                        this.initQueue(this.url, partition);
                        pts[index] = partition;
                    }
                    this.poolBusy.set(false);
                    continue;
                }
                db = (DatabaseDocumentTxPolled)partition.queue.poll();
                if (db != null) break block7;
                if (pts.length >= this.maxPartitions) break;
                if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                if (pts == this.partitions) {
                    PoolPartition[] newPartitions = new PoolPartition[this.partitions.length << 1];
                    System.arraycopy(this.partitions, 0, newPartitions, 0, this.partitions.length);
                    this.partitions = newPartitions;
                }
                this.poolBusy.set(false);
            }
            if (partition.currentSize.get() >= this.maxSize) {
                throw new IllegalStateException("You have reached maximum pool size for given partition");
            }
            db = new DatabaseDocumentTxPolled(this.url);
            this.openDatabase(db);
            db.partition = partition;
            data.acquireCount = 1;
            data.acquiredDatabase = db;
            partition.acquiredConnections.incrementAndGet();
            partition.currentSize.incrementAndGet();
            return db;
        }
        this.openDatabase(db);
        db.partition = partition;
        partition.acquiredConnections.incrementAndGet();
        data.acquireCount = 1;
        data.acquiredDatabase = db;
        return db;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public OPartitionedDatabasePool setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
        return this;
    }

    protected void openDatabase(DatabaseDocumentTxPolled db) {
        if (!db.getURL().startsWith("remote:") && !db.exists()) {
            if (this.autoCreate) {
                db.create();
            }
        } else {
            db.internalOpen();
        }
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            ConcurrentLinkedQueue queue = partition.queue;
            while (!queue.isEmpty()) {
                DatabaseDocumentTxPolled db = (DatabaseDocumentTxPolled)queue.poll();
                OStorage storage = db.getStorage();
                storage.close();
            }
        }
    }

    private void initQueue(String url, PoolPartition partition) {
        ConcurrentLinkedQueue queue = partition.queue;
        for (int n = 0; n < 2; ++n) {
            DatabaseDocumentTxPolled db = new DatabaseDocumentTxPolled(url);
            queue.add(db);
        }
        partition.currentSize.addAndGet(2);
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Pool is closed");
        }
    }

    static /* synthetic */ int access$100() {
        return OPartitionedDatabasePool.nextHashCode();
    }

    private final class DatabaseDocumentTxPolled
    extends ODatabaseDocumentTx {
        private PoolPartition partition;

        private DatabaseDocumentTxPolled(String iURL) {
            super(iURL, true);
        }

        @Override
        public <DB extends ODatabase> DB open(OToken iToken) {
            throw new ODatabaseException("Impossible to open a database managed by a pool ");
        }

        @Override
        public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
            throw new ODatabaseException("Impossible to open a database managed by a pool ");
        }

        protected void internalOpen() {
            super.open(OPartitionedDatabasePool.this.userName, OPartitionedDatabasePool.this.password);
        }

        @Override
        public void close() {
            PoolData data = (PoolData)OPartitionedDatabasePool.this.poolData.get();
            if (data.acquireCount == 0) {
                return;
            }
            data.acquireCount--;
            if (data.acquireCount > 0) {
                return;
            }
            PoolPartition p = this.partition;
            this.partition = null;
            super.close();
            data.acquiredDatabase = null;
            p.queue.offer(this);
            p.acquiredConnections.decrementAndGet();
        }
    }

    private static class ThreadPoolData
    extends ThreadLocal<PoolData> {
        private ThreadPoolData() {
        }

        @Override
        protected PoolData initialValue() {
            return new PoolData();
        }
    }

    private static final class PoolPartition {
        private final AtomicInteger currentSize = new AtomicInteger();
        private final AtomicInteger acquiredConnections = new AtomicInteger();
        private final ConcurrentLinkedQueue<DatabaseDocumentTxPolled> queue = new ConcurrentLinkedQueue();

        private PoolPartition() {
        }
    }

    private static final class PoolData {
        private final int hashCode = OPartitionedDatabasePool.access$100();
        private int acquireCount;
        private DatabaseDocumentTxPolled acquiredDatabase;

        private PoolData() {
        }
    }
}

