/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedIterator;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ORecordTrackedSet
extends AbstractCollection<OIdentifiable>
implements Set<OIdentifiable>,
OTrackedMultiValue<OIdentifiable, OIdentifiable>,
ORecordElement {
    protected final ORecord sourceRecord;
    protected Map<OIdentifiable, Object> map = new HashMap<OIdentifiable, Object>();
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    protected static final Object ENTRY_REMOVAL = new Object();
    private Set<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners = Collections.newSetFromMap(new WeakHashMap());

    public ORecordTrackedSet(ORecord iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        if (iSourceRecord != null) {
            iSourceRecord.setDirty();
        }
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new ORecordTrackedIterator(this.sourceRecord, this.map.keySet().iterator());
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (this.map.containsKey(e)) {
            return false;
        }
        this.map.put(e, ENTRY_REMOVAL);
        this.setDirty();
        if (e instanceof ODocument) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, e, e));
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        Object old = this.map.remove(o);
        if (old != null) {
            if (o instanceof ODocument) {
                ODocumentInternal.removeOwner((ODocument)o, this);
            }
            this.setDirty();
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, (OIdentifiable)o, null, (OIdentifiable)o));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.map.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object item : c) {
            if (!this.remove(item)) continue;
            changed = true;
        }
        if (changed) {
            this.setDirty();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        for (OIdentifiable oIdentifiable : c) {
            this.add(oIdentifiable);
        }
        this.setDirty();
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        if (super.retainAll(c)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public ORecordTrackedSet setDirty() {
        if (!(this.status == ORecordElement.STATUS.UNMARSHALLING || this.sourceRecord == null || this.sourceRecord.isDirty() && ORecordInternal.isContentChanged(this.sourceRecord))) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public Set<OIdentifiable> returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> events) {
        HashSet<OIdentifiable> reverted = new HashSet<OIdentifiable>(this);
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = events.listIterator(events.size());
        block4: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block4;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        if (this.getOwner().getInternalStatus() == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }
}

