/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import java.util.UUID;

public abstract class OSBTreeCollectionManagerAbstract
implements OCloseable,
OSBTreeCollectionManager {
    public static final String FILE_NAME_PREFIX = "collections_";
    public static final String DEFAULT_EXTENSION = ".sbc";
    protected final int evictionThreshold;
    protected final int cacheMaxSize;
    protected final int shift;
    protected final int mask;
    protected final Object[] locks;
    private final ConcurrentLinkedHashMap<OBonsaiCollectionPointer, SBTreeBonsaiContainer> treeCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(Long.MAX_VALUE).build();

    public OSBTreeCollectionManagerAbstract() {
        this(OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE.getValueAsInteger(), OGlobalConfiguration.SBTREEBONSAI_LINKBAG_CACHE_SIZE.getValueAsInteger());
    }

    public OSBTreeCollectionManagerAbstract(int evictionThreshold, int cacheMaxSize) {
        this.evictionThreshold = evictionThreshold;
        this.cacheMaxSize = cacheMaxSize;
        int concurrencyLevel = Runtime.getRuntime().availableProcessors() * 4;
        int cL = 1;
        int sh = 0;
        while (cL < concurrencyLevel) {
            cL <<= 1;
            ++sh;
        }
        this.shift = 32 - sh;
        this.mask = cL - 1;
        Object[] locks = new Object[cL];
        for (int i = 0; i < locks.length; ++i) {
            locks[i] = new Object();
        }
        this.locks = locks;
    }

    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> createAndLoadTree(int clusterId) {
        return this.loadSBTree(this.createSBTree(clusterId, null));
    }

    @Override
    public OBonsaiCollectionPointer createSBTree(int clusterId, UUID ownerUUID) {
        OSBTreeBonsai<OIdentifiable, Integer> tree = this.createTree(clusterId);
        return tree.getCollectionPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSBTreeBonsai<OIdentifiable, Integer> loadSBTree(OBonsaiCollectionPointer collectionPointer) {
        OSBTreeBonsai tree;
        Object lock;
        Object object = lock = this.treesSubsetLock(collectionPointer);
        synchronized (object) {
            SBTreeBonsaiContainer container = this.treeCache.get(collectionPointer);
            if (container != null) {
                container.usagesCounter++;
                tree = container.tree;
            } else {
                tree = this.loadTree(collectionPointer);
                assert (tree.getRootBucketPointer().equals(collectionPointer.getRootPointer()));
                container = new SBTreeBonsaiContainer(tree);
                container.usagesCounter++;
                this.treeCache.put(collectionPointer, container);
            }
        }
        this.evict();
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSBTree(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        Object object = lock = this.treesSubsetLock(collectionPointer);
        synchronized (object) {
            SBTreeBonsaiContainer container = this.treeCache.getQuietly(collectionPointer);
            assert (container != null);
            container.usagesCounter--;
            assert (container.usagesCounter >= 0);
        }
        this.evict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(OBonsaiCollectionPointer collectionPointer) {
        Object lock;
        Object object = lock = this.treesSubsetLock(collectionPointer);
        synchronized (object) {
            SBTreeBonsaiContainer container = this.treeCache.getQuietly(collectionPointer);
            assert (container != null);
            if (container.usagesCounter != 0) {
                throw new IllegalStateException("Can not delete SBTreeBonsai instance because it is used in other thread.");
            }
            this.treeCache.remove(collectionPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict() {
        if (this.treeCache.size() <= this.cacheMaxSize) {
            return;
        }
        for (OBonsaiCollectionPointer collectionPointer : this.treeCache.ascendingKeySetWithLimit(this.evictionThreshold)) {
            Object treeLock;
            Object object = treeLock = this.treesSubsetLock(collectionPointer);
            synchronized (object) {
                SBTreeBonsaiContainer container = this.treeCache.getQuietly(collectionPointer);
                if (container != null && container.usagesCounter == 0) {
                    this.treeCache.remove(collectionPointer);
                }
            }
        }
    }

    @Override
    public void close(boolean onDelete) {
        this.treeCache.clear();
    }

    protected abstract OSBTreeBonsai<OIdentifiable, Integer> createTree(int var1);

    protected abstract OSBTreeBonsai<OIdentifiable, Integer> loadTree(OBonsaiCollectionPointer var1);

    int size() {
        return this.treeCache.size();
    }

    private Object treesSubsetLock(OBonsaiCollectionPointer collectionPointer) {
        int hashCode = collectionPointer.hashCode();
        int index = hashCode >>> this.shift & this.mask;
        return this.locks[index];
    }

    private static final class SBTreeBonsaiContainer {
        private final OSBTreeBonsai<OIdentifiable, Integer> tree;
        private int usagesCounter = 0;

        private SBTreeBonsaiContainer(OSBTreeBonsai<OIdentifiable, Integer> tree) {
            this.tree = tree;
        }
    }
}

