/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.exception.OException;

public class OQueryParsingException
extends OException {
    private String text;
    private int position = -1;
    private static final long serialVersionUID = -7430575036316163711L;

    public OQueryParsingException(String iMessage) {
        super(iMessage);
    }

    public OQueryParsingException(String iMessage, Throwable cause) {
        super(iMessage, cause);
    }

    public OQueryParsingException(String iMessage, String iText, int iPosition, Throwable cause) {
        super(iMessage, cause);
        this.text = iText;
        this.position = iPosition;
    }

    public OQueryParsingException(String iMessage, String iText, int iPosition) {
        super(iMessage);
        this.text = iText;
        this.position = iPosition;
    }

    @Override
    public String getMessage() {
        StringBuilder buffer = new StringBuilder();
        if (this.position > -1) {
            buffer.append("Error on parsing query at position #");
            buffer.append(this.position);
            buffer.append(": ");
        }
        buffer.append(super.getMessage());
        if (this.text != null) {
            buffer.append("\nQuery: ");
            buffer.append(this.text);
            buffer.append("\n------");
            for (int i = 0; i < this.position - 1; ++i) {
                buffer.append("-");
            }
            buffer.append("^");
        }
        return buffer.toString();
    }

    public String getText() {
        return this.text;
    }
}

