/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.hook;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.util.HashSet;
import java.util.Set;

public class OHookThreadLocal
extends ThreadLocal<Set<OIdentifiable>> {
    public static volatile OHookThreadLocal INSTANCE = new OHookThreadLocal();

    public boolean push(OIdentifiable iRecord) {
        Set set = (Set)this.get();
        if (set.contains(iRecord)) {
            return false;
        }
        set.add(iRecord);
        return true;
    }

    public boolean isInsideHookExecution() {
        return !((Set)this.get()).isEmpty();
    }

    public boolean pop(OIdentifiable iRecord) {
        return ((Set)this.get()).remove(iRecord);
    }

    @Override
    protected Set<OIdentifiable> initialValue() {
        return new HashSet<OIdentifiable>();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OHookThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }
}

