/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OSBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ODefaultIndexFactory
implements OIndexFactory {
    public static final String SBTREE_ALGORITHM = "SBTREE";
    public static final String SBTREEBONSAI_VALUE_CONTAINER = "SBTREEBONSAISET";
    public static final String NONE_VALUE_CONTAINER = "NONE";
    private static final Set<String> TYPES;
    private static final Set<String> ALGORITHMS;

    public static boolean isMultiValueIndex(String indexType) {
        switch (OClass.INDEX_TYPE.valueOf(indexType)) {
            case UNIQUE: 
            case UNIQUE_HASH_INDEX: 
            case DICTIONARY: 
            case DICTIONARY_HASH_INDEX: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public OIndexInternal<?> createIndex(String name, ODatabaseDocumentInternal database, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = NONE_VALUE_CONTAINER;
        }
        if (SBTREE_ALGORITHM.equals(algorithm)) {
            return this.createSBTreeIndex(name, indexType, valueContainerAlgorithm, metadata, (OAbstractPaginatedStorage)database.getStorage().getUnderlying(), version);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    private OIndexInternal<?> createSBTreeIndex(String name, String indexType, String valueContainerAlgorithm, ODocument metadata, OAbstractPaginatedStorage storage, int version) {
        Object durable = null;
        if (metadata != null) {
            durable = metadata.field("durableInNonTxMode");
        }
        Boolean durableInNonTxMode = durable instanceof Boolean ? (Boolean)durable : null;
        if (OClass.INDEX_TYPE.UNIQUE.toString().equals(indexType)) {
            return new OIndexUnique(indexType, SBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OSBTreeIndexEngine<OIdentifiable>(name, durableInNonTxMode, storage, version), valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE.toString().equals(indexType)) {
            return new OIndexNotUnique(indexType, SBTREE_ALGORITHM, (OIndexEngine<Set<OIdentifiable>>)new OSBTreeIndexEngine<Set<OIdentifiable>>(name, durableInNonTxMode, storage, version), valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.FULLTEXT.toString().equals(indexType)) {
            return new OIndexFullText(indexType, SBTREE_ALGORITHM, (OIndexEngine<Set<OIdentifiable>>)new OSBTreeIndexEngine<Set<OIdentifiable>>(name, durableInNonTxMode, storage, version), valueContainerAlgorithm, metadata);
        }
        if (OClass.INDEX_TYPE.DICTIONARY.toString().equals(indexType)) {
            return new OIndexDictionary(indexType, SBTREE_ALGORITHM, (OIndexEngine<OIdentifiable>)new OSBTreeIndexEngine<OIdentifiable>(name, durableInNonTxMode, storage, version), valueContainerAlgorithm, metadata);
        }
        throw new OConfigurationException("Unsupported type : " + indexType);
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OClass.INDEX_TYPE.UNIQUE.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE.toString());
        types.add(OClass.INDEX_TYPE.FULLTEXT.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add(SBTREE_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

