/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class OIndexOneValue
extends OIndexAbstract<OIdentifiable> {
    public OIndexOneValue(String type, String algorithm, OIndexEngine<OIdentifiable> engine, String valueContainerAlgorithm, ODocument metadata) {
        super(type, algorithm, engine, valueContainerAlgorithm, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIdentifiable get(Object iKey) {
        this.checkForRebuild();
        iKey = this.getCollatingValue(iKey);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(iKey);
        }
        try {
            OIdentifiable oIdentifiable;
            this.acquireSharedLock();
            try {
                oIdentifiable = (OIdentifiable)this.indexEngine.get(iKey);
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return oIdentifiable;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(iKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Object iKey) {
        this.checkForRebuild();
        iKey = this.getCollatingValue(iKey);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(iKey);
        }
        try {
            long l;
            this.acquireSharedLock();
            try {
                l = this.indexEngine.contains(iKey) ? 1L : 0L;
            }
            catch (Throwable throwable) {
                this.releaseSharedLock();
                throw throwable;
            }
            this.releaseSharedLock();
            return l;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(iKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument checkEntry(OIdentifiable record, Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        ODatabaseDocumentInternal database = this.getDatabase();
        boolean txIsActive = database.getTransaction().isActive();
        if (!txIsActive) {
            this.keyLockManager.acquireSharedLock(key);
        }
        try {
            OIdentifiable indexedRID = this.get(key);
            if (indexedRID != null && !indexedRID.getIdentity().equals(record.getIdentity())) {
                Boolean mergeSameKey = this.metadata != null && (Boolean)this.metadata.field("mergeKeys") != false;
                if (mergeSameKey != null && mergeSameKey.booleanValue()) {
                    ODocument oDocument = (ODocument)indexedRID.getRecord();
                    return oDocument;
                }
                throw new OIndexException("Cannot index record : " + record + " found duplicated key '" + key + "' in index " + this.getName() + " previously assigned to the record " + indexedRID);
            }
            ODocument oDocument = null;
            return oDocument;
        }
        finally {
            if (!txIsActive) {
                this.keyLockManager.releaseSharedLock(key);
            }
        }
    }

    public OIndexOneValue create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexOneValue)super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        this.checkForRebuild();
        final ArrayList sortedKeys = new ArrayList(keys);
        Comparator<Object> comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            {
                this.keysIterator = sortedKeys.iterator();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                OIdentifiable result = null;
                Object key = null;
                while (this.keysIterator.hasNext() && result == null) {
                    key = this.keysIterator.next();
                    key = OIndexOneValue.this.getCollatingValue(key);
                    OIndexOneValue.this.acquireSharedLock();
                    try {
                        result = (OIdentifiable)OIndexOneValue.this.indexEngine.get(key);
                    }
                    finally {
                        OIndexOneValue.this.releaseSharedLock();
                    }
                }
                if (result == null) {
                    return null;
                }
                final Object resultKey = key;
                final OIdentifiable resultValue = result;
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return resultKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMajor(fromKey, fromInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMinor(toKey, toInclusive, ascOrder, null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getSize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.cursor(null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.descCursor(null);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    protected OStreamSerializer determineValueSerializer() {
        return OStreamSerializerRID.INSTANCE;
    }
}

