/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collections;
import java.util.List;

public class OPropertyIndexDefinition
extends OAbstractIndexDefinition {
    protected String className;
    protected String field;
    protected OType keyType;

    public OPropertyIndexDefinition(String iClassName, String iField, OType iType) {
        this.className = iClassName;
        this.field = iField;
        this.keyType = iType;
    }

    public OPropertyIndexDefinition() {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public List<String> getFields() {
        return Collections.singletonList(this.field);
    }

    @Override
    public List<String> getFieldsToIndex() {
        if (this.collate == null || this.collate.getName().equals("default")) {
            return Collections.singletonList(this.field);
        }
        return Collections.singletonList(this.field + " collate " + this.collate.getName());
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        if (OType.LINK.equals((Object)this.keyType)) {
            OIdentifiable identifiable = (OIdentifiable)iDocument.field(this.field);
            if (identifiable != null) {
                return this.createValue(identifiable.getIdentity());
            }
            return null;
        }
        return this.createValue(iDocument.field(this.field));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OPropertyIndexDefinition that = (OPropertyIndexDefinition)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.keyType == that.keyType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.keyType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OPropertyIndexDefinition{className='" + this.className + '\'' + ", field='" + this.field + '\'' + ", keyType=" + (Object)((Object)this.keyType) + ", collate=" + this.collate + ", null values ignored = " + this.isNullValuesIgnored() + '}';
    }

    @Override
    public Object createValue(List<?> params) {
        return OType.convert(params.get(0), this.keyType.getDefaultJavaType());
    }

    @Override
    public Object createValue(Object ... params) {
        return OType.convert(params[0], this.keyType.getDefaultJavaType());
    }

    @Override
    public int getParamCount() {
        return 1;
    }

    @Override
    public OType[] getTypes() {
        return new OType[]{this.keyType};
    }

    @Override
    protected final void fromStream() {
        this.serializeFromStream();
    }

    @Override
    public final ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.serializeToStream();
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    protected void serializeToStream() {
        this.document.field("className", this.className);
        this.document.field("field", this.field);
        this.document.field("keyType", this.keyType.toString());
        this.document.field("collate", this.collate.getName());
        this.document.field("nullValuesIgnored", this.isNullValuesIgnored());
    }

    protected void serializeFromStream() {
        this.className = (String)this.document.field("className");
        this.field = (String)this.document.field("field");
        String keyTypeStr = (String)this.document.field("keyType");
        this.keyType = OType.valueOf(keyTypeStr);
        this.setCollate((String)this.document.field("collate"));
        this.setNullValuesIgnored(!Boolean.FALSE.equals(this.document.field("nullValuesIgnored")));
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        return this.createIndexDDLWithFieldType(indexName, indexType).toString();
    }

    protected StringBuilder createIndexDDLWithFieldType(String indexName, String indexType) {
        StringBuilder ddl = this.createIndexDDLWithoutFieldType(indexName, indexType);
        ddl.append(' ').append(this.keyType.name());
        return ddl;
    }

    protected StringBuilder createIndexDDLWithoutFieldType(String indexName, String indexType) {
        StringBuilder ddl = new StringBuilder("create index ");
        String shortName = this.className + "." + this.field;
        if (indexName.equalsIgnoreCase(shortName)) {
            ddl.append(shortName).append(" ");
        } else {
            ddl.append(indexName).append(" on ");
            ddl.append(this.className).append(" ( ").append(this.field);
            if (!this.collate.getName().equals("default")) {
                ddl.append(" collate ").append(this.collate.getName());
            }
            ddl.append(" ) ");
        }
        ddl.append(indexType);
        return ddl;
    }

    @Override
    public boolean isAutomatic() {
        return true;
    }
}

