/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class OHashTableIndexEngine<V>
implements OIndexEngine<V> {
    public static final String METADATA_FILE_EXTENSION = ".him";
    public static final String TREE_FILE_EXTENSION = ".hit";
    public static final String BUCKET_FILE_EXTENSION = ".hib";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".hnb";
    private final OLocalHashTable<Object, V> hashTable;
    private final OMurmurHash3HashFunction<Object> hashFunction = new OMurmurHash3HashFunction();

    public OHashTableIndexEngine(String name, Boolean durableInNonTxMode, OAbstractPaginatedStorage storage, int version) {
        boolean durableInNonTx = durableInNonTxMode == null ? OGlobalConfiguration.INDEX_DURABLE_IN_NON_TX_MODE.getValueAsBoolean() : durableInNonTxMode.booleanValue();
        this.hashTable = new OLocalHashTable(name, METADATA_FILE_EXTENSION, TREE_FILE_EXTENSION, BUCKET_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, this.hashFunction, durableInNonTx, storage);
    }

    @Override
    public void init() {
    }

    @Override
    public void create(OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        OBinarySerializer<Object> keySerializer = indexDefinition != null ? (indexDefinition instanceof ORuntimeKeyIndexDefinition ? ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer() : (indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.getInstance().getObjectSerializer(indexDefinition.getTypes()[0]))) : new OSimpleKeySerializer();
        this.hashFunction.setValueSerializer(keySerializer);
        this.hashTable.create(keySerializer, (OBinarySerializer)((Object)valueSerializer), indexDefinition != null ? indexDefinition.getTypes() : null, indexDefinition != null && !indexDefinition.isNullValuesIgnored());
    }

    @Override
    public void flush() {
        this.hashTable.flush();
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
        this.hashTable.deleteWithoutLoad(indexName, (OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying());
    }

    @Override
    public void delete() {
        this.hashTable.delete();
    }

    @Override
    public void load(String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.hashTable.load(indexName, indexDefinition != null ? indexDefinition.getTypes() : null, indexDefinition != null && !indexDefinition.isNullValuesIgnored());
        this.hashFunction.setValueSerializer(this.hashTable.getKeySerializer());
    }

    @Override
    public boolean contains(Object key) {
        return this.hashTable.get(key) != null;
    }

    @Override
    public boolean remove(Object key) {
        return this.hashTable.remove(key) != null;
    }

    @Override
    public void clear() {
        this.hashTable.clear();
    }

    @Override
    public void close() {
        this.hashTable.close();
    }

    @Override
    public V get(Object key) {
        return this.hashTable.get(key);
    }

    @Override
    public void put(Object key, V value) {
        this.hashTable.put(key, value);
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        if (transformer == null) {
            return this.hashTable.size();
        }
        OHashIndexBucket.Entry<Object, V> firstEntry = this.hashTable.firstEntry();
        if (firstEntry == null) {
            return 0L;
        }
        OHashIndexBucket.Entry<Object, V>[] entries = this.hashTable.ceilingEntries(firstEntry.key);
        long counter = 0L;
        while (entries.length > 0) {
            for (OHashIndexBucket.Entry<Object, V> entry : entries) {
                counter += (long)transformer.transformFromValue(entry.value).size();
            }
            entries = this.hashTable.higherEntries(entries[entries.length - 1].key);
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("firstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("lastKey");
    }

    @Override
    public OIndexCursor cursor(final OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        return new OIndexAbstractCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, V>[] entries;
            private Iterator<OIdentifiable> currentIterator = new OEmptyIterator<OIdentifiable>();
            private Object currentKey;
            {
                OHashIndexBucket.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? new OHashIndexBucket.Entry[0] : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                if (this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return null;
                    }
                    OHashIndexBucket.Entry bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((OIdentifiable)value).iterator();
                    ++this.nextEntriesIndex;
                    if (this.nextEntriesIndex < this.entries.length) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                this.currentIterator = null;
                return null;
            }

            private Map.Entry<Object, OIdentifiable> nextCursorValue() {
                final OIdentifiable identifiable = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public OIndexCursor descCursor(final OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        return new OIndexAbstractCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, V>[] entries;
            private Iterator<OIdentifiable> currentIterator = new OEmptyIterator<OIdentifiable>();
            private Object currentKey;
            {
                OHashIndexBucket.Entry lastEntry = OHashTableIndexEngine.this.hashTable.lastEntry();
                this.entries = lastEntry == null ? new OHashIndexBucket.Entry[0] : OHashTableIndexEngine.this.hashTable.floorEntries(lastEntry.key);
                if (this.entries.length == 0) {
                    this.currentIterator = null;
                }
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                if (this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    if (this.entries.length == 0) {
                        this.currentIterator = null;
                        return null;
                    }
                    OHashIndexBucket.Entry bucketEntry = this.entries[this.nextEntriesIndex];
                    this.currentKey = bucketEntry.key;
                    Object value = bucketEntry.value;
                    this.currentIterator = valuesTransformer != null ? valuesTransformer.transformFromValue(value).iterator() : Collections.singletonList((OIdentifiable)value).iterator();
                    --this.nextEntriesIndex;
                    if (this.nextEntriesIndex >= 0) continue;
                    this.entries = OHashTableIndexEngine.this.hashTable.lowerEntries(this.entries[0].key);
                    this.nextEntriesIndex = this.entries.length - 1;
                }
                if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                this.currentIterator = null;
                return null;
            }

            private Map.Entry<Object, OIdentifiable> nextCursorValue() {
                final OIdentifiable identifiable = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, V>[] entries;
            {
                OHashIndexBucket.Entry firstEntry = OHashTableIndexEngine.this.hashTable.firstEntry();
                this.entries = firstEntry == null ? new OHashIndexBucket.Entry[0] : OHashTableIndexEngine.this.hashTable.ceilingEntries(firstEntry.key);
            }

            @Override
            public Object next(int prefetchSize) {
                if (this.entries.length == 0) {
                    return null;
                }
                OHashIndexBucket.Entry bucketEntry = this.entries[this.nextEntriesIndex];
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex >= this.entries.length) {
                    this.entries = OHashTableIndexEngine.this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                }
                return bucketEntry.key;
            }
        };
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

