/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.Iterator;
import java.util.Map;

public class OSBTreeIndexEngine<V>
extends OSharedResourceAdaptiveExternal
implements OIndexEngine<V> {
    public static final String DATA_FILE_EXTENSION = ".sbt";
    public static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    private final OSBTree<Object, V> sbTree;

    public OSBTreeIndexEngine(String name, Boolean durableInNonTxMode, OAbstractPaginatedStorage storage, int version) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        boolean durableInNonTx = durableInNonTxMode == null ? OGlobalConfiguration.INDEX_DURABLE_IN_NON_TX_MODE.getValueAsBoolean() : durableInNonTxMode.booleanValue();
        this.sbTree = new OSBTree(name, DATA_FILE_EXTENSION, durableInNonTx, NULL_BUCKET_FILE_EXTENSION, storage);
    }

    @Override
    public void init() {
    }

    @Override
    public void flush() {
        this.acquireSharedLock();
        try {
            this.sbTree.flush();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            OBinarySerializer keySerializer = this.determineKeySerializer(indexDefinition);
            int keySize = this.determineKeySize(indexDefinition);
            this.sbTree.create(keySerializer, (OBinarySerializer)((Object)valueSerializer), indexDefinition != null ? indexDefinition.getTypes() : null, keySize, indexDefinition != null && !indexDefinition.isNullValuesIgnored());
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private int determineKeySize(OIndexDefinition indexDefinition) {
        if (indexDefinition == null || indexDefinition instanceof ORuntimeKeyIndexDefinition) {
            return 1;
        }
        return indexDefinition.getTypes().length;
    }

    private OBinarySerializer determineKeySerializer(OIndexDefinition indexDefinition) {
        OBinarySerializer<Object> keySerializer = indexDefinition != null ? (indexDefinition instanceof ORuntimeKeyIndexDefinition ? ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer() : (indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.getInstance().getObjectSerializer(indexDefinition.getTypes()[0]))) : new OSimpleKeySerializer();
        return keySerializer;
    }

    @Override
    public void delete() {
        this.acquireSharedLock();
        try {
            this.sbTree.delete();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWithoutLoad(String indexName) {
        this.acquireExclusiveLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
            this.sbTree.deleteWithoutLoad(indexName);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
        this.acquireExclusiveLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
            this.sbTree.load(indexName, this.determineKeySerializer(indexDefinition), valueSerializer, indexDefinition != null ? indexDefinition.getTypes() : null, this.determineKeySize(indexDefinition), indexDefinition != null && !indexDefinition.isNullValuesIgnored());
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean contains(Object key) {
        this.acquireSharedLock();
        try {
            boolean bl = this.sbTree.get(key) != null;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean remove(Object key) {
        this.acquireSharedLock();
        try {
            boolean bl = this.sbTree.remove(key) != null;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void clear() {
        this.acquireSharedLock();
        try {
            this.sbTree.clear();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void close() {
        this.acquireSharedLock();
        try {
            this.sbTree.close();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public V get(Object key) {
        this.acquireSharedLock();
        try {
            V v = this.sbTree.get(key);
            return v;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        this.acquireSharedLock();
        try {
            Object firstKey = this.sbTree.firstKey();
            if (firstKey == null) {
                OIndexAbstractCursor oIndexAbstractCursor = new OIndexAbstractCursor(){

                    @Override
                    public Map.Entry<Object, OIdentifiable> nextEntry() {
                        return null;
                    }
                };
                return oIndexAbstractCursor;
            }
            OSBTreeIndexCursor oSBTreeIndexCursor = new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(firstKey, true, true), valuesTransformer);
            return oSBTreeIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        this.acquireSharedLock();
        try {
            Object lastKey = this.sbTree.lastKey();
            if (lastKey == null) {
                OIndexAbstractCursor oIndexAbstractCursor = new OIndexAbstractCursor(){

                    @Override
                    public Map.Entry<Object, OIdentifiable> nextEntry() {
                        return null;
                    }
                };
                return oIndexAbstractCursor;
            }
            OSBTreeIndexCursor oSBTreeIndexCursor = new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(lastKey, true, false), valuesTransformer);
            return oSBTreeIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        this.acquireSharedLock();
        try {
            OIndexKeyCursor oIndexKeyCursor = new OIndexKeyCursor(){
                private final OSBTree.OSBTreeKeyCursor<Object> sbTreeKeyCursor;
                {
                    this.sbTreeKeyCursor = OSBTreeIndexEngine.this.sbTree.keyCursor();
                }

                @Override
                public Object next(int prefetchSize) {
                    return this.sbTreeKeyCursor.next(prefetchSize);
                }
            };
            return oIndexKeyCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void put(Object key, V value) {
        this.acquireSharedLock();
        try {
            this.sbTree.put(key, value);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Object getFirstKey() {
        this.acquireSharedLock();
        try {
            Object object = this.sbTree.firstKey();
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Object getLastKey() {
        this.acquireSharedLock();
        try {
            Object object = this.sbTree.lastKey();
            return object;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireSharedLock();
        try {
            OSBTreeIndexCursor oSBTreeIndexCursor = new OSBTreeIndexCursor(this.sbTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder), transformer);
            return oSBTreeIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireSharedLock();
        try {
            OSBTreeIndexCursor oSBTreeIndexCursor = new OSBTreeIndexCursor(this.sbTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder), transformer);
            return oSBTreeIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireSharedLock();
        try {
            OSBTreeIndexCursor oSBTreeIndexCursor = new OSBTreeIndexCursor(this.sbTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder), transformer);
            return oSBTreeIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        this.acquireSharedLock();
        try {
            if (transformer == null) {
                long l = this.sbTree.size();
                return l;
            }
            Object firstKey = this.sbTree.firstKey();
            Object lastKey = this.sbTree.lastKey();
            if (firstKey != null && lastKey != null) {
                int counter = 0;
                OSBTree.OSBTreeCursor<Object, V> cursor = this.sbTree.iterateEntriesBetween(firstKey, true, lastKey, true, true);
                Map.Entry<Object, V> entry = cursor.next(-1);
                while (entry != null) {
                    counter += transformer.transformFromValue(entry.getValue()).size();
                    entry = cursor.next(-1);
                }
                long l = counter;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private static final class OSBTreeIndexCursor<V>
    extends OIndexAbstractCursor {
        private final OSBTree.OSBTreeCursor<Object, V> treeCursor;
        private final OIndexEngine.ValuesTransformer<V> valuesTransformer;
        private Iterator<OIdentifiable> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
        private Object currentKey = null;

        private OSBTreeIndexCursor(OSBTree.OSBTreeCursor<Object, V> treeCursor, OIndexEngine.ValuesTransformer<V> valuesTransformer) {
            this.treeCursor = treeCursor;
            this.valuesTransformer = valuesTransformer;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.valuesTransformer == null) {
                return this.treeCursor.next(this.getPrefetchSize());
            }
            if (this.currentIterator == null) {
                return null;
            }
            while (!this.currentIterator.hasNext()) {
                Map.Entry<Object, V> entry = this.treeCursor.next(this.getPrefetchSize());
                if (entry == null) {
                    this.currentIterator = null;
                    return null;
                }
                this.currentKey = entry.getKey();
                this.currentIterator = this.valuesTransformer.transformFromValue(entry.getValue()).iterator();
            }
            final OIdentifiable value = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return OSBTreeIndexCursor.this.currentKey;
                }

                @Override
                public OIdentifiable getValue() {
                    return value;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value2) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

