/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OHashIndexBucket<K, V>
extends ODurablePage
implements Iterable<Entry<K, V>> {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int DEPTH_OFFSET = 32;
    private static final int SIZE_OFFSET = 33;
    private static final int HISTORY_OFFSET = 37;
    private static final int NEXT_REMOVED_BUCKET_OFFSET = 549;
    private static final int POSITIONS_ARRAY_OFFSET = 557;
    public static final int MAX_BUCKET_SIZE_BYTES = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;
    private final OType[] keyTypes;
    private final Comparator keyComparator = ODefaultComparator.INSTANCE;

    public OHashIndexBucket(int depth, OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OWALChangesTree changesTree) throws IOException {
        super(cacheEntry, changesTree);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyTypes = keyTypes;
        this.setByteValue(32, (byte)depth);
        this.setIntValue(28, MAX_BUCKET_SIZE_BYTES);
    }

    public OHashIndexBucket(OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OWALChangesTree changesTree) {
        super(cacheEntry, changesTree);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyTypes = keyTypes;
    }

    public Entry<K, V> find(K key, long hashCode) {
        int index = this.binarySearch(key, hashCode);
        if (index < 0) {
            return null;
        }
        return this.getEntry(index);
    }

    private int binarySearch(K key, long hashCode) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            long midHashCode = this.getHashCode(mid);
            if (OHashIndexBucket.lessThanUnsigned(midHashCode, hashCode)) {
                cmp = -1;
            } else if (OHashIndexBucket.greaterThanUnsigned(midHashCode, hashCode)) {
                cmp = 1;
            } else {
                K midVal = this.getKey(mid);
                cmp = this.keyComparator.compare(midVal, key);
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static boolean lessThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
    }

    private static boolean greaterThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE > longTwo + Long.MIN_VALUE;
    }

    public Entry<K, V> getEntry(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        long hashCode = this.getLongValue(entryPosition);
        K key = this.deserializeFromDirectMemory(this.keySerializer, entryPosition += 8);
        entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        V value = this.deserializeFromDirectMemory(this.valueSerializer, entryPosition);
        return new Entry<K, V>(key, value, hashCode);
    }

    public long getHashCode(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        return this.getLongValue(entryPosition);
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(557 + index * 4);
        return this.deserializeFromDirectMemory(this.keySerializer, entryPosition + 8);
    }

    public int getIndex(long hashCode, K key) {
        return this.binarySearch(key, hashCode);
    }

    public int size() {
        return this.getIntValue(33);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator(0);
    }

    public Iterator<Entry<K, V>> iterator(int index) {
        return new EntryIterator(index);
    }

    public int mergedSize(OHashIndexBucket buddyBucket) {
        return 557 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28)) + buddyBucket.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28));
    }

    public int getContentSize() {
        return 557 + this.size() * 4 + (MAX_BUCKET_SIZE_BYTES - this.getIntValue(28));
    }

    public int updateEntry(int index, V value) throws IOException {
        int oldSize;
        int entryPosition = this.getIntValue(557 + index * 4);
        entryPosition += 8;
        entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        int newSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        if (newSize != (oldSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition))) {
            return -1;
        }
        byte[] newSerializedValue = new byte[newSize];
        this.valueSerializer.serializeNativeObject(value, newSerializedValue, 0, new Object[0]);
        byte[] oldSerializedValue = this.getBinaryValue(entryPosition, oldSize);
        if (ODefaultComparator.INSTANCE.compare(oldSerializedValue, newSerializedValue) == 0) {
            return 0;
        }
        this.setBinaryValue(entryPosition, newSerializedValue);
        return 1;
    }

    public Entry<K, V> deleteEntry(int index) throws IOException {
        Entry<K, V> removedEntry = this.getEntry(index);
        int freePointer = this.getIntValue(28);
        int positionOffset = 557 + index * 4;
        int entryPosition = this.getIntValue(positionOffset);
        int keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition + 8);
        int ridSize = this.getObjectSizeInDirectMemory(this.valueSerializer, entryPosition + keySize + 8);
        int entrySize = keySize + ridSize + 8;
        this.moveData(positionOffset + 4, positionOffset, this.size() * 4 - (index + 1) * 4);
        if (entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        int currentPositionOffset = 557;
        int size = this.size();
        for (int i = 0; i < size - 1; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.setIntValue(28, freePointer + entrySize);
        this.setIntValue(33, size - 1);
        return removedEntry;
    }

    public boolean addEntry(long hashCode, K key, V value) throws IOException {
        int size;
        int entreeSize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes) + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        int freePointer = this.getIntValue(28);
        if (freePointer - entreeSize < 557 + ((size = this.size()) + 1) * 4) {
            return false;
        }
        int index = this.binarySearch(key, hashCode);
        if (index >= 0) {
            throw new IllegalArgumentException("Given value is present in bucket.");
        }
        int insertionPoint = -index - 1;
        this.insertEntry(hashCode, key, value, insertionPoint, entreeSize);
        return true;
    }

    private void insertEntry(long hashCode, K key, V value, int insertionPoint, int entreeSize) throws IOException {
        int freePointer = this.getIntValue(28);
        int size = this.size();
        int positionsOffset = insertionPoint * 4 + 557;
        this.moveData(positionsOffset, positionsOffset + 4, this.size() * 4 - insertionPoint * 4);
        int entreePosition = freePointer - entreeSize;
        this.setIntValue(positionsOffset, entreePosition);
        this.serializeEntry(hashCode, key, value, entreePosition);
        this.setIntValue(28, entreePosition);
        this.setIntValue(33, size + 1);
    }

    public void appendEntry(long hashCode, K key, V value) throws IOException {
        int positionsOffset = this.size() * 4 + 557;
        int entreeSize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes) + this.valueSerializer.getObjectSize(value, new Object[0]) + 8;
        int freePointer = this.getIntValue(28);
        int entreePosition = freePointer - entreeSize;
        this.setIntValue(positionsOffset, entreePosition);
        this.serializeEntry(hashCode, key, value, entreePosition);
        this.setIntValue(28, freePointer - entreeSize);
        this.setIntValue(33, this.size() + 1);
    }

    private void serializeEntry(long hashCode, K key, V value, int entryOffset) throws IOException {
        this.setLongValue(entryOffset, hashCode);
        int keySize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes);
        byte[] binaryKey = new byte[keySize];
        this.keySerializer.serializeNativeObject(key, binaryKey, 0, (Object[])this.keyTypes);
        this.setBinaryValue(entryOffset += 8, binaryKey);
        int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
        byte[] binaryValue = new byte[valueSize];
        this.valueSerializer.serializeNativeObject(value, binaryValue, 0, new Object[0]);
        this.setBinaryValue(entryOffset += keySize, binaryValue);
    }

    public int getDepth() {
        return this.getByteValue(32);
    }

    public void setDepth(int depth) {
        this.setByteValue(32, (byte)depth);
    }

    public long getNextRemovedBucketPair() {
        return this.getLongValue(549);
    }

    public void setNextRemovedBucketPair(long nextRemovedBucketPair) throws IOException {
        this.setLongValue(549, nextRemovedBucketPair);
    }

    public long getSplitHistory(int level) {
        return this.getLongValue(37 + 8 * level);
    }

    public void setSplitHistory(int level, long position) throws IOException {
        this.setLongValue(37 + 8 * level, position);
    }

    private final class EntryIterator
    implements Iterator<Entry<K, V>> {
        private int currentIndex;

        private EntryIterator(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < OHashIndexBucket.this.size();
        }

        @Override
        public Entry<K, V> next() {
            if (this.currentIndex >= OHashIndexBucket.this.size()) {
                throw new NoSuchElementException("Iterator was reached last element");
            }
            Entry entry = OHashIndexBucket.this.getEntry(this.currentIndex);
            ++this.currentIndex;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation is not supported");
        }
    }

    public static class Entry<K, V> {
        public final K key;
        public final V value;
        public final long hashCode;

        public Entry(K key, V value, long hashCode) {
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }
    }
}

