/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public class OHashIndexFileLevelMetadataPage
extends ODurablePage {
    private static final int RECORDS_COUNT_OFFSET = 28;
    private static final int KEY_SERIALIZER_ID_OFFSET = 36;
    private static final int VALUE_SERIALIZER_ID_OFFSET = 37;
    private static final int METADATA_ARRAY_OFFSET = 38;
    private static final int ITEM_SIZE = 25;

    public OHashIndexFileLevelMetadataPage(OCacheEntry cacheEntry, OWALChangesTree changesTree, boolean isNewPage) throws IOException {
        super(cacheEntry, changesTree);
        if (isNewPage) {
            for (int i = 0; i < 64; ++i) {
                this.remove(i);
            }
            this.setRecordsCount(0L);
            this.setKeySerializerId((byte)-1);
            this.setValueSerializerId((byte)-1);
        }
    }

    public void setRecordsCount(long recordsCount) throws IOException {
        this.setLongValue(28, recordsCount);
    }

    public long getRecordsCount() throws IOException {
        return this.getLongValue(28);
    }

    public void setKeySerializerId(byte keySerializerId) throws IOException {
        this.setByteValue(36, keySerializerId);
    }

    public byte getKeySerializerId() throws IOException {
        return this.getByteValue(36);
    }

    public void setValueSerializerId(byte valueSerializerId) throws IOException {
        this.setByteValue(37, valueSerializerId);
    }

    public byte getValueSerializerId() throws IOException {
        return this.getByteValue(37);
    }

    public void setFileMetadata(int index, long fileId, long bucketsCount, long tombstoneIndex) throws IOException {
        int offset = 38 + index * 25;
        this.setByteValue(offset, (byte)1);
        this.setLongValue(++offset, fileId);
        this.setLongValue(offset += 8, bucketsCount);
        this.setLongValue(offset += 8, tombstoneIndex);
        offset += 8;
    }

    public void setBucketsCount(int index, long bucketsCount) throws IOException {
        assert (!this.isRemoved(index));
        int offset = 38 + index * 25;
        this.setLongValue(offset += 9, bucketsCount);
    }

    public long getBucketsCount(int index) throws IOException {
        assert (!this.isRemoved(index));
        int offset = 38 + index * 25;
        return this.getLongValue(offset += 9);
    }

    public void setTombstoneIndex(int index, long tombstoneIndex) throws IOException {
        assert (!this.isRemoved(index));
        int offset = 38 + index * 25;
        this.setLongValue(offset += 17, tombstoneIndex);
    }

    public long getTombstoneIndex(int index) {
        assert (!this.isRemoved(index));
        int offset = 38 + index * 25;
        return this.getLongValue(offset += 17);
    }

    public long getFileId(int index) {
        assert (!this.isRemoved(index));
        int offset = 38 + index * 25;
        return this.getLongValue(++offset);
    }

    public boolean isRemoved(int index) {
        int offset = 38 + index * 25;
        return this.getByteValue(offset) == 0;
    }

    public void remove(int index) {
        int offset = 38 + index * 25;
        this.setByteValue(offset, (byte)0);
    }
}

