/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryFirstPage;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryPage;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;

public class OHashTableDirectory
extends ODurableComponent {
    public static final int ITEM_SIZE = 8;
    public static final int LEVEL_SIZE = 256;
    public static final int BINARY_LEVEL_SIZE = 2051;
    private long fileId;
    private final long firstEntryIndex;
    private final boolean durableInNonTxMode;
    private final OAbstractPaginatedStorage storage;
    private final ODiskCache diskCache;

    public OHashTableDirectory(String defaultExtension, String name, boolean durableInNonTxMode, OAbstractPaginatedStorage storage) {
        super(storage, name, defaultExtension);
        this.durableInNonTxMode = durableInNonTxMode;
        this.storage = storage;
        this.firstEntryIndex = 0L;
        this.diskCache = storage.getDiskCache();
    }

    public void create() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            this.fileId = OHashTableDirectory.addFile(atomicOperation, this.getFullName(), this.diskCache);
            this.init();
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during creation of hash table.", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        try {
            OCacheEntry firstEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true, this.diskCache);
            if (firstEntry == null) {
                firstEntry = OHashTableDirectory.addPage(atomicOperation, this.fileId, this.diskCache);
                assert (firstEntry.getPageIndex() == 0L);
            }
            OHashTableDirectory.pinPage(atomicOperation, firstEntry, this.diskCache);
            firstEntry.acquireExclusiveLock();
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, OHashTableDirectory.getChangesTree(atomicOperation, firstEntry), firstEntry);
                firstPage.setTreeSize(0);
                firstPage.setTombstone(-1);
            }
            finally {
                firstEntry.releaseExclusiveLock();
                OHashTableDirectory.releasePage(atomicOperation, firstEntry, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.fileId = OHashTableDirectory.openFile(atomicOperation, this.getFullName(), this.diskCache);
            int filledUpTo = (int)OHashTableDirectory.getFilledUpTo(atomicOperation, this.diskCache, this.fileId);
            for (int i = 0; i < filledUpTo; ++i) {
                OCacheEntry entry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, i, true, this.diskCache);
                assert (entry != null);
                OHashTableDirectory.pinPage(atomicOperation, entry, this.diskCache);
                OHashTableDirectory.releasePage(atomicOperation, entry, this.diskCache);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            OHashTableDirectory.deleteFile(atomicOperation, this.fileId, this.diskCache);
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during hash table deletion", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void deleteWithoutOpen() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            if (OHashTableDirectory.isFileExists(atomicOperation, this.getFullName(), this.diskCache)) {
                this.fileId = OHashTableDirectory.openFile(atomicOperation, this.getFullName(), this.diskCache);
                OHashTableDirectory.deleteFile(atomicOperation, this.fileId, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode) throws IOException {
        int nodeIndex;
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            block21: {
                OCacheEntry firstEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true, this.diskCache);
                firstEntry.acquireExclusiveLock();
                try {
                    ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, OHashTableDirectory.getChangesTree(atomicOperation, firstEntry), firstEntry);
                    int tombstone = firstPage.getTombstone();
                    if (tombstone >= 0) {
                        nodeIndex = tombstone;
                    } else {
                        nodeIndex = firstPage.getTreeSize();
                        firstPage.setTreeSize(nodeIndex + 1);
                    }
                    if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                        int localNodeIndex = nodeIndex;
                        firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                        firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                        firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                        if (tombstone >= 0) {
                            firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                        }
                        for (int i = 0; i < newNode.length; ++i) {
                            firstPage.setPointer(localNodeIndex, i, newNode[i]);
                        }
                        break block21;
                    }
                    int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                    int localLevel = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                    OCacheEntry cacheEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, pageIndex, true, this.diskCache);
                    while (cacheEntry == null || cacheEntry.getPageIndex() < (long)pageIndex) {
                        if (cacheEntry != null) {
                            OHashTableDirectory.releasePage(atomicOperation, cacheEntry, this.diskCache);
                        }
                        cacheEntry = OHashTableDirectory.addPage(atomicOperation, this.fileId, this.diskCache);
                    }
                    cacheEntry.acquireExclusiveLock();
                    try {
                        ODirectoryPage page = new ODirectoryPage(cacheEntry, OHashTableDirectory.getChangesTree(atomicOperation, cacheEntry), cacheEntry);
                        page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                        page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                        page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                        if (tombstone >= 0) {
                            firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                        }
                        for (int i = 0; i < newNode.length; ++i) {
                            page.setPointer(localLevel, i, newNode[i]);
                        }
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        OHashTableDirectory.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    }
                }
                finally {
                    firstEntry.releaseExclusiveLock();
                    OHashTableDirectory.releasePage(atomicOperation, firstEntry, this.diskCache);
                }
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
        return nodeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(int nodeIndex) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            block13: {
                OCacheEntry firstEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true, this.diskCache);
                firstEntry.acquireExclusiveLock();
                try {
                    ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, OHashTableDirectory.getChangesTree(atomicOperation, firstEntry), firstEntry);
                    if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                        firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                        firstPage.setTombstone(nodeIndex);
                        break block13;
                    }
                    int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                    int localNodeIndex = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                    OCacheEntry cacheEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, pageIndex, true, this.diskCache);
                    cacheEntry.acquireExclusiveLock();
                    try {
                        ODirectoryPage page = new ODirectoryPage(cacheEntry, OHashTableDirectory.getChangesTree(atomicOperation, cacheEntry), cacheEntry);
                        page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                        firstPage.setTombstone(nodeIndex);
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        OHashTableDirectory.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    }
                }
                finally {
                    firstEntry.releaseExclusiveLock();
                    OHashTableDirectory.releasePage(atomicOperation, firstEntry, this.diskCache);
                }
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getMaxLeftChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
            try {
                page.setMaxLeftChildDepth(this.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
            }
            finally {
                this.releasePage(page, true, atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getMaxRightChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
            try {
                page.setMaxRightChildDepth(this.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
            }
            finally {
                this.releasePage(page, true, atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getNodeLocalDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeLocalDepth(int nodeIndex, byte localNodeDepth) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
            try {
                page.setNodeLocalDepth(this.getLocalNodeIndex(nodeIndex), localNodeDepth);
            }
            finally {
                this.releasePage(page, true, atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNode(int nodeIndex) throws IOException {
        long[] node = new long[256];
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
                try {
                    int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                    for (int i = 0; i < 256; ++i) {
                        node[i] = page.getPointer(localNodeIndex, i);
                    }
                }
                finally {
                    this.releasePage(page, false, atomicOperation);
                }
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNode(int nodeIndex, long[] node) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
            try {
                int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                for (int i = 0; i < 256; ++i) {
                    page.setPointer(localNodeIndex, i, node[i]);
                }
            }
            finally {
                this.releasePage(page, true, atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public long getNodePointer(int nodeIndex, int index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePointer(int nodeIndex, int index, long pointer) throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
            try {
                page.setPointer(this.getLocalNodeIndex(nodeIndex), index, pointer);
            }
            finally {
                this.releasePage(page, true, atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void clear() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            OHashTableDirectory.truncateFile(atomicOperation, this.fileId, this.diskCache);
            this.init();
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Exception e) {
            this.endAtomicOperation(true);
            throw new OStorageException("Error during removing of hash table directory content.", e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void flush() throws IOException {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.diskCache.flushFile(this.fileId);
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    private ODirectoryPage loadPage(int nodeIndex, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            OCacheEntry cacheEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true, this.diskCache);
            if (exclusiveLock) {
                cacheEntry.acquireExclusiveLock();
            }
            return new ODirectoryFirstPage(cacheEntry, OHashTableDirectory.getChangesTree(atomicOperation, cacheEntry), cacheEntry);
        }
        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
        OCacheEntry cacheEntry = OHashTableDirectory.loadPage(atomicOperation, this.fileId, pageIndex, true, this.diskCache);
        if (exclusiveLock) {
            cacheEntry.acquireExclusiveLock();
        }
        return new ODirectoryPage(cacheEntry, OHashTableDirectory.getChangesTree(atomicOperation, cacheEntry), cacheEntry);
    }

    private void releasePage(ODirectoryPage page, boolean exclusiveLock, OAtomicOperation atomicOperation) {
        OCacheEntry cacheEntry = page.getEntry();
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        if (exclusiveLock) {
            cachePointer.releaseExclusiveLock();
        }
        OHashTableDirectory.releasePage(atomicOperation, cacheEntry, this.diskCache);
    }

    private int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, !this.durableInNonTxMode);
    }
}

