/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ConcurrentLRUList;
import com.orientechnologies.orient.core.index.hashindex.local.cache.LRUList;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OWOWCache;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class OReadWriteDiskCache
implements ODiskCache {
    public static final int MIN_CACHE_SIZE = 256;
    private static final int MAX_CACHE_OVERFLOW = Runtime.getRuntime().availableProcessors() * 8;
    private volatile int maxSize;
    private volatile int K_IN;
    private volatile int K_OUT;
    private final LRUList am;
    private final LRUList a1out;
    private final LRUList a1in;
    private final OWOWCache writeCache;
    private final int pageSize;
    private final ConcurrentMap<Long, Set<Long>> filePages;
    private final OReadersWriterSpinLock cacheLock = new OReadersWriterSpinLock();
    private final ONewLockManager fileLockManager = new ONewLockManager(true);
    private final ONewLockManager<PageKey> pageLockManager = new ONewLockManager();
    private final NavigableMap<PinnedPage, OCacheEntry> pinnedPages = new ConcurrentSkipListMap<PinnedPage, OCacheEntry>();
    private final String storageName;
    private final AtomicBoolean coldPagesRemovalInProgress = new AtomicBoolean();
    private static String METRIC_HITS;
    private static String METRIC_HITS_METADATA;
    private static String METRIC_MISSED;
    private static String METRIC_MISSED_METADATA;

    public OReadWriteDiskCache(long readCacheMaxMemory, long writeCacheMaxMemory, int pageSize, long writeGroupTTL, int pageFlushInterval, OLocalPaginatedStorage storageLocal, OWriteAheadLog writeAheadLog, boolean syncOnPageFlush, boolean checkMinSize) {
        this(null, readCacheMaxMemory, writeCacheMaxMemory, pageSize, writeGroupTTL, pageFlushInterval, storageLocal, writeAheadLog, syncOnPageFlush, checkMinSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OReadWriteDiskCache(String storageName, long readCacheMaxMemory, long writeCacheMaxMemory, int pageSize, long writeGroupTTL, int pageFlushInterval, OLocalPaginatedStorage storageLocal, OWriteAheadLog writeAheadLog, boolean syncOnPageFlush, boolean checkMinSize) {
        this.cacheLock.acquireWriteLock();
        try {
            this.storageName = storageName;
            this.pageSize = pageSize;
            this.initProfiler();
            this.filePages = new ConcurrentHashMap<Long, Set<Long>>();
            this.maxSize = this.normalizeMemory(readCacheMaxMemory, pageSize);
            if (checkMinSize && this.maxSize < 256) {
                this.maxSize = 256;
            }
            this.writeCache = new OWOWCache(syncOnPageFlush, pageSize, writeGroupTTL, writeAheadLog, pageFlushInterval, this.normalizeMemory(writeCacheMaxMemory, pageSize), storageLocal, checkMinSize);
            this.K_IN = this.maxSize >> 2;
            this.K_OUT = this.maxSize >> 1;
            this.am = new ConcurrentLRUList();
            this.a1out = new ConcurrentLRUList();
            this.a1in = new ConcurrentLRUList();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    LRUList getAm() {
        return this.am;
    }

    LRUList getA1out() {
        return this.a1out;
    }

    LRUList getA1in() {
        return this.a1in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addFile(String fileName) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long fileId = this.writeCache.addFile(fileName);
            this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long openFile(String fileName) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long fileId = this.writeCache.isOpen(fileName);
            if (fileId >= 0L) {
                long l = fileId;
                return l;
            }
            fileId = this.writeCache.openFile(fileName);
            this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            long l = fileId;
            return l;
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    @Override
    public long bookFileId(String fileName) throws IOException {
        return this.writeCache.bookFileId(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(long fileId) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                if (this.writeCache.isOpen(fileId)) {
                    return;
                }
                this.writeCache.openFile(fileId);
                this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(String fileName, long fileId) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            long existingFileId = this.writeCache.isOpen(fileName);
            if (fileId == existingFileId) {
                return;
            }
            if (existingFileId >= 0L) {
                throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            this.writeCache.openFile(fileName, fileId);
            this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String fileName, long fileId) throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            this.writeCache.addFile(fileName, fileId);
            this.filePages.put(fileId, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    @Override
    public boolean exists(String fileName) {
        return this.writeCache.exists(fileName);
    }

    @Override
    public boolean exists(long fileId) {
        return this.writeCache.exists(fileId);
    }

    @Override
    public String fileNameById(long fileId) {
        return this.writeCache.fileNameById(fileId);
    }

    @Override
    public void lock() throws IOException {
        this.writeCache.lock();
    }

    @Override
    public void unlock() throws IOException {
        this.writeCache.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinPage(OCacheEntry cacheEntry) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.fileId);
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.fileId, cacheEntry.pageIndex));
                try {
                    this.remove(cacheEntry.fileId, cacheEntry.pageIndex);
                    this.pinnedPages.put(new PinnedPage(cacheEntry.fileId, cacheEntry.pageIndex), cacheEntry);
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    @Override
    public OCacheEntry load(long fileId, long pageIndex, boolean checkPinnedPages) throws IOException {
        UpdateCacheResult cacheResult = this.doLoad(fileId, pageIndex, checkPinnedPages, false);
        if (cacheResult == null) {
            return null;
        }
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded();
            }
        }
        catch (RuntimeException e) {
            assert (!((UpdateCacheResult)cacheResult).cacheEntry.isDirty);
            this.release(cacheResult.cacheEntry);
            throw e;
        }
        return cacheResult.cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateCacheResult doLoad(long fileId, long pageIndex, boolean checkPinnedPages, boolean addNewPages) throws IOException {
        boolean removeColdPages = false;
        OCacheEntry cacheEntry = null;
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(fileId);
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(fileId, pageIndex));
                try {
                    if (checkPinnedPages) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry == null) {
                        UpdateCacheResult cacheResult = this.updateCache(fileId, pageIndex, addNewPages);
                        if (cacheResult == null) {
                            UpdateCacheResult updateCacheResult = null;
                            return updateCacheResult;
                        }
                        cacheEntry = cacheResult.cacheEntry;
                        removeColdPages = cacheResult.removeColdPages;
                    }
                    ++cacheEntry.usagesCount;
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        return new UpdateCacheResult(removeColdPages, cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry allocateNewPage(long fileId) throws IOException {
        UpdateCacheResult cacheResult;
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                long filledUpTo = this.getFilledUpTo(fileId);
                cacheResult = this.doLoad(fileId, filledUpTo, false, true);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        try {
            if (cacheResult.removeColdPages) {
                this.removeColdestPagesIfNeeded();
            }
        }
        catch (RuntimeException e) {
            assert (!((UpdateCacheResult)cacheResult).cacheEntry.isDirty);
            this.release(cacheResult.cacheEntry);
            throw e;
        }
        return cacheResult.cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(OCacheEntry cacheEntry) {
        Future flushFuture = null;
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireSharedLock(cacheEntry.fileId);
            try {
                Lock pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(cacheEntry.fileId, cacheEntry.pageIndex));
                try {
                    --cacheEntry.usagesCount;
                    assert (cacheEntry.usagesCount >= 0);
                    if (cacheEntry.usagesCount == 0 && cacheEntry.isDirty) {
                        flushFuture = this.writeCache.store(cacheEntry.fileId, cacheEntry.pageIndex, cacheEntry.dataPointer);
                        cacheEntry.isDirty = false;
                    }
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
        if (flushFuture != null) {
            try {
                flushFuture.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new OException("File flush was interrupted", e);
            }
            catch (Exception e) {
                throw new OException("File flush was abnormally terminated", e);
            }
        }
    }

    @Override
    public long getFilledUpTo(long fileId) throws IOException {
        return this.writeCache.getFilledUpTo(fileId);
    }

    @Override
    public void flushFile(long fileId) throws IOException {
        this.writeCache.flush(fileId);
    }

    @Override
    public void closeFile(long fileId) throws IOException {
        this.closeFile(fileId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(long fileId, boolean flush) throws IOException {
        if (!this.isOpen(fileId)) {
            return;
        }
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.writeCache.close(fileId, flush);
                Set pageIndexes = (Set)this.filePages.get(fileId);
                if (pageIndexes == null) {
                    return;
                }
                for (Long pageIndex : pageIndexes) {
                    OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
                    if (cacheEntry == null) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry != null) {
                        if (cacheEntry.dataPointer == null) continue;
                        if (cacheEntry.usagesCount == 0) {
                            cacheEntry = this.remove(fileId, pageIndex);
                            if (cacheEntry == null) {
                                cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                            }
                        } else {
                            throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " can not be freed because it is used.");
                        }
                        cacheEntry.dataPointer.decrementReferrer();
                        cacheEntry.dataPointer = null;
                        continue;
                    }
                    throw new OStorageException("Page with index " + pageIndex + " for file with id " + fileId + " was not found in cache");
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                if (this.isOpen(fileId)) {
                    this.truncateFile(fileId);
                }
                this.writeCache.deleteFile(fileId);
                this.filePages.remove(fileId);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.writeCache.truncateFile(fileId);
                Set pageEntries = (Set)this.filePages.get(fileId);
                for (Long pageIndex : pageEntries) {
                    OCacheEntry cacheEntry = this.get(fileId, pageIndex, true);
                    if (cacheEntry == null) {
                        cacheEntry = (OCacheEntry)this.pinnedPages.get(new PinnedPage(fileId, pageIndex));
                    }
                    if (cacheEntry != null) {
                        if (cacheEntry.usagesCount != 0) continue;
                        cacheEntry = this.remove(fileId, pageIndex);
                        if (cacheEntry == null) {
                            cacheEntry = (OCacheEntry)this.pinnedPages.remove(new PinnedPage(fileId, pageIndex));
                        }
                        if (cacheEntry.dataPointer == null) continue;
                        cacheEntry.dataPointer.decrementReferrer();
                        cacheEntry.dataPointer = null;
                        continue;
                    }
                    throw new OStorageException("Page with index " + pageIndex + " was  not found in cache for file with id " + fileId);
                }
                pageEntries.clear();
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        this.cacheLock.acquireReadLock();
        try {
            Lock fileLock = this.fileLockManager.acquireExclusiveLock(fileId);
            try {
                this.writeCache.renameFile(fileId, oldFileName, newFileName);
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
        finally {
            this.cacheLock.releaseReadLock();
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        this.writeCache.flush();
    }

    public void clear() throws IOException {
        this.writeCache.flush();
        this.cacheLock.acquireWriteLock();
        try {
            this.clearCacheContent();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    private void clearCacheContent() {
        for (OCacheEntry cacheEntry : this.am) {
            if (cacheEntry.usagesCount == 0) {
                cacheEntry.dataPointer.decrementReferrer();
                cacheEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.pageIndex + " for file id " + cacheEntry.fileId + " is used and can not be removed");
        }
        for (OCacheEntry cacheEntry : this.a1in) {
            if (cacheEntry.usagesCount == 0) {
                cacheEntry.dataPointer.decrementReferrer();
                cacheEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + cacheEntry.pageIndex + " for file id " + cacheEntry.fileId + " is used and can not be removed");
        }
        this.a1out.clear();
        this.am.clear();
        this.a1in.clear();
        for (Set pages : this.filePages.values()) {
            pages.clear();
        }
        this.clearPinnedPages();
    }

    private void clearPinnedPages() {
        for (OCacheEntry pinnedEntry : this.pinnedPages.values()) {
            if (pinnedEntry.usagesCount == 0) {
                pinnedEntry.dataPointer.decrementReferrer();
                pinnedEntry.dataPointer = null;
                continue;
            }
            throw new OStorageException("Page with index " + pinnedEntry.pageIndex + " for file with id " + pinnedEntry.fileId + "can not be freed because it is used.");
        }
        this.pinnedPages.clear();
    }

    @Override
    public void close() throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            this.clear();
            this.writeCache.close();
            this.deinitProfiler();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    @Override
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        return this.writeCache.wasSoftlyClosed(fileId);
    }

    @Override
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
        this.writeCache.setSoftlyClosed(fileId, softlyClosed);
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.writeCache.setSoftlyClosed(softlyClosed);
    }

    @Override
    public boolean isOpen(long fileId) {
        return this.writeCache.isOpen(fileId);
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.writeCache.addLowDiskSpaceListener(listener);
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.writeCache.removeLowDiskSpaceListener(listener);
    }

    private UpdateCacheResult updateCache(long fileId, long pageIndex, boolean addNewPages) throws IOException {
        OProfilerMBean profiler = this.storageName != null ? Orient.instance().getProfiler() : null;
        long startTime = this.storageName != null ? System.currentTimeMillis() : 0L;
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            this.am.putToMRU(cacheEntry);
            if (profiler != null && profiler.isRecording()) {
                profiler.stopChrono(METRIC_HITS, "Requested item was found in Disk Cache", startTime, METRIC_HITS_METADATA);
            }
            return new UpdateCacheResult(false, cacheEntry);
        }
        if (profiler != null && profiler.isRecording()) {
            profiler.stopChrono(METRIC_MISSED, "Requested item was not found in Disk Cache", startTime, METRIC_MISSED_METADATA);
        }
        if ((cacheEntry = this.a1out.remove(fileId, pageIndex)) != null) {
            OCachePointer dataPointer = this.writeCache.load(fileId, pageIndex, false);
            assert (dataPointer != null);
            assert (cacheEntry.dataPointer == null);
            assert (!cacheEntry.isDirty);
            cacheEntry.dataPointer = dataPointer;
            this.am.putToMRU(cacheEntry);
            return new UpdateCacheResult(true, cacheEntry);
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        if (cacheEntry != null) {
            return new UpdateCacheResult(false, cacheEntry);
        }
        OCachePointer dataPointer = this.writeCache.load(fileId, pageIndex, addNewPages);
        if (dataPointer == null) {
            return null;
        }
        cacheEntry = new OCacheEntry(fileId, pageIndex, dataPointer, false);
        this.a1in.putToMRU(cacheEntry);
        Set pages = (Set)this.filePages.get(fileId);
        if (pages == null) {
            pages = Collections.newSetFromMap(new ConcurrentHashMap());
            this.filePages.put(fileId, pages);
        }
        pages.add(pageIndex);
        return new UpdateCacheResult(true, cacheEntry);
    }

    private void removeColdestPagesIfNeeded() throws IOException {
        boolean exclusiveCacheLock;
        if (!this.coldPagesRemovalInProgress.compareAndSet(false, true)) {
            return;
        }
        boolean bl = exclusiveCacheLock = this.am.size() + this.a1in.size() - this.maxSize > MAX_CACHE_OVERFLOW;
        if (exclusiveCacheLock) {
            this.cacheLock.acquireWriteLock();
        } else {
            this.cacheLock.acquireReadLock();
        }
        try {
            if (exclusiveCacheLock) {
                this.removeColdPagesWithCacheLock();
            } else {
                this.removeColdPagesWithoutCacheLock();
            }
        }
        finally {
            if (exclusiveCacheLock) {
                this.cacheLock.releaseWriteLock();
            } else {
                this.cacheLock.releaseReadLock();
            }
            this.coldPagesRemovalInProgress.set(false);
        }
    }

    private void removeColdPagesWithCacheLock() {
        while (this.am.size() + this.a1in.size() > this.maxSize) {
            if (this.a1in.size() > this.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.removeLRU();
                if (removedFromAInEntry == null) {
                    this.increaseCacheSize();
                } else {
                    assert (removedFromAInEntry.usagesCount == 0);
                    assert (!removedFromAInEntry.isDirty);
                    removedFromAInEntry.dataPointer.decrementReferrer();
                    removedFromAInEntry.dataPointer = null;
                    this.a1out.putToMRU(removedFromAInEntry);
                }
                while (this.a1out.size() > this.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.removeLRU();
                    assert (removedEntry.usagesCount == 0);
                    assert (removedEntry.dataPointer == null);
                    assert (!removedEntry.isDirty);
                    Set pageEntries = (Set)this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.removeLRU();
            if (removedEntry == null) {
                this.increaseCacheSize();
                continue;
            }
            assert (removedEntry.usagesCount == 0);
            assert (!removedEntry.isDirty);
            removedEntry.dataPointer.decrementReferrer();
            removedEntry.dataPointer = null;
            Set pageEntries = (Set)this.filePages.get(removedEntry.fileId);
            pageEntries.remove(removedEntry.pageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColdPagesWithoutCacheLock() {
        int iterationsCounter = 0;
        while (this.am.size() + this.a1in.size() > this.maxSize && iterationsCounter < 1000) {
            Lock pageLock;
            Lock fileLock;
            ++iterationsCounter;
            if (this.a1in.size() > this.K_IN) {
                OCacheEntry removedFromAInEntry = this.a1in.getLRU();
                if (removedFromAInEntry == null) {
                    this.increaseCacheSize();
                } else {
                    fileLock = this.fileLockManager.acquireSharedLock(removedFromAInEntry.fileId);
                    try {
                        pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedFromAInEntry.fileId, removedFromAInEntry.pageIndex));
                        try {
                            if (this.a1in.get(removedFromAInEntry.fileId, removedFromAInEntry.pageIndex) == null || removedFromAInEntry.usagesCount > 0) continue;
                            assert (!removedFromAInEntry.isDirty);
                            this.a1in.remove(removedFromAInEntry.fileId, removedFromAInEntry.pageIndex);
                            removedFromAInEntry.dataPointer.decrementReferrer();
                            removedFromAInEntry.dataPointer = null;
                            this.a1out.putToMRU(removedFromAInEntry);
                        }
                        finally {
                            this.pageLockManager.releaseLock(pageLock);
                            continue;
                        }
                    }
                    finally {
                        this.fileLockManager.releaseLock(fileLock);
                        continue;
                    }
                }
                while (this.a1out.size() > this.K_OUT) {
                    OCacheEntry removedEntry = this.a1out.getLRU();
                    fileLock = this.fileLockManager.acquireSharedLock(removedEntry.fileId);
                    try {
                        pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedEntry.fileId, removedEntry.pageIndex));
                        try {
                            if (this.a1out.get(removedEntry.fileId, removedEntry.pageIndex) == null) continue;
                            assert (removedEntry.usagesCount == 0);
                            assert (removedEntry.dataPointer == null);
                            assert (!removedEntry.isDirty);
                            this.a1out.remove(removedEntry.fileId, removedEntry.pageIndex);
                            Set pageEntries = (Set)this.filePages.get(removedEntry.fileId);
                            pageEntries.remove(removedEntry.pageIndex);
                        }
                        finally {
                            this.pageLockManager.releaseLock(pageLock);
                        }
                    }
                    finally {
                        this.fileLockManager.releaseLock(fileLock);
                    }
                }
                continue;
            }
            OCacheEntry removedEntry = this.am.getLRU();
            if (removedEntry == null) {
                this.increaseCacheSize();
                continue;
            }
            fileLock = this.fileLockManager.acquireSharedLock(removedEntry.fileId);
            try {
                pageLock = this.pageLockManager.acquireExclusiveLock(new PageKey(removedEntry.fileId, removedEntry.pageIndex));
                try {
                    if (this.am.get(removedEntry.fileId, removedEntry.pageIndex) == null || removedEntry.usagesCount > 0) continue;
                    assert (!removedEntry.isDirty);
                    this.am.remove(removedEntry.fileId, removedEntry.pageIndex);
                    removedEntry.dataPointer.decrementReferrer();
                    removedEntry.dataPointer = null;
                    Set pageEntries = (Set)this.filePages.get(removedEntry.fileId);
                    pageEntries.remove(removedEntry.pageIndex);
                }
                finally {
                    this.pageLockManager.releaseLock(pageLock);
                }
            }
            finally {
                this.fileLockManager.releaseLock(fileLock);
            }
        }
    }

    private void increaseCacheSize() {
        String message = "All records in aIn queue in 2q cache are used!";
        OLogManager.instance().warn((Object)this, message, new Object[0]);
        if (!OGlobalConfiguration.SERVER_CACHE_INCREASE_ON_DEMAND.getValueAsBoolean()) {
            throw new OAllCacheEntriesAreUsedException(message);
        }
        OLogManager.instance().warn((Object)this, "Cache size will be increased.", new Object[0]);
        this.maxSize = (int)Math.ceil((float)this.maxSize * (1.0f + OGlobalConfiguration.SERVER_CACHE_INCREASE_STEP.getValueAsFloat()));
        this.K_IN = this.maxSize >> 2;
        this.K_OUT = this.maxSize >> 1;
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        return this.writeCache.checkStoredPages(commandOutputListener);
    }

    @Override
    public void delete() throws IOException {
        this.cacheLock.acquireWriteLock();
        try {
            this.writeCache.delete();
            this.clearCacheContent();
            this.deinitProfiler();
        }
        finally {
            this.cacheLock.releaseWriteLock();
        }
    }

    int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getUsedMemory() {
        return ((long)(this.am.size() + this.a1in.size()) + this.writeCache.getAllocatedPages()) * (long)(16 + this.pageSize);
    }

    @Override
    public void startFuzzyCheckpoints() {
        this.writeCache.startFuzzyCheckpoints();
    }

    @Override
    public boolean checkLowDiskSpace() {
        return this.writeCache.checkLowDiskSpace();
    }

    @Override
    public void makeFuzzyCheckpoint() {
        this.writeCache.makeFuzzyCheckpoint();
    }

    private OCacheEntry get(long fileId, long pageIndex, boolean useOutQueue) {
        OCacheEntry cacheEntry = this.am.get(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        if (useOutQueue && (cacheEntry = this.a1out.get(fileId, pageIndex)) != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.get(fileId, pageIndex);
        return cacheEntry;
    }

    private OCacheEntry remove(long fileId, long pageIndex) {
        OCacheEntry cacheEntry = this.am.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            if (cacheEntry.usagesCount > 1) {
                throw new IllegalStateException("Record cannot be removed because it is used!");
            }
            return cacheEntry;
        }
        cacheEntry = this.a1out.remove(fileId, pageIndex);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this.a1in.remove(fileId, pageIndex);
        if (cacheEntry != null && cacheEntry.usagesCount > 1) {
            throw new IllegalStateException("Record cannot be removed because it is used!");
        }
        return cacheEntry;
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)(pageSize + 16);
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    private void initProfiler() {
        OProfilerMBean profiler = Orient.instance().getProfiler();
        METRIC_HITS = profiler.getDatabaseMetric(this.storageName, "diskCache.hits");
        METRIC_HITS_METADATA = profiler.getDatabaseMetric(null, "diskCache.hits");
        METRIC_MISSED = profiler.getDatabaseMetric(this.storageName, "diskCache.missed");
        METRIC_MISSED_METADATA = profiler.getDatabaseMetric(null, "diskCache.missed");
        profiler.registerHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.totalMemory"), "Total memory used by Disk Cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return (OReadWriteDiskCache.this.am.size() + OReadWriteDiskCache.this.a1in.size()) * OReadWriteDiskCache.this.pageSize;
            }
        }, profiler.getDatabaseMetric(null, "diskCache.totalMemory"));
        profiler.registerHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.maxMemory"), "Maximum memory used by Disk Cache", OProfilerMBean.METRIC_TYPE.SIZE, new OAbstractProfiler.OProfilerHookValue(){

            @Override
            public Object getValue() {
                return OReadWriteDiskCache.this.maxSize * OReadWriteDiskCache.this.pageSize;
            }
        }, profiler.getDatabaseMetric(null, "diskCache.maxMemory"));
    }

    private void deinitProfiler() {
        OProfilerMBean profiler = Orient.instance().getProfiler();
        profiler.unregisterHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.totalMemory"));
        profiler.unregisterHookValue(profiler.getDatabaseMetric(this.storageName, "diskCache.maxMemory"));
    }

    private static final class UpdateCacheResult {
        private final boolean removeColdPages;
        private final OCacheEntry cacheEntry;

        private UpdateCacheResult(boolean removeColdPages, OCacheEntry cacheEntry) {
            this.removeColdPages = removeColdPages;
            this.cacheEntry = cacheEntry;
        }
    }

    private static final class PageKey {
        private final long fileId;
        private final long pageIndex;

        private PageKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }
    }

    private class PinnedPage
    implements Comparable<PinnedPage> {
        private final long fileId;
        private final long pageIndex;

        private PinnedPage(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PinnedPage that = (PinnedPage)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public String toString() {
            return "PinnedPage{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        @Override
        public int compareTo(PinnedPage other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.pageIndex > other.pageIndex) {
                return 1;
            }
            if (this.pageIndex < other.pageIndex) {
                return -1;
            }
            return 0;
        }
    }
}

