/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.sbtree.local.ONullBucket;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeBucket;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValuePage;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OSBTree<K, V>
extends ODurableComponent {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final long ROOT_INDEX = 0L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private final boolean durableInNonTxMode;
    private ODiskCache diskCache;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTree(String name, String dataFileExtension, boolean durableInNonTxMode, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
            this.durableInNonTxMode = durableInNonTxMode;
            this.diskCache = storage.getDiskCache();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree creation.", e);
        }
        this.acquireExclusiveLock();
        try {
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.diskCache = this.storage.getDiskCache();
            this.keySerializer = keySerializer;
            if (keySerializer == null) {
                System.out.println("sdf");
            }
            this.valueSerializer = valueSerializer;
            this.nullPointerSupport = nullPointerSupport;
            this.fileId = OSBTree.addFile(atomicOperation, this.getFullName(), this.diskCache);
            if (nullPointerSupport) {
                this.nullBucketFileId = OSBTree.addFile(atomicOperation, this.getName() + this.nullFileExtension, this.diskCache);
            }
            OCacheEntry rootCacheEntry = OSBTree.addPage(atomicOperation, this.fileId, this.diskCache);
            rootCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, true, keySerializer, keyTypes, valueSerializer, OSBTree.getChangesTree(atomicOperation, rootCacheEntry));
                rootBucket.setTreeSize(0L);
            }
            finally {
                rootCacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            try {
                this.endAtomicOperation(true);
            }
            catch (IOException e1) {
                OLogManager.instance().error((Object)this, "Error during sbtree data rollback", (Throwable)e1, new Object[0]);
            }
            throw new OSBTreeException("Error creation of sbtree with name" + this.getName(), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree entrie put.", e);
        }
        this.acquireExclusiveLock();
        try {
            this.checkNullSupport(key);
            if (key != null) {
                int sizeDiff;
                int insertionIndex;
                int keySize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes);
                int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                if (keySize > MAX_KEY_SIZE) {
                    throw new OSBTreeException("Key size is more than allowed, operation was canceled. Current key size " + keySize + ", allowed  " + MAX_KEY_SIZE);
                }
                boolean createLinkToTheValue = valueSize > MAX_EMBEDDED_VALUE_SIZE;
                key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                long valueLink = -1L;
                if (createLinkToTheValue) {
                    valueLink = this.createLinkToTheValue(value, atomicOperation);
                }
                OSBTreeValue<Object> treeValue = new OSBTreeValue<Object>(createLinkToTheValue, valueLink, (createLinkToTheValue ? null : (Object)value));
                BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                OCacheEntry keyBucketCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, this.diskCache);
                keyBucketCacheEntry.acquireExclusiveLock();
                OSBTreeBucket<K, Object> keyBucket = new OSBTreeBucket<K, Object>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, keyBucketCacheEntry));
                if (bucketSearchResult.itemIndex >= 0) {
                    int updateResult = keyBucket.updateValue(bucketSearchResult.itemIndex, treeValue);
                    if (updateResult >= 0) {
                        keyBucketCacheEntry.releaseExclusiveLock();
                        OSBTree.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
                        this.endAtomicOperation(false);
                        return;
                    }
                    assert (updateResult == -1);
                    long removedLinkedValue = keyBucket.remove(bucketSearchResult.itemIndex);
                    if (removedLinkedValue >= 0L) {
                        this.removeLinkedValue(removedLinkedValue, atomicOperation);
                    }
                    insertionIndex = bucketSearchResult.itemIndex;
                    sizeDiff = 0;
                } else {
                    insertionIndex = -bucketSearchResult.itemIndex - 1;
                    sizeDiff = 1;
                }
                while (!keyBucket.addEntry(insertionIndex, new OSBTreeBucket.SBTreeEntry<K, Object>(-1L, -1L, key, treeValue), true)) {
                    keyBucketCacheEntry.releaseExclusiveLock();
                    OSBTree.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
                    bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key, atomicOperation);
                    insertionIndex = bucketSearchResult.itemIndex;
                    keyBucketCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, this.diskCache);
                    keyBucketCacheEntry.acquireExclusiveLock();
                    keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, keyBucketCacheEntry));
                }
                keyBucketCacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
                if (sizeDiff != 0) {
                    this.setSize(this.size() + (long)sizeDiff, atomicOperation);
                }
            } else {
                OCacheEntry cacheEntry;
                boolean isNew = false;
                if (OSBTree.getFilledUpTo(atomicOperation, this.diskCache, this.nullBucketFileId) == 0L) {
                    cacheEntry = OSBTree.addPage(atomicOperation, this.nullBucketFileId, this.diskCache);
                    isNew = true;
                } else {
                    cacheEntry = OSBTree.loadPage(atomicOperation, this.nullBucketFileId, 0L, false, this.diskCache);
                }
                int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                boolean createLinkToTheValue = valueSize > MAX_EMBEDDED_VALUE_SIZE;
                long valueLink = -1L;
                if (createLinkToTheValue) {
                    valueLink = this.createLinkToTheValue(value, atomicOperation);
                }
                OSBTreeValue<Object> treeValue = new OSBTreeValue<Object>(createLinkToTheValue, valueLink, (createLinkToTheValue ? null : (Object)value));
                int sizeDiff = 0;
                cacheEntry.acquireExclusiveLock();
                try {
                    ONullBucket<Object> nullBucket = new ONullBucket<Object>(cacheEntry, OSBTree.getChangesTree(atomicOperation, cacheEntry), this.valueSerializer, isNew);
                    if (nullBucket.getValue() != null) {
                        sizeDiff = -1;
                    }
                    nullBucket.setValue(treeValue);
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
                }
                this.setSize(this.size() + (long)(++sizeDiff), atomicOperation);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OSBTreeException("Error during index update with key " + key + " and value " + value, e);
        }
        catch (Exception e) {
            this.rollback();
            throw new OSBTreeException("Error during index update with key " + key + " and value " + value, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId, flush);
            if (this.nullPointerSupport) {
                this.diskCache.closeFile(this.nullBucketFileId, flush);
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during close of index " + this.getName(), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree clear.", e);
        }
        this.acquireExclusiveLock();
        try {
            OCacheEntry cacheEntry;
            OSBTree.truncateFile(atomicOperation, this.fileId, this.diskCache);
            if (this.nullPointerSupport) {
                OSBTree.truncateFile(atomicOperation, this.nullBucketFileId, this.diskCache);
            }
            if ((cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache)) == null) {
                cacheEntry = OSBTree.addPage(atomicOperation, this.fileId, this.diskCache);
            }
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(cacheEntry, true, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
                rootBucket.setTreeSize(0L);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OSBTreeException("Error during clear of sbtree with name " + this.getName(), e);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException(e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree deletion.", e);
        }
        this.acquireExclusiveLock();
        try {
            OSBTree.deleteFile(atomicOperation, this.fileId, this.diskCache);
            if (this.nullPointerSupport) {
                OSBTree.deleteFile(atomicOperation, this.nullBucketFileId, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OSBTreeException("Error during delete of sbtree with name " + this.getName(), e);
        }
        catch (Exception e) {
            this.rollback();
            throw new OSBTreeException("Error during delete of sbtree with name " + this.getName(), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void deleteWithoutLoad(String name) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree deletion.", e);
        }
        this.acquireExclusiveLock();
        try {
            if (OSBTree.isFileExists(atomicOperation, this.getFullName(), this.diskCache)) {
                long fileId = OSBTree.openFile(atomicOperation, this.getFullName(), this.diskCache);
                OSBTree.deleteFile(atomicOperation, fileId, this.diskCache);
            }
            if (OSBTree.isFileExists(atomicOperation, this.getName() + this.nullFileExtension, this.diskCache)) {
                long nullFileId = OSBTree.openFile(atomicOperation, this.getName() + this.nullFileExtension, this.diskCache);
                OSBTree.deleteFile(atomicOperation, nullFileId, this.diskCache);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException ioe) {
            this.rollback();
            throw new OSBTreeException("Exception during deletion of sbtree " + this.getName(), ioe);
        }
        catch (Exception e) {
            this.rollback();
            throw new OSBTreeException("Exception during deletion of sbtree " + this.getName(), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void load(String name, OBinarySerializer<K> keySerializer, OStreamSerializer valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport) {
        this.acquireExclusiveLock();
        try {
            this.keySize = keySize;
            this.keyTypes = keyTypes;
            this.nullPointerSupport = nullPointerSupport;
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.fileId = OSBTree.openFile(atomicOperation, this.getFullName(), this.diskCache);
            if (nullPointerSupport) {
                this.nullBucketFileId = OSBTree.openFile(atomicOperation, name + this.nullFileExtension, this.diskCache);
            }
            this.keySerializer = keySerializer;
            if (keySerializer == null) {
                System.out.println("sdf");
            }
            this.valueSerializer = (OBinarySerializer)((Object)valueSerializer);
        }
        catch (IOException e) {
            throw new OSBTreeException("Exception during loading of sbtree " + name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V remove(K key) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OIndexException("Error during sbtree entrie remove.", e);
        }
        this.acquireExclusiveLock();
        try {
            V removedValue;
            if (key != null) {
                BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                if (bucketSearchResult.itemIndex < 0) {
                    this.endAtomicOperation(false);
                    V v = null;
                    return v;
                }
                OCacheEntry keyBucketCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, this.diskCache);
                keyBucketCacheEntry.acquireExclusiveLock();
                try {
                    OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, keyBucketCacheEntry));
                    OSBTreeValue removed = keyBucket.getEntry((int)((BucketSearchResult)bucketSearchResult).itemIndex).value;
                    Object value = this.readValue(removed, atomicOperation);
                    long removedValueLink = keyBucket.remove(bucketSearchResult.itemIndex);
                    if (removedValueLink >= 0L) {
                        this.removeLinkedValue(removedValueLink, atomicOperation);
                    }
                    this.setSize(this.size() - 1L, atomicOperation);
                    removedValue = value;
                }
                finally {
                    keyBucketCacheEntry.releaseExclusiveLock();
                    OSBTree.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
                }
            }
            if (OSBTree.getFilledUpTo(atomicOperation, this.diskCache, this.nullBucketFileId) == 0L) {
                this.endAtomicOperation(false);
                V bucketSearchResult = null;
                return bucketSearchResult;
            }
            OCacheEntry nullCacheEntry = OSBTree.loadPage(atomicOperation, this.nullBucketFileId, 0L, false, this.diskCache);
            nullCacheEntry.acquireExclusiveLock();
            try {
                ONullBucket<V> nullBucket = new ONullBucket<V>(nullCacheEntry, OSBTree.getChangesTree(atomicOperation, nullCacheEntry), this.valueSerializer, false);
                OSBTreeValue<V> treeValue = nullBucket.getValue();
                if (treeValue == null) {
                    this.endAtomicOperation(false);
                    V v = null;
                    return v;
                }
                removedValue = this.readValue(treeValue, atomicOperation);
                nullBucket.removeValue();
            }
            finally {
                nullCacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, nullCacheEntry, this.diskCache);
            }
            if (removedValue != null) {
                this.setSize(this.size() - 1L, atomicOperation);
            }
            this.endAtomicOperation(false);
            V v = removedValue;
            return v;
        }
        catch (IOException e) {
            this.rollback();
            throw new OSBTreeException("Error during removing key " + key + " from sbtree " + this.getName(), e);
        }
        catch (Exception e) {
            this.rollback();
            throw new OSBTreeException("Error during removing key " + key + " from sbtree " + this.getName(), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, V> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OAtomicOperation atomicOperation;
            block10: {
                OSBTreeCursor<K, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    if (ascSortOrder) break block10;
                    oSBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive, atomicOperation);
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new OSBTreeException("Error during iteration of minor values for key " + key + " in sbtree " + this.getName());
                    }
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive, atomicOperation);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, V> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OAtomicOperation atomicOperation;
            block10: {
                OSBTreeCursor<K, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    if (!ascSortOrder) break block10;
                    oSBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive, atomicOperation);
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new OSBTreeException("Error during iteration of major values for key " + key + " in sbtree " + this.getName());
                    }
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive, atomicOperation);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeKeyCursor<K> keyCursor() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                OSBTreeKeyCursor oSBTreeKeyCursor;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    oSBTreeKeyCursor = new OSBTreeKeyCursor<K>(){

                        @Override
                        public K next(int prefetchSize) {
                            return null;
                        }
                    };
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OSBTreeException("Error during finding first key in sbtree [" + this.getName() + "]");
                    }
                }
                this.releaseSharedLock();
                return oSBTreeKeyCursor;
            }
            OSBTreeFullKeyCursor oSBTreeFullKeyCursor = new OSBTreeFullKeyCursor(searchResult.getLastPathItem());
            this.releaseSharedLock();
            return oSBTreeFullKeyCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeCursor<K, V> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            OAtomicOperation atomicOperation;
            block10: {
                OSBTreeCursor<K, V> oSBTreeCursor;
                this.acquireSharedLock();
                try {
                    atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    if (!ascSortOrder) break block10;
                    oSBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive, atomicOperation);
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new OSBTreeException("Error during fetch of values between key " + keyFrom + " and key " + keyTo + " in sbtree " + this.getName());
                    }
                }
                this.releaseSharedLock();
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive, atomicOperation);
            this.releaseSharedLock();
            return oSBTreeCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void flush() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                try {
                    this.diskCache.flushBuffer();
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during flush of sbtree [" + this.getName() + "] data");
                }
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, !this.durableInNonTxMode);
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OSBTreeException("Null keys are not supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLinkedValue(long removedLink, OAtomicOperation atomicOperation) throws IOException {
        long nextPage = removedLink;
        do {
            removedLink = nextPage;
            OCacheEntry valueEntry = OSBTree.loadPage(atomicOperation, this.fileId, removedLink, false, this.diskCache);
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, OSBTree.getChangesTree(atomicOperation, valueEntry), false);
                nextPage = valuePage.getNextPage();
            }
            finally {
                OSBTree.releasePage(atomicOperation, valueEntry, this.diskCache);
            }
            this.removeValuePage(removedLink, atomicOperation);
        } while (nextPage >= 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValuePage(long pageIndex, OAtomicOperation atomicOperation) throws IOException {
        long prevFreeListItem;
        OCacheEntry rootCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache);
        rootCacheEntry.acquireExclusiveLock();
        OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rootCacheEntry));
        try {
            prevFreeListItem = rootBucket.getValuesFreeListFirstIndex();
            rootBucket.setValuesFreeListFirstIndex(pageIndex);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
        }
        OCacheEntry valueEntry = OSBTree.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
        valueEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, OSBTree.getChangesTree(atomicOperation, valueEntry), false);
            valuePage.setNextFreeListPage(prevFreeListItem);
        }
        finally {
            valueEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, valueEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createLinkToTheValue(V value, OAtomicOperation atomicOperation) throws IOException {
        byte[] serializeValue = new byte[this.valueSerializer.getObjectSize(value, new Object[0])];
        this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
        int amountOfPages = OSBTreeValuePage.calculateAmountOfPage(serializeValue.length);
        int position = 0;
        long freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
        OCacheEntry cacheEntry = freeListPageIndex < 0L ? OSBTree.addPage(atomicOperation, this.fileId, this.diskCache) : OSBTree.loadPage(atomicOperation, this.fileId, freeListPageIndex, false, this.diskCache);
        long valueLink = cacheEntry.getPageIndex();
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, OSBTree.getChangesTree(atomicOperation, cacheEntry), freeListPageIndex >= 0L);
            position = valuePage.fillBinaryContent(serializeValue, position);
            valuePage.setNextFreeListPage(-1L);
            valuePage.setNextPage(-1L);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
        }
        long prevPage = valueLink;
        for (int i = 1; i < amountOfPages; ++i) {
            freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
            cacheEntry = freeListPageIndex < 0L ? OSBTree.addPage(atomicOperation, this.fileId, this.diskCache) : OSBTree.loadPage(atomicOperation, this.fileId, freeListPageIndex, false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, OSBTree.getChangesTree(atomicOperation, cacheEntry), freeListPageIndex >= 0L);
                position = valuePage.fillBinaryContent(serializeValue, position);
                valuePage.setNextFreeListPage(-1L);
                valuePage.setNextPage(-1L);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            OCacheEntry prevPageCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, prevPage, false, this.diskCache);
            prevPageCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(prevPageCacheEntry, OSBTree.getChangesTree(atomicOperation, prevPageCacheEntry), freeListPageIndex >= 0L);
                valuePage.setNextPage(cacheEntry.getPageIndex());
            }
            finally {
                prevPageCacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, prevPageCacheEntry, this.diskCache);
            }
            prevPage = cacheEntry.getPageIndex();
        }
        return valueLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateValuePageFromFreeList(OAtomicOperation atomicOperation) throws IOException {
        long freeListFirstIndex;
        OCacheEntry rootCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache);
        assert (rootCacheEntry != null);
        OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rootCacheEntry));
        try {
            freeListFirstIndex = rootBucket.getValuesFreeListFirstIndex();
        }
        finally {
            OSBTree.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
        }
        if (freeListFirstIndex >= 0L) {
            OCacheEntry freePageEntry = OSBTree.loadPage(atomicOperation, this.fileId, freeListFirstIndex, false, this.diskCache);
            OSBTreeValuePage valuePage = new OSBTreeValuePage(freePageEntry, OSBTree.getChangesTree(atomicOperation, freePageEntry), false);
            freePageEntry.acquireExclusiveLock();
            try {
                long nextFreeListIndex = valuePage.getNextFreeListPage();
                rootCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache);
                rootCacheEntry.acquireExclusiveLock();
                rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rootCacheEntry));
                try {
                    rootBucket.setValuesFreeListFirstIndex(nextFreeListIndex);
                }
                finally {
                    rootCacheEntry.releaseExclusiveLock();
                    OSBTree.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
                }
                valuePage.setNextFreeListPage(-1L);
            }
            finally {
                freePageEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, freePageEntry, this.diskCache);
            }
            return freePageEntry.getPageIndex();
        }
        return -1L;
    }

    private void rollback() {
        try {
            this.endAtomicOperation(true);
        }
        catch (IOException e1) {
            OLogManager.instance().error((Object)this, "Error during sbtree operation  rollback", (Throwable)e1, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, 0L, false, this.diskCache);
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rootCacheEntry));
            rootBucket.setTreeSize(size);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorDesc(K key, boolean inclusive, OAtomicOperation atomicOperation) throws IOException {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
        long pageIndex = bucketSearchResult.getLastPathItem();
        int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
        return new OSBTreeCursorBackward(pageIndex, index, null, key, false, inclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorAsc(K key, boolean inclusive, OAtomicOperation atomicOperation) throws IOException {
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
            BucketSearchResult searchResult = this.firstItem(atomicOperation);
            if (searchResult == null) {
                OSBTreeCursor oSBTreeCursor = new OSBTreeCursor<K, V>(){

                    @Override
                    public Map.Entry<K, V> next(int prefetchSize) {
                        return null;
                    }
                };
                return oSBTreeCursor;
            }
            OSBTreeCursorForward oSBTreeCursorForward = new OSBTreeCursorForward(searchResult.getLastPathItem(), searchResult.itemIndex, null, key, false, inclusive);
            return oSBTreeCursorForward;
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during finding first key in sbtree [" + this.getName() + "]");
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorAsc(K key, boolean inclusive, OAtomicOperation atomicOperation) throws IOException {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
        long pageIndex = bucketSearchResult.getLastPathItem();
        int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
        return new OSBTreeCursorForward(pageIndex, index, key, null, inclusive, false);
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorDesc(K key, boolean inclusive, OAtomicOperation atomicOperation) throws IOException {
        BucketSearchResult searchResult;
        this.acquireSharedLock();
        try {
            key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
            key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
            searchResult = this.lastItem(atomicOperation);
            if (searchResult == null) {
                OSBTreeCursor oSBTreeCursor = new OSBTreeCursor<K, V>(){

                    @Override
                    public Map.Entry<K, V> next(int prefetchSize) {
                        return null;
                    }
                };
                return oSBTreeCursor;
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during finding last key in sbtree [" + this.getName() + "]");
        }
        finally {
            this.releaseSharedLock();
        }
        return new OSBTreeCursorBackward(searchResult.getLastPathItem(), searchResult.itemIndex, key, null, inclusive, false);
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketIndex, false, this.diskCache);
        int itemIndex = 0;
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex < bucket.size()) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.leftChild;
                        } else {
                            entry = bucket.getEntry(itemIndex - 1);
                            bucketIndex = entry.rightChild;
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(0, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
                cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketIndex, false, this.diskCache);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
            }
        }
        finally {
            OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketIndex, false, this.diskCache);
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex > -1) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.rightChild;
                        } else {
                            entry = bucket.getEntry(0);
                            bucketIndex = entry.leftChild;
                        }
                        itemIndex = OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(bucket.size() - 1, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
                cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, bucketIndex, false, this.diskCache);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
                if (itemIndex != OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OAtomicOperation atomicOperation) throws IOException {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        BucketSearchResult bucketSearchResultFrom = this.findBucket(keyFrom, atomicOperation);
        long pageIndexFrom = bucketSearchResultFrom.getLastPathItem();
        int indexFrom = bucketSearchResultFrom.itemIndex >= 0 ? (fromInclusive ? bucketSearchResultFrom.itemIndex : bucketSearchResultFrom.itemIndex + 1) : -bucketSearchResultFrom.itemIndex - 1;
        return new OSBTreeCursorForward(pageIndexFrom, indexFrom, keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OAtomicOperation atomicOperation) throws IOException {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        BucketSearchResult bucketSearchResultTo = this.findBucket(keyTo, atomicOperation);
        long pageIndexTo = bucketSearchResultTo.getLastPathItem();
        int indexTo = bucketSearchResultTo.itemIndex >= 0 ? (toInclusive ? bucketSearchResultTo.itemIndex : bucketSearchResultTo.itemIndex - 1) : -bucketSearchResultTo.itemIndex - 2;
        return new OSBTreeCursorBackward(pageIndexTo, indexTo, keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<Long> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = path.get(path.size() - 1);
        OCacheEntry bucketEntry = OSBTree.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
        bucketEntry.acquireExclusiveLock();
        try {
            int startRightIndex;
            OSBTreeBucket<K, V> bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, bucketEntry));
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries = new ArrayList<OSBTreeBucket.SBTreeEntry<K, V>>(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (pageIndex != 0L) {
                BucketSearchResult bucketSearchResult = this.splitNonRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = this.splitRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketEntry, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
            return bucketSearchResult;
        }
        finally {
            bucketEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, bucketEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitNonRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry = OSBTree.addPage(atomicOperation, this.fileId, this.diskCache);
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rightBucketEntry));
            newRightBucket.addAll(rightEntries);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = OSBTree.loadPage(atomicOperation, this.fileId, rightSiblingPageIndex, false, this.diskCache);
                    rightSiblingBucketEntry.acquireExclusiveLock();
                    OSBTreeBucket<K, V> rightSiblingBucket = new OSBTreeBucket<K, V>(rightSiblingBucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rightSiblingBucketEntry));
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        rightSiblingBucketEntry.releaseExclusiveLock();
                        OSBTree.releasePage(atomicOperation, rightSiblingBucketEntry, this.diskCache);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, parentIndex, false, this.diskCache);
            parentCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket parentBucket = new OSBTreeBucket(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, parentCacheEntry));
                OSBTreeBucket.SBTreeEntry parentEntry = new OSBTreeBucket.SBTreeEntry(pageIndex, rightBucketEntry.getPageIndex(), separationKey, null);
                int insertionIndex = parentBucket.find(separationKey);
                assert (insertionIndex < 0);
                insertionIndex = -insertionIndex - 1;
                while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                    parentCacheEntry.releaseExclusiveLock();
                    OSBTree.releasePage(atomicOperation, parentCacheEntry, this.diskCache);
                    BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    parentCacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, parentIndex, false, this.diskCache);
                    parentCacheEntry.acquireExclusiveLock();
                    insertionIndex = bucketSearchResult.itemIndex;
                    parentBucket = new OSBTreeBucket<K, V>(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, parentCacheEntry));
                }
            }
            finally {
                parentCacheEntry.releaseExclusiveLock();
                OSBTree.releasePage(atomicOperation, parentCacheEntry, this.diskCache);
            }
        }
        finally {
            rightBucketEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, rightBucketEntry, this.diskCache);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(pageIndex);
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OCacheEntry bucketEntry, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        long freeListPage = bucketToSplit.getValuesFreeListFirstIndex();
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList leftEntries = new ArrayList(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getEntry(i));
        }
        OCacheEntry leftBucketEntry = OSBTree.addPage(atomicOperation, this.fileId, this.diskCache);
        OCacheEntry rightBucketEntry = OSBTree.addPage(atomicOperation, this.fileId, this.diskCache);
        leftBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket newLeftBucket = new OSBTreeBucket(leftBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, leftBucketEntry));
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            leftBucketEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, leftBucketEntry, this.diskCache);
        }
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, rightBucketEntry));
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            rightBucketEntry.releaseExclusiveLock();
            OSBTree.releasePage(atomicOperation, rightBucketEntry, this.diskCache);
        }
        bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, false, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, bucketEntry));
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.setValuesFreeListFirstIndex(freeListPage);
        bucketToSplit.addEntry(0, new OSBTreeBucket.SBTreeEntry(leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), separationKey, null), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(leftBucketEntry.getPageIndex());
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>();
        while (true) {
            OSBTreeBucket.SBTreeEntry<K, V> entry;
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OSBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.");
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = OSBTree.loadPage(atomicOperation, this.fileId, pageIndex, false, this.diskCache);
            try {
                int insertionIndex;
                OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, OSBTree.getChangesTree(atomicOperation, bucketEntry));
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                OSBTree.releasePage(atomicOperation, bucketEntry, this.diskCache);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                pageIndex = entry.rightChild;
                continue;
            }
            pageIndex = entry.leftChild;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private V readValue(OSBTreeValue<V> sbTreeValue, OAtomicOperation atomicOperation) throws IOException {
        if (!sbTreeValue.isLink()) {
            return sbTreeValue.getValue();
        }
        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, sbTreeValue.getLink(), false, this.diskCache);
        OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, OSBTree.getChangesTree(atomicOperation, cacheEntry), false);
        int totalSize = valuePage.getSize();
        int currentSize = 0;
        byte[] value = new byte[totalSize];
        while (currentSize < totalSize) {
            currentSize = valuePage.readBinaryContent(value, currentSize);
            long nextPage = valuePage.getNextPage();
            if (nextPage < 0L) continue;
            OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
            cacheEntry = OSBTree.loadPage(atomicOperation, this.fileId, nextPage, false, this.diskCache);
            valuePage = new OSBTreeValuePage(cacheEntry, OSBTree.getChangesTree(atomicOperation, cacheEntry), false);
        }
        OSBTree.releasePage(atomicOperation, cacheEntry, this.diskCache);
        return this.valueSerializer.deserializeNativeObject(value, 0);
    }

    private Map.Entry<K, V> convertToMapEntry(OSBTreeBucket.SBTreeEntry<K, V> treeEntry, OAtomicOperation atomicOperation) throws IOException {
        final Object key = treeEntry.key;
        final Object value = this.readValue(treeEntry.value, atomicOperation);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private long pageIndex;
        private int itemIndex;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(long endPageIndex, int endItemIndex, K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            this.pageIndex = endPageIndex;
            this.itemIndex = endItemIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                return this.dataCacheIterator.next();
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                    while (this.dataCache.size() < prefetchSize) {
                        if (this.pageIndex >= OSBTree.getFilledUpTo(atomicOperation, OSBTree.this.diskCache, OSBTree.this.fileId)) {
                            this.pageIndex = OSBTree.getFilledUpTo(atomicOperation, OSBTree.this.diskCache, OSBTree.this.fileId) - 1L;
                        }
                        if (this.pageIndex == -1L) {
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, OSBTree.this.fileId, this.pageIndex, false, OSBTree.this.diskCache);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
                            if (this.itemIndex >= bucket.size()) {
                                this.itemIndex = bucket.size() - 1;
                            }
                            if (this.itemIndex < 0) {
                                this.pageIndex = bucket.getLeftSibling();
                                this.itemIndex = Integer.MAX_VALUE;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex), atomicOperation);
                            --this.itemIndex;
                            if (this.toKey != null && (!this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0)) continue;
                            if (this.fromKey != null && (this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0)) {
                                this.pageIndex = -1L;
                                break;
                            }
                            this.dataCache.add(entry);
                        }
                        finally {
                            OSBTree.releasePage(atomicOperation, cacheEntry, OSBTree.this.diskCache);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            return this.dataCacheIterator.next();
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private long pageIndex;
        private int itemIndex;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(long startPageIndex, int startItemIndex, K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            this.pageIndex = startPageIndex;
            this.itemIndex = startItemIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                return this.dataCacheIterator.next();
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                    while (this.dataCache.size() < prefetchSize) {
                        if (this.pageIndex == -1L) {
                            break;
                        }
                        if (this.pageIndex >= OSBTree.getFilledUpTo(atomicOperation, OSBTree.this.diskCache, OSBTree.this.fileId)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, OSBTree.this.fileId, this.pageIndex, false, OSBTree.this.diskCache);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
                            if (this.itemIndex >= bucket.size()) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex), atomicOperation);
                            ++this.itemIndex;
                            if (this.fromKey != null && (!this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0)) continue;
                            if (this.toKey != null && (this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0)) {
                                this.pageIndex = -1L;
                                break;
                            }
                            this.dataCache.add(entry);
                        }
                        finally {
                            OSBTree.releasePage(atomicOperation, cacheEntry, OSBTree.this.diskCache);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            return this.dataCacheIterator.next();
        }
    }

    public class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        public OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OSBTree.this.atomicOperationsManager.getCurrentOperation();
                    while (this.keysCache.size() < prefetchSize) {
                        if (this.pageIndex == -1L) {
                            break;
                        }
                        if (this.pageIndex >= OSBTree.getFilledUpTo(atomicOperation, OSBTree.this.diskCache, OSBTree.this.fileId)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.loadPage(atomicOperation, OSBTree.this.fileId, this.pageIndex, false, OSBTree.this.diskCache);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.getChangesTree(atomicOperation, cacheEntry));
                            if (this.itemIndex >= bucket.size()) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex), atomicOperation);
                            ++this.itemIndex;
                            this.keysCache.add(entry.getKey());
                        }
                        finally {
                            OSBTree.releasePage(atomicOperation, cacheEntry, OSBTree.this.diskCache);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<Long> path;

        private BucketSearchResult(int itemIndex, ArrayList<Long> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    public static interface OSBTreeKeyCursor<K> {
        public K next(int var1);
    }

    public static interface OSBTreeCursor<K, V> {
        public Map.Entry<K, V> next(int var1);
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

