/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtreebonsai.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.concur.lock.ONewLockManager;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiBucket;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSysBucket;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;

public class OSBTreeBonsaiLocal<K, V>
extends ODurableComponent
implements OSBTreeBonsai<K, V> {
    private static final ONewLockManager<Integer> fileLockManager = new ONewLockManager();
    private static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final float freeSpaceReuseTrigger = OGlobalConfiguration.SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER.getValueAsFloat();
    private static final OBonsaiBucketPointer SYS_BUCKET = new OBonsaiBucketPointer(0L, 0);
    private OBonsaiBucketPointer rootBucketPointer;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private long fileId;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private final boolean durableInNonTxMode;
    private final ODiskCache diskCache;

    public OSBTreeBonsaiLocal(String name, String dataFileExtension, boolean durableInNonTxMode, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension);
        this.durableInNonTxMode = durableInNonTxMode;
        this.diskCache = storage.getDiskCache();
    }

    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during sbtree creation.", e);
        }
        Lock lock = fileLockManager.acquireExclusiveLock(-1);
        try {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.fileId = OSBTreeBonsaiLocal.isFileExists(atomicOperation, this.getFullName(), this.diskCache) ? OSBTreeBonsaiLocal.openFile(atomicOperation, this.getFullName(), this.diskCache) : OSBTreeBonsaiLocal.addFile(atomicOperation, this.getFullName(), this.diskCache);
            this.initAfterCreate(atomicOperation);
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback();
            throw new OSBTreeException("Error creation of sbtree with name" + this.getName(), e);
        }
        catch (Exception e) {
            this.rollback();
            throw new OSBTreeException("Error creation of sbtree with name" + this.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAfterCreate(OAtomicOperation atomicOperation) throws IOException {
        this.initSysBucket(atomicOperation);
        AllocationResult allocationResult = this.allocateBucket(atomicOperation);
        OCacheEntry rootCacheEntry = allocationResult.getCacheEntry();
        this.rootBucketPointer = allocationResult.getPointer();
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rootCacheEntry));
            rootBucket.setTreeSize(0L);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileId() {
        Lock lock = fileLockManager.acquireSharedLock(this.fileId);
        try {
            long l = this.fileId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBonsaiBucketPointer getRootBucketPointer() {
        Lock lock = fileLockManager.acquireSharedLock(this.fileId);
        try {
            OBonsaiBucketPointer oBonsaiBucketPointer = this.rootBucketPointer;
            return oBonsaiBucketPointer;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBonsaiCollectionPointer getCollectionPointer() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Lock lock = fileLockManager.acquireSharedLock(this.fileId);
            try {
                OBonsaiCollectionPointer oBonsaiCollectionPointer = new OBonsaiCollectionPointer(this.fileId, this.rootBucketPointer);
                lock.unlock();
                return oBonsaiCollectionPointer;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean put(K key, V value) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during sbtree entrie put.", e);
        }
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            OCacheEntry keyBucketCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
            keyBucketCacheEntry.acquireExclusiveLock();
            OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, keyBucketCacheEntry));
            boolean itemFound = bucketSearchResult.itemIndex >= 0;
            boolean result = true;
            if (itemFound) {
                int updateResult = keyBucket.updateValue(bucketSearchResult.itemIndex, value);
                assert (updateResult == 0 || updateResult == 1);
                result = updateResult != 0;
            } else {
                int insertionIndex = -bucketSearchResult.itemIndex - 1;
                while (!keyBucket.addEntry(insertionIndex, new OSBTreeBonsaiBucket.SBTreeEntry<K, V>(OBonsaiBucketPointer.NULL, OBonsaiBucketPointer.NULL, key, value), true)) {
                    keyBucketCacheEntry.releaseExclusiveLock();
                    OSBTreeBonsaiLocal.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
                    bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key, atomicOperation);
                    bucketPointer = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    keyBucketCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem().getPageIndex(), false, this.diskCache);
                    keyBucketCacheEntry.acquireExclusiveLock();
                    keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, keyBucketCacheEntry));
                }
            }
            keyBucketCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
            if (!itemFound) {
                this.setSize(this.size() + 1L, atomicOperation);
            }
            this.endAtomicOperation(false);
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during index update with key " + key + " and value " + value, e);
        }
        finally {
            lock.unlock();
        }
    }

    private void rollback() {
        try {
            this.endAtomicOperation(true);
        }
        catch (IOException e1) {
            OLogManager.instance().error((Object)this, "Error during sbtree operation  rollback", (Throwable)e1, new Object[0]);
        }
    }

    public void close(boolean flush) {
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            this.diskCache.closeFile(this.fileId, flush);
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during close of index " + this.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during sbtree entrie clear.", e);
        }
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
            OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                this.addChildrenToQueue(subTreesToDelete, rootBucket);
                rootBucket.shrink(0);
                rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                rootBucket.setTreeSize(0L);
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            this.recycleSubTrees(subTreesToDelete, atomicOperation);
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during clear of sbtree with name " + this.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    private void addChildrenToQueue(Queue<OBonsaiBucketPointer> subTreesToDelete, OSBTreeBonsaiBucket<K, V> rootBucket) {
        if (!rootBucket.isLeaf()) {
            int size = rootBucket.size();
            if (size > 0) {
                subTreesToDelete.add(rootBucket.getEntry((int)0).leftChild);
            }
            for (int i = 0; i < size; ++i) {
                OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = rootBucket.getEntry(i);
                subTreesToDelete.add(entry.rightChild);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSubTrees(Queue<OBonsaiBucketPointer> subTreesToDelete, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer head = OBonsaiBucketPointer.NULL;
        OBonsaiBucketPointer tail = subTreesToDelete.peek();
        int bucketCount = 0;
        while (!subTreesToDelete.isEmpty()) {
            OBonsaiBucketPointer bucketPointer = subTreesToDelete.poll();
            OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                this.addChildrenToQueue(subTreesToDelete, bucket);
                bucket.setFreeListPointer(head);
                head = bucketPointer;
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
            }
            ++bucketCount;
        }
        if (head.isValid()) {
            OCacheEntry sysCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false, this.diskCache);
            sysCacheEntry.acquireExclusiveLock();
            try {
                OSysBucket sysBucket = new OSysBucket(sysCacheEntry, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, sysCacheEntry));
                this.attachFreeListHead(tail, sysBucket.getFreeListHead(), atomicOperation);
                sysBucket.setFreeListHead(head);
                sysBucket.setFreeListLength(sysBucket.freeListLength() + (long)bucketCount);
            }
            finally {
                sysCacheEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, sysCacheEntry, this.diskCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachFreeListHead(OBonsaiBucketPointer bucketPointer, OBonsaiBucketPointer freeListHead, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
            bucket.setFreeListPointer(freeListHead);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
        }
    }

    @Override
    public void delete() {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during sbtree deletion.", e);
        }
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
            subTreesToDelete.add(this.rootBucketPointer);
            this.recycleSubTrees(subTreesToDelete, atomicOperation);
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during delete of sbtree with name " + this.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(OBonsaiBucketPointer rootBucketPointer) {
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            this.rootBucketPointer = rootBucketPointer;
            OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
            this.fileId = OSBTreeBonsaiLocal.openFile(atomicOperation, this.getFullName(), this.diskCache);
            OCacheEntry rootCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false, this.diskCache);
            rootCacheEntry.acquireSharedLock();
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rootCacheEntry));
                this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(rootBucket.getKeySerializerId());
                this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(rootBucket.getValueSerializerId());
            }
            finally {
                rootCacheEntry.releaseSharedLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Exception during loading of sbtree " + this.fileId, e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, this.rootBucketPointer.getPageIndex(), false, this.diskCache);
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rootCacheEntry));
            rootBucket.setTreeSize(size);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, rootCacheEntry, this.diskCache);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        OAtomicOperation atomicOperation;
        try {
            atomicOperation = this.startAtomicOperation();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during sbtree entrie removal.", e);
        }
        Lock lock = fileLockManager.acquireExclusiveLock(this.fileId);
        try {
            Object removed;
            BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
            if (bucketSearchResult.itemIndex < 0) {
                this.endAtomicOperation(false);
                V v = null;
                return v;
            }
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            OCacheEntry keyBucketCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
            keyBucketCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, keyBucketCacheEntry));
                removed = keyBucket.getEntry((int)((BucketSearchResult)bucketSearchResult).itemIndex).value;
                keyBucket.remove(bucketSearchResult.itemIndex);
            }
            finally {
                keyBucketCacheEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, keyBucketCacheEntry, this.diskCache);
            }
            this.setSize(this.size() - 1L, atomicOperation);
            this.endAtomicOperation(false);
            Object v = removed;
            return v;
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during removing key " + key + " from sbtree " + this.getName(), e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, !this.durableInNonTxMode);
    }

    @Override
    public Collection<V> getValuesMinor(K key, boolean inclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesMinor(key, inclusive, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Lock lock = fileLockManager.acquireSharedLock(this.fileId);
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
                int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                boolean firstBucket = true;
                do {
                    OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
                    try {
                        OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                        if (!firstBucket) {
                            index = bucket.size() - 1;
                        }
                        for (int i = index; i >= 0; --i) {
                            if (listener.addResult(bucket.getEntry(i))) continue;
                            return;
                        }
                        bucketPointer = bucket.getLeftSibling();
                        firstBucket = false;
                    }
                    finally {
                        OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    }
                } while (bucketPointer.getPageIndex() >= 0L);
            }
            finally {
                lock.unlock();
            }
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during fetch of minor values for key " + key + " in sbtree " + this.getName());
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public Collection<V> getValuesMajor(K key, boolean inclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesMajor(key, inclusive, true, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        if (!ascSortOrder) {
            throw new IllegalStateException("Descending sort order is not supported.");
        }
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Lock lock = fileLockManager.acquireSharedLock(this.fileId);
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
                int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                do {
                    OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
                    try {
                        OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                        int bucketSize = bucket.size();
                        for (int i = index; i < bucketSize; ++i) {
                            if (listener.addResult(bucket.getEntry(i))) continue;
                            return;
                        }
                        bucketPointer = bucket.getRightSibling();
                        index = 0;
                    }
                    finally {
                        OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
                    }
                } while (bucketPointer.getPageIndex() >= 0L);
            }
            finally {
                lock.unlock();
            }
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during fetch of major values for key " + key + " in sbtree " + this.getName());
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesBetween(keyFrom, fromInclusive, keyTo, toInclusive, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= 0 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        block16: {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                Lock lock = fileLockManager.acquireSharedLock(this.fileId);
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResultFrom = this.findBucket(keyFrom, atomicOperation);
                    OBonsaiBucketPointer bucketPointerFrom = bucketSearchResultFrom.getLastPathItem();
                    int indexFrom = bucketSearchResultFrom.itemIndex >= 0 ? (fromInclusive ? bucketSearchResultFrom.itemIndex : bucketSearchResultFrom.itemIndex + 1) : -bucketSearchResultFrom.itemIndex - 1;
                    BucketSearchResult bucketSearchResultTo = this.findBucket(keyTo, atomicOperation);
                    OBonsaiBucketPointer bucketPointerTo = bucketSearchResultTo.getLastPathItem();
                    int indexTo = bucketSearchResultTo.itemIndex >= 0 ? (toInclusive ? bucketSearchResultTo.itemIndex : bucketSearchResultTo.itemIndex - 1) : -bucketSearchResultTo.itemIndex - 2;
                    int startIndex = indexFrom;
                    OBonsaiBucketPointer bucketPointer = bucketPointerFrom;
                    while (true) {
                        block17: {
                            OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
                            try {
                                OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
                                int endIndex = !bucketPointer.equals(bucketPointerTo) ? bucket.size() - 1 : indexTo;
                                for (int i = startIndex; i <= endIndex; ++i) {
                                    if (listener.addResult(bucket.getEntry(i))) {
                                        continue;
                                    }
                                    break block16;
                                }
                                if (!bucketPointer.equals(bucketPointerTo) && (bucketPointer = bucket.getRightSibling()).getPageIndex() >= 0L) break block17;
                                break;
                            }
                            finally {
                                OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
                            }
                        }
                        startIndex = 0;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (IOException ioe) {
                throw new OSBTreeException("Error during fetch of values between key " + keyFrom + " and key " + keyTo + " in sbtree " + this.getName());
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            Lock lock = fileLockManager.acquireSharedLock(this.fileId);
            try {
                try {
                    this.diskCache.flushBuffer();
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during flush of sbtree [" + this.getName() + "] data");
                }
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<OBonsaiBucketPointer> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer bucketPointer = path.get(path.size() - 1);
        OCacheEntry bucketEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
        bucketEntry.acquireExclusiveLock();
        try {
            int startRightIndex;
            OSBTreeBonsaiBucket<K, Object> bucketToSplit = new OSBTreeBonsaiBucket<K, Object>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, bucketEntry));
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList rightEntries = new ArrayList(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (!bucketPointer.equals(this.rootBucketPointer)) {
                Object parentBucketPointer;
                AllocationResult allocationResult = this.allocateBucket(atomicOperation);
                OCacheEntry rightBucketEntry = allocationResult.getCacheEntry();
                OBonsaiBucketPointer rightBucketPointer = allocationResult.getPointer();
                rightBucketEntry.acquireExclusiveLock();
                try {
                    OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rightBucketEntry));
                    newRightBucket.addAll(rightEntries);
                    bucketToSplit.shrink(indexToSplit);
                    if (splitLeaf) {
                        OBonsaiBucketPointer rightSiblingBucketPointer = bucketToSplit.getRightSibling();
                        newRightBucket.setRightSibling(rightSiblingBucketPointer);
                        newRightBucket.setLeftSibling(bucketPointer);
                        bucketToSplit.setRightSibling(rightBucketPointer);
                        if (rightSiblingBucketPointer.isValid()) {
                            OCacheEntry rightSiblingBucketEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, rightSiblingBucketPointer.getPageIndex(), false, this.diskCache);
                            rightSiblingBucketEntry.acquireExclusiveLock();
                            OSBTreeBonsaiBucket<K, V> rightSiblingBucket = new OSBTreeBonsaiBucket<K, V>(rightSiblingBucketEntry, rightSiblingBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rightSiblingBucketEntry));
                            try {
                                rightSiblingBucket.setLeftSibling(rightBucketPointer);
                            }
                            finally {
                                rightSiblingBucketEntry.releaseExclusiveLock();
                                OSBTreeBonsaiLocal.releasePage(atomicOperation, rightSiblingBucketEntry, this.diskCache);
                            }
                        }
                    }
                    parentBucketPointer = path.get(path.size() - 2);
                    OCacheEntry parentCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false, this.diskCache);
                    parentCacheEntry.acquireExclusiveLock();
                    try {
                        OSBTreeBonsaiBucket<K, Object> parentBucket = new OSBTreeBonsaiBucket<K, Object>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, parentCacheEntry));
                        OSBTreeBonsaiBucket.SBTreeEntry<K, Object> parentEntry = new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(bucketPointer, rightBucketPointer, separationKey, null);
                        int insertionIndex = parentBucket.find(separationKey);
                        assert (insertionIndex < 0);
                        insertionIndex = -insertionIndex - 1;
                        while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                            parentCacheEntry.releaseExclusiveLock();
                            OSBTreeBonsaiLocal.releasePage(atomicOperation, parentCacheEntry, this.diskCache);
                            BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                            parentBucketPointer = bucketSearchResult.getLastPathItem();
                            parentCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false, this.diskCache);
                            parentCacheEntry.acquireExclusiveLock();
                            insertionIndex = bucketSearchResult.itemIndex;
                            parentBucket = new OSBTreeBonsaiBucket<K, V>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, parentCacheEntry));
                        }
                    }
                    finally {
                        parentCacheEntry.releaseExclusiveLock();
                        OSBTreeBonsaiLocal.releasePage(atomicOperation, parentCacheEntry, this.diskCache);
                    }
                }
                finally {
                    rightBucketEntry.releaseExclusiveLock();
                    OSBTreeBonsaiLocal.releasePage(atomicOperation, rightBucketEntry, this.diskCache);
                }
                ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
                if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                    resultPath.add(bucketPointer);
                    parentBucketPointer = new BucketSearchResult(keyIndex, resultPath);
                    return parentBucketPointer;
                }
                resultPath.add(rightBucketPointer);
                if (splitLeaf) {
                    parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                    return parentBucketPointer;
                }
                parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
                return parentBucketPointer;
            }
            long treeSize = bucketToSplit.getTreeSize();
            ArrayList leftEntries = new ArrayList(indexToSplit);
            for (int i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getEntry(i));
            }
            AllocationResult leftAllocationResult = this.allocateBucket(atomicOperation);
            OCacheEntry leftBucketEntry = leftAllocationResult.getCacheEntry();
            OBonsaiBucketPointer leftBucketPointer = leftAllocationResult.getPointer();
            AllocationResult rightAllocationResult = this.allocateBucket(atomicOperation);
            OCacheEntry rightBucketEntry = rightAllocationResult.getCacheEntry();
            OBonsaiBucketPointer rightBucketPointer = rightAllocationResult.getPointer();
            leftBucketEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket newLeftBucket = new OSBTreeBonsaiBucket(leftBucketEntry, leftBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, leftBucketEntry));
                newLeftBucket.addAll(leftEntries);
                if (splitLeaf) {
                    newLeftBucket.setRightSibling(rightBucketPointer);
                }
            }
            finally {
                leftBucketEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, leftBucketEntry, this.diskCache);
            }
            rightBucketEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, rightBucketEntry));
                newRightBucket.addAll(rightEntries);
                if (splitLeaf) {
                    newRightBucket.setLeftSibling(leftBucketPointer);
                }
            }
            finally {
                rightBucketEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, rightBucketEntry, this.diskCache);
            }
            bucketToSplit = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), false, this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, bucketEntry));
            bucketToSplit.setTreeSize(treeSize);
            bucketToSplit.addEntry(0, new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(leftBucketPointer, rightBucketPointer, separationKey, null), true);
            ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
            if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                resultPath.add(leftBucketPointer);
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex, resultPath);
                return bucketSearchResult;
            }
            resultPath.add(rightBucketPointer);
            if (splitLeaf) {
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
            return bucketSearchResult;
        }
        finally {
            bucketEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, bucketEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer bucketPointer = this.rootBucketPointer;
        ArrayList<OBonsaiBucketPointer> path = new ArrayList<OBonsaiBucketPointer>();
        while (true) {
            OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry;
            path.add(bucketPointer);
            OCacheEntry bucketEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, bucketPointer.getPageIndex(), false, this.diskCache);
            try {
                int insertionIndex;
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, bucketEntry));
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                OSBTreeBonsaiLocal.releasePage(atomicOperation, bucketEntry, this.diskCache);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                bucketPointer = entry.rightChild;
                continue;
            }
            bucketPointer = entry.leftChild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSysBucket(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry sysCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false, this.diskCache);
        if (sysCacheEntry == null) {
            sysCacheEntry = OSBTreeBonsaiLocal.addPage(atomicOperation, this.fileId, this.diskCache);
            assert (sysCacheEntry.getPageIndex() == SYS_BUCKET.getPageIndex());
        }
        sysCacheEntry.acquireExclusiveLock();
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, sysCacheEntry));
            if (sysBucket.isInitialized()) {
                sysCacheEntry.releaseExclusiveLock();
                OSBTreeBonsaiLocal.releasePage(atomicOperation, sysCacheEntry, this.diskCache);
                sysCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false, this.diskCache);
                sysCacheEntry.acquireExclusiveLock();
                sysBucket = new OSysBucket(sysCacheEntry, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, sysCacheEntry));
                sysBucket.init();
            }
        }
        finally {
            sysCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, sysCacheEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocationResult allocateBucket(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry sysCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false, this.diskCache);
        if (sysCacheEntry == null) {
            sysCacheEntry = OSBTreeBonsaiLocal.addPage(atomicOperation, this.fileId, this.diskCache);
            assert (sysCacheEntry.getPageIndex() == SYS_BUCKET.getPageIndex());
        }
        sysCacheEntry.acquireExclusiveLock();
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, sysCacheEntry));
            if (1.0 * (double)sysBucket.freeListLength() / (double)(OSBTreeBonsaiLocal.getFilledUpTo(atomicOperation, this.diskCache, this.fileId) * (long)PAGE_SIZE / (long)OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES) >= (double)this.freeSpaceReuseTrigger) {
                AllocationResult allocationResult;
                AllocationResult allocationResult2 = allocationResult = this.reuseBucketFromFreeList(sysBucket, atomicOperation);
                return allocationResult2;
            }
            OBonsaiBucketPointer freeSpacePointer = sysBucket.getFreeSpacePointer();
            if (freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES > PAGE_SIZE) {
                OCacheEntry cacheEntry = OSBTreeBonsaiLocal.addPage(atomicOperation, this.fileId, this.diskCache);
                long pageIndex = cacheEntry.getPageIndex();
                sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(pageIndex, OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
                AllocationResult allocationResult = new AllocationResult(new OBonsaiBucketPointer(pageIndex, 0), cacheEntry, true);
                return allocationResult;
            }
            sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(freeSpacePointer.getPageIndex(), freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
            OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, freeSpacePointer.getPageIndex(), false, this.diskCache);
            AllocationResult allocationResult = new AllocationResult(freeSpacePointer, cacheEntry, false);
            return allocationResult;
        }
        finally {
            sysCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, sysCacheEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocationResult reuseBucketFromFreeList(OSysBucket sysBucket, OAtomicOperation atomicOperation) throws IOException {
        OBonsaiBucketPointer oldFreeListHead = sysBucket.getFreeListHead();
        assert (oldFreeListHead.isValid());
        OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, oldFreeListHead.getPageIndex(), false, this.diskCache);
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, oldFreeListHead.getPageOffset(), this.keySerializer, this.valueSerializer, OSBTreeBonsaiLocal.getChangesTree(atomicOperation, cacheEntry));
            sysBucket.setFreeListHead(bucket.getFreeListPointer());
            sysBucket.setFreeListLength(sysBucket.freeListLength() - 1L);
        }
        finally {
            cacheEntry.releaseExclusiveLock();
        }
        return new AllocationResult(oldFreeListHead, cacheEntry, false);
    }

    @Override
    public int getRealBagSize(Map<K, OSBTreeRidBag.Change> changes) {
        final HashMap<K, OSBTreeRidBag.Change> notAppliedChanges = new HashMap<K, OSBTreeRidBag.Change>(changes);
        final OModifiableInteger size = new OModifiableInteger(0);
        this.loadEntriesMajor(this.firstKey(), true, true, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                OSBTreeRidBag.Change change = (OSBTreeRidBag.Change)notAppliedChanges.remove(entry.getKey());
                Integer treeValue = (Integer)entry.getValue();
                int result = change == null ? treeValue.intValue() : change.applyTo(treeValue);
                size.increment(result);
                return true;
            }
        });
        for (OSBTreeRidBag.Change change : notAppliedChanges.values()) {
            size.increment(change.applyTo(0));
        }
        return size.intValue();
    }

    @Override
    public OBinarySerializer<K> getKeySerializer() {
        Lock lock = fileLockManager.acquireSharedLock(this.fileId);
        try {
            OBinarySerializer<K> oBinarySerializer = this.keySerializer;
            return oBinarySerializer;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OBinarySerializer<V> getValueSerializer() {
        Lock lock = fileLockManager.acquireSharedLock(this.fileId);
        try {
            OBinarySerializer<V> oBinarySerializer = this.valueSerializer;
            return oBinarySerializer;
        }
        finally {
            lock.unlock();
        }
    }

    public List<OBonsaiBucketPointer> listBuckets() throws IOException {
        ArrayList<OBonsaiBucketPointer> result = new ArrayList<OBonsaiBucketPointer>();
        if (this.rootBucketPointer.isValid()) {
            this.listBuckets(this.rootBucketPointer, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listBuckets(OBonsaiBucketPointer toInspect, List<OBonsaiBucketPointer> result) throws IOException {
        result.add(toInspect);
        OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
        OCacheEntry bucketEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, toInspect.getPageIndex(), false, this.diskCache);
        try {
            OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(bucketEntry, toInspect.getPageOffset(), this.keySerializer, this.valueSerializer, null);
            if (!keyBucket.isLeaf()) {
                for (int index = 0; index < keyBucket.size(); ++index) {
                    OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = keyBucket.getEntry(index);
                    OBonsaiBucketPointer next = entry.leftChild;
                    if (next.isValid()) {
                        this.listBuckets(next, result);
                    }
                    if (!(next = entry.rightChild).isValid()) continue;
                    this.listBuckets(next, result);
                }
            }
        }
        finally {
            OSBTreeBonsaiLocal.releasePage(atomicOperation, bucketEntry, this.diskCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucketsFromFreeList() throws IOException {
        List<OBonsaiBucketPointer> buckets = this.listBuckets();
        OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
        OCacheEntry sysCacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, SYS_BUCKET.getPageIndex(), false, this.diskCache);
        if (sysCacheEntry == null) {
            return;
        }
        sysCacheEntry.acquireExclusiveLock();
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry, null);
            OBonsaiBucketPointer oldFreeListHead = sysBucket.getFreeListHead();
            boolean check = true;
            while (check && oldFreeListHead.isValid()) {
                OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, oldFreeListHead.getPageIndex(), false, this.diskCache);
                cacheEntry.acquireExclusiveLock();
                try {
                    OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, oldFreeListHead.getPageOffset(), this.keySerializer, this.valueSerializer, null);
                    if (buckets.contains(oldFreeListHead)) {
                        sysBucket.setFreeListHead(bucket.getFreeListPointer());
                        sysBucket.setFreeListLength(sysBucket.freeListLength() - 1L);
                        oldFreeListHead = bucket.getFreeListPointer();
                        continue;
                    }
                    check = false;
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
                }
            }
            OBonsaiBucketPointer next = oldFreeListHead;
            OBonsaiBucketPointer prev = null;
            long len = sysBucket.freeListLength();
            for (long i = 0L; i < len && next.isValid(); ++i) {
                OCacheEntry cacheEntry = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, next.getPageIndex(), false, this.diskCache);
                if (cacheEntry == null) continue;
                cacheEntry.acquireExclusiveLock();
                try {
                    OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, next.getPageOffset(), this.keySerializer, this.valueSerializer, null);
                    if (buckets.contains(next)) {
                        OCacheEntry cacheEntryNext = OSBTreeBonsaiLocal.loadPage(atomicOperation, this.fileId, prev.getPageIndex(), false, this.diskCache);
                        cacheEntry.acquireExclusiveLock();
                        try {
                            OSBTreeBonsaiBucket<K, V> bucketPrev = new OSBTreeBonsaiBucket<K, V>(cacheEntryNext, prev.getPageOffset(), this.keySerializer, this.valueSerializer, null);
                            bucketPrev.setFreeListPointer(bucket.getFreeListPointer());
                            sysBucket.setFreeListLength(sysBucket.freeListLength() - 1L);
                        }
                        finally {
                            cacheEntryNext.releaseExclusiveLock();
                            OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntryNext, this.diskCache);
                        }
                    } else {
                        prev = next;
                    }
                    next = bucket.getFreeListPointer();
                    continue;
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    OSBTreeBonsaiLocal.releasePage(atomicOperation, cacheEntry, this.diskCache);
                }
            }
        }
        finally {
            sysCacheEntry.releaseExclusiveLock();
            OSBTreeBonsaiLocal.releasePage(atomicOperation, sysCacheEntry, this.diskCache);
        }
    }

    private static final class PagePathItemUnit {
        private final OBonsaiBucketPointer bucketPointer;
        private final int itemIndex;

        private PagePathItemUnit(OBonsaiBucketPointer bucketPointer, int itemIndex) {
            this.bucketPointer = bucketPointer;
            this.itemIndex = itemIndex;
        }

        static /* synthetic */ OBonsaiBucketPointer access$400(PagePathItemUnit x0) {
            return x0.bucketPointer;
        }

        static /* synthetic */ int access$500(PagePathItemUnit x0) {
            return x0.itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<OBonsaiBucketPointer> path;

        private BucketSearchResult(int itemIndex, ArrayList<OBonsaiBucketPointer> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public OBonsaiBucketPointer getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static class AllocationResult {
        private final OBonsaiBucketPointer pointer;
        private final OCacheEntry cacheEntry;
        private final boolean newPage;

        private AllocationResult(OBonsaiBucketPointer pointer, OCacheEntry cacheEntry, boolean newPage) {
            this.pointer = pointer;
            this.cacheEntry = cacheEntry;
            this.newPage = newPage;
        }

        private OBonsaiBucketPointer getPointer() {
            return this.pointer;
        }

        private OCacheEntry getCacheEntry() {
            return this.cacheEntry;
        }

        private boolean isNewPage() {
            return this.newPage;
        }
    }
}

