/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class OLazyWrapperIterator<T>
implements Iterator<T>,
Iterable<T>,
OResettable,
OSizeable {
    protected final Iterator<?> iterator;
    protected T nextElement;
    protected final int size;

    public OLazyWrapperIterator(Iterator<?> iterator) {
        this.iterator = iterator;
        this.size = -1;
    }

    public OLazyWrapperIterator(Iterator<?> iterator, int iSize) {
        this.iterator = iterator;
        this.size = iSize;
    }

    public abstract boolean filter(T var1);

    public abstract T createWrapper(Object var1);

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int size() {
        if (this.size > -1) {
            return this.size;
        }
        if (this.iterator instanceof OSizeable) {
            return ((OSizeable)((Object)this.iterator)).size();
        }
        return 0;
    }

    @Override
    public void reset() {
        if (this.iterator instanceof OResettable) {
            ((OResettable)((Object)this.iterator)).reset();
        }
        this.nextElement = null;
    }

    @Override
    public boolean hasNext() {
        while (this.nextElement == null && this.iterator.hasNext()) {
            this.nextElement = this.createWrapper(this.iterator.next());
            if (this.nextElement == null || this.filter(this.nextElement)) continue;
            this.nextElement = null;
        }
        return this.nextElement != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            try {
                T t = this.nextElement;
                return t;
            }
            finally {
                this.nextElement = null;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

