/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OImmutableProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OImmutableClass
implements OClass {
    private final boolean isAbstract;
    private final boolean strictMode;
    private final String superClassName;
    private final String name;
    private final String streamAbleName;
    private final Map<String, OProperty> properties;
    private final Class<?> javaClass;
    private final OClusterSelectionStrategy clusterSelection;
    private final int defaultClusterId;
    private final int[] clusterIds;
    private final int[] polymorphicClusterIds;
    private final Collection<String> baseClassesNames;
    private final float overSize;
    private final float classOverSize;
    private final String shortName;
    private final Map<String, String> customFields;
    private final OImmutableSchema schema;
    private OImmutableClass superClass;
    private Collection<OImmutableClass> baseClasses;

    public OImmutableClass(OClass oClass, OImmutableSchema schema) {
        this.isAbstract = oClass.isAbstract();
        this.strictMode = oClass.isStrictMode();
        this.schema = schema;
        this.superClassName = oClass.getSuperClass() != null ? oClass.getSuperClass().getName() : null;
        this.name = oClass.getName();
        this.streamAbleName = oClass.getStreamableName();
        this.clusterSelection = oClass.getClusterSelection();
        this.defaultClusterId = oClass.getDefaultClusterId();
        this.clusterIds = oClass.getClusterIds();
        this.polymorphicClusterIds = oClass.getPolymorphicClusterIds();
        this.baseClassesNames = new ArrayList<String>();
        for (OClass baseClass : oClass.getBaseClasses()) {
            this.baseClassesNames.add(baseClass.getName());
        }
        this.overSize = oClass.getOverSize();
        this.classOverSize = oClass.getClassOverSize();
        this.shortName = oClass.getShortName();
        this.javaClass = oClass.getJavaClass();
        this.properties = new HashMap<String, OProperty>();
        for (OProperty p : oClass.declaredProperties()) {
            this.properties.put(p.getName().toLowerCase(), new OImmutableProperty(p, this));
        }
        this.customFields = new HashMap<String, String>();
        for (String key : oClass.getCustomKeys()) {
            this.customFields.put(key, oClass.getCustom(key));
        }
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public OClass setAbstract(boolean iAbstract) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public OClass setStrictMode(boolean iMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass getSuperClass() {
        this.initSuperClass();
        return this.superClass;
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OClass setName(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStreamableName() {
        return this.streamAbleName;
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Collection<OProperty> properties() {
        ArrayList<OProperty> props = new ArrayList<OProperty>();
        this.initSuperClass();
        OImmutableClass currentClass = this;
        do {
            props.addAll(currentClass.properties.values());
            currentClass.initSuperClass();
        } while ((currentClass = currentClass.superClass) != null);
        return Collections.unmodifiableCollection(props);
    }

    @Override
    public Map<String, OProperty> propertiesMap() {
        HashMap<String, OProperty> props = new HashMap<String, OProperty>(20);
        this.initSuperClass();
        OImmutableClass currentClass = this;
        do {
            for (OProperty p : currentClass.properties.values()) {
                String propName = p.getName();
                if (props.containsKey(propName)) continue;
                props.put(propName, p);
            }
            currentClass.initSuperClass();
        } while ((currentClass = currentClass.superClass) != null);
        return Collections.unmodifiableMap(props);
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        ArrayList<OProperty> indexedProps = null;
        OImmutableClass currentClass = this;
        this.initSuperClass();
        do {
            for (OProperty p : currentClass.properties.values()) {
                if (!this.areIndexed(p.getName())) continue;
                if (indexedProps == null) {
                    indexedProps = new ArrayList<OProperty>();
                }
                indexedProps.add(p);
            }
            currentClass.initSuperClass();
        } while ((currentClass = currentClass.superClass) != null);
        return indexedProps != null ? Collections.unmodifiableCollection(indexedProps) : Collections.emptyList();
    }

    @Override
    public OProperty getProperty(String propertyName) {
        this.initSuperClass();
        propertyName = propertyName.toLowerCase();
        OImmutableClass currentClass = this;
        do {
            OProperty p;
            if ((p = currentClass.properties.get(propertyName)) != null) {
                return p;
            }
            currentClass.initSuperClass();
        } while ((currentClass = currentClass.superClass) != null);
        return null;
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropProperty(String iPropertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsProperty(String propertyName) {
        propertyName = propertyName.toLowerCase();
        OImmutableClass currentClass = this;
        do {
            boolean result;
            if (!(result = currentClass.properties.containsKey(propertyName))) continue;
            return true;
        } while ((currentClass = (OImmutableClass)currentClass.getSuperClass()) != null);
        return false;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public int getClusterForNewInstance(ODocument doc) {
        return this.clusterSelection.getCluster(this, doc);
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int iDefaultClusterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public OClass addClusterId(int iId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClusterSelectionStrategy getClusterSelection() {
        return this.clusterSelection;
    }

    @Override
    public OClass setClusterSelection(OClusterSelectionStrategy clusterSelection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setClusterSelection(String iStrategyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass addCluster(String iClusterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass removeClusterId(int iId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        return this.polymorphicClusterIds;
    }

    public OImmutableSchema getSchema() {
        return this.schema;
    }

    @Override
    public Collection<OClass> getBaseClasses() {
        this.initBaseClasses();
        ArrayList<OClass> result = new ArrayList<OClass>();
        for (OClass oClass : this.baseClasses) {
            result.add(oClass);
        }
        return result;
    }

    @Override
    public Collection<OClass> getAllBaseClasses() {
        this.initBaseClasses();
        HashSet<OClass> set = new HashSet<OClass>();
        set.addAll(this.getBaseClasses());
        for (OImmutableClass c : this.baseClasses) {
            set.addAll(c.getAllBaseClasses());
        }
        return set;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (int clusterId : this.clusterIds) {
            size += this.getDatabase().getClusterRecordSizeById(clusterId);
        }
        return size;
    }

    @Override
    public float getOverSize() {
        return this.overSize;
    }

    @Override
    public float getClassOverSize() {
        return this.classOverSize;
    }

    @Override
    public OClass setOverSize(float overSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count() {
        return this.count(true);
    }

    @Override
    public long count(boolean isPolymorphic) {
        if (isPolymorphic) {
            return this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.polymorphicClusterIds));
        }
        return this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.clusterIds));
    }

    @Override
    public void truncate() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSubClassOf(String iClassName) {
        if (iClassName == null) {
            return false;
        }
        OClass cls = this;
        do {
            if (!iClassName.equalsIgnoreCase(cls.getName()) && !iClassName.equalsIgnoreCase(cls.getShortName())) continue;
            return true;
        } while ((cls = cls.getSuperClass()) != null);
        return false;
    }

    @Override
    public boolean isSubClassOf(OClass clazz) {
        if (clazz == null) {
            return false;
        }
        for (OClass cls = this; cls != null; cls = cls.getSuperClass()) {
            if (!((Object)cls).equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperClassOf(OClass clazz) {
        return clazz != null && clazz.isSubClassOf(this);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public OClass setShortName(String shortName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case CLUSTERSELECTION: {
                return this.getClusterSelection();
            }
            case CUSTOM: {
                return this.getCustomInternal();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String algorithm, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String ... fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        this.initSuperClass();
        HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
        if (this.superClass != null) {
            result.addAll(this.superClass.getInvolvedIndexes(fields));
        }
        return result;
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassInvolvedIndexes(this.name, fields);
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        boolean currentClassResult = indexManager.areIndexed(this.name, fields);
        this.initSuperClass();
        if (this.superClass != null) {
            return currentClassResult || this.superClass.areIndexed(fields);
        }
        return currentClassResult;
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String iName) {
        return this.getDatabase().getMetadata().getIndexManager().getClassIndex(this.name, this.name);
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        return this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name);
    }

    @Override
    public void getClassIndexes(Collection<OIndex<?>> indexes) {
        this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name, indexes);
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        this.initSuperClass();
        Set<OIndex<?>> indexes = this.getClassIndexes();
        for (OClass s = this.superClass; s != null; s = s.getSuperClass()) {
            s.getClassIndexes(indexes);
        }
        return indexes;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!OClass.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        OClass other = (OClass)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getCustom(String iName) {
        return this.customFields.get(iName);
    }

    @Override
    public OClass setCustom(String iName, String iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCustom(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCustom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCustomKeys() {
        return Collections.unmodifiableSet(this.customFields.keySet());
    }

    @Override
    public boolean hasClusterId(int clusterId) {
        return Arrays.binarySearch(this.clusterIds, clusterId) >= 0;
    }

    @Override
    public int compareTo(OClass other) {
        return this.name.compareTo(other.getName());
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private Map<String, String> getCustomInternal() {
        return Collections.unmodifiableMap(this.customFields);
    }

    private void initSuperClass() {
        if (this.superClassName != null && this.superClass == null) {
            this.superClass = (OImmutableClass)this.schema.getClass(this.superClassName);
        }
    }

    private void initBaseClasses() {
        if (this.baseClasses == null) {
            ArrayList<OImmutableClass> result = new ArrayList<OImmutableClass>(this.baseClassesNames.size());
            for (String clsName : this.baseClassesNames) {
                result.add((OImmutableClass)this.schema.getClass(clsName));
            }
            this.baseClasses = result;
        }
    }
}

