/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class OImmutableProperty
implements OProperty {
    private final String name;
    private final String fullName;
    private final OType type;
    private OClass linkedClass = null;
    private final String linkedClassName;
    private final OType linkedType;
    private final boolean notNull;
    private final OCollate collate;
    private final boolean mandatory;
    private final String min;
    private final String max;
    private final String regexp;
    private final Map<String, String> customProperties;
    private final OClass owner;
    private final Integer id;
    private final boolean readOnly;

    public OImmutableProperty(OProperty property, OImmutableClass owner) {
        this.name = property.getName();
        this.fullName = property.getFullName();
        this.type = property.getType();
        this.linkedClassName = property.getLinkedClass() != null ? property.getLinkedClass().getName() : null;
        this.linkedType = property.getLinkedType();
        this.notNull = property.isNotNull();
        this.collate = property.getCollate();
        this.mandatory = property.isMandatory();
        this.min = property.getMin();
        this.max = property.getMax();
        this.regexp = property.getRegexp();
        this.customProperties = new HashMap<String, String>();
        for (String key : property.getCustomKeys()) {
            this.customProperties.put(key, property.getCustom(key));
        }
        this.owner = owner;
        this.id = property.getId();
        this.readOnly = property.isReadonly();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public OProperty setName(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(OProperty.ATTRIBUTES attribute, Object iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OType getType() {
        return this.type;
    }

    @Override
    public OClass getLinkedClass() {
        if (this.linkedClassName == null) {
            return null;
        }
        if (this.linkedClass != null) {
            return this.linkedClass;
        }
        OImmutableSchema schema = ((OImmutableClass)this.owner).getSchema();
        this.linkedClass = schema.getClass(this.linkedClassName);
        return this.linkedClass;
    }

    @Override
    public OProperty setLinkedClass(OClass oClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OType getLinkedType() {
        return this.linkedType;
    }

    @Override
    public OProperty setLinkedType(OType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public OProperty setNotNull(boolean iNotNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OCollate getCollate() {
        return this.collate;
    }

    @Override
    public OProperty setCollate(String iCollateName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty setCollate(OCollate collate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public OProperty setMandatory(boolean mandatory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadonly() {
        return this.readOnly;
    }

    @Override
    public OProperty setReadonly(boolean iReadonly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMin() {
        return this.min;
    }

    @Override
    public OProperty setMin(String min) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMax() {
        return this.max;
    }

    @Override
    public OProperty setMax(String max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndex<?> createIndex(String iType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty dropIndexes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        return this.owner.getInvolvedIndexes(this.name);
    }

    @Override
    public OIndex<?> getIndex() {
        Set<OIndex<?>> indexes = this.owner.getInvolvedIndexes(this.name);
        if (indexes != null && !indexes.isEmpty()) {
            return indexes.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<OIndex<?>> getAllIndexes() {
        Set<OIndex<?>> indexes = this.owner.getIndexes();
        LinkedList indexList = new LinkedList();
        for (OIndex<?> index : indexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            if (!indexDefinition.getFields().contains(this.name)) continue;
            indexList.add(index);
        }
        return indexList;
    }

    @Override
    public boolean isIndexed() {
        return this.owner.areIndexed(this.name);
    }

    @Override
    public String getRegexp() {
        return this.regexp;
    }

    @Override
    public OProperty setRegexp(String regexp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OProperty setType(OType iType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCustom(String iName) {
        return this.customProperties.get(iName);
    }

    @Override
    public OProperty setCustom(String iName, String iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCustom(String iName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCustom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getCustomKeys() {
        return Collections.unmodifiableSet(this.customProperties.keySet());
    }

    @Override
    public OClass getOwnerClass() {
        return this.owner;
    }

    @Override
    public Object get(OProperty.ATTRIBUTES attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (attribute) {
            case LINKEDCLASS: {
                return this.getLinkedClass();
            }
            case LINKEDTYPE: {
                return this.getLinkedType();
            }
            case MIN: {
                return this.getMin();
            }
            case MANDATORY: {
                return this.isMandatory();
            }
            case READONLY: {
                return this.isReadonly();
            }
            case MAX: {
                return this.getMax();
            }
            case NAME: {
                return this.getName();
            }
            case NOTNULL: {
                return this.isNotNull();
            }
            case REGEXP: {
                return this.getRegexp();
            }
            case TYPE: {
                return this.getType();
            }
            case COLLATE: {
                return this.getCollate();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)attribute) + "'");
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public int compareTo(OProperty other) {
        return this.name.compareTo(other.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!OProperty.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        OProperty other = (OProperty)obj;
        return !(this.owner == null ? other.getOwnerClass() != null : !this.owner.equals(other.getOwnerClass()));
    }

    public String toString() {
        return this.getName() + " (type=" + (Object)((Object)this.getType()) + ")";
    }
}

