/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionFactory;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OImmutableSchema
implements OSchema {
    private final Map<Integer, OClass> clustersToClasses;
    private final Map<String, OClass> classes;
    public final int version;
    private final ORID identity;
    private final boolean clustersCanNotBeSharedAmongClasses;
    private final List<OGlobalProperty> properties;
    private final OClusterSelectionFactory clusterSelectionFactory;

    public OImmutableSchema(OSchemaShared schemaShared) {
        this.version = schemaShared.getVersion();
        this.identity = schemaShared.getIdentity();
        this.clustersCanNotBeSharedAmongClasses = schemaShared.isClustersCanNotBeSharedAmongClasses();
        this.clusterSelectionFactory = schemaShared.getClusterSelectionFactory();
        this.clustersToClasses = new HashMap<Integer, OClass>();
        this.classes = new HashMap<String, OClass>();
        for (OClass oClass : schemaShared.getClasses()) {
            OImmutableClass immutableClass = new OImmutableClass(oClass, this);
            this.classes.put(immutableClass.getName().toLowerCase(), immutableClass);
            if (immutableClass.getShortName() != null) {
                this.classes.put(immutableClass.getShortName().toLowerCase(), immutableClass);
            }
            for (int clusterId : immutableClass.getClusterIds()) {
                this.clustersToClasses.put(clusterId, immutableClass);
            }
        }
        this.properties = new ArrayList<OGlobalProperty>();
        for (OGlobalProperty globalProperty : schemaShared.getGlobalProperties()) {
            this.properties.add(globalProperty);
        }
    }

    @Override
    public OImmutableSchema makeSnapshot() {
        return this;
    }

    @Override
    public int countClasses() {
        return this.classes.size();
    }

    @Override
    public OClass createClass(Class<?> iClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(Class<?> iClass, int iDefaultClusterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, int iDefaultClusterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int iDefaultClusterId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int[] iClusterIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(Class<?> iClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass createAbstractClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dropClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsClass(String iClassName) {
        return this.classes.containsKey(iClassName.toLowerCase());
    }

    @Override
    public OClass getClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        return this.getClass(iClass.getSimpleName());
    }

    @Override
    public OClass getClass(String iClassName) {
        if (iClassName == null) {
            return null;
        }
        OClass cls = this.classes.get(iClassName.toLowerCase());
        if (cls != null) {
            return cls;
        }
        return null;
    }

    @Override
    public OClass getOrCreateClass(String iClassName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass getOrCreateClass(String iClassName, OClass iSuperClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<OClass> getClasses() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        return new HashSet<OClass>(this.classes.values());
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ORID getIdentity() {
        return new ORecordId(this.identity);
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<OClass> getClassesRelyOnCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        int clusterId = this.getDatabase().getClusterIdByName(clusterName);
        HashSet<OClass> result = new HashSet<OClass>();
        for (OClass c : this.classes.values()) {
            if (!OArrays.contains(c.getPolymorphicClusterIds(), clusterId)) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public OClass getClassByClusterId(int clusterId) {
        if (!this.clustersCanNotBeSharedAmongClasses) {
            throw new OSchemaException("This feature is not supported in current version of binary format.");
        }
        return this.clustersToClasses.get(clusterId);
    }

    @Override
    public OGlobalProperty getGlobalPropertyById(int id) {
        if (id >= this.properties.size()) {
            return null;
        }
        return this.properties.get(id);
    }

    @Override
    public List<OGlobalProperty> getGlobalProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    @Override
    public OGlobalProperty createGlobalProperty(String name, OType type, Integer id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClusterSelectionFactory getClusterSelectionFactory() {
        return this.clusterSelectionFactory;
    }

    @Override
    public boolean isFullCheckpointOnChange() {
        return false;
    }

    @Override
    public void setFullCheckpointOnChange(boolean fullCheckpointOnChange) {
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

