/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.processor.block;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.processor.OComposableProcessor;
import com.orientechnologies.orient.core.processor.block.OAbstractBlock;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OIterateBlock
extends OAbstractBlock {
    public static final String NAME = "iterate";

    @Override
    public Object processBlock(OComposableProcessor iManager, OCommandContext iContext, ODocument iConfig, ODocument iOutput, boolean iReadOnly) {
        OIterateBlockIterable result = null;
        String var = this.getFieldOfClass(iContext, iConfig, "variable", String.class);
        String range = this.getFieldOfClass(iContext, iConfig, "range", String.class);
        Object value = this.getField(iContext, iConfig, "value");
        if (range != null) {
            String[] fromTo = range.split("-");
            if (fromTo.length < 2) {
                throw new IllegalArgumentException("Invalid range for: " + range);
            }
            int from = Integer.parseInt(fromTo[0]);
            int to = Integer.parseInt(fromTo[1]);
            Object[] values = new Integer[Math.abs(to - from + 1)];
            if (from < to) {
                for (int i = from; i <= to; ++i) {
                    values[i - from] = i;
                }
            } else {
                for (int i = to; i >= from; --i) {
                    values[to - i] = i;
                }
            }
            result = new OIterateBlockIterable(values, iContext, var);
        } else if (value != null && OMultiValue.isIterable(value)) {
            result = OMultiValue.getMultiValueIterable(value);
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected class OIterateBlockIterable
    implements Iterable<Object> {
        private final Object[] objects;
        private final OCommandContext context;
        private final String variableName;

        public OIterateBlockIterable(Object[] o, OCommandContext iContext, String iVariableName) {
            this.objects = o;
            this.context = iContext;
            this.variableName = iVariableName;
        }

        @Override
        public Iterator<Object> iterator() {
            return new OIterateBlockIterator();
        }

        private class OIterateBlockIterator
        implements Iterator<Object> {
            private int p = 0;

            private OIterateBlockIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.p < OIterateBlockIterable.this.objects.length;
            }

            @Override
            public Object next() {
                if (this.p < OIterateBlockIterable.this.objects.length) {
                    Object value = OIterateBlockIterable.this.objects[this.p++];
                    OIterateBlockIterable.this.context.setVariable(OIterateBlockIterable.this.variableName, value);
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

