/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirtyFinder {
    public static Set<ORecord> findDirty(ODocument document) {
        HashSet<ORecord> all = new HashSet<ORecord>();
        DirtyFinder.checkObject(document, all);
        return all;
    }

    public static Set<ORecord> findDirties(Iterable<ORecord> records) {
        HashSet<ORecord> all = new HashSet<ORecord>();
        for (ORecord oRecord : all) {
            DirtyFinder.checkObject(oRecord, all);
        }
        return all;
    }

    public static void findDirties(ORecord record, Set<ORecord> allLocks) {
        DirtyFinder.checkObject(record, allLocks);
    }

    private static void checkObject(Object object, Set<ORecord> all) {
        if (object instanceof ODocument) {
            ODocument doc = (ODocument)object;
            if (all.contains(doc)) {
                return;
            }
            if (doc.isDirty()) {
                if (!doc.isEmbedded()) {
                    all.add(doc);
                }
                ORecordElement.STATUS prev = doc.getInternalStatus();
                doc.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
                for (Map.Entry<String, Object> entry : (ODocument)object) {
                    DirtyFinder.checkObject(entry.getValue(), all);
                }
                doc.setInternalStatus(prev);
            }
        } else if (object instanceof Iterable) {
            for (Object elem : (Iterable)object) {
                DirtyFinder.checkObject(elem, all);
            }
        } else if (object instanceof Map) {
            for (Object elem : ((Map)object).values()) {
                DirtyFinder.checkObject(elem, all);
            }
        } else if (object instanceof ORecord && ((ORecord)object).isDirty()) {
            all.add((ORecord)object);
        }
    }
}

