/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODetachable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueChangeListener;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODocument
extends ORecordAbstract
implements Iterable<Map.Entry<String, Object>>,
ORecordSchemaAware,
ODetachable,
Externalizable {
    public static final byte RECORD_TYPE = 100;
    protected static final String[] EMPTY_STRINGS = new String[0];
    private static final long serialVersionUID = 1L;
    private final ThreadLocal<OModifiableInteger> TO_STRING_DEPTH = new ThreadLocal<OModifiableInteger>(){

        @Override
        protected OModifiableInteger initialValue() {
            return new OModifiableInteger();
        }
    };
    protected Map<String, Object> _fieldValues;
    protected Map<String, Object> _fieldOriginalValues;
    protected Map<String, OType> _fieldTypes;
    protected Map<String, OSimpleMultiValueChangeListener<Object, Object>> _fieldChangeListeners;
    protected Map<String, OMultiValueChangeTimeLine<Object, Object>> _fieldCollectionChangeTimeLines;
    protected boolean _trackingChanges = true;
    protected boolean _ordered = true;
    protected boolean _lazyLoad = true;
    protected boolean _allowChainedAccess = true;
    protected transient List<WeakReference<ORecordElement>> _owners = null;
    protected OImmutableSchema _schema;
    private String _className;
    private OClass _immutableClazz;
    private int _immutableSchemaVersion = 1;

    public ODocument() {
        this.setup();
    }

    public ODocument(byte[] iSource) {
        this._source = iSource;
        this.setup();
    }

    public ODocument(InputStream iSource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OIOUtils.copyStream(iSource, out, -1L);
        this._source = out.toByteArray();
        this.setup();
    }

    public ODocument(ORID iRID) {
        this.setup();
        this._recordId = (ORecordId)iRID;
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._dirty = false;
        this._contentChanged = false;
    }

    public ODocument(String iClassName, ORID iRID) {
        this(iClassName);
        OImmutableSchema schema;
        OClass cls;
        this._recordId = (ORecordId)iRID;
        ODatabaseDocumentInternal database = this.getDatabaseInternal();
        if (this._recordId.clusterId > -1 && database.getStorageVersions().classesAreDetectedByClusterId() && (cls = (schema = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot()).getClassByClusterId(this._recordId.clusterId)) != null && !cls.getName().equals(iClassName)) {
            throw new IllegalArgumentException("Cluster id does not correspond class name should be " + iClassName + " but found " + cls.getName());
        }
        this._dirty = false;
        this._contentChanged = false;
        this._status = ORecordElement.STATUS.NOT_LOADED;
    }

    public ODocument(String iClassName) {
        this.setClassName(iClassName);
        this.setup();
    }

    public ODocument(OClass iClass) {
        this.setup();
        this._className = iClass == null ? null : iClass.getName();
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
    }

    public ODocument(Object[] iFields) {
        this.setup();
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
    }

    public ODocument(Map<?, Object> iFieldMap) {
        this.setup();
        if (iFieldMap != null && !iFieldMap.isEmpty()) {
            for (Map.Entry<?, Object> entry : iFieldMap.entrySet()) {
                this.field(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public ODocument(String iFieldName, Object iFieldValue, Object ... iFields) {
        this(iFields);
        this.field(iFieldName, iFieldValue);
    }

    protected static void validateField(ODocument iRecord, OProperty p) throws OValidationException {
        Object fieldValue;
        if (iRecord.containsField(p.getName())) {
            fieldValue = iRecord.rawField(p.getName());
            if (p.isNotNull() && fieldValue == null) {
                throw new OValidationException("The field '" + p.getFullName() + "' cannot be null, record: " + iRecord);
            }
            if (fieldValue != null && p.getRegexp() != null && !fieldValue.toString().matches(p.getRegexp())) {
                throw new OValidationException("The field '" + p.getFullName() + "' does not match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue + ", record: " + iRecord);
            }
        } else {
            if (p.isMandatory()) {
                throw new OValidationException("The field '" + p.getFullName() + "' is mandatory, but not found on record: " + iRecord);
            }
            fieldValue = null;
        }
        OType type = p.getType();
        if (fieldValue != null && type != null) {
            switch (type) {
                case LINK: {
                    ODocument.validateLink(p, fieldValue, false);
                    break;
                }
                case LINKLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue);
                    break;
                }
                case LINKSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, (Collection)fieldValue);
                    break;
                }
                case LINKMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as LINKMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    ODocument.validateLinkCollection(p, ((Map)fieldValue).values());
                    break;
                }
                case EMBEDDED: {
                    ODocument.validateEmbedded(p, fieldValue);
                    break;
                }
                case EMBEDDEDLIST: {
                    if (!(fieldValue instanceof List)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDLIST but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object e : (List)fieldValue) {
                            ODocument.validateEmbedded(p, e);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object e : (List)fieldValue) {
                            ODocument.validateType(p, e);
                        }
                    }
                    break;
                }
                case EMBEDDEDSET: {
                    if (!(fieldValue instanceof Set)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDSET but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Object e : (Set)fieldValue) {
                            ODocument.validateEmbedded(p, e);
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Object e : (Set)fieldValue) {
                            ODocument.validateType(p, e);
                        }
                    }
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(fieldValue instanceof Map)) {
                        throw new OValidationException("The field '" + p.getFullName() + "' has been declared as EMBEDDEDMAP but an incompatible type is used. Value: " + fieldValue);
                    }
                    if (p.getLinkedClass() != null) {
                        for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                            ODocument.validateEmbedded(p, entry.getValue());
                        }
                    } else {
                        if (p.getLinkedType() == null) break;
                        for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                            ODocument.validateType(p, entry.getValue());
                        }
                    }
                    break;
                }
            }
        }
        if (p.getMin() != null) {
            String min = p.getMin();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer characters than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer bytes than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) < Long.parseLong(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) < Float.parseFloat(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) < Double.parseDouble(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabaseInternal().getStorage().getConfiguration().getDateFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which precedes the first acceptable date (" + min + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabaseInternal().getStorage().getConfiguration().getDateTimeFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the datetime " + fieldValue + " which precedes the first acceptable datetime (" + min + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains fewer items than " + min + " requested");
            }
        }
        if (p.getMax() != null) {
            String max = p.getMax();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more characters than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more bytes than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) > Long.parseLong(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) > Float.parseFloat(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) > Double.parseDouble(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabaseInternal().getStorage().getConfiguration().getDateFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the date " + fieldValue + " which is after the last acceptable date (" + max + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabaseInternal().getStorage().getConfiguration().getDateTimeFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + p.getFullName() + "' contains the datetime " + fieldValue + " which is after the last acceptable datetime (" + max + ")");
                    }
                }
                catch (ParseException parseException) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + p.getFullName() + "' contains more items than " + max + " requested");
            }
        }
        if (p.isReadonly() && iRecord instanceof ODocument && !iRecord.getRecordVersion().isTombstone()) {
            for (String f : iRecord.getDirtyFields()) {
                boolean simple;
                if (!f.equals(p.getName())) continue;
                Object orgVal = iRecord.getOriginalValue(f);
                boolean bl = simple = fieldValue != null ? OType.isSimpleType(fieldValue) : OType.isSimpleType(orgVal);
                if (!(simple || fieldValue != null && orgVal == null || fieldValue == null && orgVal != null) && (fieldValue == null || fieldValue.equals(orgVal))) continue;
                throw new OValidationException("The field '" + p.getFullName() + "' is immutable and cannot be altered. Field value is: " + iRecord.field(f));
            }
        }
    }

    protected static void validateLinkCollection(OProperty property, Collection<Object> values) {
        if (property.getLinkedClass() != null) {
            boolean autoconvert = false;
            if (values instanceof ORecordLazyMultiValue) {
                autoconvert = ((ORecordLazyMultiValue)((Object)values)).isAutoConvertToRecord();
                ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(false);
            }
            for (Object object : values) {
                ODocument.validateLink(property, object, OSecurityShared.ALLOW_FIELDS.contains(property.getName()));
            }
            if (values instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)values)).setAutoConvertToRecord(autoconvert);
            }
        }
    }

    protected static void validateType(OProperty p, Object value) {
        if (value != null && OType.convert(value, p.getLinkedType().getDefaultJavaType()) == null) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + (Object)((Object)p.getLinkedType()) + "' but the value is " + value);
        }
    }

    protected static void validateLink(OProperty p, Object fieldValue, boolean allowNull) {
        Object linkedRecord;
        if (fieldValue == null) {
            if (allowNull) {
                return;
            }
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but contains a null record (probably a deleted record?)");
        }
        if (fieldValue instanceof OIdentifiable) {
            linkedRecord = ((OIdentifiable)fieldValue).getRecord();
        } else if (fieldValue instanceof String) {
            linkedRecord = new ORecordId((String)fieldValue).getRecord();
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is not a record or a record-id");
        }
        if (linkedRecord != null && p.getLinkedClass() != null) {
            if (!(linkedRecord instanceof ODocument)) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + p.getLinkedClass() + "' but the value is the record " + linkedRecord.getIdentity() + " that is not a document");
            }
            ODocument doc = (ODocument)linkedRecord;
            if (doc.getImmutableSchemaClass() != null && !p.getLinkedClass().isSuperClassOf(doc.getImmutableSchemaClass())) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " of type '" + p.getLinkedClass().getName() + "' but the value is the document " + linkedRecord.getIdentity() + " of class '" + doc.getImmutableSchemaClass() + "'");
            }
        }
    }

    protected static void validateEmbedded(OProperty p, Object fieldValue) {
        if (fieldValue instanceof ORecordId) {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is the RecordID " + fieldValue);
        }
        if (fieldValue instanceof OIdentifiable) {
            OIdentifiable embedded = (OIdentifiable)fieldValue;
            if (embedded.getIdentity().isValid()) {
                throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but the value is a document with the valid RecordID " + fieldValue);
            }
            OClass embeddedClass = p.getLinkedClass();
            if (embeddedClass != null) {
                Object embeddedRecord = embedded.getRecord();
                if (!(embeddedRecord instanceof ODocument)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record was not a document");
                }
                ODocument doc = (ODocument)embeddedRecord;
                if (doc.getImmutableSchemaClass() == null) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record has no class");
                }
                if (!doc.getImmutableSchemaClass().isSubClassOf(embeddedClass)) {
                    throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " with linked class '" + embeddedClass + "' but the record is of class '" + doc.getImmutableSchemaClass().getName() + "' that is not a subclass of that");
                }
                doc.validate();
            }
        } else {
            throw new OValidationException("The field '" + p.getFullName() + "' has been declared as " + (Object)((Object)p.getType()) + " but an incompatible type is used. Value: " + fieldValue);
        }
    }

    public ODocument copy() {
        return (ODocument)this.copyTo(new ODocument());
    }

    @Override
    public ORecordAbstract copyTo(ORecordAbstract iDestination) {
        this.checkForFields(new String[0]);
        ODocument destination = (ODocument)iDestination;
        super.copyTo(iDestination);
        destination._ordered = this._ordered;
        destination._className = this._className;
        destination._immutableSchemaVersion = -1;
        destination._immutableClazz = null;
        destination._trackingChanges = this._trackingChanges;
        destination._owners = this._owners != null ? new ArrayList<WeakReference<ORecordElement>>(this._owners) : null;
        if (this._fieldValues != null) {
            destination._fieldValues = this._fieldValues instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
            for (Map.Entry<String, Object> entry : this._fieldValues.entrySet()) {
                ODocumentHelper.copyFieldValue(destination, entry);
            }
        } else {
            destination._fieldValues = null;
        }
        destination._fieldTypes = this._fieldTypes != null ? new HashMap<String, OType>(this._fieldTypes) : null;
        destination._fieldChangeListeners = null;
        destination._fieldCollectionChangeTimeLines = null;
        destination._fieldOriginalValues = null;
        destination.addAllMultiValueChangeListeners();
        destination._dirty = this._dirty;
        destination._contentChanged = this._contentChanged;
        return destination;
    }

    public ORecord placeholder() {
        ODocument cloned = new ODocument();
        cloned._source = null;
        cloned._recordId = this._recordId;
        cloned._status = ORecordElement.STATUS.NOT_LOADED;
        cloned._dirty = false;
        cloned._contentChanged = false;
        return cloned;
    }

    @Override
    public boolean detach() {
        this.deserializeFields(new String[0]);
        boolean fullyDetached = true;
        if (this._fieldValues != null) {
            for (Map.Entry<String, Object> entry : this._fieldValues.entrySet()) {
                Object fieldValue = entry.getValue();
                if (fieldValue instanceof ORecord) {
                    if (((ORecord)fieldValue).getIdentity().isNew()) {
                        fullyDetached = false;
                    } else {
                        this._fieldValues.put(entry.getKey(), ((ORecord)fieldValue).getIdentity());
                    }
                }
                if (!(fieldValue instanceof ODetachable) || ((ODetachable)fieldValue).detach()) continue;
                fullyDetached = false;
            }
        }
        return fullyDetached;
    }

    public ODocument load(String iFetchPlan) {
        return this.load(iFetchPlan, false);
    }

    public ODocument load(String iFetchPlan, boolean iIgnoreCache) {
        Object result;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache);
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found", e);
        }
        if (result == null) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found");
        }
        return (ODocument)result;
    }

    @Deprecated
    public ODocument load(String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone) {
        Object result;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found", e);
        }
        if (result == null) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found");
        }
        return (ODocument)result;
    }

    @Override
    public ODocument reload(String iFetchPlan, boolean iIgnoreCache) {
        super.reload(iFetchPlan, iIgnoreCache);
        if (!this._lazyLoad) {
            this.checkForFields(new String[0]);
            this.checkForLoading();
        }
        return this;
    }

    public boolean hasSameContentOf(ODocument iOther) {
        ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        return ODocumentHelper.hasSameContentOf(this, currentDb, iOther, currentDb, null);
    }

    @Override
    public byte[] toStream() {
        if (this._recordFormat == null) {
            this.setup();
        }
        return this.toStream(false);
    }

    public Map<String, Object> toMap() {
        String className;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : this.fieldNames()) {
            map.put(field, this.field(field));
        }
        ORID id = this.getIdentity();
        if (id.isValid()) {
            map.put("@rid", id);
        }
        if ((className = this.getClassName()) != null) {
            map.put("@class", className);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.TO_STRING_DEPTH.get().increment();
        try {
            if (this.TO_STRING_DEPTH.get().intValue() > 1) {
                String string = "<recursion:rid=" + (this._recordId != null ? this._recordId : "null") + ">";
                return string;
            }
            boolean saveDirtyStatus = this._dirty;
            boolean oldUpdateContent = this._contentChanged;
            try {
                StringBuilder buffer = new StringBuilder(128);
                this.checkForFields(new String[0]);
                OClass _clazz = this.getImmutableSchemaClass();
                if (_clazz != null) {
                    buffer.append(_clazz.getStreamableName());
                }
                if (this._recordId != null && this._recordId.isValid()) {
                    buffer.append(this._recordId);
                }
                boolean first = true;
                for (Map.Entry<String, Object> f : this._fieldValues.entrySet()) {
                    buffer.append(first ? (char)'{' : ',');
                    buffer.append(f.getKey());
                    buffer.append(':');
                    if (f.getValue() == null) {
                        buffer.append("null");
                    } else if (f.getValue() instanceof Collection || f.getValue().getClass().isArray()) {
                        buffer.append('[');
                        buffer.append(OMultiValue.getSize(f.getValue()));
                        buffer.append(']');
                    } else if (f.getValue() instanceof ORecord) {
                        ORecord record = (ORecord)f.getValue();
                        if (record.getIdentity().isValid()) {
                            record.getIdentity().toString(buffer);
                        } else {
                            buffer.append(record.toString());
                        }
                    } else {
                        buffer.append(f.getValue());
                    }
                    if (!first) continue;
                    first = false;
                }
                if (!first) {
                    buffer.append('}');
                }
                if (this._recordId != null && this._recordId.isValid()) {
                    buffer.append(" v");
                    buffer.append(this._recordVersion);
                }
                String string = buffer.toString();
                this._dirty = saveDirtyStatus;
                this._contentChanged = oldUpdateContent;
                return string;
            }
            catch (Throwable throwable) {
                this._dirty = saveDirtyStatus;
                this._contentChanged = oldUpdateContent;
                throw throwable;
            }
        }
        finally {
            this.TO_STRING_DEPTH.get().decrement();
        }
    }

    @Deprecated
    public void fromString(String iValue) {
        this._dirty = true;
        this._contentChanged = true;
        this._source = OBinaryProtocol.string2bytes(iValue);
        this.removeAllCollectionChangeListeners();
        this._fieldCollectionChangeTimeLines = null;
        this._fieldOriginalValues = null;
        this._fieldTypes = null;
        this._fieldValues = null;
    }

    @Override
    public String[] fieldNames() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if (this._fieldValues == null || this._fieldValues.size() == 0) {
            return EMPTY_STRINGS;
        }
        return this._fieldValues.keySet().toArray(new String[this._fieldValues.size()]);
    }

    @Override
    public Object[] fieldValues() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this._fieldValues.values().toArray(new Object[this._fieldValues.size()]);
    }

    public <RET> RET rawField(String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        this.checkForLoading();
        if (!this.checkForFields(iFieldName)) {
            return null;
        }
        if (!this._allowChainedAccess || iFieldName.charAt(0) != '@' && OStringSerializerHelper.indexOf(iFieldName, 0, '.', '[') == -1) {
            return (RET)this._fieldValues.get(iFieldName);
        }
        return ODocumentHelper.getFieldValue(this, iFieldName);
    }

    @Override
    public <RET> RET field(String iFieldName) {
        Object newValue;
        RET value = this.rawField(iFieldName);
        if (!iFieldName.startsWith("@") && this._lazyLoad && value instanceof ORID && (((ORID)value).isPersistent() || ((ORID)value).isNew()) && ODatabaseRecordThreadLocal.INSTANCE.isDefined() && (newValue = this.getDatabase().load((ORID)value)) != null) {
            value = newValue;
            if (!iFieldName.contains(".")) {
                this.removeCollectionChangeListener(iFieldName, this._fieldValues.get(iFieldName));
                this.removeCollectionTimeLine(iFieldName);
                this._fieldValues.put(iFieldName, value);
                this.addCollectionChangeListener(iFieldName, value);
            }
        }
        return value;
    }

    public <RET> RET field(String iFieldName, Class<?> iFieldType) {
        RET value = this.rawField(iFieldName);
        if (value != null) {
            value = ODocumentHelper.convertField(this, iFieldName, iFieldType, value);
        }
        return value;
    }

    @Override
    public <RET> RET field(String iFieldName, OType iFieldType) {
        OType original;
        Object value = this.field(iFieldName);
        if (iFieldType != null && iFieldType != (original = this.fieldType(iFieldName))) {
            if (original == null && iFieldType == (original = OType.getTypeByValue(value))) {
                return value;
            }
            Object newValue = null;
            newValue = iFieldType == OType.BINARY && value instanceof String ? OStringSerializerHelper.getBinaryContent(value) : (iFieldType == OType.DATE && value instanceof Long ? (Object)new Date((Long)value) : ((iFieldType == OType.EMBEDDEDSET || iFieldType == OType.LINKSET) && value instanceof List ? (Object)Collections.unmodifiableSet((Set)ODocumentHelper.convertField(this, iFieldName, Set.class, value)) : ((iFieldType == OType.EMBEDDEDLIST || iFieldType == OType.LINKLIST) && value instanceof Set ? (Object)Collections.unmodifiableList((List)ODocumentHelper.convertField(this, iFieldName, List.class, value)) : ((iFieldType == OType.EMBEDDEDMAP || iFieldType == OType.LINKMAP) && value instanceof Map ? (Object)Collections.unmodifiableMap((Map)ODocumentHelper.convertField(this, iFieldName, Map.class, value)) : (Object)OType.convert(value, iFieldType.getDefaultJavaType())))));
            if (newValue != null) {
                value = newValue;
            }
        }
        return value;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue) {
        return this.field(iFieldName, iPropertyValue, new OType[0]);
    }

    public ODocument fields(String iFieldName, Object iFieldValue, Object ... iFields) {
        if (iFields != null && iFields.length % 2 != 0) {
            throw new IllegalArgumentException("Fields must be passed in pairs as name and value");
        }
        this.field(iFieldName, iFieldValue);
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
        return this;
    }

    @Deprecated
    public ODocument fields(Map<String, Object> iMap) {
        return this.fromMap(iMap);
    }

    public ODocument fromMap(Map<String, Object> iMap) {
        if (iMap != null) {
            for (Map.Entry<String, Object> entry : iMap.entrySet()) {
                this.field(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public ODocument field(String iFieldName, Object iPropertyValue, OType ... iFieldType) {
        ORidBag ridBag;
        int lastSep;
        if ("@class".equals(iFieldName)) {
            this.setClassName(iPropertyValue.toString());
            return this;
        }
        if ("@rid".equals(iFieldName)) {
            this._recordId.fromString(iPropertyValue.toString());
            return this;
        }
        int n = lastSep = this._allowChainedAccess ? iFieldName.lastIndexOf(46) : -1;
        if (lastSep > -1) {
            Object subObject = this.field(iFieldName.substring(0, lastSep));
            if (subObject != null) {
                String subFieldName = iFieldName.substring(lastSep + 1);
                if (subObject instanceof ODocument) {
                    ((ODocument)subObject).field(subFieldName, iPropertyValue);
                    return ((ODocument)subObject).isEmbedded() ? this : subObject;
                }
                if (subObject instanceof Map) {
                    ((Map)subObject).put(subFieldName, iPropertyValue);
                } else if (OMultiValue.isMultiValue(subObject)) {
                    for (Object subObjectItem : OMultiValue.getMultiValueIterable(subObject)) {
                        if (subObjectItem instanceof ODocument) {
                            if (!((ODocument)subObjectItem).isEmbedded()) {
                                throw new IllegalArgumentException("Property '" + iFieldName + "' points to linked collection of items. You can only change embedded documents in this way");
                            }
                            ((ODocument)subObjectItem).field(subFieldName, iPropertyValue);
                            continue;
                        }
                        if (!(subObjectItem instanceof Map)) continue;
                        ((Map)subObjectItem).put(subFieldName, iPropertyValue);
                    }
                    return this;
                }
            }
            return null;
        }
        iFieldName = this.checkFieldName(iFieldName);
        this.checkForLoading();
        this.checkForFields(new String[0]);
        boolean knownProperty = this._fieldValues.containsKey(iFieldName);
        Object oldValue = this._fieldValues.get(iFieldName);
        OType oldType = this.fieldType(iFieldName);
        OType fieldType = this.deriveFieldType(iFieldName, iFieldType);
        if (iPropertyValue != null && fieldType != null) {
            iPropertyValue = ODocumentHelper.convertField(this, iFieldName, fieldType.getDefaultJavaType(), iPropertyValue);
        } else if (iPropertyValue instanceof Enum) {
            iPropertyValue = iPropertyValue.toString();
        }
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return this;
                }
            } else {
                try {
                    if (iPropertyValue.equals(oldValue) && (iFieldType == null || iFieldType.length == 0 || iFieldType[0] == oldType)) {
                        if (!(iPropertyValue instanceof ORecordElement)) {
                            this.setDirty();
                        }
                        return this;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iFieldName, this.getIdentity());
                }
            }
        }
        if (oldValue instanceof ORidBag) {
            ridBag = (ORidBag)oldValue;
            ridBag.setOwner(null);
        } else if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        if (iPropertyValue != null) {
            if (OType.EMBEDDED.equals((Object)fieldType) && iPropertyValue instanceof ODocument) {
                ODocument embeddedDocument = (ODocument)iPropertyValue;
                ODocumentInternal.addOwner(embeddedDocument, this);
            }
            if (iPropertyValue instanceof ORidBag) {
                ridBag = (ORidBag)iPropertyValue;
                ridBag.setOwner(null);
                ridBag.setOwner(this);
            }
        }
        if (oldType != fieldType && oldType != null && (iPropertyValue == null || fieldType != null || oldType != OType.getTypeByValue(iPropertyValue))) {
            this.setFieldType(iFieldName, fieldType);
        }
        this.removeCollectionChangeListener(iFieldName, this._fieldValues.get(iFieldName));
        this.removeCollectionTimeLine(iFieldName);
        this._fieldValues.put(iFieldName, iPropertyValue);
        this.addCollectionChangeListener(iFieldName, iPropertyValue);
        if (this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this.setDirty();
            this.saveOldFieldValue(iFieldName, oldValue);
        }
        return this;
    }

    @Override
    public Object removeField(String iFieldName) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        boolean knownProperty = this._fieldValues.containsKey(iFieldName);
        Object oldValue = this._fieldValues.get(iFieldName);
        if (knownProperty && this._trackingChanges) {
            if (this._fieldOriginalValues == null) {
                this._fieldOriginalValues = new HashMap<String, Object>();
            }
            if (!this._fieldOriginalValues.containsKey(iFieldName)) {
                this._fieldOriginalValues.put(iFieldName, oldValue);
            }
        }
        this.removeCollectionTimeLine(iFieldName);
        this.removeCollectionChangeListener(iFieldName, oldValue);
        this._fieldValues.remove(iFieldName);
        this._source = null;
        this.setDirty();
        return oldValue;
    }

    public ODocument merge(ODocument iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        iOther.checkForLoading();
        iOther.checkForFields(new String[0]);
        if (this._className == null && iOther.getImmutableSchemaClass() != null) {
            this._className = iOther.getImmutableSchemaClass().getName();
        }
        return this.merge(iOther._fieldValues, iUpdateOnlyMode, iMergeSingleItemsOfMultiValueFields);
    }

    public ODocument merge(Map<String, Object> iOther, boolean iUpdateOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this._source = null;
        for (String f : iOther.keySet()) {
            Object value = this.field(f);
            Object otherValue = iOther.get(f);
            if (this.containsField(f) && iMergeSingleItemsOfMultiValueFields) {
                if (value instanceof Map) {
                    Map map = (Map)value;
                    Map otherMap = (Map)otherValue;
                    for (Map.Entry entry : otherMap.entrySet()) {
                        map.put(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (OMultiValue.isMultiValue(value) && !(value instanceof ORidBag)) {
                    for (Object item : OMultiValue.getMultiValueIterable(otherValue)) {
                        if (OMultiValue.contains(value, item)) continue;
                        OMultiValue.add(value, item);
                    }
                    continue;
                }
            }
            this.setFieldType(f, null);
            boolean bagsMerged = false;
            if (value instanceof ORidBag && otherValue instanceof ORidBag) {
                bagsMerged = ((ORidBag)value).tryMerge((ORidBag)otherValue, iMergeSingleItemsOfMultiValueFields);
            }
            if ((bagsMerged || value == null || value.equals(otherValue)) && (value != null || otherValue == null)) continue;
            if (otherValue instanceof ORidBag) {
                ((ORidBag)otherValue).convertLinks2Records();
            }
            this.field(f, otherValue);
        }
        if (!iUpdateOnlyMode) {
            for (String f : this.fieldNames()) {
                if (iOther.containsKey(f)) continue;
                this.removeField(f);
            }
        }
        return this;
    }

    public String[] getDirtyFields() {
        if ((this._fieldOriginalValues == null || this._fieldOriginalValues.isEmpty()) && (this._fieldCollectionChangeTimeLines == null || this._fieldCollectionChangeTimeLines.isEmpty())) {
            return EMPTY_STRINGS;
        }
        HashSet<String> dirtyFields = new HashSet<String>();
        if (this._fieldOriginalValues != null) {
            dirtyFields.addAll(this._fieldOriginalValues.keySet());
        }
        if (this._fieldCollectionChangeTimeLines != null) {
            dirtyFields.addAll(this._fieldCollectionChangeTimeLines.keySet());
        }
        return dirtyFields.toArray(new String[dirtyFields.size()]);
    }

    public Object getOriginalValue(String iFieldName) {
        return this._fieldOriginalValues != null ? this._fieldOriginalValues.get(iFieldName) : null;
    }

    public OMultiValueChangeTimeLine<Object, Object> getCollectionTimeLine(String iFieldName) {
        return this._fieldCollectionChangeTimeLines != null ? this._fieldCollectionChangeTimeLines.get(iFieldName) : null;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        if (this._fieldValues == null) {
            return OEmptyMapEntryIterator.INSTANCE;
        }
        final Iterator<Map.Entry<String, Object>> iterator = this._fieldValues.entrySet().iterator();
        return new Iterator<Map.Entry<String, Object>>(){
            private Map.Entry<String, Object> current;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                this.current = (Map.Entry)iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                iterator.remove();
                if (ODocument.this._trackingChanges) {
                    if (ODocument.this._fieldOriginalValues == null) {
                        ODocument.this._fieldOriginalValues = new HashMap<String, Object>();
                    }
                    if (!ODocument.this._fieldOriginalValues.containsKey(this.current.getKey())) {
                        ODocument.this._fieldOriginalValues.put(this.current.getKey(), this.current.getValue());
                    }
                }
                ODocument.this.removeCollectionChangeListener(this.current.getKey(), this.current.getValue());
                ODocument.this.removeCollectionTimeLine(this.current.getKey());
            }
        };
    }

    @Override
    public boolean containsField(String iFieldName) {
        if (iFieldName == null) {
            return false;
        }
        this.checkForLoading();
        this.checkForFields(iFieldName);
        return this._fieldValues.containsKey(iFieldName);
    }

    public boolean hasOwners() {
        return this._owners != null && !this._owners.isEmpty();
    }

    @Override
    public ORecordElement getOwner() {
        if (this._owners == null) {
            return null;
        }
        for (WeakReference<ORecordElement> _owner : this._owners) {
            ORecordElement e = (ORecordElement)_owner.get();
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public Iterable<ORecordElement> getOwners() {
        if (this._owners == null) {
            return Collections.emptyList();
        }
        ArrayList<ORecordElement> result = new ArrayList<ORecordElement>();
        for (WeakReference<ORecordElement> o : this._owners) {
            result.add((ORecordElement)o.get());
        }
        return result;
    }

    @Override
    public ORecordAbstract setDirty() {
        if (this._owners != null) {
            for (WeakReference<ORecordElement> o : this._owners) {
                ORecordElement e = (ORecordElement)o.get();
                if (e == null) continue;
                e.setDirty();
            }
        }
        this.checkForFields(new String[0]);
        return super.setDirty();
    }

    @Override
    public void setDirtyNoChanged() {
        if (this._owners != null) {
            for (WeakReference<ORecordElement> o : this._owners) {
                ORecordElement e = (ORecordElement)o.get();
                if (e == null) continue;
                e.setDirtyNoChanged();
            }
        }
        this.checkForFields(new String[0]);
        super.setDirtyNoChanged();
    }

    @Override
    public ODocument fromStream(byte[] iRecordBuffer) {
        this.removeAllCollectionChangeListeners();
        this._fieldValues = null;
        this._fieldTypes = null;
        this._fieldOriginalValues = null;
        this._fieldChangeListeners = null;
        this._fieldCollectionChangeTimeLines = null;
        this._contentChanged = false;
        this._schema = null;
        this.fetchSchemaIfCan();
        super.fromStream(iRecordBuffer);
        if (!this._lazyLoad) {
            this.checkForFields(new String[0]);
            this.checkForLoading();
        }
        return this;
    }

    public OType fieldType(String iFieldName) {
        this.checkForFields(iFieldName);
        return this._fieldTypes != null ? this._fieldTypes.get(iFieldName) : null;
    }

    @Override
    public ODocument unload() {
        super.unload();
        this.internalReset();
        return this;
    }

    @Override
    public ODocument clear() {
        super.clear();
        if (this._fieldValues != null) {
            if (this._fieldOriginalValues == null) {
                this._fieldOriginalValues = new HashMap<String, Object>();
            }
            for (Map.Entry<String, Object> entry : this._fieldValues.entrySet()) {
                if (this._fieldOriginalValues.containsKey(entry.getKey())) continue;
                this._fieldOriginalValues.put(entry.getKey(), entry.getValue());
            }
        }
        this.internalReset();
        this._owners = null;
        return this;
    }

    @Override
    public ODocument reset() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot reset documents during a transaction. Create a new one each time");
        }
        super.reset();
        this._className = null;
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        this.internalReset();
        if (this._fieldOriginalValues != null) {
            this._fieldOriginalValues.clear();
        }
        this._owners = null;
        return this;
    }

    public ODocument undo() {
        if (!this._trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this._fieldOriginalValues != null) {
            for (Map.Entry<String, Object> entry : this._fieldOriginalValues.entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    this._fieldValues.remove(entry.getKey());
                    continue;
                }
                this._fieldValues.put(entry.getKey(), entry.getValue());
            }
            this._fieldOriginalValues.clear();
        }
        return this;
    }

    public ODocument undo(String field) {
        if (!this._trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        if (this._fieldOriginalValues != null && this._fieldOriginalValues.containsKey(field)) {
            Object value = this._fieldOriginalValues.get(field);
            if (value == null) {
                this._fieldValues.remove(field);
            } else {
                this._fieldValues.put(field, value);
            }
            this._fieldOriginalValues.remove(field);
        }
        return this;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void setLazyLoad(boolean iLazyLoad) {
        this._lazyLoad = iLazyLoad;
        this.checkForFields(new String[0]);
        if (this._fieldValues != null) {
            for (Map.Entry<String, Object> field : this._fieldValues.entrySet()) {
                if (!(field.getValue() instanceof ORecordLazyMultiValue)) continue;
                ((ORecordLazyMultiValue)field.getValue()).setAutoConvertToRecord(false);
            }
        }
    }

    public boolean isTrackingChanges() {
        return this._trackingChanges;
    }

    public ODocument setTrackingChanges(boolean iTrackingChanges) {
        this._trackingChanges = iTrackingChanges;
        if (!iTrackingChanges) {
            this._fieldOriginalValues = null;
            this.removeAllCollectionChangeListeners();
            this._fieldChangeListeners = null;
            this._fieldCollectionChangeTimeLines = null;
        } else {
            this.addAllMultiValueChangeListeners();
        }
        return this;
    }

    public boolean isOrdered() {
        return this._ordered;
    }

    public ODocument setOrdered(boolean iOrdered) {
        this._ordered = iOrdered;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj || this._recordId.isValid();
    }

    @Override
    public int hashCode() {
        if (this._recordId.isValid()) {
            return super.hashCode();
        }
        return System.identityHashCode(this);
    }

    @Override
    public int fields() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this._fieldValues == null ? 0 : this._fieldValues.size();
    }

    public boolean isEmpty() {
        this.checkForLoading();
        this.checkForFields(new String[0]);
        return this._fieldValues == null || this._fieldValues.isEmpty();
    }

    public ODocument fromJSON(String iSource, String iOptions) {
        return (ODocument)super.fromJSON(iSource, iOptions);
    }

    public ODocument fromJSON(String iSource) {
        return (ODocument)super.fromJSON(iSource);
    }

    public ODocument fromJSON(InputStream iContentResult) throws IOException {
        return (ODocument)super.fromJSON(iContentResult);
    }

    public ODocument fromJSON(String iSource, boolean needReload) {
        return (ODocument)super.fromJSON(iSource, needReload);
    }

    public boolean isEmbedded() {
        return this._owners != null && !this._owners.isEmpty();
    }

    public ODocument setFieldType(String iFieldName, OType iFieldType) {
        if (iFieldType != null) {
            if (this._fieldTypes == null) {
                this._fieldTypes = new HashMap<String, OType>();
            }
            this._fieldTypes.put(iFieldName, iFieldType);
        } else if (this._fieldTypes != null) {
            this._fieldTypes.remove(iFieldName);
            if (this._fieldTypes.size() == 0) {
                this._fieldTypes = null;
            }
        }
        return this;
    }

    @Override
    public ODocument save() {
        return (ODocument)this.save(null, false);
    }

    @Override
    public ODocument save(String iClusterName) {
        return (ODocument)this.save(iClusterName, false);
    }

    @Override
    public ORecordAbstract save(String iClusterName, boolean forceCreate) {
        return (ORecordAbstract)this.getDatabase().save(this, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, forceCreate, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeFields(String ... iFields) {
        if (this._source == null) {
            return true;
        }
        if (iFields != null && iFields.length > 0) {
            int pos2;
            for (int i = 0; i < iFields.length; ++i) {
                int pos;
                String f = iFields[i];
                if (f.startsWith("@")) continue;
                int pos1 = f.indexOf(91);
                pos2 = f.indexOf(46);
                if (pos1 <= -1 && pos2 <= -1) continue;
                int n = pos = pos1 > -1 ? pos1 : pos2;
                if (pos2 > -1 && pos2 < pos) {
                    pos = pos2;
                }
                iFields[i] = f.substring(0, pos);
            }
            if (this._fieldValues != null && !this._fieldValues.isEmpty()) {
                boolean allFound = true;
                String[] stringArray = iFields;
                int n = stringArray.length;
                for (pos2 = 0; pos2 < n; ++pos2) {
                    String f = stringArray[pos2];
                    if (f.startsWith("@") || this._fieldValues.containsKey(f)) continue;
                    allFound = false;
                    break;
                }
                if (allFound) {
                    return true;
                }
            }
        }
        if (this._recordFormat == null) {
            this.setup();
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        try {
            this._recordFormat.fromStream(this._source, this, iFields);
        }
        finally {
            this._status = ORecordElement.STATUS.LOADED;
        }
        if (iFields != null && iFields.length > 0) {
            for (String field : iFields) {
                if (!field.startsWith("@")) continue;
                return true;
            }
            if (this._fieldValues != null && !this._fieldValues.isEmpty()) {
                for (String f : iFields) {
                    if (!this._fieldValues.containsKey(f)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this._source != null) {
            this._source = null;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        byte[] idBuffer = this._recordId.toStream();
        stream.writeInt(-1);
        stream.writeInt(idBuffer.length);
        stream.write(idBuffer);
        this._recordVersion.getSerializer().writeTo(stream, this._recordVersion);
        byte[] content = this.toStream();
        stream.writeInt(content.length);
        stream.write(content);
        stream.writeBoolean(this._dirty);
        stream.writeObject(this._recordFormat.toString());
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i = stream.readInt();
        int size = i < 0 ? stream.readInt() : i;
        byte[] idBuffer = new byte[size];
        stream.readFully(idBuffer);
        this._recordId.fromStream(idBuffer);
        this._recordVersion.getSerializer().readFrom(stream, this._recordVersion);
        int len = stream.readInt();
        byte[] content = new byte[len];
        stream.readFully(content);
        this._dirty = stream.readBoolean();
        if (i < 0) {
            String str = (String)stream.readObject();
            this._recordFormat = ORecordSerializerFactory.instance().getFormat(str);
        }
        this.fromStream(content);
    }

    public boolean isAllowChainedAccess() {
        return this._allowChainedAccess;
    }

    public ODocument setAllowChainedAccess(boolean _allowChainedAccess) {
        this._allowChainedAccess = _allowChainedAccess;
        return this;
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        if (iClassName == null) {
            this._className = null;
            return;
        }
        OClass _clazz = ((OMetadataInternal)this.getDatabase().getMetadata()).getImmutableSchemaSnapshot().getClass(iClassName);
        if (_clazz != null) {
            this._className = _clazz.getName();
            this.convertFieldsToClass(_clazz);
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this._className == null) {
            this.fetchClassName();
        }
        if (this._className == null) {
            return null;
        }
        ODatabaseDocument databaseRecord = this.getDatabaseIfDefined();
        if (databaseRecord != null) {
            return databaseRecord.getMetadata().getSchema().getClass(this._className);
        }
        return null;
    }

    @Override
    public String getClassName() {
        if (this._className == null) {
            this.getImmutableSchemaClass();
        }
        return this._className;
    }

    @Override
    public void setClassName(String className) {
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        if (className == null) {
            this._className = null;
            return;
        }
        OMetadataInternal metadata = (OMetadataInternal)this.getDatabase().getMetadata();
        this._immutableClazz = metadata.getImmutableSchemaSnapshot().getClass(className);
        OClass clazz = this._immutableClazz != null ? this._immutableClazz : metadata.getSchema().getOrCreateClass(className);
        if (clazz != null) {
            this._className = clazz.getName();
            this.convertFieldsToClass(clazz);
        }
    }

    @Override
    public void validate() throws OValidationException {
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !this.getDatabase().isValidationEnabled()) {
            return;
        }
        this.checkForLoading();
        this.checkForFields(new String[0]);
        this.autoConvertValues();
        OClass immutableSchemaClass = this.getImmutableSchemaClass();
        if (immutableSchemaClass != null) {
            if (immutableSchemaClass.isStrictMode()) {
                for (String f : this.fieldNames()) {
                    if (immutableSchemaClass.getProperty(f) != null) continue;
                    throw new OValidationException("Found additional field '" + (String)f + "'. It cannot be added because the schema class '" + immutableSchemaClass.getName() + "' is defined as STRICT");
                }
            }
            for (OProperty p : immutableSchemaClass.properties()) {
                ODocument.validateField(this, p);
            }
        }
    }

    @Override
    protected ORecordAbstract fill(ORID iRid, ORecordVersion iVersion, byte[] iBuffer, boolean iDirty) {
        this._schema = null;
        this.fetchSchemaIfCan();
        return super.fill(iRid, iVersion, iBuffer, iDirty);
    }

    @Override
    protected void clearSource() {
        super.clearSource();
        this._schema = null;
    }

    protected OGlobalProperty getGlobalPropertyById(int id) {
        OGlobalProperty prop;
        if (!ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            return null;
        }
        if (this._schema == null) {
            OMetadataInternal metadata = (OMetadataInternal)this.getDatabase().getMetadata();
            this._schema = metadata.getImmutableSchemaSnapshot();
        }
        if ((prop = this._schema.getGlobalPropertyById(id)) == null) {
            ODatabaseDocumentInternal db = this.getDatabase();
            if (db == null || db.isClosed()) {
                throw new ODatabaseException("Cannot unmarshall the document because no database is active, use detach for use the document outside the database session scope");
            }
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            if (metadata.getImmutableSchemaSnapshot() != null) {
                metadata.clearThreadLocalSchemaSnapshot();
            }
            metadata.reload();
            metadata.makeThreadLocalSchemaSnapshot();
            this._schema = metadata.getImmutableSchemaSnapshot();
            prop = this._schema.getGlobalPropertyById(id);
        }
        return prop;
    }

    protected void fillClassIfNeed(String iClassName) {
        if (this._className == null) {
            this.setClassNameIfExists(iClassName);
        }
    }

    protected OClass getImmutableSchemaClass() {
        ODatabaseDocument databaseRecord;
        if (this._className == null) {
            this.fetchClassName();
        }
        if ((databaseRecord = this.getDatabaseIfDefined()) != null && !databaseRecord.isClosed()) {
            OImmutableSchema immutableSchema = ((OMetadataInternal)databaseRecord.getMetadata()).getImmutableSchemaSnapshot();
            if (immutableSchema == null) {
                return null;
            }
            if (this._immutableClazz == null) {
                this._immutableSchemaVersion = immutableSchema.getVersion();
                this._immutableClazz = immutableSchema.getClass(this._className);
            } else if (this._immutableSchemaVersion < immutableSchema.getVersion()) {
                this._immutableSchemaVersion = immutableSchema.getVersion();
                this._immutableClazz = immutableSchema.getClass(this._className);
            }
        }
        return this._immutableClazz;
    }

    protected void rawField(String iFieldName, Object iFieldValue, OType iFieldType) {
        if (this._fieldValues == null) {
            Map<Object, Object> map = this._fieldValues = this._ordered ? new LinkedHashMap() : new HashMap();
        }
        if (this._fieldTypes == null) {
            this._fieldTypes = new HashMap<String, OType>();
        }
        this._fieldValues.put(iFieldName, iFieldValue);
        this.addCollectionChangeListener(iFieldName, iFieldValue);
        if (iFieldType != null) {
            this._fieldTypes.put(iFieldName, iFieldType);
        }
    }

    protected boolean rawContainsField(String iFiledName) {
        return this._fieldValues != null && this._fieldValues.containsKey(iFiledName);
    }

    protected void autoConvertValues() {
        OClass clazz = this.getImmutableSchemaClass();
        if (clazz != null) {
            for (OProperty prop : clazz.properties()) {
                Iterator<Object> iterator;
                Object values;
                AbstractCollection list;
                Object value;
                OType type = prop.getType();
                OType linkedType = prop.getLinkedType();
                if (linkedType == null || (value = this.field(prop.getName())) == null) continue;
                if (type == OType.EMBEDDEDLIST) {
                    list = new OTrackedList(this);
                    values = (Collection)value;
                    iterator = values.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        list.add(OType.convert(e, linkedType.getDefaultJavaType()));
                    }
                    this.field(prop.getName(), list);
                    continue;
                }
                if (type == OType.EMBEDDEDMAP) {
                    OTrackedMap map = new OTrackedMap(this);
                    values = (Map)value;
                    for (Map.Entry entry : values.entrySet()) {
                        map.put(entry.getKey(), OType.convert(entry.getValue(), linkedType.getDefaultJavaType()));
                    }
                    this.field(prop.getName(), map);
                    continue;
                }
                if (type != OType.EMBEDDEDSET || linkedType == null) continue;
                list = new OTrackedSet(this);
                values = (Collection)value;
                iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    list.add(OType.convert(object, linkedType.getDefaultJavaType()));
                }
                this.field(prop.getName(), list);
            }
        }
    }

    protected ODocument flatCopy() {
        if (this.isDirty()) {
            throw new IllegalStateException("Cannot execute a flat copy of a dirty record");
        }
        ODocument cloned = new ODocument();
        cloned.setOrdered(this._ordered);
        cloned.fill(this._recordId, this._recordVersion, this._source, false);
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toStream(boolean iOnlyDelta) {
        ORecordElement.STATUS prev = this._status;
        this._status = ORecordElement.STATUS.MARSHALLING;
        try {
            if (ONetworkThreadLocalSerializer.getNetworkSerializer() != null) {
                byte[] byArray = ONetworkThreadLocalSerializer.getNetworkSerializer().toStream(this, iOnlyDelta);
                return byArray;
            }
            if (this._source == null) {
                this._source = this._recordFormat.toStream(this, iOnlyDelta);
            }
        }
        finally {
            this._status = prev;
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    @Override
    protected byte getRecordType() {
        return 100;
    }

    protected void addOwner(ORecordElement iOwner) {
        if (this._owners == null) {
            this._owners = new ArrayList<WeakReference<ORecordElement>>();
        }
        boolean found = false;
        for (WeakReference<ORecordElement> _owner : this._owners) {
            ORecordElement e = (ORecordElement)_owner.get();
            if (e != iOwner) continue;
            found = true;
            break;
        }
        if (!found) {
            this._owners.add(new WeakReference<ORecordElement>(iOwner));
        }
    }

    protected void removeOwner(ORecordElement iRecordElement) {
        if (this._owners != null) {
            for (int i = 0; i < this._owners.size(); ++i) {
                ORecordElement e = (ORecordElement)this._owners.get(i).get();
                if (e != iRecordElement) continue;
                this._owners.remove(i);
                break;
            }
        }
    }

    protected void convertAllMultiValuesToTrackedVersions() {
        if (this._fieldValues == null) {
            return;
        }
        HashMap<String, ORecordLazyList> fieldsToUpdate = new HashMap<String, ORecordLazyList>();
        for (Map.Entry<String, Object> fieldEntry : this._fieldValues.entrySet()) {
            Object fieldValue = fieldEntry.getValue();
            if (!(fieldValue instanceof Collection) && !(fieldValue instanceof Map)) continue;
            if (fieldValue instanceof OTrackedMultiValue) {
                this.addCollectionChangeListener(fieldEntry.getKey(), (OTrackedMultiValue)fieldValue);
                continue;
            }
            OType fieldType = this.fieldType(fieldEntry.getKey());
            OClass _clazz = this.getImmutableSchemaClass();
            if (fieldType == null && _clazz != null) {
                OProperty prop = _clazz.getProperty(fieldEntry.getKey());
                OType oType = fieldType = prop != null ? prop.getType() : null;
            }
            if (fieldType == null) {
                fieldType = OType.getTypeByValue(fieldEntry.getValue());
            }
            if (fieldType == null || !OType.EMBEDDEDLIST.equals((Object)fieldType) && !OType.EMBEDDEDMAP.equals((Object)fieldType) && !OType.EMBEDDEDSET.equals((Object)fieldType) && !OType.LINKSET.equals((Object)fieldType) && !OType.LINKLIST.equals((Object)fieldType) && !OType.LINKMAP.equals((Object)fieldType)) continue;
            Cloneable newValue = null;
            if (fieldValue instanceof List && fieldType.equals((Object)OType.EMBEDDEDLIST)) {
                newValue = new OTrackedList(this, (List)fieldValue, null);
            } else if (fieldValue instanceof Set && fieldType.equals((Object)OType.EMBEDDEDSET)) {
                newValue = new OTrackedSet(this, (Set)fieldValue, null);
            } else if (fieldValue instanceof Map && fieldType.equals((Object)OType.EMBEDDEDMAP)) {
                newValue = new OTrackedMap(this, (Map)fieldValue, null);
            } else if (fieldValue instanceof Set && fieldType.equals((Object)OType.LINKSET)) {
                newValue = new ORecordLazySet(this, (Collection)fieldValue);
            } else if (fieldValue instanceof List && fieldType.equals((Object)OType.LINKLIST)) {
                newValue = new ORecordLazyList(this, (List)fieldValue);
            } else if (fieldValue instanceof Map && fieldType.equals((Object)OType.LINKMAP)) {
                newValue = new ORecordLazyMap(this, (Map)fieldValue);
            }
            if (newValue == null) continue;
            this.addCollectionChangeListener(fieldEntry.getKey(), (OTrackedMultiValue<Object, Object>)((Object)newValue));
            fieldsToUpdate.put(fieldEntry.getKey(), (ORecordLazyList)newValue);
        }
        this._fieldValues.putAll(fieldsToUpdate);
    }

    protected void internalReset() {
        this.removeAllCollectionChangeListeners();
        if (this._fieldCollectionChangeTimeLines != null) {
            this._fieldCollectionChangeTimeLines.clear();
        }
        if (this._fieldValues != null) {
            this._fieldValues.clear();
        }
        if (this._fieldTypes != null) {
            this._fieldTypes.clear();
        }
    }

    protected boolean checkForFields(String ... iFields) {
        if (this._fieldValues == null) {
            Map<Object, Object> map = this._fieldValues = this._ordered ? new LinkedHashMap() : new HashMap();
        }
        if (this._status == ORecordElement.STATUS.LOADED && this._source != null) {
            return this.deserializeFields(iFields);
        }
        return true;
    }

    @Override
    protected void setup() {
        super.setup();
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null) {
            this._recordFormat = db.getSerializer();
        }
        if (this._recordFormat == null) {
            this._recordFormat = ODatabaseDocumentTx.getDefaultSerializer();
        }
    }

    protected String checkFieldName(String iFieldName) {
        Character c = OSchemaShared.checkFieldNameIfValid(iFieldName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid field name '" + iFieldName + "'. Character '" + c + "' is invalid");
        }
        return iFieldName;
    }

    protected void setClass(OClass iClass) {
        if (iClass != null && iClass.isAbstract()) {
            throw new OSchemaException("Cannot create a document of the abstract class '" + iClass + "'");
        }
        this._className = iClass == null ? null : iClass.getName();
        this._immutableClazz = null;
        this._immutableSchemaVersion = -1;
        if (iClass != null) {
            this.convertFieldsToClass(iClass);
        }
    }

    private void fetchSchemaIfCan() {
        ODatabaseDocumentInternal db;
        if (this._schema == null && (db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined()) != null && !db.isClosed()) {
            OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
            this._schema = metadata.getImmutableSchemaSnapshot();
        }
    }

    private void fetchClassName() {
        ODatabaseDocumentInternal database = this.getDatabaseIfDefinedInternal();
        if (database != null && database.getStorageVersions() != null && database.getStorageVersions().classesAreDetectedByClusterId()) {
            if (this._recordId.clusterId < 0) {
                this.checkForLoading();
                this.checkForFields("@class");
            } else {
                OClass _clazz;
                OImmutableSchema schema = ((OMetadataInternal)database.getMetadata()).getImmutableSchemaSnapshot();
                if (schema != null && (_clazz = schema.getClassByClusterId(this._recordId.clusterId)) != null) {
                    this._className = _clazz.getName();
                }
            }
        } else {
            this.checkForLoading();
            this.checkForFields("@class");
        }
    }

    private void convertFieldsToClass(OClass _clazz) {
        for (OProperty prop : _clazz.properties()) {
            OType type = this.fieldType(prop.getName());
            if ((type != null || !this.containsField(prop.getName())) && (type == null || type == prop.getType())) continue;
            this.field(prop.getName(), this.field(prop.getName()), prop.getType());
        }
    }

    private void saveOldFieldValue(String iFieldName, Object oldValue) {
        if (this._trackingChanges && this._recordId.isValid()) {
            if (this._fieldOriginalValues == null) {
                this._fieldOriginalValues = new HashMap<String, Object>();
            }
            if (!this._fieldOriginalValues.containsKey(iFieldName)) {
                this._fieldOriginalValues.put(iFieldName, oldValue);
            }
        }
    }

    private OType deriveFieldType(String iFieldName, OType[] iFieldType) {
        OProperty prop;
        OType fieldType;
        if (iFieldType != null && iFieldType.length == 1) {
            this.setFieldType(iFieldName, iFieldType[0]);
            fieldType = iFieldType[0];
        } else {
            fieldType = null;
        }
        OClass _clazz = this.getImmutableSchemaClass();
        if (_clazz != null && (prop = _clazz.getProperty(iFieldName)) != null && (fieldType = prop.getType()) != OType.ANY) {
            this.setFieldType(iFieldName, fieldType);
        }
        return fieldType;
    }

    private void addCollectionChangeListener(String fieldName, Object fieldValue) {
        if (!(fieldValue instanceof OTrackedMultiValue)) {
            return;
        }
        this.addCollectionChangeListener(fieldName, (OTrackedMultiValue)fieldValue);
    }

    private void addCollectionChangeListener(String fieldName, OTrackedMultiValue<Object, Object> multiValue) {
        if (this._fieldChangeListeners == null) {
            this._fieldChangeListeners = new HashMap<String, OSimpleMultiValueChangeListener<Object, Object>>();
        }
        if (!this._fieldChangeListeners.containsKey(fieldName)) {
            OSimpleMultiValueChangeListener listener = new OSimpleMultiValueChangeListener(this, fieldName);
            multiValue.addChangeListener(listener);
            this._fieldChangeListeners.put(fieldName, listener);
        }
    }

    private void removeAllCollectionChangeListeners() {
        if (this._fieldValues == null) {
            return;
        }
        for (Map.Entry<String, Object> field : this._fieldValues.entrySet()) {
            this.removeCollectionChangeListener(field.getKey(), field.getValue());
        }
        this._fieldChangeListeners = null;
    }

    private void addAllMultiValueChangeListeners() {
        if (this._fieldValues == null) {
            return;
        }
        for (Map.Entry<String, Object> field : this._fieldValues.entrySet()) {
            this.addCollectionChangeListener(field.getKey(), field.getValue());
        }
    }

    private void removeCollectionChangeListener(String fieldName, Object fieldValue) {
        if (this._fieldChangeListeners == null) {
            return;
        }
        OMultiValueChangeListener changeListener = this._fieldChangeListeners.remove(fieldName);
        if (!(fieldValue instanceof OTrackedMultiValue)) {
            return;
        }
        if (changeListener != null) {
            OTrackedMultiValue multiValue = (OTrackedMultiValue)fieldValue;
            multiValue.removeRecordChangeListener(changeListener);
        }
    }

    private void removeCollectionTimeLine(String fieldName) {
        if (this._fieldCollectionChangeTimeLines == null) {
            return;
        }
        this._fieldCollectionChangeTimeLines.remove(fieldName);
    }
}

