/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ORecordSerializerBinaryV0
implements ODocumentSerializer {
    private static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    private static final long MILLISEC_PER_DAY = 86400000L;
    private Charset utf8 = Charset.forName("UTF-8");

    @Override
    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        int len;
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        byte[][] fields = new byte[iFields.length][];
        for (int i = 0; i < iFields.length; ++i) {
            fields[i] = iFields[i].getBytes();
        }
        String fieldName = null;
        int unmarshalledFields = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            if (len > 0) {
                boolean match = false;
                for (int i = 0; i < iFields.length; ++i) {
                    if (iFields[i].length() != len) continue;
                    boolean matchField = true;
                    for (int j = 0; j < len; ++j) {
                        if (bytes.bytes[bytes.offset + j] == fields[i][j]) continue;
                        matchField = false;
                        break;
                    }
                    if (!matchField) continue;
                    fieldName = iFields[i];
                    ++unmarshalledFields;
                    bytes.skip(len);
                    match = true;
                    break;
                }
                if (!match) {
                    bytes.skip(len + 4 + 1);
                    continue;
                }
                valuePos = this.readInteger(bytes);
                type = this.readOType(bytes);
            } else {
                OGlobalProperty prop = this.getGlobalProperty(document, len);
                if (prop == null) continue;
                fieldName = prop.getName();
                valuePos = this.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : this.readOType(bytes);
            }
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.readSingleValue(bytes, type, document);
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
            } else {
                ODocumentInternal.rawField(document, fieldName, null, null);
            }
            if (unmarshalledFields != iFields.length) continue;
            break;
        }
    }

    @Override
    public void deserialize(ODocument document, BytesContainer bytes) {
        int len;
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int last = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            String fieldName;
            if (len > 0) {
                fieldName = new String(bytes.bytes, bytes.offset, len, this.utf8);
                bytes.skip(len);
                valuePos = this.readInteger(bytes);
                type = this.readOType(bytes);
            } else {
                OGlobalProperty prop = this.getGlobalProperty(document, len);
                if (prop == null) continue;
                fieldName = prop.getName();
                valuePos = this.readInteger(bytes);
                type = prop.getType() != OType.ANY ? prop.getType() : this.readOType(bytes);
            }
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.readSingleValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
                continue;
            }
            ODocumentInternal.rawField(document, fieldName, null, null);
        }
        ORecordInternal.clearSource(document);
        if (last > bytes.offset) {
            bytes.offset = last;
        }
    }

    @Override
    public void serialize(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        OClass clazz = this.serializeClass(document, bytes);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        Map<String, OProperty> props = clazz != null ? clazz.propertiesMap() : null;
        String[] fields = document.fieldNames();
        int[] pos = new int[fields.length];
        OProperty[] properties = new OProperty[fields.length];
        int i = 0;
        Map.Entry[] values = new Map.Entry[fields.length];
        for (Map.Entry<String, Object> entry : document) {
            if (props != null) {
                properties[i] = props.get(entry.getKey());
            }
            if (properties[i] != null) {
                OVarIntSerializer.write(bytes, (properties[i].getId() + 1) * -1);
                pos[i] = properties[i].getType() != OType.ANY ? bytes.alloc(4) : bytes.alloc(5);
            } else {
                this.writeString(bytes, entry.getKey());
                pos[i] = bytes.alloc(5);
            }
            values[i] = entry;
            ++i;
        }
        this.writeEmptyString(bytes);
        for (i = 0; i < values.length; ++i) {
            int pointer = 0;
            Object value = values[i].getValue();
            if (value == null) continue;
            OType type = this.getFieldType(document, (String)values[i].getKey(), value, props);
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            pointer = this.writeSingleValue(bytes, value, type, this.getLinkedType(document, type, (String)values[i].getKey()));
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            if (properties[i] != null && properties[i].getType() != OType.ANY) continue;
            this.writeOType(bytes, pos[i] + 4, type);
        }
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes) {
        OClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (clazz != null) {
            this.writeString(bytes, clazz.getName());
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    private OGlobalProperty getGlobalProperty(ODocument document, int len) {
        int id = len * -1 - 1;
        return ODocumentInternal.getGlobalPropertyById(document, id);
    }

    private OType readOType(BytesContainer bytes) {
        return OType.getById(this.readByte(bytes));
    }

    private void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = (byte)type.getId();
    }

    private Object readSingleValue(BytesContainer bytes, OType type, ODocument document) {
        Object value = null;
        switch (type) {
            case INTEGER: {
                value = OVarIntSerializer.readAsInteger(bytes);
                break;
            }
            case LONG: {
                value = OVarIntSerializer.readAsLong(bytes);
                break;
            }
            case SHORT: {
                value = OVarIntSerializer.readAsShort(bytes);
                break;
            }
            case STRING: {
                value = this.readString(bytes);
                break;
            }
            case DOUBLE: {
                value = Double.longBitsToDouble(this.readLong(bytes));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(this.readInteger(bytes)));
                break;
            }
            case BYTE: {
                value = this.readByte(bytes);
                break;
            }
            case BOOLEAN: {
                value = this.readByte(bytes) == 1;
                break;
            }
            case DATETIME: {
                value = new Date(OVarIntSerializer.readAsLong(bytes));
                break;
            }
            case DATE: {
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                int offset = ODateHelper.getDatabaseTimeZone().getOffset(savedTime);
                value = new Date(savedTime - (long)offset);
                break;
            }
            case EMBEDDED: {
                value = new ODocument();
                this.deserialize((ODocument)value, bytes);
                if (((ODocument)value).containsField("__orientdb_serilized_class__ ")) {
                    String className = (String)((ODocument)value).field("__orientdb_serilized_class__ ");
                    try {
                        Class<?> clazz = Class.forName(className);
                        ODocumentSerializable newValue = (ODocumentSerializable)clazz.newInstance();
                        newValue.fromDocument((ODocument)value);
                        value = newValue;
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ODocumentInternal.addOwner((ODocument)value, document);
                break;
            }
            case EMBEDDEDSET: {
                value = this.readEmbeddedCollection(bytes, new OTrackedSet<Object>(document), document);
                break;
            }
            case EMBEDDEDLIST: {
                value = this.readEmbeddedCollection(bytes, new OTrackedList<Object>(document), document);
                break;
            }
            case LINKSET: {
                value = this.readLinkCollection(bytes, new ORecordLazySet(document));
                break;
            }
            case LINKLIST: {
                value = this.readLinkCollection(bytes, new ORecordLazyList(document));
                break;
            }
            case BINARY: {
                value = this.readBinary(bytes);
                break;
            }
            case LINK: {
                value = this.readOptimizedLink(bytes);
                break;
            }
            case LINKMAP: {
                value = this.readLinkMap(bytes, document);
                break;
            }
            case EMBEDDEDMAP: {
                value = this.readEmbeddedMap(bytes, document);
                break;
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                break;
            }
            case LINKBAG: {
                ORidBag bag = new ORidBag();
                bag.fromStream(bytes);
                bag.setOwner(document);
                value = bag;
                break;
            }
            case TRANSIENT: {
                break;
            }
            case CUSTOM: {
                try {
                    String className = this.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    stream.fromStream(this.readBinary(bytes));
                    if (stream instanceof OSerializableWrapper) {
                        value = ((OSerializableWrapper)stream).getSerializable();
                        break;
                    }
                    value = stream;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    private byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    private Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = new ORecordLazyMap(document);
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.readSingleValue(bytes, keyType, document);
            ORecordId value = this.readOptimizedLink(bytes);
            if (value.equals(NULL_RECORD_ID)) {
                result.put(key, null);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Object readEmbeddedMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap result = new OTrackedMap(document);
        int last = 0;
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.readSingleValue(bytes, keyType, document);
            int valuePos = this.readInteger(bytes);
            OType type = this.readOType(bytes);
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.readSingleValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                result.put(key, value);
                continue;
            }
            result.put(key, null);
        }
        if (last > bytes.offset) {
            bytes.offset = last;
        }
        return result;
    }

    private Collection<OIdentifiable> readLinkCollection(BytesContainer bytes, Collection<OIdentifiable> found) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = this.readOptimizedLink(bytes);
            if (id.equals(NULL_RECORD_ID)) {
                found.add(null);
                continue;
            }
            found.add(id);
        }
        return found;
    }

    private ORecordId readOptimizedLink(BytesContainer bytes) {
        return new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
    }

    private Collection<?> readEmbeddedCollection(BytesContainer bytes, Collection<Object> found, ODocument document) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        OType type = this.readOType(bytes);
        if (type == OType.ANY) {
            for (int i = 0; i < items; ++i) {
                OType itemType = this.readOType(bytes);
                if (itemType == OType.ANY) {
                    found.add(null);
                    continue;
                }
                found.add(this.readSingleValue(bytes, itemType, document));
            }
            return found;
        }
        return null;
    }

    private OType getLinkedType(ODocument document, OType type, String key) {
        OProperty prop;
        if (type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDMAP) {
            return null;
        }
        OClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (clazz != null && (prop = clazz.getProperty(key)) != null) {
            return prop.getLinkedType();
        }
        return null;
    }

    private int writeSingleValue(BytesContainer bytes, Object value, OType type, OType linkedType) {
        int pointer = 0;
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                pointer = OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                pointer = this.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits((Double)value);
                pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Float)value).floatValue());
                pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Byte)value;
                break;
            }
            case BOOLEAN: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Long) {
                    pointer = OVarIntSerializer.write(bytes, (Long)value);
                    break;
                }
                pointer = OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Long ? ((Long)value).longValue() : ((Date)value).getTime();
                int offset = ODateHelper.getDatabaseTimeZone().getOffset(dateValue);
                pointer = OVarIntSerializer.write(bytes, (dateValue + (long)offset) / 86400000L);
                break;
            }
            case EMBEDDED: {
                pointer = bytes.offset;
                if (value instanceof ODocumentSerializable) {
                    ODocument cur = ((ODocumentSerializable)value).toDocument();
                    cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                    this.serialize(cur, bytes, false);
                    break;
                }
                this.serialize((ODocument)value, bytes, false);
                break;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                if (value.getClass().isArray()) {
                    pointer = this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), linkedType);
                    break;
                }
                pointer = this.writeEmbeddedCollection(bytes, (Collection)value, linkedType);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                pointer = this.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKSET: 
            case LINKLIST: {
                Collection ridCollection = (Collection)value;
                pointer = this.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                pointer = this.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                pointer = this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                pointer = this.writeEmbeddedMap(bytes, (Map)value);
                break;
            }
            case LINKBAG: {
                pointer = ((ORidBag)value).toStream(bytes);
                break;
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                pointer = this.writeString(bytes, value.getClass().getName());
                this.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
        return pointer;
    }

    private int writeBinary(BytesContainer bytes, byte[] valueBytes) {
        int pointer = OVarIntSerializer.write(bytes, valueBytes.length);
        int start = bytes.alloc(valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes.bytes, start, valueBytes.length);
        return pointer;
    }

    private int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean prevLazy = this.checkLazy(map);
        int fullPos = OVarIntSerializer.write(bytes, map.size());
        for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
            OType type = OType.STRING;
            this.writeOType(bytes, bytes.alloc(1), type);
            this.writeString(bytes, entry.getKey().toString());
            if (entry.getValue() == null) {
                this.writeNullLink(bytes);
                continue;
            }
            this.writeOptimizedLink(bytes, entry.getValue());
        }
        this.resetLazy(map, prevLazy);
        return fullPos;
    }

    private int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        OType type;
        boolean prevLazy = this.checkLazy(map);
        int[] pos = new int[map.size()];
        int i = 0;
        Map.Entry[] values = new Map.Entry[map.size()];
        int fullPos = OVarIntSerializer.write(bytes, map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            type = OType.STRING;
            this.writeOType(bytes, bytes.alloc(1), type);
            this.writeString(bytes, entry.getKey().toString());
            pos[i] = bytes.alloc(5);
            values[i] = entry;
            ++i;
        }
        for (i = 0; i < values.length; ++i) {
            int pointer = 0;
            Object value = values[i].getValue();
            if (value == null) continue;
            type = this.getTypeFromValueEmbedded(value);
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            pointer = this.writeSingleValue(bytes, value, type, null);
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            this.writeOType(bytes, pos[i] + 4, type);
        }
        this.resetLazy(map, prevLazy);
        return fullPos;
    }

    private OIdentifiable recursiveLinkSave(OIdentifiable link) {
        if (link instanceof ORID) {
            if (((ORID)link).isValid() && ((ORID)link).isNew()) {
                ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.INSTANCE.get();
                Object record = link.getRecord();
                if (record != null) {
                    if (ONetworkThreadLocalSerializer.getNetworkSerializer() != null) {
                        throw new ODatabaseException("Impossible save a record during network serialization");
                    }
                    database.save(record);
                    return record;
                }
            }
        } else if (link instanceof ORecord) {
            ORID rid = link.getIdentity();
            if (((ORecord)link).isDirty() || rid.isTemporary()) {
                if (ONetworkThreadLocalSerializer.getNetworkSerializer() != null) {
                    throw new ODatabaseException("Impossible save a record during network serialization");
                }
                ((ORecord)link).save();
            }
        }
        return link;
    }

    private int writeNullLink(BytesContainer bytes) {
        int pos = OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterPosition());
        return pos;
    }

    private int writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        link = this.recursiveLinkSave(link);
        assert (link.getIdentity().isValid() || ODatabaseRecordThreadLocal.INSTANCE.get().getStorage() instanceof OStorageProxy) : "Impossible to serialize invalid link";
        int pos = OVarIntSerializer.write(bytes, link.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        return pos;
    }

    private int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean prevLazy = this.checkLazy(value);
        assert (!(value instanceof OMVRBTreeRIDSet));
        int pos = OVarIntSerializer.write(bytes, value.size());
        for (OIdentifiable itemValue : value) {
            if (itemValue == null) {
                this.writeNullLink(bytes);
                continue;
            }
            this.writeOptimizedLink(bytes, itemValue);
        }
        this.resetLazy(value, prevLazy);
        return pos;
    }

    private void resetLazy(Object value, boolean prevLazy) {
        if (value instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)value).setAutoConvertToRecord(prevLazy);
        }
    }

    private boolean checkLazy(Object value) {
        boolean prevLazy = false;
        if (value instanceof ORecordLazyMultiValue) {
            prevLazy = ((ORecordLazyMultiValue)value).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)value).setAutoConvertToRecord(false);
        }
        return prevLazy;
    }

    private int writeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OType linkedType) {
        boolean prevLazy = this.checkLazy(value);
        int pos = OVarIntSerializer.write(bytes, value.size());
        this.writeOType(bytes, bytes.alloc(1), OType.ANY);
        for (Object itemValue : value) {
            if (itemValue == null) {
                this.writeOType(bytes, bytes.alloc(1), OType.ANY);
                continue;
            }
            OType type = linkedType == null ? this.getTypeFromValueEmbedded(itemValue) : linkedType;
            if (type != null) {
                this.writeOType(bytes, bytes.alloc(1), type);
                this.writeSingleValue(bytes, itemValue, type, null);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        this.resetLazy(value, prevLazy);
        return pos;
    }

    private OType getFieldType(ODocument document, String key, Object fieldValue, Map<String, OProperty> properties) {
        OType type = document.fieldType(key);
        if (type == null) {
            OProperty prop;
            OProperty oProperty = prop = properties != null ? properties.get(key) : null;
            if (prop != null) {
                type = prop.getType();
            }
        }
        if (type == null || OType.ANY == type) {
            type = OType.getTypeByValue(fieldValue);
        }
        return type;
    }

    private OType getTypeFromValueEmbedded(Object fieldValue) {
        OType type = OType.getTypeByValue(fieldValue);
        if (type == OType.LINK && fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
            type = OType.EMBEDDED;
        }
        return type;
    }

    private String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        String res = new String(bytes.bytes, bytes.offset, len, this.utf8);
        bytes.skip(len);
        return res;
    }

    private int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    private byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    private long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    private int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private int writeString(BytesContainer bytes, String toWrite) {
        byte[] nameBytes = toWrite.getBytes(this.utf8);
        int pointer = OVarIntSerializer.write(bytes, nameBytes.length);
        int start = bytes.alloc(nameBytes.length);
        System.arraycopy(nameBytes, 0, bytes.bytes, start, nameBytes.length);
        return pointer;
    }
}

