/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class OCommandExecutorSQLAbstract
extends OCommandExecutorAbstract {
    public static final String KEYWORD_FROM = "FROM";
    public static final String KEYWORD_LET = "LET";
    public static final String KEYWORD_WHERE = "WHERE";
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_SKIP = "SKIP";
    public static final String KEYWORD_OFFSET = "OFFSET";
    public static final String KEYWORD_TIMEOUT = "TIMEOUT";
    public static final String KEYWORD_LOCK = "LOCK";
    public static final String KEYWORD_RETURN = "RETURN";
    public static final String KEYWORD_KEY = "key";
    public static final String KEYWORD_RID = "rid";
    public static final String CLUSTER_PREFIX = "CLUSTER:";
    public static final String CLASS_PREFIX = "CLASS:";
    public static final String INDEX_PREFIX = "INDEX:";
    public static final String KEYWORD_UNSAFE = "UNSAFE";
    public static final String INDEX_VALUES_PREFIX = "INDEXVALUES:";
    public static final String INDEX_VALUES_ASC_PREFIX = "INDEXVALUESASC:";
    public static final String INDEX_VALUES_DESC_PREFIX = "INDEXVALUESDESC:";
    public static final String DICTIONARY_PREFIX = "DICTIONARY:";
    public static final String METADATA_PREFIX = "METADATA:";
    public static final String METADATA_SCHEMA = "SCHEMA";
    public static final String METADATA_INDEXMGR = "INDEXMANAGER";
    public static final String DEFAULT_PARAM_USER = "$user";
    protected long timeoutMs = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
    protected OCommandContext.TIMEOUT_STRATEGY timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @Override
    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandSQLParsingException(iText + ". Use " + this.getSyntax(), this.parserText, this.parserGetPreviousPosition());
    }

    protected void throwParsingException(String iText) {
        throw new OCommandSQLParsingException(iText, this.parserText, this.parserGetPreviousPosition());
    }

    protected boolean parseTimeout(String w) throws OCommandSQLParsingException {
        if (!w.equals(KEYWORD_TIMEOUT)) {
            return false;
        }
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        try {
            this.timeoutMs = Long.parseLong(word);
        }
        catch (Exception e) {
            this.throwParsingException("Invalid TIMEOUT value set to '" + word + "' but it should be a valid long. Example: " + KEYWORD_TIMEOUT + " 3000");
        }
        if (this.timeoutMs < 0L) {
            this.throwParsingException("Invalid TIMEOUT: value set minor than ZERO. Example: " + this.timeoutMs + " 10000");
        }
        this.parserNextWord(true);
        word = this.parserGetLastWord();
        if (word.equals(OCommandContext.TIMEOUT_STRATEGY.EXCEPTION.toString())) {
            this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;
        } else if (word.equals(OCommandContext.TIMEOUT_STRATEGY.RETURN.toString())) {
            this.timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.RETURN;
        } else {
            this.parserGoBack();
        }
        return true;
    }

    protected String parseLock() throws OCommandSQLParsingException {
        this.parserNextWord(true);
        String lockStrategy = this.parserGetLastWord();
        if (!(lockStrategy.equalsIgnoreCase("DEFAULT") || lockStrategy.equalsIgnoreCase("NONE") || lockStrategy.equalsIgnoreCase("RECORD"))) {
            this.throwParsingException("Invalid LOCK value set to '" + lockStrategy + "' but it should be NONE (default) or RECORD. Example: " + KEYWORD_LOCK + " RECORD");
        }
        return lockStrategy;
    }

    protected Set<String> getInvolvedClustersOfClasses(Collection<String> iClassNames) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        for (String clazz : iClassNames) {
            OClass cls = ((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().getClass(clazz);
            if (cls == null) continue;
            for (int clId : cls.getClusterIds()) {
                if (clId <= -1 || !this.checkClusterAccess(db, db.getClusterNameById(clId))) continue;
                clusters.add(db.getClusterNameById(clId).toLowerCase());
            }
        }
        return clusters;
    }

    protected Set<String> getInvolvedClustersOfClusters(Collection<String> iClusterNames) {
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        for (String cluster : iClusterNames) {
            String c = cluster.toLowerCase();
            if (!this.checkClusterAccess(db, c)) continue;
            clusters.add(c);
        }
        return clusters;
    }

    protected Set<String> getInvolvedClustersOfIndex(String iIndexName) {
        OClass cls;
        String clazz;
        ODatabaseDocumentInternal db = OCommandExecutorSQLAbstract.getDatabase();
        HashSet<String> clusters = new HashSet<String>();
        OMetadataInternal metadata = (OMetadataInternal)db.getMetadata();
        OIndex<?> idx = metadata.getIndexManager().getIndex(iIndexName);
        if (idx != null && (clazz = idx.getDefinition().getClassName()) != null && (cls = metadata.getImmutableSchemaSnapshot().getClass(clazz)) != null) {
            for (int clId : cls.getClusterIds()) {
                String clName = db.getClusterNameById(clId);
                if (clName == null) continue;
                clusters.add(clName.toLowerCase());
            }
        }
        return clusters;
    }

    protected boolean checkClusterAccess(ODatabaseDocument db, String iClusterName) {
        return db.getUser() != null && db.getUser().checkIfAllowed(ORule.ResourceGeneric.CLUSTER, iClusterName, this.getSecurityOperationType()) != null;
    }

    protected void bindDefaultContextVariables() {
        if (this.context != null && OCommandExecutorSQLAbstract.getDatabase() != null && OCommandExecutorSQLAbstract.getDatabase().getUser() != null) {
            this.context.setVariable(DEFAULT_PARAM_USER, OCommandExecutorSQLAbstract.getDatabase().getUser().getIdentity());
        }
    }
}

