/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLAlterClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;
    private OClass.ATTRIBUTES attribute;
    private String value;

    public OCommandExecutorSQLAlterClass parse(OCommandRequest iRequest) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLAlterClass.getDatabase();
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found", this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found", this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.parserText, oldPos);
        }
        this.className = word.toString();
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed the class's attribute to change", this.parserText, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = OClass.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown class's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OClass.ATTRIBUTES.values()), this.parserText, oldPos);
        }
        this.value = this.parserText.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missed the property's value to change for attribute '" + (Object)((Object)this.attribute) + "'", this.parserText, oldPos);
        }
        if (this.value.equalsIgnoreCase("null")) {
            this.value = null;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLAlterClass.getDatabase();
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OClassImpl cls = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (cls == null) {
            throw new OCommandExecutionException("Cannot alter class '" + this.className + "' because not found");
        }
        if (this.value != null && this.attribute == OClass.ATTRIBUTES.SUPERCLASS) {
            this.checkClassExists(database, this.className, this.value);
        }
        cls.set(this.attribute, this.value);
        return null;
    }

    protected void checkClassExists(ODatabaseDocument database, String targetClass, String superClass) {
        superClass = "" + superClass;
        if (database.getMetadata().getSchema().getClass(superClass) == null) {
            throw new OCommandExecutionException("Cannot alter superClass of '" + targetClass + "' because  " + superClass + " class not found");
        }
    }

    @Override
    public String getSyntax() {
        return "ALTER CLASS <class> <attribute-name> <attribute-value>";
    }

    @Override
    public boolean involveSchema() {
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

