/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import java.util.Map;

public class OCommandExecutorSQLDelegate
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    protected OCommandExecutorSQLAbstract delegate;

    public OCommandExecutorSQLDelegate parse(OCommandRequest iCommand) {
        if (iCommand instanceof OCommandRequestText) {
            OCommandRequestText textRequest = (OCommandRequestText)iCommand;
            String text = textRequest.getText();
            if (text == null) {
                throw new IllegalArgumentException("Command text is null");
            }
            String textUpperCase = this.upperCase(text);
            this.delegate = OSQLEngine.getInstance().getCommand(textUpperCase);
            if (this.delegate == null) {
                throw new OCommandExecutorNotFoundException("Cannot find a command executor for the command request: " + iCommand);
            }
        } else {
            throw new OCommandExecutionException("Cannot find a command executor for the command request: " + iCommand);
        }
        this.delegate.setContext(this.context);
        this.delegate.setLimit(iCommand.getLimit());
        this.delegate.parse(iCommand);
        this.delegate.setProgressListener(this.progressListener);
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.delegate.execute(iArgs);
    }

    @Override
    public long getDistributedTimeout() {
        return this.delegate.getDistributedTimeout();
    }

    @Override
    public OCommandContext getContext() {
        return this.delegate.getContext();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getSyntax() {
        return this.delegate.getSyntax();
    }

    @Override
    public String getFetchPlan() {
        return this.delegate.getFetchPlan();
    }

    @Override
    public boolean isIdempotent() {
        return this.delegate.isIdempotent();
    }

    public OCommandExecutorSQLAbstract getDelegate() {
        return this.delegate;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        if (this.delegate instanceof OCommandDistributedReplicateRequest) {
            return ((OCommandDistributedReplicateRequest)((Object)this.delegate)).getQuorumType();
        }
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

