/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class OCommandExecutorSQLSetAware
extends OCommandExecutorSQLAbstract {
    protected static final String KEYWORD_SET = "SET";
    protected static final String KEYWORD_CONTENT = "CONTENT";
    protected ODocument content = null;
    protected int parameterCounter = 0;

    protected void parseContent() {
        if (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            this.content = this.parseJSON();
        }
        if (this.content == null) {
            this.throwSyntaxErrorException("Content not provided. Example: CONTENT { \"name\": \"Jay\" }");
        }
    }

    protected void parseSetFields(OClass iClass, Map<String, Object> fields) {
        while (!(this.parserIsEnded() || fields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            OProperty p;
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            if (fieldName.equalsIgnoreCase("WHERE")) {
                this.parserGoBack();
                break;
            }
            this.parserNextChars(false, true, "=");
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            Cloneable v = this.getFieldValueCountingParameters(fieldValue);
            if (iClass != null && (p = iClass.getProperty(fieldName)) != null) {
                OClass embeddedType = p.getLinkedClass();
                switch (p.getType()) {
                    case EMBEDDED: {
                        if (!(v instanceof Map)) break;
                        ODocument doc = new ODocument();
                        if (embeddedType != null) {
                            doc.setClassName(embeddedType.getName());
                        }
                        doc.fromMap((Map<String, Object>)((Object)v));
                        v = doc;
                        break;
                    }
                    case EMBEDDEDSET: {
                        ODocument doc;
                        if (v instanceof Map || !OMultiValue.isMultiValue(v)) break;
                        AbstractCollection set = new HashSet();
                        for (Object object : OMultiValue.getMultiValueIterable(v)) {
                            if (object instanceof Map) {
                                doc = new ODocument();
                                if (embeddedType != null) {
                                    doc.setClassName(embeddedType.getName());
                                }
                                doc.fromMap((Map)object);
                                set.add(doc);
                                continue;
                            }
                            if (object instanceof OIdentifiable) {
                                set.add(((OIdentifiable)object).getRecord());
                                continue;
                            }
                            set.add(object);
                        }
                        v = set;
                        break;
                    }
                    case EMBEDDEDLIST: {
                        ODocument doc;
                        if (v instanceof Map || !OMultiValue.isMultiValue(v)) break;
                        AbstractCollection set = new ArrayList();
                        for (Object object : OMultiValue.getMultiValueIterable(v)) {
                            if (object instanceof Map) {
                                doc = new ODocument();
                                if (embeddedType != null) {
                                    doc.setClassName(embeddedType.getName());
                                }
                                doc.fromMap((Map)object);
                                set.add(doc);
                                continue;
                            }
                            if (object instanceof OIdentifiable) {
                                set.add(((OIdentifiable)object).getRecord());
                                continue;
                            }
                            set.add(object);
                        }
                        v = set;
                        break;
                    }
                    case EMBEDDEDMAP: {
                        ODocument doc;
                        if (!(v instanceof Map)) break;
                        HashMap map = new HashMap();
                        for (Map.Entry entry : ((Map)((Object)v)).entrySet()) {
                            if (entry.getValue() instanceof Map) {
                                doc = new ODocument();
                                if (embeddedType != null) {
                                    doc.setClassName(embeddedType.getName());
                                }
                                doc.fromMap((Map)entry.getValue());
                                map.put(entry.getKey(), doc);
                                continue;
                            }
                            if (entry.getValue() instanceof OIdentifiable) {
                                map.put(entry.getKey(), (ODocument)((OIdentifiable)entry.getValue()).getRecord());
                                continue;
                            }
                            map.put(entry.getKey(), (ODocument)entry.getValue());
                        }
                        v = map;
                    }
                }
            }
            fields.put(fieldName, v);
            this.parserSkipWhiteSpaces();
        }
        if (fields.size() == 0) {
            this.throwParsingException("Entries to set <field> = <value> are missed. Example: name = 'Bill', salary = 300.2");
        }
    }

    protected Object getFieldValueCountingParameters(String fieldValue) {
        if (fieldValue.trim().equals("?")) {
            ++this.parameterCounter;
        }
        return OSQLHelper.parseValue(this, fieldValue, this.context);
    }

    protected ODocument parseJSON() {
        String contentAsString = this.parserRequiredWord(false, "JSON expected").trim();
        ODocument json = new ODocument().fromJSON(contentAsString);
        this.parserSkipWhiteSpaces();
        return json;
    }
}

