/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.stat;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLFunctionMode
extends OSQLFunctionAbstract {
    public static final String NAME = "mode";
    private Map<Object, Integer> seen = new HashMap<Object, Integer>();
    private int max = 0;
    private List<Object> maxElems = new ArrayList<Object>();

    public OSQLFunctionMode() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (OMultiValue.isMultiValue(iParams[0])) {
            for (Object o : OMultiValue.getMultiValueIterable(iParams[0])) {
                this.max = this.evaluate(o, 1, this.seen, this.maxElems, this.max);
            }
        } else {
            this.max = this.evaluate(iParams[0], 1, this.seen, this.maxElems, this.max);
        }
        return this.getResult();
    }

    @Override
    public Object getResult() {
        if (this.returnDistributedResult()) {
            return this.seen;
        }
        return this.maxElems.isEmpty() ? null : this.maxElems;
    }

    @Override
    public String getSyntax() {
        return "mode(<field>)";
    }

    @Override
    public boolean aggregateResults() {
        return true;
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        HashMap<Object, Integer> dSeen = new HashMap<Object, Integer>();
        int dMax = 0;
        ArrayList<Object> dMaxElems = new ArrayList<Object>();
        for (Object iParameter : resultsToMerge) {
            Map mSeen = (Map)iParameter;
            for (Map.Entry o : mSeen.entrySet()) {
                dMax = this.evaluate(o.getKey(), (Integer)o.getValue(), dSeen, dMaxElems, dMax);
            }
        }
        return dMaxElems;
    }

    private int evaluate(Object value, int times, Map<Object, Integer> iSeen, List<Object> iMaxElems, int iMax) {
        if (value != null) {
            if (iSeen.containsKey(value)) {
                iSeen.put(value, iSeen.get(value) + times);
            } else {
                iSeen.put(value, times);
            }
            if (iSeen.get(value) > iMax) {
                iMax = iSeen.get(value);
                iMaxElems.clear();
                iMaxElems.add(value);
            } else if (iSeen.get(value) == iMax) {
                iMaxElems.add(value);
            }
        }
        return iMax;
    }
}

