/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.text;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.Map;

public class OSQLMethodToJSON
extends OAbstractSQLMethod {
    public static final String NAME = "tojson";

    public OSQLMethodToJSON() {
        super(NAME, 0, 1);
    }

    @Override
    public String getSyntax() {
        return "toJSON([<format>])";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iThis == null) {
            return null;
        }
        if (iThis instanceof ODocument) {
            ODocument doc = (ODocument)iThis;
            return iParams.length == 1 ? doc.toJSON(((String)iParams[0]).replace("\"", "")) : doc.toJSON();
        }
        if (iThis instanceof Map) {
            ODocument doc = new ODocument().fromMap((Map)iThis);
            return iParams.length == 1 ? doc.toJSON(((String)iParams[0]).replace("\"", "")) : doc.toJSON();
        }
        return null;
    }
}

