/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.eh;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;

public class OPhysicalPositionSerializer
implements OBinarySerializer<OPhysicalPosition> {
    public static final OPhysicalPositionSerializer INSTANCE = new OPhysicalPositionSerializer();
    public static final byte ID = 50;

    @Override
    public int getObjectSize(OPhysicalPosition object, Object ... hints) {
        return this.getFixedLength();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return this.getFixedLength();
    }

    @Override
    public void serialize(OPhysicalPosition object, byte[] stream, int startPosition, Object ... hints) {
        int position = startPosition;
        OLongSerializer.INSTANCE.serialize(object.clusterPosition, stream, position, new Object[0]);
        object.recordVersion.getSerializer().writeTo(stream, position += OLongSerializer.INSTANCE.getFixedLength(), object.recordVersion);
        OIntegerSerializer.INSTANCE.serializeLiteral(object.recordSize, stream, position += OVersionFactory.instance().getVersionSize());
        OByteSerializer.INSTANCE.serializeLiteral(object.recordType, stream, position += 4);
    }

    @Override
    public OPhysicalPosition deserialize(byte[] stream, int startPosition) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        int position = startPosition;
        physicalPosition.clusterPosition = OLongSerializer.INSTANCE.deserialize(stream, position);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.getSerializer().readFrom(stream, position += OLongSerializer.INSTANCE.getFixedLength(), version);
        physicalPosition.recordSize = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, position += OVersionFactory.instance().getVersionSize());
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeLiteral(stream, position += 4);
        return physicalPosition;
    }

    @Override
    public byte getId() {
        return 50;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        int clusterPositionSize = OLongSerializer.INSTANCE.getFixedLength();
        int versionSize = OVersionFactory.instance().getVersionSize();
        return clusterPositionSize + versionSize + 8 + 8 + 1;
    }

    @Override
    public void serializeNativeObject(OPhysicalPosition object, byte[] stream, int startPosition, Object ... hints) {
        int position = startPosition;
        OLongSerializer.INSTANCE.serializeNativeObject(object.clusterPosition, stream, position, new Object[0]);
        object.recordVersion.getSerializer().fastWriteTo(stream, position += OLongSerializer.INSTANCE.getFixedLength(), object.recordVersion);
        OIntegerSerializer.INSTANCE.serializeNative(object.recordSize, stream, position += OVersionFactory.instance().getVersionSize(), new Object[0]);
        OByteSerializer.INSTANCE.serializeNative(object.recordType, stream, position += 4, new Object[0]);
    }

    @Override
    public OPhysicalPosition deserializeNativeObject(byte[] stream, int startPosition) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        int position = startPosition;
        physicalPosition.clusterPosition = OLongSerializer.INSTANCE.deserializeNativeObject(stream, position);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        version.getSerializer().fastReadFrom(stream, position += OLongSerializer.INSTANCE.getFixedLength(), version);
        physicalPosition.recordSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, position += OVersionFactory.instance().getVersionSize());
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeNative(stream, position += 4);
        return physicalPosition;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return this.getFixedLength();
    }

    @Override
    public void serializeInDirectMemoryObject(OPhysicalPosition object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        long currentOffset = offset;
        OLongSerializer.INSTANCE.serializeInDirectMemoryObject(object.clusterPosition, pointer, currentOffset, new Object[0]);
        byte[] serializedVersion = new byte[OVersionFactory.instance().getVersionSize()];
        object.recordVersion.getSerializer().fastWriteTo(serializedVersion, 0, object.recordVersion);
        pointer.set(currentOffset += (long)OLongSerializer.INSTANCE.getFixedLength(), serializedVersion, 0, serializedVersion.length);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(object.recordSize, pointer, currentOffset += (long)OVersionFactory.instance().getVersionSize(), new Object[0]);
        OByteSerializer.INSTANCE.serializeInDirectMemory(object.recordType, pointer, currentOffset += 4L, new Object[0]);
    }

    @Override
    public OPhysicalPosition deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        long currentPointer = offset;
        physicalPosition.clusterPosition = OLongSerializer.INSTANCE.deserializeFromDirectMemoryObject(pointer, currentPointer);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        byte[] serializedVersion = pointer.get(currentPointer += (long)OLongSerializer.INSTANCE.getFixedLength(), OVersionFactory.instance().getVersionSize());
        version.getSerializer().fastReadFrom(serializedVersion, 0, version);
        physicalPosition.recordVersion = version;
        OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += (long)OVersionFactory.instance().getVersionSize());
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeFromDirectMemory(pointer, currentPointer += 4L);
        return physicalPosition;
    }

    @Override
    public OPhysicalPosition deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        OPhysicalPosition physicalPosition = new OPhysicalPosition();
        long currentPointer = offset;
        physicalPosition.clusterPosition = OLongSerializer.INSTANCE.deserializeFromDirectMemoryObject(wrapper, currentPointer);
        ORecordVersion version = OVersionFactory.instance().createVersion();
        byte[] serializedVersion = wrapper.get(currentPointer += (long)OLongSerializer.INSTANCE.getFixedLength(), OVersionFactory.instance().getVersionSize());
        version.getSerializer().fastReadFrom(serializedVersion, 0, version);
        physicalPosition.recordVersion = version;
        OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(wrapper, currentPointer += (long)OVersionFactory.instance().getVersionSize());
        physicalPosition.recordType = OByteSerializer.INSTANCE.deserializeFromDirectMemory(wrapper, currentPointer += 4L);
        return physicalPosition;
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return this.getFixedLength();
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return this.getFixedLength();
    }

    @Override
    public OPhysicalPosition preprocess(OPhysicalPosition value, Object ... hints) {
        return value;
    }
}

