/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.ONestedRollbackException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;

public class OAtomicOperationsManager {
    private static volatile ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OAbstractPaginatedStorage storage;
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<String, OAtomicOperationsManager> lockManager = new OLockManager(true, -1);

    public OAtomicOperationsManager(OAbstractPaginatedStorage storage) {
        this.storage = storage;
        this.writeAheadLog = storage.getWALInstance();
    }

    public OAtomicOperation startAtomicOperation(ODurableComponent durableComponent, boolean rollbackOnlyMode) throws IOException {
        return this.startAtomicOperation(durableComponent.getFullName(), rollbackOnlyMode);
    }

    public OAtomicOperation startAtomicOperation(String component, boolean rollbackOnlyMode) throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            operation.incrementCounter();
            if (component != null) {
                this.acquireExclusiveLockTillOperationComplete(component);
            }
            return operation;
        }
        OOperationUnitId unitId = OOperationUnitId.generateId();
        OLogSequenceNumber lsn = !rollbackOnlyMode ? this.writeAheadLog.logAtomicOperationStartRecord(true, unitId) : null;
        operation = new OAtomicOperation(lsn, unitId, rollbackOnlyMode);
        currentOperation.set(operation);
        if (this.storage.getStorageTransaction() == null) {
            this.writeAheadLog.log(new ONonTxOperationPerformedWALRecord());
        }
        if (component != null) {
            this.acquireExclusiveLockTillOperationComplete(component);
        }
        return operation;
    }

    public OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    public OAtomicOperation endAtomicOperation(boolean rollback) throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        if (rollback) {
            operation.rollback();
        }
        if (operation.isRollback() && !rollback) {
            throw new ONestedRollbackException("Atomic operation was rolled back by internal component");
        }
        int counter = operation.decrementCounter();
        assert (counter >= 0);
        if (counter == 0) {
            if (!operation.isRollback()) {
                operation.commitChanges(this.storage.getDiskCache(), this.writeAheadLog);
            }
            if (!operation.isRollbackOnlyMode()) {
                this.writeAheadLog.logAtomicOperationEndRecord(operation.getOperationUnitId(), rollback, operation.getStartLSN());
            }
            currentOperation.set(null);
            for (String lockObject : operation.lockedObjects()) {
                this.lockManager.releaseLock(this, lockObject, OLockManager.LOCK.EXCLUSIVE);
            }
        }
        return operation;
    }

    private void acquireExclusiveLockTillOperationComplete(String durableComponent) {
        OAtomicOperation operation = currentOperation.get();
        if (operation == null) {
            return;
        }
        assert (durableComponent != null);
        if (operation.containsInLockedObjects(durableComponent)) {
            return;
        }
        this.lockManager.acquireLock(this, durableComponent, OLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(durableComponent);
    }

    public void acquireReadLock(ODurableComponent durableComponent) {
        if (this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getName() != null);
        assert (durableComponent.getFullName() != null);
        this.lockManager.acquireLock(this, durableComponent.getFullName(), OLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ODurableComponent durableComponent) {
        if (this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getName() != null);
        assert (durableComponent.getFullName() != null);
        this.lockManager.releaseLock(this, durableComponent.getFullName(), OLockManager.LOCK.SHARED);
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (currentOperation == null) {
                    currentOperation = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                currentOperation = null;
            }
        });
    }
}

