/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public abstract class ODurableComponent
extends OSharedResourceAdaptive {
    protected final OAtomicOperationsManager atomicOperationsManager;
    protected final OAbstractPaginatedStorage storage;
    private volatile String name;
    private volatile String fullName;
    protected final String extension;

    public ODurableComponent(OAbstractPaginatedStorage storage, String name, String extension) {
        super(true);
        this.extension = extension;
        this.storage = storage;
        this.fullName = name + extension;
        this.name = name;
        this.atomicOperationsManager = storage.getAtomicOperationsManager();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fullName = name + this.extension;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    protected void acquireExclusiveLock() {
        super.acquireExclusiveLock();
    }

    protected void endAtomicOperation(boolean rollback) throws IOException {
        this.atomicOperationsManager.endAtomicOperation(rollback);
    }

    protected OAtomicOperation startAtomicOperation() throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, false);
    }

    protected static OWALChangesTree getChangesTree(OAtomicOperation atomicOperation, OCacheEntry entry) {
        if (atomicOperation == null) {
            return null;
        }
        return atomicOperation.getChangesTree(entry.getFileId(), entry.getPageIndex());
    }

    protected static long getFilledUpTo(OAtomicOperation atomicOperation, ODiskCache diskCache, long fileId) throws IOException {
        if (atomicOperation == null) {
            return diskCache.getFilledUpTo(fileId);
        }
        return atomicOperation.filledUpTo(fileId, diskCache);
    }

    protected static OCacheEntry loadPage(OAtomicOperation atomicOperation, long fileId, long pageIndex, boolean checkPinnedPages, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            return diskCache.load(fileId, pageIndex, checkPinnedPages);
        }
        return atomicOperation.loadPage(fileId, pageIndex, diskCache, checkPinnedPages);
    }

    protected static void pinPage(OAtomicOperation atomicOperation, OCacheEntry cacheEntry, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            diskCache.pinPage(cacheEntry);
        } else {
            atomicOperation.pinPage(cacheEntry);
        }
    }

    protected static OCacheEntry addPage(OAtomicOperation atomicOperation, long fileId, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            return diskCache.allocateNewPage(fileId);
        }
        return atomicOperation.addPage(fileId, diskCache);
    }

    protected static void releasePage(OAtomicOperation atomicOperation, OCacheEntry cacheEntry, ODiskCache diskCache) {
        if (atomicOperation == null) {
            diskCache.release(cacheEntry);
        } else {
            atomicOperation.releasePage(cacheEntry, diskCache);
        }
    }

    protected static long addFile(OAtomicOperation atomicOperation, String fileName, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            return diskCache.addFile(fileName);
        }
        return atomicOperation.addFile(fileName, diskCache);
    }

    protected static long openFile(OAtomicOperation atomicOperation, String fileName, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            return diskCache.openFile(fileName);
        }
        return atomicOperation.openFile(fileName, diskCache);
    }

    protected static void openFile(OAtomicOperation atomicOperation, long fileId, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            diskCache.openFile(fileId);
        } else {
            atomicOperation.openFile(fileId, diskCache);
        }
    }

    protected static void deleteFile(OAtomicOperation atomicOperation, long fileId, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            diskCache.deleteFile(fileId);
        } else {
            atomicOperation.deleteFile(fileId, diskCache);
        }
    }

    protected static boolean isFileExists(OAtomicOperation atomicOperation, String fileName, ODiskCache diskCache) {
        if (atomicOperation == null) {
            return diskCache.exists(fileName);
        }
        return atomicOperation.isFileExists(fileName, diskCache);
    }

    protected static boolean isFileExists(OAtomicOperation atomicOperation, long fileId, ODiskCache diskCache) {
        if (atomicOperation == null) {
            return diskCache.exists(fileId);
        }
        return atomicOperation.isFileExists(fileId, diskCache);
    }

    protected static String fileNameById(OAtomicOperation atomicOperation, long fileId, ODiskCache diskCache) {
        if (atomicOperation == null) {
            return diskCache.fileNameById(fileId);
        }
        return atomicOperation.fileNameById(fileId, diskCache);
    }

    protected static void truncateFile(OAtomicOperation atomicOperation, long filedId, ODiskCache diskCache) throws IOException {
        if (atomicOperation == null) {
            diskCache.truncateFile(filedId);
        } else {
            atomicOperation.truncateFile(filedId);
        }
    }
}

