/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.directmemory.ODirectMemoryViolationException;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class OWALChangesTree {
    private final int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024 + 16;
    private static final boolean BLACK = false;
    private static final boolean RED = true;
    private Node root = null;
    private int version = 0;
    private boolean debug;
    private int serializedSize = 4;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public byte getByteValue(ODirectMemoryPointer pointer, int offset) {
        int end = offset + 1;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, offset, end, result);
        if (pointer != null && result.isEmpty()) {
            return pointer.getByte(offset);
        }
        byte[] value = new byte[]{0};
        this.applyChanges(value, offset, end, result);
        return value[0];
    }

    public byte[] getBinaryValue(ODirectMemoryPointer pointer, int offset, int len) {
        int end = offset + len;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, offset, end, result);
        if (result.isEmpty() && pointer != null) {
            return pointer.get(offset, len);
        }
        byte[] value = pointer != null ? pointer.get(offset, len) : new byte[len];
        this.applyChanges(value, offset, end, result);
        return value;
    }

    public short getShortValue(ODirectMemoryPointer pointer, int offset) {
        int end = offset + 2;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, offset, end, result);
        if (result.isEmpty() && pointer != null) {
            return pointer.getShort(offset);
        }
        byte[] value = pointer != null ? pointer.get(offset, 2) : new byte[2];
        this.applyChanges(value, offset, end, result);
        return OShortSerializer.INSTANCE.deserializeNative(value, 0);
    }

    public int getIntValue(ODirectMemoryPointer pointer, int offset) {
        int end = offset + 4;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, offset, end, result);
        if (result.isEmpty() && pointer != null) {
            return pointer.getInt(offset);
        }
        byte[] value = pointer != null ? pointer.get(offset, 4) : new byte[4];
        this.applyChanges(value, offset, end, result);
        return OIntegerSerializer.INSTANCE.deserializeNative(value, 0);
    }

    public long getLongValue(ODirectMemoryPointer pointer, int offset) {
        int end = offset + 8;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, offset, end, result);
        if (result.isEmpty() && pointer != null) {
            return pointer.getLong(offset);
        }
        byte[] value = pointer != null ? pointer.get(offset, 8) : new byte[8];
        this.applyChanges(value, offset, end, result);
        return OLongSerializer.INSTANCE.deserializeNative(value, 0);
    }

    public void add(byte[] value, int start) {
        ++this.version;
        this.add(value, start, this.version, true);
    }

    private void add(byte[] value, int start, int version, boolean updateSerializedSize) {
        if (value == null || value.length == 0) {
            return;
        }
        this.rangeCheck(start, value.length);
        Node fnode = this.bsearch(start);
        Node node = new Node(value, start, true, version);
        if (fnode == null) {
            this.root = node;
            this.root.color = false;
            if (this.debug) {
                this.assertInvariants();
            }
            if (updateSerializedSize) {
                this.serializedSize += this.serializedSize(value.length);
            }
            return;
        }
        if (start < fnode.start) {
            fnode.left = node;
            node.parent = fnode;
            if (updateSerializedSize) {
                this.serializedSize += this.serializedSize(value.length);
            }
            this.updateMaxEndAfterAppend(node);
            this.insertCaseOne(node);
        } else if (start > fnode.start) {
            fnode.right = node;
            node.parent = fnode;
            if (updateSerializedSize) {
                this.serializedSize += this.serializedSize(value.length);
            }
            this.updateMaxEndAfterAppend(node);
            this.insertCaseOne(node);
        } else {
            int end = start + value.length;
            if (end == fnode.end) {
                if (fnode.version < version) {
                    if (updateSerializedSize) {
                        this.serializedSize -= fnode.value.length;
                    }
                    Node.access$702(fnode, value);
                    fnode.version = version;
                    if (updateSerializedSize) {
                        this.serializedSize += fnode.value.length;
                    }
                }
            } else if (end < fnode.end) {
                if (fnode.version < version) {
                    byte[] cvalue = Arrays.copyOfRange(fnode.value, end - start, fnode.end - start);
                    int cversion = fnode.version;
                    int cstart = end;
                    if (updateSerializedSize) {
                        this.serializedSize -= fnode.value.length;
                    }
                    fnode.end = end;
                    Node.access$702(fnode, value);
                    fnode.version = version;
                    if (updateSerializedSize) {
                        this.serializedSize += fnode.value.length;
                    }
                    this.updateMaxEndAccordingToChildren(fnode);
                    this.add(cvalue, cstart, cversion, updateSerializedSize);
                }
            } else if (fnode.version > version) {
                byte[] cvalue = Arrays.copyOfRange(value, fnode.end - start, end - start);
                int cversion = version;
                int cstart = fnode.end;
                this.add(cvalue, cstart, cversion, updateSerializedSize);
            } else {
                if (updateSerializedSize) {
                    this.serializedSize -= fnode.value.length;
                }
                fnode.end = end;
                Node.access$702(fnode, value);
                fnode.version = version;
                if (updateSerializedSize) {
                    this.serializedSize += fnode.value.length;
                }
                this.updateMaxEndAccordingToChildren(fnode);
            }
        }
        if (this.debug) {
            this.assertInvariants();
        }
    }

    public void applyChanges(byte[] values, int start) {
        int end = start + values.length;
        ArrayList<Node> result = new ArrayList<Node>();
        this.findIntervals(this.root, start, end, result);
        this.applyChanges(values, start, end, result);
    }

    public int serializedSize() {
        return this.serializedSize;
    }

    public int serializedSize(int content) {
        return content + 12;
    }

    private void applyChanges(byte[] values, int start, int end, List<Node> result) {
        if (result.isEmpty()) {
            return;
        }
        ArrayDeque<Node> processedNodes = new ArrayDeque<Node>();
        for (Node activeNode : result) {
            int vStart;
            int deltaStart;
            int activeStart = activeNode.start;
            Iterator pNodesIterator = processedNodes.iterator();
            while (pNodesIterator.hasNext()) {
                Node pNode = (Node)pNodesIterator.next();
                if (pNode.end > activeStart && pNode.version > activeNode.version) {
                    activeStart = pNode.end;
                }
                if (pNode.end > activeNode.start) continue;
                pNodesIterator.remove();
            }
            processedNodes.add(activeNode);
            if (activeStart >= activeNode.end) continue;
            int vLength = deltaStart > 0 ? activeNode.end - activeStart : activeNode.end - activeStart + deltaStart;
            int vEnd = vLength + (vStart = (deltaStart = activeStart - start) > 0 ? start + deltaStart : start);
            if (vEnd > end) {
                vLength -= vEnd - end;
            }
            if (vLength <= 0) continue;
            System.arraycopy(activeNode.value, deltaStart >= 0 ? activeStart - activeNode.start : activeStart - activeNode.start - deltaStart, values, deltaStart >= 0 ? deltaStart : 0, vLength);
        }
    }

    public void applyChanges(ODirectMemoryPointer pointer) {
        if (this.root == null) {
            return;
        }
        ArrayDeque<Node> processedNodes = new ArrayDeque<Node>();
        this.applyChanges(pointer, this.root, processedNodes);
    }

    public PointerWrapper wrap(ODirectMemoryPointer pointer) {
        return new PointerWrapper(pointer);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public int fromStream(int offset, byte[] stream) {
        int readBytes;
        int length;
        this.serializedSize = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset);
        for (readBytes = 4; readBytes < this.serializedSize; readBytes += length) {
            int start = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset + readBytes);
            int version = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset + (readBytes += 4));
            length = OIntegerSerializer.INSTANCE.deserializeNative(stream, offset + (readBytes += 4));
            byte[] data = new byte[length];
            System.arraycopy(stream, offset + (readBytes += 4), data, 0, length);
            this.add(data, start, version, false);
        }
        return offset + readBytes;
    }

    public int toStream(int offset, byte[] stream) {
        OIntegerSerializer.INSTANCE.serializeNative(this.serializedSize, stream, offset, new Object[0]);
        offset += 4;
        if (this.root == null) {
            return offset;
        }
        offset = this.toStream(this.root, offset, stream);
        return offset;
    }

    private int toStream(Node node, int offset, byte[] stream) {
        if (node.left != null) {
            offset = this.toStream(node.left, offset, stream);
        }
        OIntegerSerializer.INSTANCE.serializeNative(node.start, stream, offset, new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(node.version, stream, offset += 4, new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(node.value.length, stream, offset += 4, new Object[0]);
        System.arraycopy(node.value, 0, stream, offset += 4, node.value.length);
        offset += node.value.length;
        if (node.right != null) {
            offset = this.toStream(node.right, offset, stream);
        }
        return offset;
    }

    private void applyChanges(ODirectMemoryPointer pointer, Node node, Queue<Node> processedNodes) {
        if (node.left != null) {
            this.applyChanges(pointer, node.left, processedNodes);
        }
        int activeStart = node.start;
        Iterator pNodesIterator = processedNodes.iterator();
        while (pNodesIterator.hasNext()) {
            Node pNode = (Node)pNodesIterator.next();
            if (pNode.end > activeStart && pNode.version > node.version) {
                activeStart = pNode.end;
            }
            if (pNode.end > node.start) continue;
            pNodesIterator.remove();
        }
        processedNodes.add(node);
        if (activeStart < node.end) {
            int vLength = node.end - activeStart;
            pointer.set(activeStart, node.value, activeStart - node.start, vLength);
        }
        if (node.right != null) {
            this.applyChanges(pointer, node.right, processedNodes);
        }
    }

    private void assertInvariants() {
        assert (this.rootIsBlack());
        assert (this.redHaveBlackChildNodes());
        assert (this.allBlackPathsAreEqual());
        assert (this.maxEndIsPresent());
        assert (this.maxEndValueIsCorrect());
    }

    private boolean allBlackPathsAreEqual() {
        ArrayList<OModifiableInteger> paths = new ArrayList<OModifiableInteger>();
        OModifiableInteger currentPath = new OModifiableInteger();
        paths.add(currentPath);
        this.calculateBlackPathsFromNode(this.root, paths, currentPath);
        int basePath = ((OModifiableInteger)paths.get(0)).getValue();
        for (OModifiableInteger path : paths) {
            if (path.getValue() == basePath) continue;
            return false;
        }
        return true;
    }

    private void calculateBlackPathsFromNode(Node node, List<OModifiableInteger> paths, OModifiableInteger currentPath) {
        if (!node.color) {
            currentPath.increment();
        }
        if (node.right != null) {
            OModifiableInteger newPath = new OModifiableInteger(currentPath.getValue());
            paths.add(newPath);
            this.calculateBlackPathsFromNode(node.right, paths, newPath);
        }
        if (node.left != null) {
            this.calculateBlackPathsFromNode(node.left, paths, currentPath);
        }
    }

    private boolean redHaveBlackChildNodes() {
        return this.redHaveBlackChildNodes(this.root);
    }

    private boolean redHaveBlackChildNodes(Node node) {
        if (node.color) {
            if (node.left != null && node.left.color) {
                return false;
            }
            if (node.right != null && node.right.color) {
                return false;
            }
        }
        if (node.left != null && !this.redHaveBlackChildNodes(node.left)) {
            return false;
        }
        return node.right == null || this.redHaveBlackChildNodes(node.right);
    }

    private boolean rootIsBlack() {
        if (this.root == null) {
            return true;
        }
        return !this.root.color;
    }

    private boolean maxEndIsPresent() {
        if (this.root == null) {
            return true;
        }
        return this.maxEndIsPresent(this.root);
    }

    private boolean maxEndIsPresent(Node node) {
        boolean result = this.endValueIsPresentAmongChildren(node.maxEnd, node);
        if (!result) {
            return false;
        }
        if (node.left != null) {
            result = this.maxEndIsPresent(node.left);
        }
        if (!result) {
            return false;
        }
        if (node.right != null) {
            result = this.maxEndIsPresent(node.right);
        }
        return result;
    }

    private boolean endValueIsPresentAmongChildren(int value, Node node) {
        if (node.end == value) {
            return true;
        }
        if (node.left != null && this.endValueIsPresentAmongChildren(value, node.left)) {
            return true;
        }
        return node.right != null && this.endValueIsPresentAmongChildren(value, node.right);
    }

    private boolean maxEndValueIsCorrect() {
        if (this.root == null) {
            return true;
        }
        return this.maxEndValueIsCorrect(this.root);
    }

    private boolean maxEndValueIsCorrect(Node node) {
        if (!this.valueIsMaxEndValueAmongChildren(node, node.maxEnd)) {
            return false;
        }
        if (node.left != null && !this.maxEndIsPresent(node.left)) {
            return false;
        }
        return node.right == null || this.maxEndIsPresent(node.right);
    }

    private boolean valueIsMaxEndValueAmongChildren(Node node, int value) {
        if (node.end > value) {
            return false;
        }
        if (node.left != null && !this.valueIsMaxEndValueAmongChildren(node.left, value)) {
            return false;
        }
        return node.right == null || this.valueIsMaxEndValueAmongChildren(node.right, value);
    }

    private void findIntervals(Node node, int start, int end, List<Node> result) {
        if (node == null) {
            return;
        }
        if (start >= node.maxEnd) {
            return;
        }
        if (node.left != null) {
            this.findIntervals(node.left, start, end, result);
        }
        if (node.overlapsWith(start, end)) {
            result.add(node);
        }
        if (end <= node.start) {
            return;
        }
        if (node.right != null) {
            this.findIntervals(node.right, start, end, result);
        }
    }

    private Node bsearch(int start) {
        Node current;
        block4: {
            if (this.root == null) {
                return null;
            }
            current = this.root;
            while (true) {
                if (start < current.start) {
                    if (current.left != null) {
                        current = current.left;
                        continue;
                    }
                    return current;
                }
                if (start <= current.start) break block4;
                if (current.right == null) break;
                current = current.right;
            }
            return current;
        }
        return current;
    }

    private void insertCaseOne(Node node) {
        if (node.parent == null) {
            node.color = false;
        } else {
            this.insertCaseTwo(node);
        }
    }

    private void insertCaseTwo(Node node) {
        if (!node.parent.color) {
            return;
        }
        this.insertCaseThree(node);
    }

    private void insertCaseThree(Node node) {
        Node u = this.uncle(node);
        if (u != null && u.color) {
            node.parent.color = false;
            u.color = false;
            Node g = this.grandparent(node);
            g.color = true;
            this.insertCaseOne(g);
        } else {
            this.insertCaseFour(node);
        }
    }

    private void insertCaseFour(Node node) {
        Node g = this.grandparent(node);
        if (node == node.parent.right && node.parent == g.left) {
            this.rotateLeft(node.parent);
            node = node.left;
        } else if (node == node.parent.left && node.parent == g.right) {
            this.rotateRight(node.parent);
            node = node.right;
        }
        this.insertCaseFive(node);
    }

    private void rotateRight(Node node) {
        Node q = node;
        Node p = q.left;
        Node b = p.right;
        Node parent = node.parent;
        p.right = q;
        q.parent = p;
        p.parent = parent;
        if (parent != null) {
            if (parent.left == node) {
                parent.left = p;
            } else {
                parent.right = p;
            }
        }
        q.left = b;
        if (b != null) {
            b.parent = q;
        }
        if (node == this.root) {
            this.root = p;
        }
        this.updateMaxEndAccordingToChildren(q);
    }

    private void rotateLeft(Node node) {
        Node p = node;
        Node q = p.right;
        Node b = q.left;
        Node parent = node.parent;
        q.left = p;
        p.parent = q;
        q.parent = parent;
        if (parent != null) {
            if (parent.left == node) {
                parent.left = q;
            } else {
                parent.right = q;
            }
        }
        p.right = b;
        if (b != null) {
            b.parent = p;
        }
        if (node == this.root) {
            this.root = q;
        }
        this.updateMaxEndAccordingToChildren(p);
    }

    private void updateMaxEndAccordingToChildren(Node node) {
        if (node.left != null && node.right != null) {
            node.maxEnd = Math.max(node.end, Math.max(node.left.maxEnd, node.right.maxEnd));
        } else if (node.left != null) {
            node.maxEnd = Math.max(node.end, node.left.maxEnd);
        } else if (node.right != null) {
            node.maxEnd = Math.max(node.end, node.right.maxEnd);
        } else {
            node.maxEnd = node.end;
        }
        if (node.parent != null) {
            this.updateMaxEndAccordingToChildren(node.parent);
        }
    }

    private void insertCaseFive(Node node) {
        Node g = this.grandparent(node);
        node.parent.color = false;
        g.color = true;
        if (node == node.parent.left) {
            this.rotateRight(g);
        } else {
            this.rotateLeft(g);
        }
    }

    private Node grandparent(Node node) {
        if (node != null && node.parent != null) {
            return node.parent.parent;
        }
        return null;
    }

    private Node uncle(Node node) {
        Node g = this.grandparent(node);
        if (g == null) {
            return null;
        }
        if (node.parent == g.left) {
            return g.right;
        }
        return g.left;
    }

    private void updateMaxEndAfterAppend(Node node) {
        Node parent = node.parent;
        if (parent != null && parent.maxEnd < node.maxEnd) {
            parent.maxEnd = node.maxEnd;
            this.updateMaxEndAfterAppend(parent);
        }
    }

    private void rangeCheck(long offset, long size) {
        if (offset < 0L) {
            throw new ODirectMemoryViolationException("Negative offset was provided");
        }
        if (size < 0L) {
            throw new ODirectMemoryViolationException("Negative size was provided");
        }
        if (offset > (long)this.pageSize) {
            throw new ODirectMemoryViolationException("Provided offset [" + offset + "] is more than size of allocated area  [" + this.pageSize + "]");
        }
        if (offset + size > (long)this.pageSize) {
            throw new ODirectMemoryViolationException("Last position of provided data interval [" + (offset + size) + "] is more than size of allocated area [" + this.pageSize + "]");
        }
    }

    public final class PointerWrapper {
        private final ODirectMemoryPointer pointer;

        private PointerWrapper(ODirectMemoryPointer pointer) {
            this.pointer = pointer;
        }

        public byte getByte(long offset) {
            return OWALChangesTree.this.getByteValue(this.pointer, (int)offset);
        }

        public short getShort(long offset) {
            return OWALChangesTree.this.getShortValue(this.pointer, (int)offset);
        }

        public int getInt(long offset) {
            return OWALChangesTree.this.getIntValue(this.pointer, (int)offset);
        }

        public long getLong(long offset) {
            return OWALChangesTree.this.getLongValue(this.pointer, (int)offset);
        }

        public byte[] get(long offset, int len) {
            return OWALChangesTree.this.getBinaryValue(this.pointer, (int)offset, len);
        }

        public char getChar(long offset) {
            return (char)OWALChangesTree.this.getShortValue(this.pointer, (int)offset);
        }
    }

    private static final class Node {
        private boolean color;
        private byte[] value;
        private int version;
        private int start;
        private int end;
        private int maxEnd;
        private Node parent;
        private Node left;
        private Node right;

        public Node(byte[] value, int start, boolean color, int version) {
            this.color = color;
            this.version = version;
            this.value = value;
            this.start = start;
            this.maxEnd = this.end = start + value.length;
        }

        private boolean overlapsWith(Node other) {
            return this.start < other.end && this.end > other.start;
        }

        private boolean overlapsWith(int start, int end) {
            return this.start < end && this.end > start;
        }

        static /* synthetic */ byte[] access$702(Node x0, byte[] x1) {
            x0.value = x1;
            return x1;
        }
    }
}

